/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.GridLayout;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.ImageIcon;
//import com.sun.java.swing.GraphicsUtilsConstants;

public class LabelDemo extends JPanel {

JLabel label1, label2, label3;

    public LabelDemo() {
	super(true);     		    // true = please double buffer
	ImageIcon icon = new ImageIcon("middle.gif");
	setLayout(new GridLayout(3,1));     //3 rows, 1 column

        label1 = new JLabel("Image and Text",
			    icon,
			    JLabel.CENTER);
	label1.setVerticalTextPosition(JLabel.BOTTOM);
	label1.setHorizontalTextPosition(JLabel.CENTER);

        label2 = new JLabel("Text-Only Label");

        label3 = new JLabel(icon);

        //Add labels to the JPanel. 
        add(label1);
        add(label2);
        add(label3);
    }

    public static void main(String[] args) {
	/*
	 * Create a window.  Use JFrame since this window will include 
	 * lightweight components.
	 */
	JFrame frame = new JFrame("LabelDemo");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	frame.addWindowListener(l);

	frame.add("Center", new LabelDemo());
	frame.pack();
	frame.show();
    }
}
