/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import com.sun.java.swing.table.JTableDataModelAdapter;
import com.sun.java.swing.table.JTable;
import com.sun.java.swing.table.JTableColumn;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.BoxLayout;
import java.awt.GridLayout;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SimpleTableDemo extends JPanel {
    public SimpleTableDemo() {
	super(true);     		    // true = please double buffer

	MyDataModel myDataModel = new MyDataModel();
	JTable table = new JTable(myDataModel);

	for (int columnIndex = 0; 
	         columnIndex < myDataModel.numColumns;
	         columnIndex++) {
	    JTableColumn newColumn = new JTableColumn(
				     myDataModel.getColumnName(columnIndex));
	    table.addColumn(newColumn);
	    newColumn.sizeWidthToFit();
	}

        //Create the scroll pane and add the table to it. 
	JScrollPane scrollPane = new JScrollPane();
	scrollPane.getViewport().add(table);  

	//Make the table heads be the non-scrolling column header.
	JViewport columnHeading = new JViewport();
	columnHeading.setView(table.getTableHeader());
	columnHeading.setLayout(new BoxLayout(columnHeading, 	//HACK
					      BoxLayout.X_AXIS));
	scrollPane.setColumnHeading(columnHeading);

	//Add the scroll pane to this panel.
	setLayout(new GridLayout(1, 0)); 
        add(scrollPane);
    }

    public static void main(String[] args) {
	/*
	 * Create a window.  Use JFrame since this window will include 
	 * lightweight components.
	 */
	JFrame frame = new JFrame("SimpleTableDemo");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	frame.addWindowListener(l);

	frame.add("Center", new SimpleTableDemo());
	frame.setSize(400, 125);
	frame.show();
    }
}

class MyDataModel extends JTableDataModelAdapter {
    
    //Dummy data.
    final Object[][] data = {
	{"First Name", "Mary", "Alison", "Kathy", "Mark", "Angela"},
	{"Last Name", "Campione", "Huml", "Walrath", "Andrews", "Lih"},
	{"Sport", "Snowboarding", "Rowing", "Chasing toddlers", "Speed reading", "Teaching high school"},
	{"Est. Years Experience", "5", "3", "2", "20", "4"},
    };

    public int numColumns = data.length;
    protected int numRows = data[0].length - 1;

    public int getRowCount() {
	return numRows;
    }

    public Object getValueAt(Object columnIdentifier, int rowIndex) {
	for (int columnIndex = 0; columnIndex < numColumns; columnIndex++) {
	    if (data[columnIndex][0].equals(columnIdentifier)) {
		return data[columnIndex][rowIndex+1];
	    }
	}
	return "NO DATA";
    }

    public void setValueAt(Object aValue, 
			   Object columnIdentifier,
			   int rowIndex) {
    }

    /** This method isn't in TableDataModel.  */
    public String getColumnName(int columnIndex) {
	return (String)data[columnIndex][0];
    }
}
