/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import java.awt.GridLayout;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TabbedPaneDemo extends JPanel {
    public TabbedPaneDemo() {
	super(true);     		    // true = please double buffer

	JTabbedPane tabbedPane = new JTabbedPane();

	//PENDING: Add icons to tabs.

	Component panel1 = makeTextPanel("Blah");
	//ImageIcon tinyPanel1 = new ImageIcon("tinypanel1.gif");
	tabbedPane.addTab("One", null, panel1, "Does nothing");
	tabbedPane.setSelectedIndex(0);

	Component panel2 = makeTextPanel("Blah blah");
	//ImageIcon tinyPanel2 = new ImageIcon("tinypanel2.gif");
	tabbedPane.addTab("Two", null, panel2, "Does nothing");

	Component panel3 = makeTextPanel("Blah blah blah");
	//ImageIcon tinyPanel3 = new ImageIcon("tinypanel3.gif");
	tabbedPane.addTab("Three", null, panel3, "Does nothing");

	Component panel4 = makeTextPanel("Blah blah blah blah");
	//ImageIcon tinyPanel4 = new ImageIcon("tinypanel4.gif");
	tabbedPane.addTab("Four", null, panel4, "Does nothing");

	//Add the tabbed pane to this panel.
	setLayout(new GridLayout(1, 0)); 
        add(tabbedPane);
    }

    protected Component makeTextPanel(String text) {
	JPanel panel = new JPanel();
	JLabel filler = new JLabel(text);
	filler.setHorizontalAlignment(JLabel.CENTER);
	panel.setLayout(new GridLayout(1, 0));
	panel.add(filler);
	return panel;
    }

    public static void main(String[] args) {
	/*
	 * Create a window.  Use JFrame since this window will include 
	 * lightweight components.
	 */
	JFrame frame = new JFrame("TabbedPaneDemo");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	frame.addWindowListener(l);

	frame.add("Center", new TabbedPaneDemo());
	frame.setSize(400, 125);
	frame.show();
    }
}
