/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import com.sun.java.swing.JTreeModel;
import com.sun.java.swing.JTree;
import com.sun.java.swing.TreeNode;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JFrame;
import java.awt.GridLayout;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;

// It would be cool to modify this so that nodes are links.
public class TreeDemo extends JPanel {
    public TreeDemo() {
	super(true);     		    // true = please double buffer

	//Create the nodes.
	TreeNode top = new TreeNode("The Java Series");
	TreeNode category;
	TreeNode book;

	category = new TreeNode("Books for Java Programmers");
	top.add(category);

	//Tutorial
	book = new TreeNode("The Java Tutorial: Object-Oriented Programming for the Internet");
        book.add(new TreeNode("Mary Campione"));
        book.add(new TreeNode("Kathy Walrath"));
	category.add(book);

	//Arnold/Gosling
	book = new TreeNode("The Java Programming Language");
        book.add(new TreeNode("Ken Arnold"));
        book.add(new TreeNode("James Gosling"));
	category.add(book);

	//FAQ
	book = new TreeNode("The Java FAQ");
        book.add(new TreeNode("Jonni Kanerva"));
	category.add(book);

	//Chan/Lee
	book = new TreeNode("The Java Class Libraries: An Annotated Reference");
        book.add(new TreeNode("Patrick Chan"));
        book.add(new TreeNode("Rosanna Lee"));
	category.add(book);

	//Threads
	book = new TreeNode("Concurrent Programming in Java: Design Principles and Patterns");
        book.add(new TreeNode("Doug Lea"));
	category.add(book);

	category = new TreeNode("Books for Java Implementers");
	top.add(category);

	//VM
	book = new TreeNode("The Java Virtual Machine Specification");
        book.add(new TreeNode("Tim Lindholm"));
        book.add(new TreeNode("Frank Yellin"));
	category.add(book);

	//Language Spec
	book = new TreeNode("The Java Language Specification");
        book.add(new TreeNode("James Gosling"));
        book.add(new TreeNode("Bill Joy"));
        book.add(new TreeNode("Guy Steele"));
	category.add(book);

	//Make all child-free nodes leaves.
	makeLeaves(top);

	JTree tree = new JTree(top);

        //Create the scroll pane and add the tree to it. 
	JScrollPane scrollPane = new JScrollPane();
	scrollPane.getViewport().add(tree);  

	//Add the scroll pane to this panel.
	setLayout(new GridLayout(1, 0)); 
        add(scrollPane);
    }

    //This method will be added to the TreeNode API in a future release.
    protected void makeLeaves(TreeNode top) {
        Enumeration       childEnum = top.preorderEnumeration();
        TreeNode          descendant;

        while(childEnum.hasMoreElements()) {
            descendant = (TreeNode)childEnum.nextElement();
            if(descendant.getChildCount() == 0)
                descendant.setAllowsChildren(false);
        }       
    }

    public static void main(String[] args) {
	/*
	 * Create a window.  Use JFrame since this window will include 
	 * lightweight components.
	 */
	JFrame frame = new JFrame("TreeDemo");

	WindowListener l = new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	};
	frame.addWindowListener(l);

	frame.add("Center", new TreeDemo());
	frame.setSize(500, 200);
	frame.show();
    }
}
