/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.*;
import java.awt.*;

public class Compatibility extends Applet {
    /* Should localize the following. */
    protected String labelText = "Your browser can't run 1.1 applets.";
    protected String filename;   // value to be provided by a subclass
    PictureFrame frame;

    public void init() {
	setLayout(new BorderLayout());

	Button button = new Button("What Am I Missing?");
	add("Center", button);

	Label label = new Label(labelText);
	label.setForeground(Color.red);
	add("North", label);

	if (filename == null) {
	    label.disable();
	    button.disable();
	    return;
	} 

	Image image = getImage(getCodeBase(), filename);
	String gifWidth = getParameter("GIFWIDTH");
	String gifHeight = getParameter("GIFHEIGHT");
	int w = 200;
	int h = 200;

	if (gifWidth != null) {
	    try {
		w = Integer.parseInt(gifWidth);
	    } catch (NumberFormatException e) {
		//Use default width.
	    }
	}

	if (gifHeight != null) {
	    try {
		h = Integer.parseInt(gifHeight);
	    } catch (NumberFormatException e) {
		//Use default height.
	    }
	}

	frame = new PictureFrame(image, w, h);
    }

    public void stop() {
	frame.hide();
    }

    public boolean action(Event e, Object arg) {
	if (frame != null) {
	    frame.pack();
	    frame.show();
	}
	return true;
    }
}
