/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.*;
import java.applet.Applet;

public class ImageDisplayer extends Canvas {
    Image image;
    Dimension size;
    int w, h;

    public ImageDisplayer(Image image, int width, int height) {
	if (image == null) {
	    System.err.println("Canvas got invalid image object!");
	    return;
	}

	this.image = image;

	w = width;
	h = height;

	size = new Dimension(w,h);
    }

    public Dimension preferredSize() {
 	return size;
    }

    public synchronized Dimension minimumSize() {
	return size;
    }

    public void paint (Graphics g) {
	if (image != null) {
	    g.drawImage(image, 0, 0, this);
	    g.drawRect(0, 0, w - 1, h - 1);
	}
    }
}

