/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.awt.Graphics;
import java.awt.Dimension;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class TimingIsEverything1_1 extends java.applet.Applet {

    public long firstClickTime = 0;
    public String displayStr;

    public void init() {
        displayStr = "Double Click Me";
        addMouseListener(new MyAdapter());
    }
    public void paint(Graphics g) {
        g.drawRect(0, 0, getSize().width-1, getSize().height-1);
        g.drawString(displayStr, 40, 30);
    }
    class MyAdapter extends MouseAdapter {
        public void mouseClicked(MouseEvent evt) {
            long clickTime = System.currentTimeMillis();
            long clickInterval = clickTime - firstClickTime;
            if (clickInterval < 200) {
                displayStr = "Double Click!! (Interval = " + clickInterval + ")";
                firstClickTime = 0;
            } else {
                displayStr = "Single Click!!";
                firstClickTime = clickTime;
            }
            repaint();
	}
    }
}
