/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class DataIOTest {
    public static void main(String[] args) {

            // writing part
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream("invoice1.txt"));

            double[] prices = { 19.99, 9.99, 15.99, 3.99, 4.99 };
            int[] units = { 12, 8, 13, 29, 50 };
            String[] descs = { "Java T-shirt", "Java Mug", "Duke Juggling Dolls", "Java Pin", "Java Key Chain" };
        
            for (int i = 0; i < prices.length; i ++) {
                dos.writeDouble(prices[i]);
                dos.writeChar('\t');
                dos.writeInt(units[i]);
                dos.writeChar('\t');
                dos.writeChars(descs[i]);
                dos.writeChar('\n');
            }
            dos.close();
        } catch (IOException e) {
            System.err.println("DataIOTest: " + e);
        }

            // reading part
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream("invoice1.txt"));
	    PrintWriter stdout = new PrintWriter(System.out, true);

            double price;
            int unit;
            double total = 0.0;
	    char chr;

            try {
                while (true) {
                    price = dis.readDouble();
                    dis.readChar();       // throws out the tab
                    unit = dis.readInt();
		    StringBuffer desc = new StringBuffer(20);
		    while ((chr = dis.readChar()) != '\n')
			    desc.append(chr);
                    stdout.println("You've ordered " + unit + " units of " + desc + " at $" + price);
                    total = total + unit * price;
                }
            } catch (EOFException e) {
            }
            stdout.println("For a TOTAL of: $" + total);
            dis.close();
        } catch (FileNotFoundException e) {
            System.err.println("DataIOTest: " + e);
        } catch (IOException e) {
            System.err.println("DataIOTest: " + e);
        }
    }
}
