/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class SortThread extends Thread {
    PrintWriter pw;
    BufferedReader br;

    SortThread(PrintWriter pw, BufferedReader br) {
        this.pw = pw;
        this.br = br;
    }

    public void run() {
         int MAXWORDS = 50;

        if (pw != null && br != null) {
            try {
                String[] listOfWords = new String[MAXWORDS];
                int numwords = 0, i = 0;
 
                while ((listOfWords[numwords] = br.readLine()) != null) {
                    numwords++;
                }
                quicksort(listOfWords, 0, numwords-1);
                for (i = 0; i < numwords; i++) {
                    pw.println(listOfWords[i]);
                }
                pw.close();
            } catch (IOException e) {
                System.err.println("WriteReversedThread run: " + e);
            }
        }
    }

    protected void finalize() {
        try {
            if (pw != null) {
                pw.close();
                pw = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
        } catch (IOException e) {
            System.err.println("WriteReversedThread finalize: " + e);
        }
    }

    private static void quicksort(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (lo >= hi) {
            return;
        }
        String mid = a[(lo + hi) / 2];
        while (lo < hi) {
            while (lo<hi && a[lo].compareTo(mid) < 0) {
                lo++;
            }
            while (lo<hi && a[hi].compareTo(mid) > 0) {
                hi--;
            }
            if (lo < hi) {
                String T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
            }
        }
        if (hi < lo) {
            int T = hi;
            hi = lo;
            lo = T;
        }
        quicksort(a, lo0, lo);
        quicksort(a, lo == lo0 ? lo+1 : lo, hi0);
    }
}
