/*
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.io.*;

class WriteReversedThread extends Thread {
    PrintWriter pw;
    BufferedReader br;

    WriteReversedThread(PrintWriter pw, BufferedReader br) {
        this.pw = pw;
        this.br = br;
    }

    public void run() {
        if (pw != null && br != null) {
            try {
                String input;
                while ((input = br.readLine()) != null) {
                    pw.println(reverseIt(input));
                    pw.flush();
                }
                pw.close();
            } catch (IOException e) {
                System.err.println("WriteReversedThread run: " + e);
            }
        }
    }

    protected void finalize() {
        try {
            if (pw != null) {
                pw.close();
                pw = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
        } catch (IOException e) {
            System.err.println("WriteReversedThread finalize: " + e);
        }
    }

    private String reverseIt(String source) {
        int i, len = source.length();
        StringBuffer dest = new StringBuffer(len);

        for (i = (len - 1); i >= 0; i--) {
            dest.append(source.charAt(i));
        }
        return dest.toString();
    }
}
