/*
 * 1.1 Swing version.
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/* 
 * This displays a framed area.  When the user clicks within
 * the area, this program displays a dot and a string indicating
 * the coordinates where the click occurred.
 */

public class CoordinatesDemo extends JApplet {
    FramedArea framedArea;
    JLabel label;

    public void init() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();

        getContentPane().setLayout(gridBag);

        framedArea = new FramedArea(this);
        c.fill = GridBagConstraints.BOTH;
        c.weighty = 1.0;
        c.gridwidth = GridBagConstraints.REMAINDER; //end row
        gridBag.setConstraints(framedArea, c);
        getContentPane().add(framedArea);

        label = new JLabel("Click within the framed area.");
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gridBag.setConstraints(label, c);
        getContentPane().add(label);
    }

    public void updateLabel(Point point) {
        label.setText("Click occurred at coordinate ("
                      + point.x + ", " + point.y + ").");
	
    }

    public static void main(String s[]) {
        JFrame f = new JFrame("CoordinatesDemo");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
        JApplet applet = new CoordinatesDemo();
        f.getContentPane().add(applet, BorderLayout.CENTER);
        applet.init();
        f.pack();
        f.setSize(new Dimension(450,200));
        f.show();
    }


}

class FramedArea extends JPanel {

    public FramedArea(CoordinatesDemo controller) {
        super();
        Border raisedBevel, loweredBevel, compound;
        raisedBevel = BorderFactory.createRaisedBevelBorder();
        loweredBevel = BorderFactory.createLoweredBevelBorder();
        compound = BorderFactory.createCompoundBorder
                        (raisedBevel, loweredBevel);
	setBorder(compound);
        
        //Set layout to one that makes its contents as big as possible.
        setLayout(new GridLayout(1,0));
 
        add(new CoordinateArea(controller));
    }
        
    public void paintComponent(Graphics g) {
        Dimension d = getSize();
        Color bg = getBackground();
	g.setColor(bg);
    }
}

class CoordinateArea extends JPanel {
    Point point = null;
    CoordinatesDemo controller;

    public CoordinateArea(CoordinatesDemo controller) {
        super();
        this.controller = controller;

	addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
                if (point == null) {
                    point = new Point(x, y);
                } else {
                    point.x = x;
                    point.y = y;
                }
                repaint();
	    }
	});
    }

    public void paintComponent(Graphics g) {
        //If user has chosen a point, paint a tiny rectangle on top.
        super.paintComponent(g); 
        if (point != null) {
	    controller.updateLabel(point);
            g.fillRect(point.x - 1, point.y - 1, 2, 2);
        }
    }
}
