/*
 * This applet's code is the same in both 1.0 and 1.1.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/* 
 * This applet displays a single image twice,
 * once at its normal size and once much wider.
 */

public class ImageDisplayer extends JApplet {
    Image image;
    ImagePanel imagePanel;

    public void init() {
        image = Toolkit.getDefaultToolkit().getImage("rocketship.gif");
	imagePanel = new ImagePanel();
	getContentPane().add(imagePanel);
    }

class ImagePanel extends JPanel {

    public ImagePanel(){
	
    }

    public void paintComponent(Graphics g) {
        //Draw image at its natural size first.
        g.drawImage(image, 0, 0, this); //85x62 image

        //Now draw the image scaled.
        g.drawImage(image, 90, 0, 300, 62, this);
    }
}
    public static void main(String s[]) {
        JFrame f = new JFrame("ImageDisplayer");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
        JApplet applet = new ImageDisplayer();
        f.getContentPane().add(applet, BorderLayout.CENTER);
        applet.init();
        f.pack();
        f.setSize(new Dimension(550,100));
        f.show();
    }
}

