/*
 * Swing version
 */

import javax.swing.*;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;

public class MouseMotionEventDemo extends JApplet 
                                  implements MouseMotionListener {
    BlankArea blankArea;
    JTextArea textArea;
    String newline;

    public void init() {

	JPanel contentPane = new JPanel();

        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        contentPane.setLayout(gridbag);

        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = GridBagConstraints.REMAINDER;
        c.weightx = 1.0;
        c.weighty = 1.0;

	c.insets = new Insets(1, 1, 1, 1);
        blankArea = new BlankArea(new Color(0.98f, 0.97f, 0.85f));
        gridbag.setConstraints(blankArea, c);
        contentPane.add(blankArea);

	c.insets = new Insets(0, 0, 0, 0);
        textArea = new JTextArea();
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea,
                                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        Dimension preferredSize = new Dimension(200, 75);
        scrollPane.setPreferredSize(preferredSize);
        gridbag.setConstraints(scrollPane, c);
        contentPane.add(scrollPane);

        //Register for mouse events on blankArea and applet (panel).
        blankArea.addMouseMotionListener(this);
        addMouseMotionListener(this);

	newline = System.getProperty("line.separator");

	setContentPane(contentPane);
    }

    public void mouseMoved(MouseEvent e) {
       saySomething("Mouse moved; # of clicks: "
		    + e.getClickCount(), e);
    }

    public void mouseDragged(MouseEvent e) {
       saySomething("Mouse dragged; # of clicks: "
		    + e.getClickCount(), e);
    }

    void saySomething(String eventDescription, MouseEvent e) {
        textArea.append(eventDescription + " detected on "
                        + e.getComponent().getClass().getName()
                        + newline);
    }
}
