/*
 * 1.1 version.
 */

import java.awt.*;
import java.awt.event.*;

public class CardWindow extends Frame
                        implements ItemListener {
    boolean inAnApplet = true;
     
    Panel cards;
    final static String BUTTONPANEL = "Panel with Buttons";
    final static String TEXTPANEL = "Panel with TextField";

    public CardWindow() {
        setLayout(new BorderLayout());
        setFont(new Font("SansSerif", Font.PLAIN, 14));

        //Put the Choice in a Panel to get a nicer look.
        Panel cp = new Panel();
        Choice c = new Choice();
        c.add(BUTTONPANEL);
        c.add(TEXTPANEL);
        c.addItemListener(this);
        cp.add(c);
        add("North", cp);

        cards = new Panel();
        cards.setLayout(new CardLayout());
   
        Panel p1 = new Panel();
        p1.add(new Button("Button 1"));
        p1.add(new Button("Button 2"));
        p1.add(new Button("Button 3"));

        Panel p2 = new Panel();
        p2.add(new TextField("TextField", 20));

        cards.add(BUTTONPANEL, p1);
        cards.add(TEXTPANEL, p2);
        add("Center", cards);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                if (inAnApplet) {
                    dispose();
                } else {
                    System.exit(0);
                }
            }
        });
    }

    public void itemStateChanged(ItemEvent evt) {
        CardLayout cl = (CardLayout)(cards.getLayout());
        cl.show(cards, (String)evt.getItem());
    }

    public static void main(String args[]) {
        CardWindow window = new CardWindow();
        window.inAnApplet = false;

        window.setTitle("CardWindow Application");
        window.pack();
        window.setVisible(true);
    }
}
