/*
 * 1.1 version.
 */

import java.awt.*;
import java.awt.event.*;

public class NoneWindow extends Frame {
    boolean inAnApplet = true;
    private boolean laidOut = false;
    private Button b1, b2, b3;

    public NoneWindow() {
        setLayout(null);
        setFont(new Font("SansSerif", Font.PLAIN, 14));

        b1 = new Button("one");
        add(b1);
        b2 = new Button("two");
        add(b2);
        b3 = new Button("three");
        add(b3);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                if (inAnApplet) {
                    dispose();
                } else {
                    System.exit(0);
                }
            }
        });
    }

    public void paint(Graphics g) {
        if (!laidOut) {
            Insets insets = getInsets();
            /* 
             * We're guaranteed that getInsets will return a 
	     * valid Insets if called from paint -- it isn't 
	     * valid when called from the constructor.
             *
             * We could perhaps cache this in an ivar, but 
	     * insets can change, and when they do, the AWT 
	     * creates a whole new Insets object; the old one
	     * is invalid.
             */
            b1.setBounds(50 + insets.left, 5 + insets.top, 50, 20);
            b2.setBounds(70 + insets.left, 35 + insets.top, 50, 20);
            b3.setBounds(130 + insets.left, 15 + insets.top, 50, 30);

            laidOut = true;
        }
    }

    public static void main(String args[]) {
        NoneWindow window = new NoneWindow();
        Insets insets = window.getInsets();
        window.inAnApplet = false;

        window.setTitle("NoneWindow Application");
        window.setSize(250 + insets.left + insets.right,
                      90 + insets.top + insets.bottom);
        window.setVisible(true);
    }
}
