import java.awt.*;
import java.awt.event.*;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.BorderFactory;

public class LabelAlignDemo extends JPanel {

JLabel label;

    public LabelAlignDemo() {
        ImageIcon icon = new ImageIcon("images/middle.gif");

        label = new JLabel();
        label.setBorder(BorderFactory.createLineBorder(Color.red));
        label.setText("Text goes here");
        label.setIcon(icon);
        label.setPreferredSize(new Dimension(300, 100));
        //PENDING: initialize radio buttons

        JPanel hTextPositionPanel = createHTextPositionPanel();
        JPanel vTextPositionPanel = createVTextPositionPanel();
        JPanel hAlignmentPanel = createHAlignmentPanel();
        JPanel vAlignmentPanel = createVAlignmentPanel();
        //[PENDING: add X/Y alignment panel?

        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(2,2));
        controlPanel.add(hTextPositionPanel);
        controlPanel.add(vTextPositionPanel);
        controlPanel.add(hAlignmentPanel);
        controlPanel.add(vAlignmentPanel);

        setLayout(new BorderLayout());
        add(label, BorderLayout.CENTER);
        add(controlPanel, BorderLayout.SOUTH);
    }

    private JPanel createHTextPositionPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(
                                        "Horiz. Text Pos."));
        final JRadioButton leftTextPosition = new JRadioButton("JLabel.LEFT");
        final JRadioButton centerTextPosition = new JRadioButton("JLabel.CENTER");
        final JRadioButton rightTextPosition = new JRadioButton("JLabel.RIGHT");
        ButtonGroup group = new ButtonGroup();
        group.add(leftTextPosition);
        group.add(centerTextPosition);
        group.add(rightTextPosition);
        ActionListener hTextPositionListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                //[PENDING: should I do action commands instead?]
                if (source == leftTextPosition) {
                    label.setHorizontalTextPosition(JLabel.LEFT);
                } else if (source == centerTextPosition) {
                    label.setHorizontalTextPosition(JLabel.CENTER);
                } else { 
                    label.setHorizontalTextPosition(JLabel.RIGHT);
                }
            }
        };
        leftTextPosition.addActionListener(hTextPositionListener);
        centerTextPosition.addActionListener(hTextPositionListener);
        rightTextPosition.addActionListener(hTextPositionListener);

        panel.setLayout(new GridLayout(0,1));
        panel.add(leftTextPosition);
        panel.add(centerTextPosition);
        panel.add(rightTextPosition);

        return panel;
    }

    private JPanel createVTextPositionPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(
                                        "Vert. Text Pos."));
        final JRadioButton topTextPosition = new JRadioButton("JLabel.TOP");
        final JRadioButton centerTextPosition = new JRadioButton("JLabel.CENTER");
        final JRadioButton bottomTextPosition = new JRadioButton("JLabel.BOTTOM");
        ButtonGroup group = new ButtonGroup();
        group.add(topTextPosition);
        group.add(centerTextPosition);
        group.add(bottomTextPosition);
        ActionListener hTextPositionListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                //[PENDING: should I do action commands instead?]
                if (source == topTextPosition) {
                    label.setVerticalTextPosition(JLabel.TOP);
                } else if (source == centerTextPosition) {
                    label.setVerticalTextPosition(JLabel.CENTER);
                } else { 
                    label.setVerticalTextPosition(JLabel.BOTTOM);
                }
            }
        };
        topTextPosition.addActionListener(hTextPositionListener);
        centerTextPosition.addActionListener(hTextPositionListener);
        bottomTextPosition.addActionListener(hTextPositionListener);

        panel.setLayout(new GridLayout(0,1));
        panel.add(topTextPosition);
        panel.add(centerTextPosition);
        panel.add(bottomTextPosition);

        return panel;
    }

    private JPanel createHAlignmentPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(
                                        "Horiz. Content Align."));
        final JRadioButton leftAlignment = new JRadioButton("JLabel.LEFT");
        final JRadioButton centerAlignment = new JRadioButton("JLabel.CENTER");
        final JRadioButton rightAlignment = new JRadioButton("JLabel.RIGHT");
        ButtonGroup group = new ButtonGroup();
        group.add(leftAlignment);
        group.add(centerAlignment);
        group.add(rightAlignment);
        ActionListener hAlignmentListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                //[PENDING: should I do action commands instead?]
                if (source == leftAlignment) {
                    label.setHorizontalAlignment(JLabel.LEFT);
                } else if (source == centerAlignment) {
                    label.setHorizontalAlignment(JLabel.CENTER);
                } else { 
                    label.setHorizontalAlignment(JLabel.RIGHT);
                }
            }
        };
        leftAlignment.addActionListener(hAlignmentListener);
        centerAlignment.addActionListener(hAlignmentListener);
        rightAlignment.addActionListener(hAlignmentListener);

        panel.setLayout(new GridLayout(0,1));
        panel.add(leftAlignment);
        panel.add(centerAlignment);
        panel.add(rightAlignment);

        return panel;
    }

    private JPanel createVAlignmentPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(
                                        "Vert. Content Align."));
        final JRadioButton topAlignment = new JRadioButton("JLabel.TOP");
        final JRadioButton centerAlignment = new JRadioButton("JLabel.CENTER");
        final JRadioButton bottomAlignment = new JRadioButton("JLabel.BOTTOM");
        ButtonGroup group = new ButtonGroup();
        group.add(topAlignment);
        group.add(centerAlignment);
        group.add(bottomAlignment);
        ActionListener vAlignmentListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                //[PENDING: should I do action commands instead?]
                if (source == topAlignment) {
                    label.setVerticalAlignment(JLabel.TOP);
                } else if (source == centerAlignment) {
                    label.setVerticalAlignment(JLabel.CENTER);
                } else { 
                    label.setVerticalAlignment(JLabel.BOTTOM);
                }
            }
        };
        topAlignment.addActionListener(vAlignmentListener);
        centerAlignment.addActionListener(vAlignmentListener);
        bottomAlignment.addActionListener(vAlignmentListener);

        panel.setLayout(new GridLayout(0,1));
        panel.add(topAlignment);
        panel.add(centerAlignment);
        panel.add(bottomAlignment);

        return panel;
    }

    public static void main(String[] args) {
        /*
         * Create a window.  Use JFrame since this window will include 
         * lightweight components.
         */
        JFrame frame = new JFrame("LabelAlignDemo");

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.getContentPane().add(new LabelAlignDemo(), BorderLayout.CENTER);
        frame.pack();
        frame.setVisible(true);
    }
}
