import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DrawingDemo extends JComponent {
    Dimension preferredSize = new Dimension(200, 150);

    public DrawingDemo() {
	setBorder(BorderFactory.createTitledBorder("Titled Border"));
    }

    public void paintComponent(Graphics g) {
	Dimension d = getSize();
	Insets insets = getInsets();

	//Draw a line around this component.
	g.drawRect(0, 0, d.width - 1, d.height - 1);

	//Draw inside of the border.
	g.setColor(Color.yellow);
	g.fillRect(insets.left, insets.top, 
		   d.width - insets.right - insets.left,
		   d.height - insets.bottom - insets.top);
    }

    public Dimension getPreferredSize() {
	return preferredSize;
    }

    public Dimension getMinimumSize() { 
	return preferredSize;
    }

    public static void main(String[] args) {
	JFrame f = new JFrame("DrawingDemo");
	f.addWindowListener(new WindowAdapter() {
	    public void windowClosing() {
		System.exit(0);
	    }
	});

	JPanel pane = new JPanel();
	pane.setLayout(new BorderLayout());
	pane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
	pane.add(new DrawingDemo(), BorderLayout.CENTER);

	//JPanel is opaque, so it can be the content pane.
	f.setContentPane(pane);
	f.pack();
	f.setVisible(true);
    }
}
