import javax.swing.*;          //This is the final package name.
//import com.sun.java.swing.*; //Used by JDK 1.2 Beta 4 and all
                               //Swing releases before Swing 1.1 Beta 3.
import java.awt.*;
import java.awt.event.*;

public class SwingApplet extends JApplet
                         implements ActionListener {
    private JLabel label;
    private static String labelPrefix = "Number of button clicks: ";
    private int numClicks = 0;

    public SwingApplet() {
        //This is a hack to try to avoid an ugly message.
        getRootPane().putClientProperty("defeatSystemEventQueueCheck",
                                        Boolean.TRUE);
    }

    public void init() {
        //Create a button and label.
        JButton button = new JButton("I'm a Swing button!");
        button.setMnemonic('i');
        button.addActionListener(this);

        label = new JLabel(labelPrefix + "0    ");
        label.setLabelFor(button);

        /*
         * An easy way to put space between a top-level container
         * and its contents is to put the contents in a JPanel
         * that has an "empty" border.
         */
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));
        pane.setLayout(new GridLayout(0, 1));
        pane.add(button);
        pane.add(label);

	//Add the JPanel to this applet.
        getContentPane().add(pane, BorderLayout.CENTER);
    }

    public void actionPerformed(ActionEvent e) {
        numClicks++;
        label.setText(labelPrefix + numClicks);
    }
}
