-------------------------------------------------------------------------------
-- Ejemplos de Entrada/Salida
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

import IO hiding (try, bracket)

prog1 :: IO ()
prog1 = do
  putStrLn "Hola. ¿Cómo te llamas?"
  n <- getLine
  putStrLn $ "Encantado de conocerte " ++ n

main :: IO ()
main = prog1


data Persona = Pers { nombre :: String
                     , edad :: Int
                     } deriving Show


leePersona :: IO Persona
leePersona = do
  putStr "Dame el nombre: "
  n <- getLine 
  putStr "Dame la edad: "
  e <- readLn 
  let p = Pers { nombre = n, edad = e }
  return p

prog2 :: IO ()
prog2 = do
  p <- leePersona
  putStrLn $ "La persona leída es " ++ show p


-- Copiando un fichero
--   openFile :: FilePath -> IOMode -> IO Handle
--   hClose :: Handle -> IO ()
--   hIsEOF :: Handle -> IO Bool
--   hGetLine :: Handle -> IO String
--   hPutStrLn :: Handle -> String -> IO ()

copiaFich :: FilePath -> FilePath -> IO ()
copiaFich orig dest = do
  hIn <- openFile orig ReadMode
  hOut <- openFile dest WriteMode
  go hIn hOut
  hClose hIn
  hClose hOut


go :: Handle -> Handle -> IO ()
go hIn hOut = do
  end <- hIsEOF hIn
  if end then return ()
         else do 
           ln <- hGetLine hIn
           hPutStrLn hOut ln
           go hIn hOut



-- El tipo IO es `de primera clase'
dosVeces :: IO () -> IO ()
dosVeces io = do
  io
  io

repite :: Int -> IO () -> IO ()
repite 0     io = return ()
repite (n+1) io = do
  io
  repite n io

-- sequence :: [IO a] -> IO ()
prog3 :: IO ()
prog3 = sequence_ [ putStrLn xs | xs <- ["hola","adios","vale"] ]


repite' :: Int -> IO () -> IO ()
repite' n io = sequence_ (replicate n io)


-- Capturando excepciones:
--   catch :: IO a -> (IOError -> IO a) -> IO a
--   isDoesNotExistError :: IOError -> Bool
ejemplo :: FilePath -> IO ()
ejemplo fich = do
  hIn <- openFile fich ReadMode
  -- procesa fichero
  hClose hIn
 `catch` \e -> if isDoesNotExistError e 
                 then putStrLn "El fichero no existe" 
                 else putStrLn "Otro error" 


-- Elevando excepciones:
--  userError :: String -> IOError   crea un IOError de usuario
--  ioError :: IOError -> IO a       eleva una excepción 
escribeFactorial :: Integer -> IO ()
escribeFactorial x
 | x < 0      = ioError (userError "Argumento negativo")
 | otherwise  = putStrLn $ "El factorial de "++show x++" es "++show (fact x)
 where
  fact :: Integer -> Integer
  fact 0  = 1
  fact n  = n * fact (n-1)


-- definido en módulo IO 
try :: IO a -> IO (Either IOError a)
try io  = body `catch` \e -> return (Left e)
 where body = do
          x <- io
          return (Right x)
          
-- definido en módulo IO 
bracket :: IO a -> (a -> IO b) -> (a -> IO c) -> IO c
bracket adquirir liberar body = do
  h <- adquirir
  r <- try (body h)
  liberar h
  case r of
    Right x -> return x
    Left  e -> ioError e

tamañoFich :: FilePath -> IO Integer
tamañoFich fich = 
  bracket (openFile fich ReadMode) hClose hFileSize


tamañoFich' :: FilePath -> IO (Maybe Integer)
tamañoFich' fich = 
  bracket (openFile fich ReadMode) hClose $ 
          \h -> do 
             sz <- hFileSize h
             return (Just sz)
   `catch` \e -> return Nothing
