-------------------------------------------------------------------------------
-- Algunas clases predefinidas (no cargar este fichero)
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------


-- Tipos con igualdad
class Eq a where
  (==)  :: a -> a -> Bool
  (/=)  :: a -> a -> Bool

  -- Minimal complete definition: (==) or (/=)
  x == y  = not (x /= y)
  x /= y  = not (x == y)


data Ordering = LT | EQ | GT

-- Tipos con orden
class Ord a where
    (<), (<=), (>=), (>)   :: a -> a -> Bool
    max, min               :: a -> a -> a
    compare                :: a -> a -> Ordering

    -- Minimal complete definition: (<=) or compare
    compare x y | x==y      = EQ
		| x<=y      = LT
		| otherwise = GT

    x <= y                  = compare x y /= GT
    x <  y                  = compare x y == LT
    x >= y                  = compare x y /= LT
    x >  y                  = compare x y == GT

    max x y   | x <= y      = y
	      | otherwise   = x
    min x y   | x <= y      = x
	      | otherwise   = y

-- Tipos numéricos
class Num a where
    (+), (-), (*)  :: a -> a -> a
    negate         :: a -> a
    abs, signum    :: a -> a
    fromInteger    :: Integer -> a
    fromInt        :: Int -> a

    -- Minimal complete definition: All, except negate or (-)
    x - y           = x + negate y
    fromInt         = fromIntegral
    negate x        = 0 - x

