-------------------------------------------------------------------------------
-- Tokenizer: parte una lista en tokens
--
-- Ampliación de Programación
-- Pepe Gallardo, 2010
-------------------------------------------------------------------------------

module Tokenizer ( tokens
                  ) where


-- El primer argumento es un predicado que verifican los
-- elementos de la secuencia segundo argumento que se
-- consideran separadores. Los tokens están constituidos
-- por elementos consecutivos que no son separadores

tokens :: (a -> Bool) -> [a] -> [[a]]
tokens isSep []  = []
tokens isSep ys  = aux (dropWhile isSep ys)
  where
    aux []  = []
    aux xs  = tk : tokens isSep xs'
      where
        (tk,xs') = span (not . isSep) xs 
 
