//Determina la cantidad de columnas del textarea
var rows=10;
//Determina la posicion del cursor antes de entrar una url
var textSelected;

//Funcion que pinta en un campo. Tiene que recibir:
//tagStart determina el tag inicial a colocar (u, i, b, code, etc...)
//tagEnd determina el tag final a colocar (/u, /i, /b, /code, ...)
//field determina el nombre del id del cuadro de texto
//content indica el contenido a colocar entre el tagStart y el tagEnd
function insTag(tagStart,tagEnd,field,content){
	var input = document.getElementById(field);
	if(typeof document.selection != 'undefined' && document.selection)
	{
		//IE - Opera
		//Si hemos recibido el contenido del tag
		if(content)
		{
			var insText=content
		}else{
			//Si tenemos texto seleccionado
			if(document.selection.createRange().text)
			{
				//Devuelve el texto seleccionado si lo hay
				var insText=document.selection.createRange().text;
			}else if(typeof(textSelected)=='object'){ //cogemos el valor de la variable si es un objeto (unicamente tiene valor cuando seleccionamos una url)
				var insText=textSelected.text;
			}else if(tagEnd){ //si no tenemos texto seleccionado pero tenemos un tag para colocar al final
				var insText="Reemplace este texto";
			}else{
				var insText="";
			}
		}
		//Causa que un objeto dentro de la pgina reciba el foco y dispara el evento onfocus
		input.focus();
		//si ya tenemos un valor seleccionado (Puede ser unicamente si hemos seleccionado una url)
		if(textSelected)
		{
			var sel=textSelected;
		}else{
			//Retorna un objeto de la actual seleccin hecha en el documento
			var sel=document.selection.createRange();
		}
		if(tagEnd)
		{
			//sel.text=al texto seleccionado. Reemplaza el texto seleccionado unicamente
			sel.text=tagStart+insText+tagEnd;
		}else{
			sel.text=tagStart+insText;
		}
		//coloca el foco en el campo
		sel.select();
	}else if(typeof input.selectionStart != 'undefined'){
		//FF
		//Si textSelected no tiene valor, cogemos la entrada actual, sino cogemos el valor de la variable
		//Esta variable tiene valor si hemos introducido una url.
		if(!textSelected)
			textSelected=input;
		//Si el valor del input.scrollTop esta definido
		// input.scrollTop determina la posicion vertical del scroll
		if(typeof textSelected.scrollTop != 'undefined')
		{
			//cogemos el valor vertical
			var st=textSelected.scrollTop;
			//cogemos el valor horizontal
			var sl=textSelected.scrollLeft;
		}
		//Determina la primera posicion de seleccion o la posicion actual si no hay seleccion
		var start = textSelected.selectionStart;
		//Determina la ultima posicion de seleccion o la posicion actual si no hay seleccion
		var end = textSelected.selectionEnd;
		//Si hemos recibido el contenido del tag
		if(content)
		{
			var insText=content
		}else{
			if(start==end && tagEnd)
			{ //Si no hay texto seleccionado y tenemos un tag para colocar al final
				var insText = "Reemplace este texto";
			}else{
				//cogemos el texto contenido entre los dos valores
				var insText = textSelected.value.substring(start, end);
			}
		}
		//Aadimos nuevamente el contenido del cuadro de texto entero
		if(tagEnd)
		{
			//desde el primer punto hasta el punto inicial+tag+texto+tag+el resto del contenido
			textSelected.value = textSelected.value.substr(0, start)+tagStart+insText+tagEnd+input.value.substr(end);
		}else{
			//desde el primer punto hasta el punto inicial+tag+texto+el resto del contenido
			textSelected.value = textSelected.value.substr(0, start)+tagStart+insText+input.value.substr(end);
		}
		//Causa que un objeto dentro de la pgina reciba el foco y dispara el evento onfocus
		textSelected.focus();
		//Si el valor del input.scrollTop esta definido
		// input.scrollTop determina la posicion vertical del scroll
		if(typeof textSelected.scrollTop != 'undefined')
		{
			//establecemos el valor vertical
			textSelected.scrollTop=st;
			//establecemos el valor horizontal
			textSelected.scrollLeft=sl;
		}
		//colocamos el cursor al final de la entrada del tag
		if(tagEnd)
			textSelected.setSelectionRange(start+tagStart.length+insText.length+tagEnd.length,start+tagStart.length+insText.length+tagEnd.length);
		else
			textSelected.setSelectionRange(start+tagStart.length+insText.length,start+tagStart.length+insText.length);
	}else{
		if(tagEnd)
			input.value+=' '+tagStart+'Reemplace este texto'+tagEnd;
	}
	textSelected="";
	return;
}

//Funcin para aadir una url
function insLink(field,textvalue){
	//Cogemos el valor del campo
	var val=document.getElementById(textvalue).value;
	//Escondemos el div que muestra el enlace
	document.getElementById('link'+field).style.display='none';
	//Colocamos el valor por defecto
	document.getElementById(textvalue).value="http://";
	if(val && val!="http://")
	{
		//Pintamos el contenido
		insTag("[a href='"+val+"']","[/a]",field);
		//Una vez hemos pintado, vaciamos la variable
	}
}

//Funcin para soliciar una imagen externa
function insImage(field,textvalue){
	//Cogemos el valor del campo
	var val=document.getElementById(textvalue).value;
	//Escondemos el div que muestra el enlace
	document.getElementById('image'+field).style.display='none';
	//Colocamos el valor por defecto
	document.getElementById(textvalue).value="http://";
	if(val && val!="http://")
	{
		//Pintamos el contenido
		insTag("[img]","[alineacion][/img]",field,val);
		//Una vez hemos pintado, vaciamos la variable
	}
}

//Funcion para crecer el tamao del cuadro de texto
function rowAdd(field)
{
	if(rows<25)
	{
		rows=rows+5;
		document.getElementById(field).rows=rows;
	}
}

//Funcion para decrecer el tamao del cuadro de texto
function rowDel(field)
{
	if(rows>5)
	{
		rows=rows-5;
		document.getElementById(field).rows=rows;
	}
}

//Funcion que muestra el div en la posicion del mouse
function showDiv(field,event,divName)
{
	//Escondemos todos lo posibles divs abiertos
	document.getElementById('link'+field).style.display='none';
	document.getElementById('image'+field).style.display='none';
	document.getElementById('smile'+field).style.display='none';
	
	//Cogemos el valor del cursor, ya que al entrar una url, se pierde el foco
	posCursor(field);
	//Determina un margen de pixels del div al raton
	margin=5;

	//La variable IE determina si estamos utilizando IE
	var IE = document.all?true:false;
	//Si no utilizamos IE capturamos el evento del mouse
	if (!IE) document.captureEvents(Event.MOUSEMOVE)

	var tempX = 0;
	var tempY = 0;

	if(IE)
	{ //para IE
		tempX = event.clientX + document.body.scrollLeft;
		tempY = event.clientY + document.body.scrollTop;
	}else{ //para netscape
		tempX = event.pageX;
		tempY = event.pageY;
	}
	if (tempX < 0){tempX = 0;}
	if (tempY < 0){tempY = 0;}

	document.getElementById(divName).style.top = (tempY+margin);
	document.getElementById(divName).style.left = (tempX+margin);
	document.getElementById(divName).style.display='block';
	return;
}

//determinamos la posicion del cursor para posteriormente colocarnos al aadir el texto
function posCursor(field)
{
	var input = document.getElementById(field);
	if(typeof document.selection != 'undefined' && document.selection)
	{
		//IE - Opera
		//Causa que un objeto dentro de la pgina reciba el foco y dispara el evento onfocus
		input.focus();
		//Retorna un objeto de la actual seleccin hecha en el documento
		textSelected=document.selection.createRange();
		return;
	}else if(typeof input.selectionStart != 'undefined'){
		//FF
		//Si el valor del input.scrollTop esta definido
		// input.scrollTop determina la posicion vertical del scroll
		textSelected=input;
		return;
	}
}

function previewHelp()
{
	//colocamos la capas en la posicion actual del documento.
	if(document.body.offsetHeight>document.body.scrollHeight)
		var varheight=document.body.offsetHeight; //firefox
	else
		var varheight=document.body.scrollHeight //IE
	document.getElementById('layerHelp').style.top=0;
	document.getElementById('layerHelp').style.height=varheight;
	document.getElementById('layerHelpIntern').style.top=document.body.scrollTop;
	document.getElementById('layerHelp').style.width=document.body.clientWidth;
	document.getElementById('layerHelp').style.display='inline';
}
