<!--
var Conexion=false; // Variable que manipula la conexion.
var js_idReloj=""; // Determina el nombre del id que hace referencia al reloj
var js_servidor=""; // Determina la pagina donde buscar
var js_cadena=""; // Determina la ultima palabra buscada.

// funcion que realiza la conexion con el objeto XMLHTTP...
function Conectar()
{
	if(window.XMLHttpRequest)
		Conexion=new XMLHttpRequest(); //mozilla
	else if(window.ActiveXObject)
		Conexion=new ActiveXObject("Microsoft.XMLHTTP"); //microsoft
}

//gestiona contenido devuelto en formato HTML
function ContenidoHTML(idDestino)
{
	/* readyState devuelve el estado de la conexion. puede valer:
	*	0- No inicializado (Es el valor inicial de readyState)
	*	1- Abierto (El mtodo "open" ha tenido xito)
	*	2- Enviado (Se ha completado la solicitud pero ningun dato ha sido recibido todava)
	*	3- Recibiendo
	*	4- Respuesta completa (Todos los datos han sido recibidos)
	*/

	// En espera del valor 4
	if(Conexion.readyState!=4) return;
	/* status: contiene un codigo enviado por el servidor
	*	200-Completado con xito
	*	404-No se encontr URL
	*	414-Los valores pasados por GET superan los 512
	* statusText: contiene el texto del estado
	*/
	if(Conexion.status==200) // Si conexion HTTP es buena !!!
	{
		//si recibimos algun valor a mostrar...
		if(Conexion.responseText)
		{
			/* Modificamos el identificador temp con el valor recibido por la consulta
			*	Podemos recibir diferentes tipos de datos:
			*	responseText-Datos devueltos por el servidor en formato cadena
			*	responseXML-Datos devueltos por el servidor en forma de documento XML
			*/
			document.getElementById(idDestino).innerHTML=Conexion.responseText;
		}
	}else{
		document.getElementById(idDestino).innerHTML=Conexion.status+"-"+Conexion.statusText;
	}
	// Deshabilitamos la visualizacin del reloj
	document.getElementById(js_idReloj).style.visibility="hidden";

	Conexion=false;
}

function Solicitud(idDestino,Cadena)
{
	// si no recibimos cadena, no hacemos nada.
	// Cadena=la cadena a reempazar
	if(Cadena && Cadena!=js_cadena)
	{
		// Si ya esta conectado, cancela la solicitud en espera de que termine
		if(Conexion) return; // Previene uso repetido del boton.
		
		// Realiza la conexion
		Conectar();
		// Si la conexion es correcta...
		if(Conexion)
		{
			// Habilitamos la visualizacin del reloj
			document.getElementById(js_idReloj).style.visibility="visible";

			// Esta variable, se utiliza para igualar con la cadena a buscar.
			js_cadena=Cadena;

			/* Preparamos una conexion con el servidor:
			*	POST|GET - determina como se envian los datos al servidor
			*	true - No sincronizado. Ello significa que la pgina WEB no es interferida en su funcionamiento
			*	por la respuesta del servidor. El usuario puede continuar usando la pgina mientras el servidor
			*	retorna una respuesta que la actualizar, usualmente, en forma parcial.
			*	false - Sincronizado */
			Conexion.open("POST",js_servidor,true);

			// Aade un par etiqueta/valor a la cabecera HTTP a enviar. Si no lo colocamos, no se pasan los parametros.
			Conexion.setRequestHeader("Content-Type","application/x-www-form-urlencoded");

			// Cada vez que el estado de la conexin (readyState) cambie se ejecutara el contenido de esta "funcion()"
			Conexion.onreadystatechange=function()
			{
				ContenidoHTML(idDestino);
			}

			date=new Date();
			/* Realiza la solicitud al servidor. Puede enviar una cadena de caracteres, o un objeto del tipo XML
			 * Si no deseamos enviar ningun valor, enviariamos null */
			Conexion.send("content="+Cadena+"&"+date);
		}else
			document.getElementById(idDestino).innerHTML="No disponible";
	}
}

/* Funcion que inicia la busqueda a partir del 3 caracter
 * Tiene que recibir:
 *	el identificador donde mostrar el texto
 *	el identificador del reloj
 *	el fichero php a ejecutar
 *	id identificador del contenedor del texto a previsualizar
 */
function preview(idDestino,idReloj,filePHP,idOrigen)
{
	//colocamos la capa en la posicion actual del documento.
	if(document.body.offsetHeight>document.body.scrollHeight)
		var varheight=document.body.offsetHeight; //firefox
	else
		var varheight=document.body.scrollHeight //IE
	document.getElementById('layerTransparente').style.top=0;
	document.getElementById('layerTransparente').style.height=varheight;
	document.getElementById('layerPreviewIntern').style.top=document.body.scrollTop;
	document.getElementById('layerTransparente').style.width=document.body.clientWidth;

	js_idReloj=idReloj;
	js_servidor=filePHP;
	Cadena=document.getElementById(idOrigen).value;

	// Comprovamos que la longitud de la cadena sea superior a 1 caracter
	if(Cadena.length>0)
	{
		document.getElementById('layerTransparente').style.display="inline";
		if(Conexion==true)
		{
			//si esta en medio de una conexion, la cancelamos
			Conexion=false;
			Conexion.abort();
			// Deshabilitamos la visualizacin del reloj
			document.getElementById(js_idReloj).style.visibility="hidden";
		}
		Solicitud(idDestino,Cadena);
	}else
		document.getElementById('layerTransparente').style.display="none";
}
