<?php
/*
 * Funcion que reemplaza los codigos bebecode por los codigos html
 */
function bebeToHtml($cadena)
{
	$caracteres=array("","","","","","","","","","","","","","","","");
	$caracteresValues=array("acute;","&Aacute;","&eacute;","&Eacute;","&iacute;","&Iacute;","&oacute;","&Oacute;","&uacute;","&Uacute;","&iuml;","&Iuml;","&uuml;","&Uuml;","&ntilde;","&tilde;");
	$emoticons=array("[:-)]","[:-D]","[:-P]","[;-)]","[:-@]","[:-S]","[:'(]","[:-$]","[:-O]","[:-(]","[(H)]","[(*)]","[:-[]","[(B)]","[(^)]","[(P)]","[(C)]","[(E)]","[(~)]","[(K)]","[(I)]","[(L)]","[(N)]","[(Y)]");
	$emoticonsValues=array("<img src='/img/emoticons/smile.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/teeth.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/tongue.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/wink.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/angry.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/confused.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cry.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/embarassed.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/omg.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/sad.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/shade.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/star.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/bat.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/beer.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cake.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/camera.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cup.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/email.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/film.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/kiss.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/lightbulb.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/love.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/down.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/up.gif' width='22' height='22' border='0' />");
	$options=array("[b]","[/b]","[u]","[/u]","[i]","[/i]","[code]","[/code]","[quote]","[/quote]","[h2]","[/h2]","[h3]","[/h3]","[-- --]","[paragraph]","[/paragraph]","[indent]","[/indent]");
	$optionsValues=array("<b>","</b>","<u>","</u>","<i>","</i>","<code>","</code>","<quote>","</quote>","<h2>","</h2>","<h3>","</h3>","<div class='line'></div>","<div style='clear:both;'>","</div>","<div class='indent'>","</div>");

	//colocamos un espacio en blanco en el inicio para no tener problemas con la instruccion strpos()
	$cadena=" ".$cadena;
	//Si hay mas de dos lineas de salto, las eliminamos (Firefox)
	do{
		$pos=strpos($cadena,"\n\n\n");
		$cadena=str_replace("\n\n\n","\n\n",$cadena);
	}while($pos>0);
	//Si hay mas de dos lineas de salto, las eliminamos (IE)
	do{
		$pos=strpos($cadena,"\n\r\n\r");
		$cadena=str_replace("\n\r\n\r","\n\r",$cadena);
	}while($pos>0);
	
	//Eliminamos las contrabarras
	$cadena=str_replace("\\\"","\"",$cadena);
	$cadena=str_replace("\'","'",$cadena);
	$cadena=str_replace("\\\\","\\",$cadena);
	
	//Modificamos la cadena por su equivalente en formato html sin modificar las comillas simples
	// y si las comillas dobles (htmlentities)
	//Modificamos los saltos de linea por <br /> (nl2br)
	$cadena=nl2br(htmlentities($cadena,ENT_COMPAT,"ISO-8859-15"));
	
	//Reemplazamos acentos, tildes y otros caracteres
	//$cadena=str_replace($caracteres,$caracteresValues,$cadena);
	
	//Reemplazamos los emoticons
	$cadena=str_replace($emoticons,$emoticonsValues,$cadena);
	
	//Reemplazamos caracteres varios
	$cadena=str_replace($options,$optionsValues,$cadena);
	
	//Enlace a una url
	//[a href="http://terra.es"]texto[/a]
	while(ereg('\[a href=\''.'(.)+'.'\'\]'.'(.)+'.'\[/a\]',$cadena))
	{
		//Cogemos la posicion de inicio del enlace
		$posini=strpos($cadena,"[a href='");
		//Cogemos la posicion intermedia del enlace
		$posent=strpos($cadena,"']",$posini);
		//Cogemos la posicion final del enlace
		$posfin=strpos($cadena,"[/a]",$posent);

		//Si hay una posicion inicial y una intermedia superior y una final superior...
		if($posini>0 && $posent>$posini && $posfin>$posent)
		{
			//Reemplazamos la primera parte
			$cadena=substr_replace($cadena,"<a href='",$posini,strlen("[a href='"));
			//Cogemos nuevamente la posicion intermedia ya que puede haber canviado en el paso anterior
			$posent=strpos($cadena,"']",$posini);
			$cadena=substr_replace($cadena,"' target='_blank'>",$posent,strlen("']"));
			//Cogemos nuevamente la posicion final ya que ha canviado en el paso anterior
			$posfin=strpos($cadena,"[/a]",$posent);
			$cadena=substr_replace($cadena,"</a>",$posfin,strlen("[/a]"));
		}
	}
	
	//Enlace a una imagen
	//[img]http://image.jpg[alineacion][/img]
	while(ereg('\[img\]'.'(.)+'.'\['.'(.)+'.'\]\[/img\]',$cadena))
	{
		//Cogemos la posicion de inicio de la imagen
		$posini=strpos($cadena,"[img]");
		//Cogemos la posicion final de la imagen
		$posfin=strpos($cadena,"[/img]",$posini);
		//Cogemos la posicion inicial de la alineaci?n
		$posAlignIni=strpos($cadena,"[",$posini+1);
		//Cogemos la posicion final de la alineaci?n
		$posAlignFin=strpos($cadena,"]",$posAlignIni);
		//Cogemos el texto de alineacion
		$textAlign=substr($cadena,($posAlignIni+1),($posAlignFin-$posAlignIni-1));
		//Si se ha encontrado una posicion inicial y una posicion final...
		if($posini>0 && $posfin>$posini)
		{
			//Reemplazamos la primera posici?n [img] por <img src='
			$cadena=substr_replace($cadena,"<img src='",$posini,strlen("[img]"));
			//Si la primera posicion de la alineacion es inferior al final, y
			//si la posicion final de la alineacion es inferior a la posicion final, y
			//el texto de la alineacion es left o right...
			if($posAlignIni<$posfin && $posAlignFin<$posfin && ($textAlign=='left' || $textAlign=='right'))
			{
				//Cogemos nuevamente la posicion inicial de la alineaci?n ya que ha canviado en el paso anterior
				$posAlignIni=strpos($cadena,"[",$posini);
				//Reemplazamos [ por ' align='
				$cadena=substr_replace($cadena,"' align='",$posAlignIni,strlen("["));
				//Cogemos nuevamente la posicion final de la alineaci?n ya que ha canviado en el paso anterior
				$posAlignFin=strpos($cadena,"]",$posAlignIni);
				$cadena=substr_replace($cadena,"'",$posAlignFin,strlen("]"));
				//Cogemos nuevamente la posicion final de la imagen, ya que ha estado variando su posicion en los reemplazos anteriores
				$posfin=strpos($cadena,"[/img]",$posini);
				$cadena=substr_replace($cadena," border=0/>",$posfin,strlen("[/img]"));
			}else{
				//Si no hay alineacion que colocar, buscamos la primera posicion de la alineacion ya que ha canviado en el paso anterior
				$posAlignIni=strpos($cadena,"[",$posini);
				//Cogemos nuevamente la posicion final de la imagen, ya que ha estado variando su posicion en los reemplazos anteriores
				$posfin=strpos($cadena,"[/img]",$posini);
				//Colocamos el final del codigo quitando todo el texto de alineacion y la mascara de final [/img]
				$cadena=substr_replace($cadena,"' border=0/>",$posAlignIni,($posfin-$posAlignIni+6));
			}
		}
	}
	
	//Quitamos algunos saltos de linea...
	$options=array("</div><br />","class='indent'><br />");
	$optionsValues=array("</div>","class='indent'>");
	$cadena=str_replace($options,$optionsValues,$cadena);

	return $cadena;
}

/*
* Funcion que reemplaza los codigos html por los codigos bebecode
*/
function editor_htmlToBebe($cadena)
{
	$caracteres=array("","","","","","","","","","","","","","","","");
	$caracteresValues=array("acute;","&Aacute;","&eacute;","&Eacute;","&iacute;","&Iacute;","&oacute;","&Oacute;","&uacute;","&Uacute;","&iuml;","&Iuml;","&uuml;","&Uuml;","&ntilde;","&tilde;");
	$emoticons=array("[:-)]","[:-D]","[:-P]","[;-)]","[:-@]","[:-S]","[:'(]","[:-$]","[:-O]","[:-(]","[(H)]","[(*)]","[:-[]","[(B)]","[(^)]","[(P)]","[(C)]","[(E)]","[(~)]","[(K)]","[(I)]","[(L)]","[(N)]","[(Y)]");
	$emoticonsValues=array("<img src='/img/emoticons/smile.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/teeth.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/tongue.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/wink.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/angry.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/confused.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cry.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/embarassed.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/omg.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/sad.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/shade.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/star.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/bat.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/beer.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cake.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/camera.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/cup.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/email.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/film.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/kiss.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/lightbulb.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/love.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/down.gif' width='22' height='22' border='0' />", "<img src='/img/emoticons/up.gif' width='22' height='22' border='0' />");
	$options=array("[b]","[/b]","[u]","[/u]","[i]","[/i]","[code]","[/code]","[quote]","[/quote]","[h2]","[/h2]","[h3]","[/h3]","[-- --]","[paragraph]","[/paragraph]","[indent]","[/indent]");
	$optionsValues=array("<b>","</b>","<u>","</u>","<i>","</i>","<code>","</code>","<quote>","</quote>","<h2>","</h2>","<h3>","</h3>","<div class='line'></div>","<div style='clear:both;'>","</div>","<div class='indent'>","</div>");

	//colocamos un espacio en blanco en el inicio para no tener problemas con la instruccion strpos()
	$cadena=" ".$cadena;

	//Reemplazamos acentos, tildes y otros caracteres
	//$cadena=str_replace($caracteres,$caracteresValues,$cadena);
	
	//Reemplazamos los emoticons
	$cadena=str_replace($emoticonsValues,$emoticons,$cadena);
	
	//Reemplazamos caracteres varios
	$cadena=str_replace($optionsValues,$options,$cadena);
	
	//Enlace a una url
	//[a href="http://terra.es"]texto[/a]
	do
	{
		//Cogemos la posicion de inicio del enlace
		$posini=strpos($cadena,"<a href='");
		//Cogemos la posicion intermedia del enlace
		$posent=strpos($cadena,"' target='_blank'>",$posini);
		//Cogemos la posicion final del enlace
		$posfin=strpos($cadena,"</a>",$posent);
		//Si hay una posicion inicial y una intermedia superior y una final superior...
		if($posini>0 && $posent>$posini && $posfin>$posent)
		{
			//Reemplazamos la primera parte
			$cadena=substr_replace($cadena,"[a href='",$posini,strlen("<a href='"));
			//Cogemos nuevamente la posicion intermedia ya que puede haber canviado en el paso anterior
			$posent=strpos($cadena,"' target='_blank'>",$posini);
			$cadena=substr_replace($cadena,"']",$posent,strlen("' target='_blank'>"));
			//Cogemos nuevamente la posicion final ya que ha canviado en el paso anterior
			$posfin=strpos($cadena,"</a>",$posent);
			$cadena=substr_replace($cadena,"[/a]",$posfin,strlen("</a>"));
		}
	}while($posini>0);
	
	//Enlace a una imagen
	//[img]http://image.jpg[alineacion][/img]
	do
	{
		//Cogemos la posicion de inicio de la imagen
		$posini=strpos($cadena,"<img src='");
		//Cogemos la posicion final de la imagen
		$posfin=strpos($cadena," border=0/>",$posini);
		//Cogemos la posicion inicial de la alineacin
		$posAlignIni=strpos($cadena,"' align='",$posini+1);
		if($posAlignIni)
		{
			//Cogemos la posicion final de la alineacin
			$posAlignFin=strpos($cadena,"'",($posAlignIni+strlen("' align='")));
			//Cogemos el texto de alineacion
			$textAlign=substr($cadena,($posAlignIni+strlen("' align='")),($posAlignFin-$posAlignIni-strlen("' align='")));
		}
		//Si se ha encontrado una posicion inicial y una posicion final...
		if($posini>0 && $posfin>$posini)
		{
			//Reemplazamos la primera posicin [img] por <img src='
			$cadena=substr_replace($cadena,"[img]",$posini,strlen("<img src='"));
			//Si la primera posicion de la alineacion es inferior al final, y
			//si la posicion final de la alineacion es inferior a la posicion final, y
			//el texto de la alineacion es left o right...
			if($posAlignIni<$posfin && $posAlignFin<$posfin && ($textAlign=='left' || $textAlign=='right'))
			{
				//Cogemos nuevamente la posicion inicial de la alineacin ya que ha canviado en el paso anterior
				$posAlignIni=strpos($cadena,"' align='",$posini);
				//Reemplazamos [ por ' align='
				$cadena=substr_replace($cadena,"[",$posAlignIni,strlen("' align='"));
				//Cogemos nuevamente la posicion final de la alineacin ya que ha canviado en el paso anterior
				$posAlignFin=strpos($cadena,"'",$posAlignIni);
				$cadena=substr_replace($cadena,"]",$posAlignFin,strlen("'"));
				//Cogemos nuevamente la posicion final de la imagen, ya que ha estado variando su posicion en los reemplazos anteriores
				$posfin=strpos($cadena," border=0/>",$posini);
				$cadena=substr_replace($cadena,"[/img]",$posfin,strlen(" border=0/>"));
			}else{
				//Cogemos nuevamente la posicion final de la imagen, ya que ha estado variando su posicion en los reemplazos anteriores
				$posfin=strpos($cadena,"' border=0/>",$posini);
				//Colocamos el final del codigo quitando todo el texto de alineacion y la mascara de final [/img]
				$cadena=substr_replace($cadena,"[alineacion][/img]",$posfin,strlen("' border=0/>"));
			}
		}
	}while($posini>0);

	//Quitamos algunos saltos de linea...
	$cadena=str_replace("<br />","",$cadena);

	return trim($cadena);
}

/*
 * Funcion que muestra los iconos
 */
function showIcons($name)
{
	?>
	<!--mostramos algunos estilos para cada uno de los cuadros de texto -->
	<style type="text/css">
		#smile<?php echo $name?>
		{position: absolute;display:none;width:220px;border:1px solid #808080;padding:5px;background-color:#f1f1f1;}
		#link<?php echo $name?>
		{position: absolute;display:none;width:300px;border:1px solid #808080;padding:5px;background-color:#f1f1f1;}
		#image<?php echo $name?>
		{position: absolute;display:none;width:300px;border:1px solid #808080;padding:5px;background-color:#f1f1f1;}
	</style>

	<!--mostramos los botones en la barra de titulo-->
	<div style='clear:both;width:100%'>
		<span class='button'><img src='imgs/icon_nuevo.png' width="25" height="25" onclick="insTag('[b]','[/b]','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title='Nuevo' /></span>
		<span class='button'><img src='imgs/icon_abrir.png'  width="25" height="25" onclick="insTag('[u]','[/u]','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Abrir" /></span>
		<span class='button'><img src='imgs/icon_guardar.png'  width="25" height="25" onclick="insTag('[i]','[/i]','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Guardar" /></span>
		<span class='button'><img src='imgs/icon_imprimir.png' width="25" height="25" onclick="showDiv('<?php echo $name?>',event,'link<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Imprimir" /></span>
		<span class='button'><img src='imgs/icon_cortar.png' width="25" height="25" onclick="showDiv('<?php echo $name?>',event,'image<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Cortar" /></span>
		<span class='button'><img src='imgs/icon_copiar.png' width="25" height="25" onclick="showDiv('<?php echo $name?>',event,'smile<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Copiar" /></span>
		<span class='button'><img src='imgs/icon_pegar.png' width="25" height="25" onclick="insTag('\n[code]','[/code]\n','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Pegar" /></span>
		<span class='button'><img src='imgs/icon_conn.png' width="25" height="25" onclick="insTag('\n[quote]','[/quote]\n','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Conectar" /></span>
		<span class='button'><img src='imgs/icon_ex_fuzz.png' width="25" height="25" onclick="insTag('&#8226;&nbsp;','','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Ejecutar query FSQL" /></span>
		<span class='button'><img src='imgs/icon_ex_sql.png' width="25" height="25" onclick="insTag('[indent]','[/indent]','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Ejecutar query SQL" /></span>
		
		<span class='button' style='margin-left:25px;'><img src='imgs/icon_desconn.png' width="22" height="22" onclick="preview('preview','idclock','preview.php','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Desconectar" /></span>
		<span class='button' style='margin-left:25px;'><img src='img/preview.gif' width="22" height="22" onclick="preview('preview','idclock','preview.php','<?php echo $name?>')" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Vista preliminar" /></span>
		<span class='button'><img src='img/help.gif' width="22" height="22" onclick="previewHelp()" class='buttonImage' onmouseout="this.style.border='solid 1px #f1f1f1';" onmouseover="this.style.border='solid 1px #808080';" border=0 title="Ayuda" /></span>
	</div>

	<!--div que contiene los emoticons-->
	<div id="smile<?php echo $name?>" onmouseout="this.style.display='none'"  onmouseover="this.style.display='block'">
		<span><a href="javascript:insTag('[:-)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/smile.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-D]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/teeth.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-P]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/tongue.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[;-)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/wink.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-@]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/angry.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-S]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/confused.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag(\"[:'(]\",'','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/cry.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-$]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/embarassed.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-O]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/omg.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-(]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/sad.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(H)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/shade.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(*)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/star.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[:-[]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/bat.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(B)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/beer.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(^)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/cake.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(P)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/camera.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(C)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/cup.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(E)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/email.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(~)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/film.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(K)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/kiss.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(I)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/lightbulb.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(L)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/love.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(N)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/down.gif" width="22" height="22" border="0" /></a></span>
		<span><a href="javascript:insTag('[(Y)]','','<?php echo $name?>')" onclick="smile<?php echo $name?>.style.display='none'"><img src="img/emoticons/up.gif" width="22" height="22" border="0" /></a></span>
	</div>

	<!--div para entrar un enlace externo-->
	<div id="link<?php echo $name?>" onmouseout="this.style.display='none'" onmouseover="this.style.display='block'">
		<span>Entra la direccin Url del enlace:</span>
		<span><input type='text' id='editor_link<?php echo $name?>' name='editor_link<?php echo $name?>' size=33 value='http://' /><input type='button' value='enviar' onclick="insLink('<?php echo $name?>','editor_link<?php echo $name?>')" /></span>
	</div>

	<!--div para entrar una imagen externa-->
	<div id="image<?php echo $name?>" onmouseout="this.style.display='none'" onmouseover="this.style.display='block'">
		<span>Entra la direccin Url de la imagen:</span>
		<span><input type='text' id='editor_image<?php echo $name?>' name='editor_image<?php echo $name?>' size=33 value='http://' /><input type='button' value='enviar' onclick="insImage('<?php echo $name?>','editor_image<?php echo $name?>')" /></span>
	</div>
	<?php
}
?>
