-- Fichero firstins2.sql
------------------------------------------------------------------------------
---------------------  CREACION DE FIRST2:  -----------------------
--   Creacion de las tablas de la base de metaconocimiento difuso (fmb).                               
-- estas tablas deben ser del dba, administrador de la base de 
-- datos (sys) y los usuarios autorizados a utilizar dicha base 
-- de datos tendran los siguientes permisos sobre esas tablas: 
--  SELECT: para poder efectuar consultas a la base de datos   
-- difusa (en fsql) y sobre dicha base de datos.      
--  INSERT: los usuarios con este permiso podran declarar      
-- nuevos atributos difusos, nuevas etiquetas...      
--  UPDATE: con este permiso los usuarios podran actualizar    
-- los valores de la fmb: alterar etiquetas...        
-- debe ser otorgado a usuarios experimentados       
-- de confianza.                                      
--  DELETE: con este permiso los usuarios podran borrar        
-- los valores de la fmb: borrar etiquetas...         
-- debe ser otorgado a usuarios experimentados       
-- de confianza.                                      
------------------------------------------------------------------------------


-- Tabla con las columnas que admiten tratamiento difuso
-- 1
CREATE TABLE fuzzy_col_list 
(
    obj		numeric 	not null,
    col         numeric 	not null,
    f_type      numeric(1) 	not null,
    len         numeric(2) 	not null,
    code_sig	numeric 	,
    colum_name	varchar(50) 	,
    com         varchar(100),
    CONSTRAINT pk_fcl PRIMARY KEY (obj, col),
--    CONSTRAINT fk_fcl_code_sig_fds foreign key (code_sig)
--        references fuzzy_degree_sig (code_sig) on delete cascade,
    constraint len_too_long_in_fuzzy_col_list
    check (len>=1 and len<=10),
    constraint fuzzy_type_long_in_fuzzy_col_list
    check (f_type=1 or f_type=2 or f_type=3 or f_type=4 or f_type=5 or f_type=6 or f_type=7 or f_type=8 )
);

--*campos
-- obj#	object_id de la tabla (obtenido de user_objects)
-- col#	column_id del campo (obtenido de user_tab_columns)
-- f_type	tipo de tratamiento difuso para ese campo (1, 2 o 3)
-- len	nmero de datos maximo en atributos tipo 3
--		suponemos que no hay mas de 10 datos (y 1 como minimo)
-- com	comentario breve (nombre de la tabla y columna)

-- objetos difusos de las columnas de la base de datos
-- 4
create table fuzzy_object_list 
(
    obj 		numeric 	not null,
    col 		numeric 	not null,
    fuzzy_id 	numeric(3) 	not null,
    fuzzy_name 	varchar(30) not null,
    fuzzy_type 	numeric(1) 	not null,
    CONSTRAINT pk_fol primary key (obj, col, fuzzy_id),
    constraint fk_obj_col_fol foreign key (obj, col)
        references fuzzy_col_list (obj, col) on delete cascade,
    constraint no_spaces_in_fuzzy_name
        check (fuzzy_name not like '% %')
);

--*campos
-- obj#/col#	object_id y column_id
-- fuzzy_id		identificador del objeto difuso. llave externa en:
--			fuzzy_label_def, fuzzy_nearness_def y fuzzy_qualifiers_def
-- fuzzy_name	nombre del objeto difuso
-- fuzzy_type	tipo de objeto:
--	0	etiqueta trapezoidal (ir a fld)
--	1	escalares con relaciones de semejanza (ir a fnd)
--	2	cualificadores (ir a fqd)
--	3	etiquetas sobre cuantificadores relativos (ir a fqnd)
--	4	etiquetas sobre cuantificadores absolutos (ir a fld)

-- trapecios asociados a las etiquetas
-- 5
create table fuzzy_label_def 
(
    obj       numeric 		not null,
    col       numeric 		not null,
    fuzzy_id  numeric(3) 	not null,
    alfa      numeric 		not null,
    beta      numeric 		not null,
    gamma     numeric 		not null,
    delta     numeric 		not null,
    CONSTRAINT pk_fld primary key (obj, col, fuzzy_id),
    constraint fk_obj_col_fuzzy_id_fld foreign key (obj, col, fuzzy_id)
    references fuzzy_object_list (obj, col, fuzzy_id)on delete cascade,
    constraint must_be_ordered
    check (alfa<=beta and beta<=gamma and gamma<=delta)
);

--*campos
-- obj/col	object_id y column_id
-- fuzzy_id		identificador del objeto difuso (fuzzy_type=0 o 4 en fol)
-- [alfa,beta,gamma,delta]	datos del trapecio donde alfa<=beta<=gamma<=delta

-- semejanza entre los escalares de los atributos tipo 3
-- 6
create table fuzzy_nearness_def 
(
    obj 		numeric 		not null,
    col 		numeric 		not null,
    fuzzy_id1 	numeric(3) 		not null,
    fuzzy_id2 	numeric(3) 		not null,
    degree    	numeric(3,2) 	not null,
    CONSTRAINT pk_fnd primary key (obj, col, fuzzy_id1, fuzzy_id2),
    constraint fk_obj_col_fuzzy_id1_fnd foreign key (obj, col, fuzzy_id1)
        references fuzzy_object_list (obj, col, fuzzy_id) on delete cascade,
    constraint fk_obj_col_fuzzy_id2_fnd foreign key (obj, col, fuzzy_id2)
        references fuzzy_object_list (obj, col, fuzzy_id) on delete cascade,
    constraint fuzzy_id1_igual_que_fuzzy_id2
        check (fuzzy_id1<>fuzzy_id2),
    constraint fuzzy_id1_mayor_que_fuzzy_id2
        check (fuzzy_id1<fuzzy_id2),
    constraint degree_must_be_in_0_1_interval
        check (degree>=0 and degree<=1)
);
-- obj/l	object_id y column_id
-- fuzzy_id1 y 2	identificadores de dos objetos difusos (fuzzy_type=1 en fol)
-- degree		valor en [0,1]: semejanza entre los dos objetos

-- almacena dos valores para atributos tipo 1 y 2:
--	1) margen por defecto para los valores aprox: n = nmargen
--	   se usara al insertar valores aprox, si no se indica otro margen
--	2) diferencia minima entre 2 valores de ese atributo, para poder afirmar
--	   que uno es mucho mayor o mucho menor que el otro:
--	   comparadores mgt (much greater than) y mlt (much less than).
-- por razones semanticas y para evitar confusiones en el orden,
-- se exige que margen sea menor que much.
-- 2
create table fuzzy_approx_much (
    obj 	numeric not null,
    col 	numeric not null,
    margen 	numeric not null,
    much 	numeric not null,
    CONSTRAINT pk_fam primary key (obj, col),
    constraint fk_obj_col_fam foreign key (obj, col)
        references fuzzy_col_list (obj, col) on delete cascade,
    constraint margen_less_than_much_in_fam
        check (margen<much)
);

-- definicion del cualificador (min) asociado al valor
-- de fuzzy_object_list (fuzzy_id): opcion no implementada an en el servidor fsql
--drop   table fuzzy_qualifiers_def;
--create table fuzzy_qualifiers_def(
--  obj# number not null,
--  col# number not null,
--  fuzzy_id number(3) not null, -- fuzzy_object_list.fuzzy_id%type
--  min number not null,
--  primary key (obj,col,fuzzy_id),
--  constraint fk_obj_col_fqd foreign key (obj,col)
--             references fuzzy_col_list (obj,col) on delete cascade);

-- definicion de columnas tipo 3 que son compatibles unas con otras.
-- 3
create table fuzzy_compatible_col (
    obj1 numeric not null,
    col1 numeric not null,
    obj2 numeric not null,
    col2 numeric not null,
    CONSTRAINT pk_fcc primary key (obj1, col1),
    constraint fk_obj1_col1_fcc foreign key (obj1, col1)
        references fuzzy_col_list (obj, col) on delete cascade,
    constraint fk_obj2_col2_fcc foreign key (obj2, col2)
        references fuzzy_col_list (obj, col) on delete cascade
);

------------------------------------  Cambios FISRT 2
-- 7 Fuzzy_Qualifiers_def
create table fuzzy_qualifiers_def 
(
    obj 		numeric 		not null,
    col 		numeric 		not null,
    fuzzy_id1 	numeric(3) 		not null,
    qualifier 	numeric(3,2) 	not null,
    CONSTRAINT pk_fqd primary key (obj, col, fuzzy_id1),
    constraint fk_obj_col_fuzzy_id_fqd foreign key (obj, col, fuzzy_id1)
    references fuzzy_object_list (obj, col, fuzzy_id)on delete cascade -- ,
--    constraint fuzzy_id1_igual_que_fuzzy_id2
--        check (fuzzy_id1<>fuzzy_id2),
--    constraint fuzzy_id1_mayor_que_fuzzy_id2
--        check (fuzzy_id1<fuzzy_id2),
--    constraint degree_must_be_in_0_1_interval
--        check (degree>=0 and degree<=1)
);

-- 8 Fuzzy_Degree_Sig
create table fuzzy_degree_sig 
(
    code_sig		numeric     not null,
    significance 	varchar(30) not null,
    CONSTRAINT pk_fds PRIMARY KEY (code_sig) -- ,

--    constraint fuzzy_id1_igual_que_fuzzy_id2
--        check (fuzzy_id1<>fuzzy_id2),
--    constraint fuzzy_id1_mayor_que_fuzzy_id2
--        check (fuzzy_id1<fuzzy_id2),
--    constraint degree_must_be_in_0_1_interval
--        check (degree>=0 and degree<=1)
);

-- 9
create table fuzzy_degree_cols (
    obj1 numeric not null,
    col1 numeric not null,
    obj2 numeric not null,
    col2 numeric not null,
    CONSTRAINT pk_fdc primary key (obj1, col1,obj2, col2),
    constraint fk_obj1_col1_fdc foreign key (obj1, col1)
        references fuzzy_col_list (obj, col) on delete cascade
);

-- 10
create table fuzzy_degree_table (
    obj 		numeric 	not null,
    col 		numeric 	not null,
    degree_type numeric(1) 	not null,
    CONSTRAINT pk_fdt primary key (obj, col),
    constraint fk_obj1_col1_fdt foreign key (obj, col)
        references fuzzy_col_list (obj, col) on delete cascade
);

-- 11 Fuzzy_table_Quantifiers     FTQ
create table fuzzy_table_quantifiers 
(
    obj       	numeric 	not null,
    fuzzy_name 	varchar(30) not null,
    fuzzy_type 	numeric(1) 	not null,
    alfa      	numeric 	not null,
    beta      	numeric 	not null,
    gamma     	numeric 	not null,
    delta     	numeric 	not null,
    CONSTRAINT pk_ftq primary key (obj, fuzzy_name) 
);

--*campos
-- obj/col	object_id y column_id
-- [alfa,beta,gamma,delta]	datos del trapecio donde alfa<=beta<=gamma<=delta


-- 12 Fuzzy_System_Quantifiers  FSQ
create table fuzzy_system_quantifiers 
(
    fuzzy_name 	varchar(30) not null,
    fuzzy_type 	numeric(1) 	not null,
    alfa      	numeric 	not null,
    beta      	numeric 	not null,
    gamma     	numeric 	not null,
    delta     	numeric 	not null,
    CONSTRAINT pk_fsq primary key (fuzzy_name) 
);

ALTER TABLE fuzzy_col_list 
ADD CONSTRAINT fk_fcl_code_sig_fds foreign key (code_sig)
        references fuzzy_degree_sig (code_sig) on delete cascade;



-- \echo ('>>>> concediendo permisos a public...')
grant select,insert,delete,update on fuzzy_col_list       		to public;
grant select,insert,delete,update on fuzzy_object_list    		to public;
grant select,insert,delete,update on fuzzy_label_def      		to public;
grant select,insert,delete,update on fuzzy_nearness_def   		to public;
grant select,insert,delete,update on fuzzy_approx_much    		to public;
grant select,insert,delete,update on fuzzy_compatible_col 		to public;
grant select,insert,delete,update on fuzzy_qualifiers_def 		to public;
grant select,insert,delete,update on fuzzy_degree_sig 			to public;
grant select,insert,delete,update on fuzzy_degree_cols 			to public;
grant select,insert,delete,update on fuzzy_degree_table 		to public;
grant select,insert,delete,update on fuzzy_table_quantifiers 	to public;
grant select,insert,delete,update on fuzzy_system_quantifiers 	to public;


--\echo ('>>>> insertando comentarios sobre las tablas de la fmb...');
-- comentarios sobre las tablas de la fmb
comment on table fuzzy_col_list is
 'columnas que son susceptibles de tratamiento difuso';
comment on table fuzzy_object_list is
 'objetos definidos en columnas difusas para su tratamiento';
comment on table fuzzy_label_def is
 'definicion de etiquetas difusas trapezoidales';
comment on table fuzzy_nearness_def is
 'semejanza entre los valores de los atributos tipo 3';
comment on table fuzzy_approx_much is
 'margen m por defecto de los valore aproximados (n+- m) y distancia minima para el mgt/mlt';
comment on table fuzzy_compatible_col is
'columnas difusas tipo 3 compatibles (comparables entre si)';
--comment on table fuzzy_qualifiers_def is
--'definicion del cualificador asociado a un valor linguistico';
   create view labels_for_objcol as
    select fuzzy_object_list.obj as obj, fuzzy_object_list.col as col, fuzzy_name as label, alfa, beta, gamma, delta
     from fuzzy_object_list, fuzzy_label_def
   where fuzzy_object_list.obj=fuzzy_label_def.obj and fuzzy_label_def.fuzzy_id=fuzzy_object_list.fuzzy_id and
        fuzzy_object_list.col=fuzzy_label_def.col and fuzzy_object_list.fuzzy_type=0;

create or replace view all_compatibles_t3 as
  select distinct fcl1.com as columna_1, fcl1.len as length_1, fcl2.com as  compatible_con_columna_2, fcl2.len as length_2
  from fuzzy_col_list as fcl1, fuzzy_col_list as fcl2, fuzzy_compatible_col
  where fcl1.obj=fuzzy_compatible_col.obj1 and fcl2.obj=fuzzy_compatible_col.obj2 and
        fcl1.col=fuzzy_compatible_col.col1 and fcl2.col=fuzzy_compatible_col.col2;

create or replace view labels_objcol_t3 as
 select fuzzy_nearness_def.obj as obj, fuzzy_nearness_def.col as col, fol1.fuzzy_name as label_1, fol2.fuzzy_name as label_2, degree
 from fuzzy_object_list as fol1, fuzzy_object_list as fol2, fuzzy_nearness_def
 where fol1.obj=fol2.obj and fol1.col=fol2.col and
       fol1.obj=fuzzy_nearness_def.obj and fol1.col=fuzzy_nearness_def.col  and
       fol1.fuzzy_type=1 and fol2.fuzzy_type=1   and
       fuzzy_nearness_def.fuzzy_id1=fol1.fuzzy_id and fuzzy_nearness_def.fuzzy_id2=fol2.fuzzy_id;
