-- fichero sfsqlins.sql
-- modificado para postgress
-- ************************************************************************
-- ***  # instalacion del servidor fsql (sfsql):                        ***
-- ***      a) crear y rellenar tablas de los analizadores              ***
-- ***      b) instalar los paquetes pl/sql: fsql_pkg, fsql_functions   ***
-- ***                                       y fsql_functions2.         ***
-- ************************************************************************
-- --------------------------------------------------------------------------------------------
-- tablas del servidor fsql:
-- tabla            leida por       escrita por     owner   contenido
-- ----------------------------------------------------------------------------------------------
-- t_transi             a. lexico       constante       sys transiciones del automata
-- reservadas           a. lexico       constante       sys palabras reservadas
-- tabla_sintax         a. sintactico   constante       sys transiciones de la gramatica
-- producciones         a. sintactico   constante       sys producciones de la gramatica
-- fsql_all_errors      --          --          sys mensajes de los errores
-- fsql_all_queries     --          --          sys consultas: fsql y su traduccion sql
-- vista fsql_errors    cliente fsql    lex/sint/sem    sys vista sobre fsql_all_errors particular
-- vista fsql_query     sint/sem/cliente    lex/sint/sem    sys vista sobre fsql_all_queries -----
-- particular
-- fsql_all_info        --          --          sys informacion gral. y opciones de usuarios
-- vista fsql_info      usuario/cliente servidor fsql   sys vista sobre fsql_all_info particular
-- vista fsql_options   a. semantico    usuario/cliente sys vista sobre fsql_all_info particular
-- fsql_stats           usuario/cliente   servidor fsqll    sys   control de accesos para --
-- estadisticas
-- --------------------------------------------------------------------------------------------

-- para que salgan los mensajes (de put_line) al instalar desde fsql*plus:
-- set serveroutput on
-- para que salgan (o no) las ordenes a ejecutar: set echo on
-- set echo off
-- para que no salgan los mensajes cuando todo va bien (los errores si salen):
-- set feedback off

\echo >>>>
\echo >>>> *************************************** <<<<
\echo >>>> **** instalacion del servidor fsql **** <<<<
\echo >>>> *************************************** <<<< by j. galindo g.
\echo >>>>
\echo >>>> notas:
\echo >>>>   - es requisito indispensable que este instalado first (tablas de la fmb...).
\echo >>>>   - no importa si se producen errores al intentar borrar
\echo >>>>     objetos que no existan (tablas ora-00942...).
\echo >>>>   - cualquier otro error podra impedir la correcta ejecucion del servidor fsql.
\echo >>>>     en ese caso revise el codigo del error y el lugar donde ha ocurrido.
\echo >>>>
\echo >>>> borrando y creando tablas, vistas y sinonimos del servidor fsql...
-- **********************************************************
-- ***  tablas de fsql usadas por todos los analizadores  ***
-- ***  estas dos tablas (fsql_*) seran las unicas a las  ***
-- ***  acceda el cliente fsql directamente.              ***
-- **********************************************************
-- tabla de errores cometidos, ordenados cronologicamente por indice (para cada sesion):
-- primero los lexicos, luego sintacticos y por ultimo los semanticos
-- cada session podra tener distintos errores, por lo que la session se identifica con sessionid.
-- drop   table fsql_all_errors;

create table fsql_all_errors (
  sessionid numeric         not null, -- identificador de la session: userenv('sessionid')
  indice    numeric(2)      not null, -- numero de orden del error
  msg_error varchar(2000) not null, -- mensaje del error
  primary key (sessionid,indice));

-- tabla con la lista de tokens de la cadena de entrada
-- drop   table fsql_all_queries;
create table fsql_all_queries (
  sessionid numeric     not null, -- identificador de la session: userenv('sessionid')
  indice   numeric (10) not null, -- numero de token (empezando por el 0)
  posicion numeric (10) not null, -- posicion del final del token (por si se producen errores ahi)
  nombre   varchar(100)not null,-- nombre del token
  atributo varchar, -- token leido de la entrada. si es cadena/texto podra tener hasta
                           -- 2000 caracteres (max long aceptada en una columna varchar sql)
  primary key (sessionid,indice));

-- ********************** tabla con informacion para estadisticas
-- drop   table fsql_stats;
create table fsql_stats (
  evento varchar(30) primary key,
  num    numeric  (38) not null);
  -- evento es el evento que se contabiliza y num es el numero de veces que ocurre el evento:
  -- 1. 'accesos_para_traducciones'   traducciones hechas (con o sin errores)
  -- 2. 'total_errores_cometidos'     errores cometidos en todas las traducciones
  -- 3. 'accesos_sin_errores'         traducciones hechas sin encontrar errores
  -- 4. 'tiempo_total_accesos'        tiempo total empleado en todas las traducciones
  -- 5. 'tiempo_accesos_sin_errores'  tiempo empleado en las traducciones sin errores
  -- 6. 'ejecuciones_fsql_fin'        veces que se ha ejecutado fsql_fin
  -- 7. 'ultimo_sessionid'            ultima sesion que accedio al servidor
  -- 8. 'cambios_de_sessionid'        numero de veces que cambia de una a otra sesion
  -- 9. 'total_paquete_fsql_pkg'      numero de cargas del paquete fsql_pkg
  -- 10. 'tiempo_ultima_traduccion'    tiempo empleado en la ultima traduccion (independiente del 
  -- usuario)
  -- 11. 'errores_ultima_traduccion'   errores en la ultima traduccion (independiente del usuario)

-- inserciones e inicializaciones para los eventos contabilizados:
insert into fsql_stats values('accesos_para_traducciones',0);
insert into fsql_stats values('total_errores_cometidos',0);
insert into fsql_stats values('accesos_sin_errores',0);
insert into fsql_stats values('tiempo_total_accesos',0);
insert into fsql_stats values('tiempo_accesos_sin_errores',0);
insert into fsql_stats values('ejecuciones_fsql_fin',0);
insert into fsql_stats values('ultimo_sessionid',0);
insert into fsql_stats values('cambios_de_sessionid',0);
insert into fsql_stats values('total_paquete_fsql_pkg',0);
insert into fsql_stats values('tiempo_ultima_traduccion',0);
insert into fsql_stats values('errores_ultima_traduccion',0);

-- ********************** tabla con informacion y opciones sobre fsql **********************
-- drop   table fsql_all_info;

create table fsql_all_info (
  owner  varchar(30),  -- identificador del usuario de la opcion, 'fsql server' si es para todos
  opcion varchar(30),  -- opcion que se establece al valor valor
  valor  varchar(100), -- valor para la opcion opcion
  primary key (owner,opcion));

-- vista con la informacion general, para todos los usuarios:

create view fsql_info as
  select opcion, valor from fsql_all_info where owner='fsql server';

-- valores que no pueden modificar los usuarios: informacion general (owner=null)
-- opcion             significado de value
------------------------------------------
-- version_sfsql      version del actual servidor fsql
-- fecha_instalacion  fecha de instalacion del servidor fsql
-- fecha_ultimo_uso   fecha del ultimo uso del servidor fsql
-- fecha_ultimo_fin   fecha del ultimo uso de la funcion fsql_fin (paquete fsql_pkg)
-- dba_installer      superusuario dba que instala el servidor fsql

--*************************************************************version actual: 1.2
insert into fsql_all_info values ('fsql server','version_sfsql','1.2');

insert into fsql_all_info values ('fsql server','fecha_instalacion',
            to_char(now(),'dd-mm-yyyy, hh24:mi'));
insert into fsql_all_info values ('fsql server','fecha_ultimo_uso','no usado');
insert into fsql_all_info values ('fsql server','fecha_ultimo_fin','no usado');
insert into fsql_all_info values ('fsql server','dba_installer',user);

---------------- valores propios de cada usuario (que pueden modificar)
-- opcion  significado de value
-------------------------------
-- not     funcion a aplicar con el cdeg en este operador: not a. por defecto 1-a
-- and     funcion a aplicar con el cdeg en este operador: a and b. por defecto least(a,b)
-- or      funcion a aplicar con el cdeg en este operador: a or b. por defecto greatest(a,b)
-- num_errores
--         indica el numero de errores fsql localizados en la ultima traduccion
-- tiempo_traduccion
--         tiempo empleado por el servidor fsql en la ultima consulta del usuario
--         (hay que tener en cuenta si hubo errores: num_errores)
-- trata_fuzzy_atrib
--         tratamiento que se le da a los atributos difusos cuando estos estan fuera de los
--         lugares normales (select_list, argumento de cdeg o en condiciones). por ejemplo,
--         cuando estan en expresiones, argumento de otras funciones, en order by...
--         valores validos que el usuario puede utilizar:
--            error      --> genera un error
--            tipo_valor --> utiliza el tipo del valor del atributo: tipo numeric(1)
--                           (concatenar 't' al nombre del atributo)
--            represent  --> utiliza la representacion grafica del atributo: tipo varchar
--                           (opcion por defecto)

-- crear vistas particulares para cada usuario:

create or replace view fsql_errors as
  select * from fsql_all_errors  where sessionid=(select pg_backend_pid() as sessionid);
create or replace view fsql_query as
  select * from fsql_all_queries where sessionid=(select pg_backend_pid() as sessionid);
create or replace view fsql_options as
  select * from fsql_all_info where owner=(select current_user);

-- ejemplos de inserciones en fsql_options:

--  insert into fsql_options values (user,'not','lukanot');
--  insert into fsql_options values (user,'and','lukaand');
--  insert into fsql_options values (user,'or','lukaor');

-- crear sinonimos para que no haya que especificar sys.fsql_*:
-- drop public synonym fsql_errors;
-- drop public synonym fsql_query;
-- drop public synonym fsql_stats;
-- drop public synonym fsql_info;
-- drop public synonym fsql_options;
-- create public synonym fsql_errors  for fsql_errors;
-- create public synonym fsql_query   for fsql_query;
-- create public synonym fsql_stats   for fsql_stats;
-- create public synonym fsql_info    for fsql_info;
-- create public synonym fsql_options for fsql_options;
-- dar privilegios de acceso:

grant select                      on fsql_info    to public;
grant select                      on fsql_stats   to public;
grant select,insert,delete,update on fsql_options to public;
grant select,insert,delete,update on fsql_errors  to public;
grant select,insert,delete,update on fsql_query   to public;

-- *****************************************/
-- ***  tablas para el analisis lexico   ***/
-- *****************************************/

-- tabla de palabras reservadas y sus permisos
-- drop   table reservadas;
create table reservadas(
  palabra     varchar(20) not null,
  primary key (palabra));
-- drop public synonym reservadas;
-- create public synonym reservadas for reservadas;
grant select on reservadas to public;

-- insercion en tabla reservadas

\echo >>>> tabla reservadas: insertando valores...
begin;
insert into reservadas values ('abs');
insert into reservadas values ('add_months');
insert into reservadas values ('all');
insert into reservadas values ('and');
insert into reservadas values ('asc');
insert into reservadas values ('ascii');
insert into reservadas values ('avg');
insert into reservadas values ('between');
insert into reservadas values ('by');
insert into reservadas values ('cdeg');
insert into reservadas values ('ceil');
insert into reservadas values ('chartorowid');
insert into reservadas values ('chr');
insert into reservadas values ('concat');
insert into reservadas values ('connect');
insert into reservadas values ('convert');
insert into reservadas values ('cos');
insert into reservadas values ('cosh');
insert into reservadas values ('count');
insert into reservadas values ('currval');
insert into reservadas values ('decode');
insert into reservadas values ('desc');
insert into reservadas values ('distinct');
insert into reservadas values ('dump');
insert into reservadas values ('exit');
insert into reservadas values ('exp');
insert into reservadas values ('favg');

insert into reservadas values ('feq'); 
insert into reservadas values ('fgt');
insert into reservadas values ('fgeq');
insert into reservadas values ('flt');
insert into reservadas values ('fleq');
insert into reservadas values ('mgt');
insert into reservadas values ('mlt');
insert into reservadas values ('nfeq');
insert into reservadas values ('nfgt');
insert into reservadas values ('nfgeq');
insert into reservadas values ('nflt');
insert into reservadas values ('nfleq');
insert into reservadas values ('nmgt');
insert into reservadas values ('nmlt');

insert into reservadas values ('like');
insert into reservadas values ('floor');
insert into reservadas values ('fmax');
insert into reservadas values ('fmin');
insert into reservadas values ('from');
insert into reservadas values ('fsum');
insert into reservadas values ('glb');
insert into reservadas values ('greatest');
insert into reservadas values ('greatest_lb');
insert into reservadas values ('group');
insert into reservadas values ('having');
insert into reservadas values ('hextoraw');
insert into reservadas values ('in');
insert into reservadas values ('initcap');
insert into reservadas values ('instr');
insert into reservadas values ('instrb');
insert into reservadas values ('is');
insert into reservadas values ('last_day');
insert into reservadas values ('least');
insert into reservadas values ('least_ub');
insert into reservadas values ('length');
insert into reservadas values ('lengthb');
insert into reservadas values ('level');
insert into reservadas values ('ln');
insert into reservadas values ('log');
insert into reservadas values ('lower');
insert into reservadas values ('lpad');
insert into reservadas values ('ltrim');
insert into reservadas values ('lub');
insert into reservadas values ('max');
insert into reservadas values ('min');
insert into reservadas values ('mod');
insert into reservadas values ('months_between');
insert into reservadas values ('new_time');
insert into reservadas values ('next_day');
insert into reservadas values ('nextval');
insert into reservadas values ('nls_initcap');
insert into reservadas values ('nls_lower');
insert into reservadas values ('nls_upper');
insert into reservadas values ('nlssort');
insert into reservadas values ('not');
insert into reservadas values ('null');
insert into reservadas values ('nvl');
insert into reservadas values ('or');
insert into reservadas values ('order');
insert into reservadas values ('power');
insert into reservadas values ('prior');
insert into reservadas values ('rawtohex');
insert into reservadas values ('replace');
insert into reservadas values ('round');
insert into reservadas values ('rowid');
insert into reservadas values ('rowidtochar');
insert into reservadas values ('rownum');
insert into reservadas values ('rpad');
insert into reservadas values ('rtrim');
insert into reservadas values ('select');
insert into reservadas values ('sign');
insert into reservadas values ('sin');
insert into reservadas values ('sinh');
insert into reservadas values ('soundex');
insert into reservadas values ('sqrt');
insert into reservadas values ('start');
insert into reservadas values ('stddev');
insert into reservadas values ('substr');
insert into reservadas values ('substrb');
insert into reservadas values ('sum');
insert into reservadas values ('sysdate');
insert into reservadas values ('tan');
insert into reservadas values ('tanh');
insert into reservadas values ('thold');
insert into reservadas values ('to_char');
insert into reservadas values ('to_date');
insert into reservadas values ('to_label');
insert into reservadas values ('to_multi_byte');
insert into reservadas values ('to_number');
insert into reservadas values ('to_single_byte');
insert into reservadas values ('traslate');
insert into reservadas values ('trunc');
insert into reservadas values ('uid');
insert into reservadas values ('undefined');
insert into reservadas values ('unknown');
insert into reservadas values ('upper');
insert into reservadas values ('user');
insert into reservadas values ('userenv');
insert into reservadas values ('variance');
insert into reservadas values ('vsize');
insert into reservadas values ('where');
insert into reservadas values ('with');
insert into reservadas values ('add');
insert into reservadas values ('allocate');
insert into reservadas values ('alter');
insert into reservadas values ('any');
insert into reservadas values ('as');
insert into reservadas values ('cascade');
insert into reservadas values ('cluster');
insert into reservadas values ('check');
insert into reservadas values ('constraint');
insert into reservadas values ('constraints');
insert into reservadas values ('create');
insert into reservadas values ('crisp');
insert into reservadas values ('default');
insert into reservadas values ('delete');
insert into reservadas values ('disable');
insert into reservadas values ('domain');
insert into reservadas values ('drop');
insert into reservadas values ('enable');
insert into reservadas values ('escape');
insert into reservadas values ('exceptions');
insert into reservadas values ('exists');
insert into reservadas values ('extent');
insert into reservadas values ('foreing');
insert into reservadas values ('freelist');
insert into reservadas values ('freelists');
insert into reservadas values ('groups');
insert into reservadas values ('index');
insert into reservadas values ('initial');
insert into reservadas values ('instance');
insert into reservadas values ('into');
insert into reservadas values ('initrans');
insert into reservadas values ('k');
insert into reservadas values ('key');
insert into reservadas values ('label');
insert into reservadas values ('m');
insert into reservadas values ('maxtrans');
insert into reservadas values ('minextents');
insert into reservadas values ('maxextents');
insert into reservadas values ('nearness');
insert into reservadas values ('next');
insert into reservadas values ('on');
insert into reservadas values ('optimal');
insert into reservadas values ('pctfree');
insert into reservadas values ('pctused');
insert into reservadas values ('pctincrease');
insert into reservadas values ('posibilistic');
insert into reservadas values ('primary');
insert into reservadas values ('nulo');
insert into reservadas values ('references');
insert into reservadas values ('rowlabel');
insert into reservadas values ('size');
insert into reservadas values ('some');
insert into reservadas values ('storage');
insert into reservadas values ('table');
insert into reservadas values ('tablespace');
insert into reservadas values ('triggers');
insert into reservadas values ('unique');
insert into reservadas values ('using');
insert into reservadas values ('values');
insert into reservadas values ('datafile');
insert into reservadas values ('modify');
insert into reservadas values ('scalar');
insert into reservadas values ('number');
insert into reservadas values ('dec');
insert into reservadas values ('decimal');
insert into reservadas values ('double');
insert into reservadas values ('precision');
insert into reservadas values ('float');
insert into reservadas values ('int');
insert into reservadas values ('integer');
insert into reservadas values ('numeric');
insert into reservadas values ('real');
insert into reservadas values ('smallint');
insert into reservadas values ('char');
insert into reservadas values ('character');
insert into reservadas values ('string');
insert into reservadas values ('varchar');
insert into reservadas values ('varchar2');
insert into reservadas values ('long');
insert into reservadas values ('raw');
insert into reservadas values ('longraw');
insert into reservadas values ('boolean');
insert into reservadas values ('date');
insert into reservadas values ('mlslabel');
insert into reservadas values ('union');
insert into reservadas values ('intersect');
insert into reservadas values ('minus');
commit;

create table t_transi (
  estado       numeric (2) not null,
  caracter     numeric (3) not null,
  sig_estado   numeric (2) not null,
  primary key (estado,caracter));

-- inserciones en la tabla t_transi
-- es un procedimiento pl-sql para aprovechar los bucles

--  \echo >>>> tabla t_transi: insertando de valores...
  insert into t_transi values(0 , ascii('+'), 1  );
  insert into t_transi values(0 , ascii('-'), 2  );
  insert into t_transi values(0 , ascii('*'), 3  );
  insert into t_transi values(0 , ascii('/'), 4  );
  insert into t_transi values(0 , ascii('('), 5  );
  insert into t_transi values(0 , ascii(')'), 6  );
  insert into t_transi values(0 , ascii(','), 7  );
  insert into t_transi values(0 , ascii('.'), 8  );
  insert into t_transi values(0 , ascii('>'), 9  );
  insert into t_transi values(0 , ascii('$'), 10 );
  insert into t_transi values(0 , ascii('<'), 11 );
  insert into t_transi values(0 , ascii('='), 12 );
  insert into t_transi values(13, ascii('.'), 14 );
  insert into t_transi values(9 , ascii('='), 16 );
  insert into t_transi values(11, ascii('='), 17 );
  insert into t_transi values(0 , ascii('!'), 18 );
  insert into t_transi values(0 , ascii('^'), 18 );
  insert into t_transi values(0 , ascii(''), 18 );
  insert into t_transi values(18, ascii('='), 19 );
  insert into t_transi values(11, ascii('>'), 19 );
  insert into t_transi values(0 , ascii('['), 20 );
  insert into t_transi values(0 , ascii(']'), 21 );
  insert into t_transi values(0 , ascii(';'), 22 );
  insert into t_transi values(0 , ascii('#'), 27 );
  insert into t_transi values(0 , ascii('%'), 28 );
  insert into t_transi values(0 , ascii('{'), 29 );
  insert into t_transi values(0 , ascii('}'), 30 );
  insert into t_transi values( 0,34,23); 
  insert into t_transi values(23,34,24); 
  insert into t_transi values( 0,39,25);
  insert into t_transi values(25,39,26);
--* este bucle no se ejecuta porque para aceptar cualquier cosa en un
--* texto o cadena, se implementa en el a. lexico. asi es + portable frente
--* a posibles cambios en el juego de caracteres de la maquina destino.
--*   for i in 0..255 loop
--*       insert into t_transi values(23,i,23); excepto i=34
--*       insert into t_transi values(25,i,25); excepto i=39
--*   end loop;
  insert into t_transi values(9 , ascii(' '),  9); 
  insert into t_transi values(11, ascii(' '), 11);
  insert into t_transi values(18, ascii(' '), 18);
  insert into t_transi values( 9, 10,  9);
  insert into t_transi values(11, 10, 11);
  insert into t_transi values(18, 10, 18);
  insert into t_transi values(9 , 13,  9);
  insert into t_transi values(11, 13, 11);
  insert into t_transi values(18, 13, 18);

  create function uno()
  returns text as '
    begin
        for i in 65..90 loop
          insert into t_transi values(0 , i, 15);
          insert into t_transi values(15, i, 15);
       end loop;
       return ''transaccion exitosa....'';
   end;
 ' language 'plpgsql';
  select uno() as funcion_uno;
  drop function uno();
 
 create function dos()
  returns text as '
    begin
        for i in 97..122 loop
          insert into t_transi values(0 , i, 15);
          insert into t_transi values(15, i, 15);
       end loop;
       return ''transaccion exitosa....'';
   end;
 ' language 'plpgsql';
  select dos() as funcion_dos;
  drop function dos();

  insert into t_transi values(15, ascii('$'), 15);
  insert into t_transi values(15, ascii('#'), 15);
  insert into t_transi values(15, ascii('_'), 15);
 
  create function tres()
  returns text as '
    begin
       for i in 48..57 loop -- numeros
         insert into t_transi values( 0, i, 13);
         insert into t_transi values( 8, i, 14);
         insert into t_transi values(13, i, 13);
         insert into t_transi values(14, i, 14);
         insert into t_transi values(15, i, 15);
         insert into t_transi values(31, i, 33); 
         insert into t_transi values(32, i, 33);
         insert into t_transi values(33, i, 33);
    end loop;
       return ''transaccion exitosa....'';
   end;
 ' language 'plpgsql';
  select tres() as funcion_tres;
  drop function tres();


  insert into t_transi values(13,ascii('e'),31);   -- notacion cientifica
  insert into t_transi values(14,ascii('e'),31);
  insert into t_transi values(31,ascii('+'),32);
  insert into t_transi values(31,ascii('-'),32);   -- operador ||
  insert into t_transi values( 0,ascii('|'),35);
  insert into t_transi values(35,ascii(' '),35);
  insert into t_transi values(35,ascii('|'),36);

  insert into t_transi values(2,ascii('-'),37);  -- comentarios con '--'
  insert into t_transi values(37,13,38);         -- terminan con el caracter 13 o el 10
  insert into t_transi values(37,10,38);         
  insert into t_transi values(4,ascii('*'),39);  -- comentarios con '/*'
  insert into t_transi values(39,ascii('*'),40); -- terminan con '*/'
  insert into t_transi values(40,ascii('*'),40);
  insert into t_transi values(40,ascii('/'),38);


-- *****************************************
-- ***  tablas del  analisis sintactico  ***
-- *****************************************

-- tabla de producciones
-- drop   table producciones;
create table producciones (
  num_prod  numeric (9) not null,
  posicion  numeric (2) not null,
  parte_der varchar(20),
  terminal_der char   not null,
  primary key (num_prod,posicion));
-- campos:
-- parte_izq    simbolo no terminal de la izquierda de una produccion
-- posicion posicion que ocupa 'parte_der' en esa produccion (entero positivo)
-- parte_der    simbolo nt o t de la derecha que esta en esa 'posicion'
-- terminal_der indica si 'parte_der' es terminal ('t') o nt ('n')

--*********  tabla de transiciones del analizador sintactico  *********
--*********  segun la gramatica ll(1) usada.                  *********
-- drop   table tabla_sintax;
create table tabla_sintax (
  simbolo_nt varchar(20) not null, --producciones.parte_der%type
  simbolo_t  varchar(20) not null,
  num_prod   numeric(3)    not null, --producciones.num_prod%type
  primary key (simbolo_nt,simbolo_t));
-- campos:
-- simbolo_nt   simbolo no terminal encontrado en la pila
-- simbolo_t    simbolo terminal (token) leido de la consulta de entrada
-- num_prod     numero de produccion a aplicar en este caso

--********* insercion en tabla producciones y tabla_sintax *********
-- las producciones estan numeradas empezando por la 1 (no la 0).
-- cada 'grupo' de producciones se comienza numerando en un multiplo de 10
-- (asi quedan numeros libres por si se amplia/modifica la gramatica).
-- convenio: en mayusculas los simbolos t y en minusculas los nt.
-- para cada produccion:  a --> b c...
--   1. insertar en producciones una tupla por cada simbolo en b c...,
--      numerados por orden por el segundo campo (posicion).
--      en el ultimo campo, indicar si es o no simbolo terminal.
--      si es la cadena vacia: insertar 'vacio' (como simbolo nt).
--   2. insertar en tabla_sintax tuplas con a en el primer campo.
--      el tercer campo el numero de esa produccion.
--      el segundo campo tendra un simbolo terminal por cada tupla.
--      este simbolo estara entre los siguientes (simbolos directores):
--         si b c... no es anulable:   iniciales(b c...)
--         si b c... si es anulable:   iniciales(b c...) u seguidores(a)


-- \echo >>>> tablas producciones y tabla_sintax: insertando valores... bloque 1/3

--1: consulta:  select_command fin_consulta
insert into producciones values (1,1,'select_command','n');
insert into producciones values (1,2,'fin_consulta','n');
insert into tabla_sintax values ('consulta','(',1);
insert into tabla_sintax values ('consulta','select',1);

--2: fin_consulta:  ';'
insert into producciones values (2,1,';','t');
insert into tabla_sintax values ('fin_consulta',';',2);
--3:        |
insert into producciones values (3,1,'vacio','n');
insert into tabla_sintax values ('fin_consulta','the end',3);

--4: select_command:    select_element resto_select clausula_orden
insert into producciones values (4,1,'select_element','n');
insert into producciones values (4,2,'resto_select','n');
insert into producciones values (4,3,'clausula_orden','n');
insert into tabla_sintax values ('select_command','(',4);
insert into tabla_sintax values ('select_command','select',4);

--5: select_element:    '(' select_command ')'
insert into producciones values (5,1,'(','t');
insert into producciones values (5,2,'select_command','n');
insert into producciones values (5,3,')','t');
insert into tabla_sintax values ('select_element','(',5);
--6:    |   select select_list from tablas  clausula_where clausula_variante
insert into producciones values (6,1,'select','t');
insert into producciones values (6,2,'select_list','n');
insert into producciones values (6,3,'from','t');
insert into producciones values (6,4,'tablas','n');
insert into producciones values (6,5,'clausula_where','n');
insert into producciones values (6,6,'clausula_variante','n');
insert into tabla_sintax values ('select_element','select',6);

-- *****> definicion de las operaciones de conjuntos <*****
--10: resto_select: set_command resto_select
insert into producciones values (10,1,'set_command','n');
insert into producciones values (10,2,'resto_select','n');
insert into tabla_sintax values ('resto_select','union',10);
insert into tabla_sintax values ('resto_select','intersect',10);
insert into tabla_sintax values ('resto_select','minus',10);
--11:       |
insert into producciones values (11,1,'vacio','n');
insert into tabla_sintax values ('resto_select',';',11);
insert into tabla_sintax values ('resto_select','the end',11);
insert into tabla_sintax values ('resto_select','order',11);
insert into tabla_sintax values ('resto_select',')',11);

--12: set_command:union all_ono select_element
insert into producciones values (12,1,'union','t');
insert into producciones values (12,2,'all_ono','n');
insert into producciones values (12,3,'select_element','n');
insert into tabla_sintax values ('set_command','union',12);
--13:       |   intersect     select_element
insert into producciones values (13,1,'intersect','t');
insert into producciones values (13,2,'select_element','n');
insert into tabla_sintax values ('set_command','intersect',13);
--14:       |   minus         select_element
insert into producciones values (14,1,'minus','t');
insert into producciones values (14,2,'select_element','n');
insert into tabla_sintax values ('set_command','minus',14);

--15: all_ono:  all
insert into producciones values (15,1,'all','t');
insert into tabla_sintax values ('all_ono','all',15);
--16:       |
insert into producciones values (16,1,'vacio','n');
insert into tabla_sintax values ('all_ono','(',16);
insert into tabla_sintax values ('all_ono','select',16);

-- *****> (datos justo despues de la palabra select)  <*****
--17: select_list   :   lista_datos
insert into producciones values (17,1,'lista_datos','n');
-- iniciales(lista_datos)
insert into tabla_sintax values ('select_list','*',17);
insert into tabla_sintax values ('select_list','%',17);
insert into tabla_sintax values ('select_list','+',17);
insert into tabla_sintax values ('select_list','-',17);
insert into tabla_sintax values ('select_list','prior',17);
insert into tabla_sintax values ('select_list','(',17);
insert into tabla_sintax values ('select_list','{',17);
-- * ctes *
insert into tabla_sintax values ('select_list','numero',17);
insert into tabla_sintax values ('select_list','sysdate',17);
insert into tabla_sintax values ('select_list','uid',17);
insert into tabla_sintax values ('select_list','user',17);
insert into tabla_sintax values ('select_list','texto',17);
insert into tabla_sintax values ('select_list','level',17);
insert into tabla_sintax values ('select_list','null',17);
insert into tabla_sintax values ('select_list','undefined',17);
insert into tabla_sintax values ('select_list','unknown',17);
-- * columna *
insert into tabla_sintax values ('select_list','id',17);
insert into tabla_sintax values ('select_list','rowid',17);
insert into tabla_sintax values ('select_list','rownum',17);
-- * funciones *
insert into tabla_sintax values ('select_list','abs',17);
insert into tabla_sintax values ('select_list','cdeg',17);
insert into tabla_sintax values ('select_list','ceil',17);
insert into tabla_sintax values ('select_list','floor',17);
insert into tabla_sintax values ('select_list','sign',17);
insert into tabla_sintax values ('select_list','sqrt',17);
insert into tabla_sintax values ('select_list','chr',17);
insert into tabla_sintax values ('select_list','mod',17);
insert into tabla_sintax values ('select_list','power',17);
insert into tabla_sintax values ('select_list','initcap',17);
insert into tabla_sintax values ('select_list','lower',17);
insert into tabla_sintax values ('select_list','lpad',17);
insert into tabla_sintax values ('select_list','ltrim',17);
insert into tabla_sintax values ('select_list','replace',17);
insert into tabla_sintax values ('select_list','rpad',17);
insert into tabla_sintax values ('select_list','rtrim',17);
insert into tabla_sintax values ('select_list','soundex',17);
insert into tabla_sintax values ('select_list','substr',17);
insert into tabla_sintax values ('select_list','translate',17);
insert into tabla_sintax values ('select_list','upper',17);
insert into tabla_sintax values ('select_list','ascii',17);
insert into tabla_sintax values ('select_list','instr',17);
insert into tabla_sintax values ('select_list','length',17);
insert into tabla_sintax values ('select_list','nlssort',17);
insert into tabla_sintax values ('select_list','avg',17);
insert into tabla_sintax values ('select_list','count',17);
insert into tabla_sintax values ('select_list','max',17);
insert into tabla_sintax values ('select_list','min',17);
insert into tabla_sintax values ('select_list','stddev',17);
insert into tabla_sintax values ('select_list','sum',17);
insert into tabla_sintax values ('select_list','variance',17);
insert into tabla_sintax values ('select_list','chartorowid',17);
insert into tabla_sintax values ('select_list','convert',17);
insert into tabla_sintax values ('select_list','hextoraw',17);
insert into tabla_sintax values ('select_list','rawtohex',17);
insert into tabla_sintax values ('select_list','rowidtochar',17);
insert into tabla_sintax values ('select_list','to_char',17);
insert into tabla_sintax values ('select_list','to_date',17);
insert into tabla_sintax values ('select_list','to_number',17);
insert into tabla_sintax values ('select_list','add_months',17);
insert into tabla_sintax values ('select_list','last_day',17);
insert into tabla_sintax values ('select_list','months_between',17);
insert into tabla_sintax values ('select_list','new_time',17);
insert into tabla_sintax values ('select_list','next_day',17);
insert into tabla_sintax values ('select_list','round',17);
insert into tabla_sintax values ('select_list','trunc',17);
insert into tabla_sintax values ('select_list','dump',17);
insert into tabla_sintax values ('select_list','greatest',17);
insert into tabla_sintax values ('select_list','least',17);
insert into tabla_sintax values ('select_list','nvl',17);
insert into tabla_sintax values ('select_list','userenv',17);
insert into tabla_sintax values ('select_list','vsize',17);
insert into tabla_sintax values ('select_list','decode',17);
--18:       |   all lista_datos
insert into producciones values (18,1,'all','t');
insert into producciones values (18,2,'lista_datos','n');
insert into tabla_sintax values ('select_list','all',18);
--19:       |   distinct lista_datos
insert into producciones values (19,1,'distinct','t');
insert into producciones values (19,2,'lista_datos','n');
insert into tabla_sintax values ('select_list','distinct',19);

--20: lista_datos   :   '*'
insert into producciones values (20,1,'*','t');
insert into tabla_sintax values ('lista_datos','*',20);
--21:       |   '%'
insert into producciones values (21,1,'%','t');
insert into tabla_sintax values ('lista_datos','%',21);
--22:       |   expr c_alias mas_datos
insert into producciones values (22,1,'expr','n');
insert into producciones values (22,2,'c_alias','n');
insert into producciones values (22,3,'mas_datos','n');
--iniciales(expr)
insert into tabla_sintax values ('lista_datos','+',22);
insert into tabla_sintax values ('lista_datos','-',22);
insert into tabla_sintax values ('lista_datos','prior',22);
insert into tabla_sintax values ('lista_datos','(',22);
insert into tabla_sintax values ('lista_datos','{',22);
-- * ctes *
insert into tabla_sintax values ('lista_datos','numero',22);
insert into tabla_sintax values ('lista_datos','sysdate',22);
insert into tabla_sintax values ('lista_datos','uid',22);
insert into tabla_sintax values ('lista_datos','user',22);
insert into tabla_sintax values ('lista_datos','texto',22);
insert into tabla_sintax values ('lista_datos','level',22);
insert into tabla_sintax values ('lista_datos','null',22);
insert into tabla_sintax values ('lista_datos','undefined',22);
insert into tabla_sintax values ('lista_datos','unknown',22);
-- * columna *
insert into tabla_sintax values ('lista_datos','id',22);
insert into tabla_sintax values ('lista_datos','rowid',22);
insert into tabla_sintax values ('lista_datos','rownum',22);
-- * funciones *
insert into tabla_sintax values ('lista_datos','abs',22);
insert into tabla_sintax values ('lista_datos','cdeg',22);
insert into tabla_sintax values ('lista_datos','ceil',22);
insert into tabla_sintax values ('lista_datos','floor',22);
insert into tabla_sintax values ('lista_datos','sign',22);
insert into tabla_sintax values ('lista_datos','sqrt',22);
insert into tabla_sintax values ('lista_datos','chr',22);
insert into tabla_sintax values ('lista_datos','mod',22);
insert into tabla_sintax values ('lista_datos','power',22);
insert into tabla_sintax values ('lista_datos','initcap',22);
insert into tabla_sintax values ('lista_datos','lower',22);
insert into tabla_sintax values ('lista_datos','lpad',22);
insert into tabla_sintax values ('lista_datos','ltrim',22);
insert into tabla_sintax values ('lista_datos','replace',22);
insert into tabla_sintax values ('lista_datos','rpad',22);
insert into tabla_sintax values ('lista_datos','rtrim',22);
insert into tabla_sintax values ('lista_datos','soundex',22);
insert into tabla_sintax values ('lista_datos','substr',22);
insert into tabla_sintax values ('lista_datos','translate',22);
insert into tabla_sintax values ('lista_datos','upper',22);
insert into tabla_sintax values ('lista_datos','ascii',22);
insert into tabla_sintax values ('lista_datos','instr',22);
insert into tabla_sintax values ('lista_datos','length',22);
insert into tabla_sintax values ('lista_datos','nlssort',22);
insert into tabla_sintax values ('lista_datos','avg',22);
insert into tabla_sintax values ('lista_datos','count',22);
insert into tabla_sintax values ('lista_datos','max',22);
insert into tabla_sintax values ('lista_datos','min',22);
insert into tabla_sintax values ('lista_datos','stddev',22);
insert into tabla_sintax values ('lista_datos','sum',22);
insert into tabla_sintax values ('lista_datos','variance',22);
insert into tabla_sintax values ('lista_datos','chartorowid',22);
insert into tabla_sintax values ('lista_datos','convert',22);
insert into tabla_sintax values ('lista_datos','hextoraw',22);
insert into tabla_sintax values ('lista_datos','rawtohex',22);
insert into tabla_sintax values ('lista_datos','rowidtochar',22);
insert into tabla_sintax values ('lista_datos','to_char',22);
insert into tabla_sintax values ('lista_datos','to_date',22);
insert into tabla_sintax values ('lista_datos','to_number',22);
insert into tabla_sintax values ('lista_datos','add_months',22);
insert into tabla_sintax values ('lista_datos','last_day',22);
insert into tabla_sintax values ('lista_datos','months_between',22);
insert into tabla_sintax values ('lista_datos','new_time',22);
insert into tabla_sintax values ('lista_datos','next_day',22);
insert into tabla_sintax values ('lista_datos','round',22);
insert into tabla_sintax values ('lista_datos','trunc',22);
insert into tabla_sintax values ('lista_datos','dump',22);
insert into tabla_sintax values ('lista_datos','greatest',22);
insert into tabla_sintax values ('lista_datos','least',22);
insert into tabla_sintax values ('lista_datos','nvl',22);
insert into tabla_sintax values ('lista_datos','userenv',22);
insert into tabla_sintax values ('lista_datos','vsize',22);
insert into tabla_sintax values ('lista_datos','decode',22);

--23: mas_datos:    ',' expr c_alias mas_datos
insert into producciones values (23,1,',','t');
insert into producciones values (23,2,'expr','n');
insert into producciones values (23,3,'c_alias','n');
insert into producciones values (23,4,'mas_datos','n');
insert into tabla_sintax values ('mas_datos',',',23);
--24:       |
insert into producciones values (24,1,'vacio','n');
insert into tabla_sintax values ('mas_datos','from',24);

--25: c_alias:  cadid
insert into producciones values (25,1,'cadid','n');
insert into tabla_sintax values ('c_alias','cadena',25);
insert into tabla_sintax values ('c_alias','id',25);
--26:       |   as cadid
insert into producciones values (26,1,'as','t');
insert into producciones values (26,2,'cadid','n');
insert into tabla_sintax values ('c_alias','as',26);
--27:       |
insert into producciones values (27,1,'vacio','n');
insert into tabla_sintax values ('c_alias',',',27);
insert into tabla_sintax values ('c_alias','from',27);

--28/29: cadid: cadena | id
insert into producciones values (28,1,'cadena','t');
insert into producciones values (29,1,'id','t');
insert into tabla_sintax values ('cadid','cadena',28);
insert into tabla_sintax values ('cadid','id',29);

-- expresiones: expr
--30: expr  :   expr_maxprior resto_expr
insert into producciones values (30,1,'expr_maxprior','n');
insert into producciones values (30,2,'resto_expr','n');
-- insertamos en tabla_sintax: iniciales(expr_maxprior)=iniciales(expr)
insert into tabla_sintax values ('expr','+',30);
insert into tabla_sintax values ('expr','-',30);
insert into tabla_sintax values ('expr','prior',30);
insert into tabla_sintax values ('expr','(',30);
insert into tabla_sintax values ('expr','{',30);
-- * ctes *
insert into tabla_sintax values ('expr','numero',30);
insert into tabla_sintax values ('expr','sysdate',30);
insert into tabla_sintax values ('expr','uid',30);
insert into tabla_sintax values ('expr','user',30);
insert into tabla_sintax values ('expr','texto',30);
insert into tabla_sintax values ('expr','level',30);
insert into tabla_sintax values ('expr','null',30);
insert into tabla_sintax values ('expr','undefined',30);
insert into tabla_sintax values ('expr','unknown',30);
-- * columna *
insert into tabla_sintax values ('expr','id',30);
insert into tabla_sintax values ('expr','rowid',30);
insert into tabla_sintax values ('expr','rownum',30);
-- * funciones *
insert into tabla_sintax values ('expr','abs',30);
insert into tabla_sintax values ('expr','cdeg',30);
insert into tabla_sintax values ('expr','ceil',30);
insert into tabla_sintax values ('expr','floor',30);
insert into tabla_sintax values ('expr','sign',30);
insert into tabla_sintax values ('expr','sqrt',30);
insert into tabla_sintax values ('expr','chr',30);
insert into tabla_sintax values ('expr','mod',30);
insert into tabla_sintax values ('expr','power',30);
insert into tabla_sintax values ('expr','initcap',30);
insert into tabla_sintax values ('expr','lower',30);
insert into tabla_sintax values ('expr','lpad',30);
insert into tabla_sintax values ('expr','ltrim',30);
insert into tabla_sintax values ('expr','replace',30);
insert into tabla_sintax values ('expr','rpad',30);
insert into tabla_sintax values ('expr','rtrim',30);
insert into tabla_sintax values ('expr','soundex',30);
insert into tabla_sintax values ('expr','substr',30);
insert into tabla_sintax values ('expr','translate',30);
insert into tabla_sintax values ('expr','upper',30);
insert into tabla_sintax values ('expr','ascii',30);
insert into tabla_sintax values ('expr','instr',30);
insert into tabla_sintax values ('expr','length',30);
insert into tabla_sintax values ('expr','nlssort',30);
insert into tabla_sintax values ('expr','avg',30);
insert into tabla_sintax values ('expr','count',30);
insert into tabla_sintax values ('expr','max',30);
insert into tabla_sintax values ('expr','min',30);
insert into tabla_sintax values ('expr','stddev',30);
insert into tabla_sintax values ('expr','sum',30);
insert into tabla_sintax values ('expr','variance',30);
insert into tabla_sintax values ('expr','chartorowid',30);
insert into tabla_sintax values ('expr','convert',30);
insert into tabla_sintax values ('expr','hextoraw',30);
insert into tabla_sintax values ('expr','rawtohex',30);
insert into tabla_sintax values ('expr','rowidtochar',30);
insert into tabla_sintax values ('expr','to_char',30);
insert into tabla_sintax values ('expr','to_date',30);
insert into tabla_sintax values ('expr','to_number',30);
insert into tabla_sintax values ('expr','add_months',30);
insert into tabla_sintax values ('expr','last_day',30);
insert into tabla_sintax values ('expr','months_between',30);
insert into tabla_sintax values ('expr','new_time',30);
insert into tabla_sintax values ('expr','next_day',30);
insert into tabla_sintax values ('expr','round',30);
insert into tabla_sintax values ('expr','trunc',30);
insert into tabla_sintax values ('expr','dump',30);
insert into tabla_sintax values ('expr','greatest',30);
insert into tabla_sintax values ('expr','least',30);
insert into tabla_sintax values ('expr','nvl',30);
insert into tabla_sintax values ('expr','userenv',30);
insert into tabla_sintax values ('expr','vsize',30);
insert into tabla_sintax values ('expr','decode',30);

--31: expr_element  :   '(' condition ')'
insert into producciones values (31,1,'(','t');
insert into producciones values (31,2,'condition','n');
insert into producciones values (31,3,')','t');
insert into tabla_sintax values ('expr_element','(',31);
--32        |   '{' condition '}'
insert into producciones values (32,1,'{','t');
insert into producciones values (32,2,'condition','n');
insert into producciones values (32,3,'}','t');
insert into tabla_sintax values ('expr_element','{',32);
--33        |   ctes
insert into producciones values (33,1,'ctes','n');
insert into tabla_sintax values ('expr_element','numero',33);
insert into tabla_sintax values ('expr_element','sysdate',33);
insert into tabla_sintax values ('expr_element','uid',33);
insert into tabla_sintax values ('expr_element','user',33);
insert into tabla_sintax values ('expr_element','texto',33);
insert into tabla_sintax values ('expr_element','level',33);
insert into tabla_sintax values ('expr_element','null',33);
insert into tabla_sintax values ('expr_element','undefined',33);
insert into tabla_sintax values ('expr_element','unknown',33);
--34        |   columna
insert into producciones values (34,1,'columna','n');
insert into tabla_sintax values ('expr_element','id',34);
insert into tabla_sintax values ('expr_element','rowid',34);
insert into tabla_sintax values ('expr_element','rownum',34);
--35        |   funcion
insert into producciones values (35,1,'funcion','n');
insert into tabla_sintax values ('expr_element','abs',35);
insert into tabla_sintax values ('expr_element','cdeg',35);
insert into tabla_sintax values ('expr_element','ceil',35);
insert into tabla_sintax values ('expr_element','floor',35);
insert into tabla_sintax values ('expr_element','sign',35);
insert into tabla_sintax values ('expr_element','sqrt',35);
insert into tabla_sintax values ('expr_element','chr',35);
insert into tabla_sintax values ('expr_element','mod',35);
insert into tabla_sintax values ('expr_element','power',35);
insert into tabla_sintax values ('expr_element','initcap',35);
insert into tabla_sintax values ('expr_element','lower',35);
insert into tabla_sintax values ('expr_element','lpad',35);
insert into tabla_sintax values ('expr_element','ltrim',35);
insert into tabla_sintax values ('expr_element','replace',35);
insert into tabla_sintax values ('expr_element','rpad',35);
insert into tabla_sintax values ('expr_element','rtrim',35);
insert into tabla_sintax values ('expr_element','soundex',35);
insert into tabla_sintax values ('expr_element','substr',35);
insert into tabla_sintax values ('expr_element','translate',35);
insert into tabla_sintax values ('expr_element','upper',35);
insert into tabla_sintax values ('expr_element','ascii',35);
insert into tabla_sintax values ('expr_element','instr',35);
insert into tabla_sintax values ('expr_element','length',35);
insert into tabla_sintax values ('expr_element','nlssort',35);
insert into tabla_sintax values ('expr_element','avg',35);
insert into tabla_sintax values ('expr_element','count',35);
insert into tabla_sintax values ('expr_element','max',35);
insert into tabla_sintax values ('expr_element','min',35);
insert into tabla_sintax values ('expr_element','stddev',35);
insert into tabla_sintax values ('expr_element','sum',35);
insert into tabla_sintax values ('expr_element','variance',35);
insert into tabla_sintax values ('expr_element','chartorowid',35);
insert into tabla_sintax values ('expr_element','convert',35);
insert into tabla_sintax values ('expr_element','hextoraw',35);
insert into tabla_sintax values ('expr_element','rawtohex',35);
insert into tabla_sintax values ('expr_element','rowidtochar',35);
insert into tabla_sintax values ('expr_element','to_char',35);
insert into tabla_sintax values ('expr_element','to_date',35);
insert into tabla_sintax values ('expr_element','to_number',35);
insert into tabla_sintax values ('expr_element','add_months',35);
insert into tabla_sintax values ('expr_element','last_day',35);
insert into tabla_sintax values ('expr_element','months_between',35);
insert into tabla_sintax values ('expr_element','new_time',35);
insert into tabla_sintax values ('expr_element','next_day',35);
insert into tabla_sintax values ('expr_element','round',35);
insert into tabla_sintax values ('expr_element','trunc',35);
insert into tabla_sintax values ('expr_element','dump',35);
insert into tabla_sintax values ('expr_element','greatest',35);
insert into tabla_sintax values ('expr_element','least',35);
insert into tabla_sintax values ('expr_element','nvl',35);
insert into tabla_sintax values ('expr_element','userenv',35);
insert into tabla_sintax values ('expr_element','vsize',35);
insert into tabla_sintax values ('expr_element','decode',35);

--36/44: ctes   :   numero | sysdate | uid | user | texto | level
--          |   null | undefined | unknown
insert into producciones values (36,1,'numero','t');
insert into producciones values (37,1,'sysdate','t');
insert into producciones values (38,1,'uid','t');
insert into producciones values (39,1,'user','t');
insert into producciones values (40,1,'texto','t');
insert into producciones values (41,1,'level','t');
insert into producciones values (42,1,'null','t');
insert into producciones values (43,1,'undefined','t');
insert into producciones values (44,1,'unknown','t');
insert into tabla_sintax values ('ctes','numero',36);
insert into tabla_sintax values ('ctes','sysdate',37);
insert into tabla_sintax values ('ctes','uid',38);
insert into tabla_sintax values ('ctes','user',39);
insert into tabla_sintax values ('ctes','texto',40);
insert into tabla_sintax values ('ctes','level',41);
insert into tabla_sintax values ('ctes','null',42);
insert into tabla_sintax values ('ctes','undefined',43);
insert into tabla_sintax values ('ctes','unknown',44);

--45: expr_maxprior :   '+' expr_element
insert into producciones values (45,1,'+','t');
insert into producciones values (45,2,'expr_element','n');
insert into tabla_sintax values ('expr_maxprior','+',45);
--46        |   '-' expr_element
insert into producciones values (46,1,'-','t');
insert into producciones values (46,2,'expr_element','n');
insert into tabla_sintax values ('expr_maxprior','-',46);
--47        |   prior expr_maxprior
insert into producciones values (47,1,'prior','t');
insert into producciones values (47,2,'expr_maxprior','n');
insert into tabla_sintax values ('expr_maxprior','prior',47);
--48        |   expr_element
insert into producciones values (48,1,'expr_element','n');
-- insertamos en tabla_sintax: iniciales(expr_element)
insert into tabla_sintax values ('expr_maxprior','(',48);
insert into tabla_sintax values ('expr_maxprior','{',48);
-- * ctes *
insert into tabla_sintax values ('expr_maxprior','numero',48);
insert into tabla_sintax values ('expr_maxprior','sysdate',48);
insert into tabla_sintax values ('expr_maxprior','uid',48);
insert into tabla_sintax values ('expr_maxprior','user',48);
insert into tabla_sintax values ('expr_maxprior','texto',48);
insert into tabla_sintax values ('expr_maxprior','level',48);
insert into tabla_sintax values ('expr_maxprior','null',48);
insert into tabla_sintax values ('expr_maxprior','undefined',48);
insert into tabla_sintax values ('expr_maxprior','unknown',48);
-- * columna *
insert into tabla_sintax values ('expr_maxprior','id',48);
insert into tabla_sintax values ('expr_maxprior','rowid',48);
insert into tabla_sintax values ('expr_maxprior','rownum',48);
-- * funcion *
insert into tabla_sintax values ('expr_maxprior','abs',48);
insert into tabla_sintax values ('expr_maxprior','cdeg',48);
insert into tabla_sintax values ('expr_maxprior','ceil',48);
insert into tabla_sintax values ('expr_maxprior','floor',48);
insert into tabla_sintax values ('expr_maxprior','sign',48);
insert into tabla_sintax values ('expr_maxprior','sqrt',48);
insert into tabla_sintax values ('expr_maxprior','chr',48);
insert into tabla_sintax values ('expr_maxprior','mod',48);
insert into tabla_sintax values ('expr_maxprior','power',48);
insert into tabla_sintax values ('expr_maxprior','initcap',48);
insert into tabla_sintax values ('expr_maxprior','lower',48);
insert into tabla_sintax values ('expr_maxprior','lpad',48);
insert into tabla_sintax values ('expr_maxprior','ltrim',48);
insert into tabla_sintax values ('expr_maxprior','replace',48);
insert into tabla_sintax values ('expr_maxprior','rpad',48);
insert into tabla_sintax values ('expr_maxprior','rtrim',48);
insert into tabla_sintax values ('expr_maxprior','soundex',48);
insert into tabla_sintax values ('expr_maxprior','substr',48);
insert into tabla_sintax values ('expr_maxprior','translate',48);
insert into tabla_sintax values ('expr_maxprior','upper',48);
insert into tabla_sintax values ('expr_maxprior','ascii',48);
insert into tabla_sintax values ('expr_maxprior','instr',48);
insert into tabla_sintax values ('expr_maxprior','length',48);
insert into tabla_sintax values ('expr_maxprior','nlssort',48);
insert into tabla_sintax values ('expr_maxprior','avg',48);
insert into tabla_sintax values ('expr_maxprior','count',48);
insert into tabla_sintax values ('expr_maxprior','max',48);
insert into tabla_sintax values ('expr_maxprior','min',48);
insert into tabla_sintax values ('expr_maxprior','stddev',48);
insert into tabla_sintax values ('expr_maxprior','sum',48);
insert into tabla_sintax values ('expr_maxprior','variance',48);
insert into tabla_sintax values ('expr_maxprior','chartorowid',48);
insert into tabla_sintax values ('expr_maxprior','convert',48);
insert into tabla_sintax values ('expr_maxprior','hextoraw',48);
insert into tabla_sintax values ('expr_maxprior','rawtohex',48);
insert into tabla_sintax values ('expr_maxprior','rowidtochar',48);
insert into tabla_sintax values ('expr_maxprior','to_char',48);
insert into tabla_sintax values ('expr_maxprior','to_date',48);
insert into tabla_sintax values ('expr_maxprior','to_number',48);
insert into tabla_sintax values ('expr_maxprior','add_months',48);
insert into tabla_sintax values ('expr_maxprior','last_day',48);
insert into tabla_sintax values ('expr_maxprior','months_between',48);
insert into tabla_sintax values ('expr_maxprior','new_time',48);
insert into tabla_sintax values ('expr_maxprior','next_day',48);
insert into tabla_sintax values ('expr_maxprior','round',48);
insert into tabla_sintax values ('expr_maxprior','trunc',48);
insert into tabla_sintax values ('expr_maxprior','dump',48);
insert into tabla_sintax values ('expr_maxprior','greatest',48);
insert into tabla_sintax values ('expr_maxprior','least',48);
insert into tabla_sintax values ('expr_maxprior','nvl',48);
insert into tabla_sintax values ('expr_maxprior','userenv',48);
insert into tabla_sintax values ('expr_maxprior','vsize',48);
insert into tabla_sintax values ('expr_maxprior','decode',48);

--49: resto_expr    :   operacion resto_expr
insert into producciones values (49,1,'operacion','n');
insert into producciones values (49,2,'resto_expr','n');
insert into tabla_sintax values ('resto_expr','concat',49);
insert into tabla_sintax values ('resto_expr','*',49);
insert into tabla_sintax values ('resto_expr','/',49);
insert into tabla_sintax values ('resto_expr','+',49);
insert into tabla_sintax values ('resto_expr','-',49);
--50        | {nulo}
insert into producciones values (50,1,'vacio','n');
--poner los seguidores(resto_expr)=seguidores(expr)
insert into tabla_sintax values ('resto_expr','the end',50);
insert into tabla_sintax values ('resto_expr',';',50);
insert into tabla_sintax values ('resto_expr',')',50);
insert into tabla_sintax values ('resto_expr','}',50);
insert into tabla_sintax values ('resto_expr','cadena',50);
insert into tabla_sintax values ('resto_expr','id',50);
insert into tabla_sintax values ('resto_expr','as',50);
insert into tabla_sintax values ('resto_expr',',',50);
insert into tabla_sintax values ('resto_expr','from',50);
insert into tabla_sintax values ('resto_expr','is',50);
insert into tabla_sintax values ('resto_expr','feq',50);
insert into tabla_sintax values ('resto_expr','fgt',50);
insert into tabla_sintax values ('resto_expr','flt',50);
insert into tabla_sintax values ('resto_expr','fgeq',50);
insert into tabla_sintax values ('resto_expr','fleq',50);
insert into tabla_sintax values ('resto_expr','mgt',50);
insert into tabla_sintax values ('resto_expr','mlt',50);
insert into tabla_sintax values ('resto_expr','nfeq',50);
insert into tabla_sintax values ('resto_expr','nfgt',50);
insert into tabla_sintax values ('resto_expr','nflt',50);
insert into tabla_sintax values ('resto_expr','nfgeq',50);
insert into tabla_sintax values ('resto_expr','nfleq',50);
insert into tabla_sintax values ('resto_expr','nmgt',50);
insert into tabla_sintax values ('resto_expr','nmlt',50);
insert into tabla_sintax values ('resto_expr','not',50);
insert into tabla_sintax values ('resto_expr','in',50);
insert into tabla_sintax values ('resto_expr','between',50);
insert into tabla_sintax values ('resto_expr','eq',50);
insert into tabla_sintax values ('resto_expr','neq',50);
insert into tabla_sintax values ('resto_expr','leq',50);
insert into tabla_sintax values ('resto_expr','geq',50);
insert into tabla_sintax values ('resto_expr','lt',50);
insert into tabla_sintax values ('resto_expr','gt',50);
insert into tabla_sintax values ('resto_expr','and',50);
insert into tabla_sintax values ('resto_expr','or',50);
insert into tabla_sintax values ('resto_expr','thold',50);
insert into tabla_sintax values ('resto_expr','numero',50);
insert into tabla_sintax values ('resto_expr','asc',50);
insert into tabla_sintax values ('resto_expr','desc',50);
insert into tabla_sintax values ('resto_expr','group',50);
insert into tabla_sintax values ('resto_expr','having',50);
insert into tabla_sintax values ('resto_expr','start',50);
insert into tabla_sintax values ('resto_expr','connect',50);
insert into tabla_sintax values ('resto_expr','order',50);
insert into tabla_sintax values ('resto_expr','union',50);
insert into tabla_sintax values ('resto_expr','intersect',50);
insert into tabla_sintax values ('resto_expr','minus',50);
insert into tabla_sintax values ('resto_expr','like',50);

--51: operacion :   concat expr_maxprior
insert into producciones values (51,1,'concat','t');
insert into producciones values (51,2,'expr_element','n');
insert into tabla_sintax values ('operacion','concat',51);
--52        |   '*' expr_maxprior
insert into producciones values (52,1,'*','t');
insert into producciones values (52,2,'expr_maxprior','n');
insert into tabla_sintax values ('operacion','*',52);
--53        |   '/' expr_maxprior
insert into producciones values (53,1,'/','t');
insert into producciones values (53,2,'expr_maxprior','n');
insert into tabla_sintax values ('operacion','/',53);
--54        |   '+' expr_maxprior
insert into producciones values (54,1,'+','t');
insert into producciones values (54,2,'expr_maxprior','n');
insert into tabla_sintax values ('operacion','+',54);
--55        |   '-' expr_maxprior
insert into producciones values (55,1,'-','t');
insert into producciones values (55,2,'expr_maxprior','n');
insert into tabla_sintax values ('operacion','-',55);

-- \echo >>>> tablas producciones y tabla_sintax: insertando valores... bloque 2/3

-- *****> definicion de una columna de una tabla <*****
--60 columna    :   id resto_col
insert into producciones values (60,1,'id','t');
insert into producciones values (60,2,'resto_col','n');
insert into tabla_sintax values ('columna','id',60);
--61        |   rowid
insert into producciones values (61,1,'rowid','t');
insert into tabla_sintax values ('columna','rowid',61);
--62        |   rownum
insert into producciones values (62,1,'rownum','t');
insert into tabla_sintax values ('columna','rownum',62);

--63 resto_col  :   '.' resto_col1
insert into producciones values (63,1,'.','t');
insert into producciones values (63,2,'resto_col1','n');
insert into tabla_sintax values ('resto_col','.',63);
--64        |
insert into producciones values (64,1,'vacio','t');
-- seguidores(resto_col)=seguidores(columna)
insert into tabla_sintax values ('resto_col','concat',64);
insert into tabla_sintax values ('resto_col','+',64);
insert into tabla_sintax values ('resto_col','-',64);
insert into tabla_sintax values ('resto_col','/',64);
insert into tabla_sintax values ('resto_col','*',64);
-- seg(expr):
insert into tabla_sintax values ('resto_col','the end',64);
insert into tabla_sintax values ('resto_col',';',64);
insert into tabla_sintax values ('resto_col',')',64);
insert into tabla_sintax values ('resto_col','}',64);
insert into tabla_sintax values ('resto_col','cadena',64);
insert into tabla_sintax values ('resto_col','id',64);
insert into tabla_sintax values ('resto_col','as',64);
insert into tabla_sintax values ('resto_col',',',64);
insert into tabla_sintax values ('resto_col','is',64);
insert into tabla_sintax values ('resto_col','feq',64);
insert into tabla_sintax values ('resto_col','fgt',64);
insert into tabla_sintax values ('resto_col','flt',64);
insert into tabla_sintax values ('resto_col','fgeq',64);
insert into tabla_sintax values ('resto_col','fleq',64);
insert into tabla_sintax values ('resto_col','mgt',64);
insert into tabla_sintax values ('resto_col','mlt',64);
insert into tabla_sintax values ('resto_col','nfeq',64);
insert into tabla_sintax values ('resto_col','nfgt',64);
insert into tabla_sintax values ('resto_col','nflt',64);
insert into tabla_sintax values ('resto_col','nfgeq',64);
insert into tabla_sintax values ('resto_col','nfleq',64);
insert into tabla_sintax values ('resto_col','nmgt',64);
insert into tabla_sintax values ('resto_col','nmlt',64);
insert into tabla_sintax values ('resto_col','not',64);
insert into tabla_sintax values ('resto_col','in',64);
insert into tabla_sintax values ('resto_col','between',64);
insert into tabla_sintax values ('resto_col','eq',64);
insert into tabla_sintax values ('resto_col','neq',64);
insert into tabla_sintax values ('resto_col','leq',64);
insert into tabla_sintax values ('resto_col','geq',64);
insert into tabla_sintax values ('resto_col','lt',64);
insert into tabla_sintax values ('resto_col','gt',64);
insert into tabla_sintax values ('resto_col','and',64);
insert into tabla_sintax values ('resto_col','or',64);
insert into tabla_sintax values ('resto_col','thold',64);
insert into tabla_sintax values ('resto_col','numero',64);
insert into tabla_sintax values ('resto_col','asc',64);
insert into tabla_sintax values ('resto_col','from',64);
insert into tabla_sintax values ('resto_col','desc',64);
insert into tabla_sintax values ('resto_col','group',64);
insert into tabla_sintax values ('resto_col','having',64);
insert into tabla_sintax values ('resto_col','start',64);
insert into tabla_sintax values ('resto_col','connect',64);
insert into tabla_sintax values ('resto_col','order',64);
insert into tabla_sintax values ('resto_col','union',64);
insert into tabla_sintax values ('resto_col','intersect',64);
insert into tabla_sintax values ('resto_col','minus',64);
insert into tabla_sintax values ('resto_col','like',64);

--65 resto_col1 :   id resto_col2
insert into producciones values (65,1,'id','t');
insert into producciones values (65,2,'resto_col2','n');
insert into tabla_sintax values ('resto_col1','id',65);
--66        |   '*'
insert into producciones values (66,1,'*','t');
insert into tabla_sintax values ('resto_col1','*',66);
--67        |   '%'
insert into producciones values (67,1,'%','t');
insert into tabla_sintax values ('resto_col1','%',67);
--68        |   pseudo_col
insert into producciones values (68,1,'pseudo_col','n');
insert into tabla_sintax values ('resto_col1','currval',68);
insert into tabla_sintax values ('resto_col1','nextval',68);
insert into tabla_sintax values ('resto_col1','level',68);
insert into tabla_sintax values ('resto_col1','rowid',68);
insert into tabla_sintax values ('resto_col1','rownum',68);

--69 resto_col2 :   '.' resto_col3
insert into producciones values (69,1,'.','t');
insert into producciones values (69,2,'resto_col3','n');
insert into tabla_sintax values ('resto_col2','.',69);
--70        |
insert into producciones values (70,1,'vacio','t');
-- seguidores(resto_col2)=seguidores(columna)
insert into tabla_sintax values ('resto_col2','concat',70);
insert into tabla_sintax values ('resto_col2','+',70);
insert into tabla_sintax values ('resto_col2','-',70);
insert into tabla_sintax values ('resto_col2','/',70);
insert into tabla_sintax values ('resto_col2','*',70);
-- seg(expr):
insert into tabla_sintax values ('resto_col2','the end',70);
insert into tabla_sintax values ('resto_col2',';',70);
insert into tabla_sintax values ('resto_col2',')',70);
insert into tabla_sintax values ('resto_col2','}',70);
insert into tabla_sintax values ('resto_col2','cadena',70);
insert into tabla_sintax values ('resto_col2','id',70);
insert into tabla_sintax values ('resto_col2','as',70);
insert into tabla_sintax values ('resto_col2',',',70);
insert into tabla_sintax values ('resto_col2','from',70);
insert into tabla_sintax values ('resto_col2','is',70);
insert into tabla_sintax values ('resto_col2','feq',70);
insert into tabla_sintax values ('resto_col2','fgt',70);
insert into tabla_sintax values ('resto_col2','flt',70);
insert into tabla_sintax values ('resto_col2','fgeq',70);
insert into tabla_sintax values ('resto_col2','fleq',70);
insert into tabla_sintax values ('resto_col2','mgt',70);
insert into tabla_sintax values ('resto_col2','mlt',70);
insert into tabla_sintax values ('resto_col2','nfeq',70);
insert into tabla_sintax values ('resto_col2','nfgt',70);
insert into tabla_sintax values ('resto_col2','nflt',70);
insert into tabla_sintax values ('resto_col2','nfgeq',70);
insert into tabla_sintax values ('resto_col2','nfleq',70);
insert into tabla_sintax values ('resto_col2','nmgt',70);
insert into tabla_sintax values ('resto_col2','nmlt',70);
insert into tabla_sintax values ('resto_col2','not',70);
insert into tabla_sintax values ('resto_col2','in',70);
insert into tabla_sintax values ('resto_col2','between',70);
insert into tabla_sintax values ('resto_col2','eq',70);
insert into tabla_sintax values ('resto_col2','neq',70);
insert into tabla_sintax values ('resto_col2','leq',70);
insert into tabla_sintax values ('resto_col2','geq',70);
insert into tabla_sintax values ('resto_col2','lt',70);
insert into tabla_sintax values ('resto_col2','gt',70);
insert into tabla_sintax values ('resto_col2','and',70);
insert into tabla_sintax values ('resto_col2','or',70);
insert into tabla_sintax values ('resto_col2','thold',70);
insert into tabla_sintax values ('resto_col2','numero',70);
insert into tabla_sintax values ('resto_col2','asc',70);
insert into tabla_sintax values ('resto_col2','desc',70);
insert into tabla_sintax values ('resto_col2','group',70);
insert into tabla_sintax values ('resto_col2','having',70);
insert into tabla_sintax values ('resto_col2','start',70);
insert into tabla_sintax values ('resto_col2','connect',70);
insert into tabla_sintax values ('resto_col2','order',70);
insert into tabla_sintax values ('resto_col2','union',70);
insert into tabla_sintax values ('resto_col2','intersect',70);
insert into tabla_sintax values ('resto_col2','minus',70);
insert into tabla_sintax values ('resto_col2','like',70);

--71/74: resto_col3 :   id | '*' | '%' | pseudo_col
insert into producciones values (71,1,'id','t');
insert into tabla_sintax values ('resto_col3','id',71);
insert into producciones values (72,1,'*','t');
insert into tabla_sintax values ('resto_col3','*',72);
insert into producciones values (73,1,'%','t');
insert into tabla_sintax values ('resto_col3','%',73);
insert into producciones values (74,1,'pseudo_col','n');
insert into tabla_sintax values ('resto_col3','currval',74);
insert into tabla_sintax values ('resto_col3','nextval',74);
insert into tabla_sintax values ('resto_col3','level',74);
insert into tabla_sintax values ('resto_col3','rowid',74);
insert into tabla_sintax values ('resto_col3','rownum',74);

--75/79: pseudo_col :   currval | nextval | level | rowid | rownum
insert into producciones values (75,1,'currval','t');
insert into tabla_sintax values ('pseudo_col','currval',75);
insert into producciones values (76,1,'nextval','t');
insert into tabla_sintax values ('pseudo_col','nextval',76);
insert into producciones values (77,1,'level','t');
insert into tabla_sintax values ('pseudo_col','level',77);
insert into producciones values (78,1,'rowid','t');
insert into tabla_sintax values ('pseudo_col','rowid',78);
insert into producciones values (79,1,'rownum','t');
insert into tabla_sintax values ('pseudo_col','rownum',79);

--90/96: funcion  :  abs arg1|cdeg arg_dif|ceil arg1|floor arg1|sign arg1|sqrt arg1|chr arg1
insert into producciones values (90,1,'abs','t');
insert into producciones values (90,2,'arg1','n');
insert into producciones values (91,1,'cdeg','t');
insert into producciones values (91,2,'(','t');
insert into producciones values (91,3,'arg_dif','n');
insert into producciones values (91,4,')','t');
insert into producciones values (92,1,'ceil','t');
insert into producciones values (92,2,'arg1','n');
insert into producciones values (93,1,'floor','t');
insert into producciones values (93,2,'arg1','n');
insert into producciones values (94,1,'sign','t');
insert into producciones values (94,2,'arg1','n');
insert into producciones values (95,1,'sqrt','t');
insert into producciones values (95,2,'arg1','n');
insert into producciones values (96,1,'chr','t');
insert into producciones values (96,2,'arg1','n');
--97/103 :|mod arg2|power arg2|initcap arg1|lower arg1|lpad arg2_3|ltrim arg1_2|replace arg2_3
insert into producciones values (97,1,'mod','t');
insert into producciones values (97,2,'arg2','n');
insert into producciones values (98,1,'power','t');
insert into producciones values (98,2,'arg2','n');
insert into producciones values (99,1,'initcap','t');
insert into producciones values (99,2,'arg1','n');
insert into producciones values (100,1,'lower','t');
insert into producciones values (100,2,'arg1','n');
insert into producciones values (101,1,'lpad','t');
insert into producciones values (101,2,'arg2_3','n');
insert into producciones values (102,1,'ltrim','t');
insert into producciones values (102,2,'arg1_2','n');
insert into producciones values (103,1,'replace','t');
insert into producciones values (103,2,'arg2_3','n');
--104/109:|rpad arg2_3|rtrim arg1_2|soundex arg1|substr arg2_3|translate arg3|upper arg1
insert into producciones values (104,1,'rpad','t');
insert into producciones values (104,2,'arg2_3','n');
insert into producciones values (105,1,'rtrim','t');
insert into producciones values (105,2,'arg1_2','n');
insert into producciones values (106,1,'soundex','t');
insert into producciones values (106,2,'arg1','n');
insert into producciones values (107,1,'substr','t');
insert into producciones values (107,2,'arg2_3','n');
insert into producciones values (108,1,'translate','t');
insert into producciones values (108,2,'arg3','n');
insert into producciones values (109,1,'upper','t');
insert into producciones values (109,2,'arg1','n');
--110/115:|ascii arg1|instr arg2_3_4|length arg1|nlssort arg1|avg arg1u|count arg2u
insert into producciones values (110,1,'ascii','t');
insert into producciones values (110,2,'arg1','n');
insert into producciones values (111,1,'instr','t');
insert into producciones values (111,2,'arg2_3_4','n');
insert into producciones values (112,1,'length','t');
insert into producciones values (112,2,'arg1','n');
insert into producciones values (113,1,'nlssort','t');
insert into producciones values (113,2,'arg1','n');
insert into producciones values (114,1,'avg','t');
insert into producciones values (114,2,'arg1u','n');
insert into producciones values (115,1,'count','t');
insert into producciones values (115,2,'arg2u','n');
--116/121:|max arg1u|min arg1u|stddev arg1u|sum arg1u|variance arg1u|chartorowid arg1
insert into producciones values (116,1,'max','t');
insert into producciones values (116,2,'arg1u','n');
insert into producciones values (117,1,'min','t');
insert into producciones values (117,2,'arg1u','n');
insert into producciones values (118,1,'stddev','t');
insert into producciones values (118,2,'arg1u','n');
insert into producciones values (119,1,'sum','t');
insert into producciones values (119,2,'arg1u','n');
insert into producciones values (120,1,'variance','t');
insert into producciones values (120,2,'arg1u','n');
insert into producciones values (121,1,'chartorowid','t');
insert into producciones values (121,2,'arg1','n');
--122/126:|convert arg1_2_3|hextoraw arg1|rawtohex arg1|rowidtochar arg1|to_char arg1_2
insert into producciones values (122,1,'convert','t');
insert into producciones values (122,2,'arg1_2_3','n');
insert into producciones values (123,1,'hextoraw','t');
insert into producciones values (123,2,'arg1','n');
insert into producciones values (124,1,'rawtohex','t');
insert into producciones values (124,2,'arg1','n');
insert into producciones values (125,1,'rowidtochar','t');
insert into producciones values (125,2,'arg1','n');
insert into producciones values (126,1,'to_char','t');
insert into producciones values (126,2,'arg1_2','n');
--127/131:|to_date arg1_2|to_number arg1|add_months arg2|last_day arg1|months_between arg2
insert into producciones values (127,1,'to_date','t');
insert into producciones values (127,2,'arg1_2','n');
insert into producciones values (128,1,'to_number','t');
insert into producciones values (128,2,'arg1','n');
insert into producciones values (129,1,'add_months','t');
insert into producciones values (129,2,'arg2','n');
insert into producciones values (130,1,'last_day','t');
insert into producciones values (130,2,'arg1','n');
insert into producciones values (131,1,'months_between','t');
insert into producciones values (131,2,'arg2','n');
--132/136:|new_time arg3|next_day arg2|round arg1_2|trunc arg1_2|dump arg1_2_3_4
insert into producciones values (132,1,'new_time','t');
insert into producciones values (132,2,'arg3','n');
insert into producciones values (133,1,'next_day','t');
insert into producciones values (133,2,'arg2','n');
insert into producciones values (134,1,'round','t');
insert into producciones values (134,2,'arg1_2','n');
insert into producciones values (135,1,'trunc','t');
insert into producciones values (135,2,'arg1_2','n');
insert into producciones values (136,1,'dump','t');
insert into producciones values (136,2,'arg1_2_3_4','n');
--137/142:|greatest arg_list|least arg_list|nvl arg2|userenv arg1|vsize arg1|decode argu_deco
insert into producciones values (137,1,'greatest','t');
insert into producciones values (137,2,'arg_list','n');
insert into producciones values (138,1,'least','t');
insert into producciones values (138,2,'arg_list','n');
insert into producciones values (139,1,'nvl','t');
insert into producciones values (139,2,'arg2','n');
insert into producciones values (140,1,'userenv','t');
insert into producciones values (140,2,'arg1','n');
insert into producciones values (141,1,'vsize','t');
insert into producciones values (141,2,'arg1','n');
insert into producciones values (142,1,'decode','t');
insert into producciones values (142,2,'argu_deco','n');
-- tuplas para las transiciones, si en la pila esta el simbolo 'funcion':
insert into tabla_sintax values ('funcion','abs',90);
insert into tabla_sintax values ('funcion','cdeg',91);
insert into tabla_sintax values ('funcion','ceil',92);
insert into tabla_sintax values ('funcion','floor',93);
insert into tabla_sintax values ('funcion','sign',94);
insert into tabla_sintax values ('funcion','sqrt',95);
insert into tabla_sintax values ('funcion','chr',96);
insert into tabla_sintax values ('funcion','mod',97);
insert into tabla_sintax values ('funcion','power',98);
insert into tabla_sintax values ('funcion','initcap',99);
insert into tabla_sintax values ('funcion','lower',100);
insert into tabla_sintax values ('funcion','lpad',101);
insert into tabla_sintax values ('funcion','ltrim',102);
insert into tabla_sintax values ('funcion','replace',103);
insert into tabla_sintax values ('funcion','rpad',104);
insert into tabla_sintax values ('funcion','rtrim',105);
insert into tabla_sintax values ('funcion','soundex',106);
insert into tabla_sintax values ('funcion','substr',107);
insert into tabla_sintax values ('funcion','translate',108);
insert into tabla_sintax values ('funcion','upper',109);
insert into tabla_sintax values ('funcion','ascii',110);
insert into tabla_sintax values ('funcion','instr',111);
insert into tabla_sintax values ('funcion','length',112);
insert into tabla_sintax values ('funcion','nlssort',113);
insert into tabla_sintax values ('funcion','avg',114);
insert into tabla_sintax values ('funcion','count',115);
insert into tabla_sintax values ('funcion','max',116);
insert into tabla_sintax values ('funcion','min',117);
insert into tabla_sintax values ('funcion','stddev',118);
insert into tabla_sintax values ('funcion','sum',119);
insert into tabla_sintax values ('funcion','variance',120);
insert into tabla_sintax values ('funcion','chartorowid',121);
insert into tabla_sintax values ('funcion','convert',122);
insert into tabla_sintax values ('funcion','hextoraw',123);
insert into tabla_sintax values ('funcion','rawtohex',124);
insert into tabla_sintax values ('funcion','rowidtochar',125);
insert into tabla_sintax values ('funcion','to_char',126);
insert into tabla_sintax values ('funcion','to_date',127);
insert into tabla_sintax values ('funcion','to_number',128);
insert into tabla_sintax values ('funcion','add_months',129);
insert into tabla_sintax values ('funcion','last_day',130);
insert into tabla_sintax values ('funcion','months_between',131);
insert into tabla_sintax values ('funcion','new_time',132);
insert into tabla_sintax values ('funcion','next_day',133);
insert into tabla_sintax values ('funcion','round',134);
insert into tabla_sintax values ('funcion','trunc',135);
insert into tabla_sintax values ('funcion','dump',136);
insert into tabla_sintax values ('funcion','greatest',137);
insert into tabla_sintax values ('funcion','least',138);
insert into tabla_sintax values ('funcion','nvl',139);
insert into tabla_sintax values ('funcion','userenv',140);
insert into tabla_sintax values ('funcion','vsize',141);
insert into tabla_sintax values ('funcion','decode',142);

--149/150: arg_dif: '*' | columna
insert into producciones values (149,1,'*','t');
insert into tabla_sintax values ('arg_dif','*',149);
insert into producciones values (150,1,'columna','n');
-- iniciales(columna)-{rowid,rownum}
insert into tabla_sintax values ('arg_dif','id',150);

--151: arg1 :   '(' expr ')'
insert into producciones values (151,1,'(','t');
insert into producciones values (151,2,'expr','n');
insert into producciones values (151,3,')','t');
insert into tabla_sintax values ('arg1','(',151);

--152: arg2 :   '(' expr ',' expr ')'
insert into producciones values (152,1,'(','t');
insert into producciones values (152,2,'expr','n');
insert into producciones values (152,3,',','t');
insert into producciones values (152,4,'expr','n');
insert into producciones values (152,5,')','t');
insert into tabla_sintax values ('arg2','(',152);

--153: arg3 :   '(' expr ',' expr ',' expr ')'
insert into producciones values (153,1,'(','t');
insert into producciones values (153,2,'expr','n');
insert into producciones values (153,3,',','t');
insert into producciones values (153,4,'expr','n');
insert into producciones values (153,5,',','t');
insert into producciones values (153,6,'expr','n');
insert into producciones values (153,7,')','t');
insert into tabla_sintax values ('arg3','(',153);

--154: arg1_2:  '(' expr list_op1 ')'
insert into producciones values (154,1,'(','t');
insert into producciones values (154,2,'expr','n');
insert into producciones values (154,3,'list_op1','n');
insert into producciones values (154,4,')','t');
insert into tabla_sintax values ('arg1_2','(',154);

--155: arg2_3:  '(' expr ',' expr list_op1 ')'
insert into producciones values (155,1,'(','t');
insert into producciones values (155,2,'expr','n');
insert into producciones values (155,3,',','t');
insert into producciones values (155,4,'expr','n');
insert into producciones values (155,5,'list_op1','n');
insert into producciones values (155,6,')','t');
insert into tabla_sintax values ('arg2_3','(',155);

--156: arg1_2_3:    '(' expr list_op2 ')'
insert into producciones values (156,1,'(','t');
insert into producciones values (156,2,'expr','n');
insert into producciones values (156,3,'list_op2','n');
insert into producciones values (156,4,')','t');
insert into tabla_sintax values ('arg1_2_3','(',156);

--157: arg2_3_4:    '(' expr ',' expr list_op2 ')'
insert into producciones values (157,1,'(','t');
insert into producciones values (157,2,'expr','n');
insert into producciones values (157,3,',','t');
insert into producciones values (157,4,'expr','n');
insert into producciones values (157,5,'list_op2','n');
insert into producciones values (157,6,')','t');
insert into tabla_sintax values ('arg2_3_4','(',157);

--158: arg1_2_3_4   :   '(' expr list_op3 ')'
insert into producciones values (158,1,'(','t');
insert into producciones values (158,2,'expr','n');
insert into producciones values (158,3,'list_op3','n');
insert into producciones values (158,4,')','t');
insert into tabla_sintax values ('arg1_2_3_4','(',158);

--159: list_op1 :   ',' expr
insert into producciones values (159,1,',','t');
insert into producciones values (159,2,'expr','n');
insert into tabla_sintax values ('list_op1',',',159);
--160:      |
insert into producciones values (160,1,'vacio','n');
--seguidores(list_op1)=seguidores(list_op2)=seguidores(list_op3)=')'
insert into tabla_sintax values ('list_op1',')',160);

--161: list_op2 :   ',' expr list_op1
insert into producciones values (161,1,',','t');
insert into producciones values (161,2,'list_op1','n');
insert into tabla_sintax values ('list_op2',',',161);
--162:      |
insert into producciones values (162,1,'vacio','n');
insert into tabla_sintax values ('list_op2',')',162);

--163: list_op3 :   ',' expr list_op2
insert into producciones values (163,1,',','t');
insert into producciones values (163,2,'expr','n');
insert into producciones values (163,3,'list_op2','n');
insert into tabla_sintax values ('list_op3',',',163);
--164:      |
insert into producciones values (164,1,'vacio','n');
insert into tabla_sintax values ('list_op3',')',164);

--165: arg_list :   '(' expr mas_expres ')'
insert into producciones values (165,1,'(','t');
insert into producciones values (165,2,'expr','n');
insert into producciones values (165,3,'mas_expres','n');
insert into producciones values (165,4,')','t');
insert into tabla_sintax values ('arg_list','(',165);

--166: mas_expres   :   ',' expr mas_expres
insert into producciones values (166,1,',','t');
insert into producciones values (166,2,'expr','n');
insert into producciones values (166,3,'mas_expres','n');
insert into tabla_sintax values ('mas_expres',',',166);
--167:      |
insert into producciones values (167,1,'vacio','n');
-- seguidores(mas_expres)
insert into tabla_sintax values ('mas_expres','the end',167);
insert into tabla_sintax values ('mas_expres',';',167);
insert into tabla_sintax values ('mas_expres',')',167);
insert into tabla_sintax values ('mas_expres','having',167);
insert into tabla_sintax values ('mas_expres','group',167);
insert into tabla_sintax values ('mas_expres','start',167);
insert into tabla_sintax values ('mas_expres','connect',167);
insert into tabla_sintax values ('mas_expres','union',167);
insert into tabla_sintax values ('mas_expres','intersect',167);
insert into tabla_sintax values ('mas_expres','minus',167);
insert into tabla_sintax values ('mas_expres','order',167);

--168/169: dupli    :   distinct | all
insert into producciones values (168,1,'distinct','t');
insert into producciones values (169,1,'all','t');
insert into tabla_sintax values ('dupli','distinct',168);
insert into tabla_sintax values ('dupli','all',169);
--170:      |
insert into producciones values (170,1,'vacio','n');
-- seguidores(dupli)=iniciales(expr)
insert into tabla_sintax values ('dupli','+',170);
insert into tabla_sintax values ('dupli','-',170);
insert into tabla_sintax values ('dupli','prior',170);
insert into tabla_sintax values ('dupli','(',170);
insert into tabla_sintax values ('dupli','{',170);
-- * ctes *
insert into tabla_sintax values ('dupli','numero',170);
insert into tabla_sintax values ('dupli','sysdate',170);
insert into tabla_sintax values ('dupli','uid',170);
insert into tabla_sintax values ('dupli','user',170);
insert into tabla_sintax values ('dupli','texto',170);
insert into tabla_sintax values ('dupli','level',170);
insert into tabla_sintax values ('dupli','null',170);
insert into tabla_sintax values ('dupli','undefined',170);
insert into tabla_sintax values ('dupli','unknown',170);
-- * columna *
insert into tabla_sintax values ('dupli','id',170);
insert into tabla_sintax values ('dupli','rowid',170);
insert into tabla_sintax values ('dupli','rownum',170);
-- * funciones *
insert into tabla_sintax values ('dupli','abs',170);
insert into tabla_sintax values ('dupli','cdeg',170);
insert into tabla_sintax values ('dupli','ceil',170);
insert into tabla_sintax values ('dupli','floor',170);
insert into tabla_sintax values ('dupli','sign',170);
insert into tabla_sintax values ('dupli','sqrt',170);
insert into tabla_sintax values ('dupli','chr',170);
insert into tabla_sintax values ('dupli','mod',170);
insert into tabla_sintax values ('dupli','power',170);
insert into tabla_sintax values ('dupli','initcap',170);
insert into tabla_sintax values ('dupli','lower',170);
insert into tabla_sintax values ('dupli','lpad',170);
insert into tabla_sintax values ('dupli','ltrim',170);
insert into tabla_sintax values ('dupli','replace',170);
insert into tabla_sintax values ('dupli','rpad',170);
insert into tabla_sintax values ('dupli','rtrim',170);
insert into tabla_sintax values ('dupli','soundex',170);
insert into tabla_sintax values ('dupli','substr',170);
insert into tabla_sintax values ('dupli','translate',170);
insert into tabla_sintax values ('dupli','upper',170);
insert into tabla_sintax values ('dupli','ascii',170);
insert into tabla_sintax values ('dupli','instr',170);
insert into tabla_sintax values ('dupli','length',170);
insert into tabla_sintax values ('dupli','nlssort',170);
insert into tabla_sintax values ('dupli','avg',170);
insert into tabla_sintax values ('dupli','count',170);
insert into tabla_sintax values ('dupli','max',170);
insert into tabla_sintax values ('dupli','min',170);
insert into tabla_sintax values ('dupli','stddev',170);
insert into tabla_sintax values ('dupli','sum',170);
insert into tabla_sintax values ('dupli','variance',170);
insert into tabla_sintax values ('dupli','chartorowid',170);
insert into tabla_sintax values ('dupli','convert',170);
insert into tabla_sintax values ('dupli','hextoraw',170);
insert into tabla_sintax values ('dupli','rawtohex',170);
insert into tabla_sintax values ('dupli','rowidtochar',170);
insert into tabla_sintax values ('dupli','to_char',170);
insert into tabla_sintax values ('dupli','to_date',170);
insert into tabla_sintax values ('dupli','to_number',170);
insert into tabla_sintax values ('dupli','add_months',170);
insert into tabla_sintax values ('dupli','last_day',170);
insert into tabla_sintax values ('dupli','months_between',170);
insert into tabla_sintax values ('dupli','new_time',170);
insert into tabla_sintax values ('dupli','next_day',170);
insert into tabla_sintax values ('dupli','round',170);
insert into tabla_sintax values ('dupli','trunc',170);
insert into tabla_sintax values ('dupli','dump',170);
insert into tabla_sintax values ('dupli','greatest',170);
insert into tabla_sintax values ('dupli','least',170);
insert into tabla_sintax values ('dupli','nvl',170);
insert into tabla_sintax values ('dupli','userenv',170);
insert into tabla_sintax values ('dupli','vsize',170);
insert into tabla_sintax values ('dupli','decode',170);

--171: arg1u    :   '(' dupli expr ')'
insert into producciones values (171,1,'(','t');
insert into producciones values (171,2,'dupli','n');
insert into producciones values (171,3,'expr','n');
insert into producciones values (171,4,')','t');
insert into tabla_sintax values ('arg1u','(',171);

--172: arg2u    :   '(' resto_arg2u ')'
insert into producciones values (172,1,'(','t');
insert into producciones values (172,2,'resto_arg2u','n');
insert into producciones values (172,3,')','t');
insert into tabla_sintax values ('arg2u','(',172);

--173: resto_arg2u: dupli expr
insert into producciones values (173,1,'dupli','n');
insert into producciones values (173,2,'expr','n');
insert into tabla_sintax values ('resto_arg2u','distinct',173);
insert into tabla_sintax values ('resto_arg2u','all',173);
-- iniciales(expr) (porque dupli puede derivar en vacio)
insert into tabla_sintax values ('resto_arg2u','+',173);
insert into tabla_sintax values ('resto_arg2u','-',173);
insert into tabla_sintax values ('resto_arg2u','prior',173);
insert into tabla_sintax values ('resto_arg2u','(',173);
insert into tabla_sintax values ('resto_arg2u','{',173);
-- * ctes *
insert into tabla_sintax values ('resto_arg2u','numero',173);
insert into tabla_sintax values ('resto_arg2u','sysdate',173);
insert into tabla_sintax values ('resto_arg2u','uid',173);
insert into tabla_sintax values ('resto_arg2u','user',173);
insert into tabla_sintax values ('resto_arg2u','texto',173);
insert into tabla_sintax values ('resto_arg2u','level',173);
insert into tabla_sintax values ('resto_arg2u','null',173);
insert into tabla_sintax values ('resto_arg2u','undefined',173);
insert into tabla_sintax values ('resto_arg2u','unknown',173);
-- * columna *
insert into tabla_sintax values ('resto_arg2u','id',173);
insert into tabla_sintax values ('resto_arg2u','rowid',173);
insert into tabla_sintax values ('resto_arg2u','rownum',173);
-- * funciones *
insert into tabla_sintax values ('resto_arg2u','abs',173);
insert into tabla_sintax values ('resto_arg2u','cdeg',173);
insert into tabla_sintax values ('resto_arg2u','ceil',173);
insert into tabla_sintax values ('resto_arg2u','floor',173);
insert into tabla_sintax values ('resto_arg2u','sign',173);
insert into tabla_sintax values ('resto_arg2u','sqrt',173);
insert into tabla_sintax values ('resto_arg2u','chr',173);
insert into tabla_sintax values ('resto_arg2u','mod',173);
insert into tabla_sintax values ('resto_arg2u','power',173);
insert into tabla_sintax values ('resto_arg2u','initcap',173);
insert into tabla_sintax values ('resto_arg2u','lower',173);
insert into tabla_sintax values ('resto_arg2u','lpad',173);
insert into tabla_sintax values ('resto_arg2u','ltrim',173);
insert into tabla_sintax values ('resto_arg2u','replace',173);
insert into tabla_sintax values ('resto_arg2u','rpad',173);
insert into tabla_sintax values ('resto_arg2u','rtrim',173);
insert into tabla_sintax values ('resto_arg2u','soundex',173);
insert into tabla_sintax values ('resto_arg2u','substr',173);
insert into tabla_sintax values ('resto_arg2u','translate',173);
insert into tabla_sintax values ('resto_arg2u','upper',173);
insert into tabla_sintax values ('resto_arg2u','ascii',173);
insert into tabla_sintax values ('resto_arg2u','instr',173);
insert into tabla_sintax values ('resto_arg2u','length',173);
insert into tabla_sintax values ('resto_arg2u','nlssort',173);
insert into tabla_sintax values ('resto_arg2u','avg',173);
insert into tabla_sintax values ('resto_arg2u','count',173);
insert into tabla_sintax values ('resto_arg2u','max',173);
insert into tabla_sintax values ('resto_arg2u','min',173);
insert into tabla_sintax values ('resto_arg2u','stddev',173);
insert into tabla_sintax values ('resto_arg2u','sum',173);
insert into tabla_sintax values ('resto_arg2u','variance',173);
insert into tabla_sintax values ('resto_arg2u','chartorowid',173);
insert into tabla_sintax values ('resto_arg2u','convert',173);
insert into tabla_sintax values ('resto_arg2u','hextoraw',173);
insert into tabla_sintax values ('resto_arg2u','rawtohex',173);
insert into tabla_sintax values ('resto_arg2u','rowidtochar',173);
insert into tabla_sintax values ('resto_arg2u','to_char',173);
insert into tabla_sintax values ('resto_arg2u','to_date',173);
insert into tabla_sintax values ('resto_arg2u','to_number',173);
insert into tabla_sintax values ('resto_arg2u','add_months',173);
insert into tabla_sintax values ('resto_arg2u','last_day',173);
insert into tabla_sintax values ('resto_arg2u','months_between',173);
insert into tabla_sintax values ('resto_arg2u','new_time',173);
insert into tabla_sintax values ('resto_arg2u','next_day',173);
insert into tabla_sintax values ('resto_arg2u','round',173);
insert into tabla_sintax values ('resto_arg2u','trunc',173);
insert into tabla_sintax values ('resto_arg2u','dump',173);
insert into tabla_sintax values ('resto_arg2u','greatest',173);
insert into tabla_sintax values ('resto_arg2u','least',173);
insert into tabla_sintax values ('resto_arg2u','nvl',173);
insert into tabla_sintax values ('resto_arg2u','userenv',173);
insert into tabla_sintax values ('resto_arg2u','vsize',173);
insert into tabla_sintax values ('resto_arg2u','decode',173);
--174:      |   '*'
insert into producciones values (174,1,'*','t');
insert into tabla_sintax values ('resto_arg2u','*',174);

--175: argu_deco    :   '(' expr ',' expr ',' expr mas_expres ')'
insert into producciones values (175,1,'(','t');
insert into producciones values (175,2,'expr','n');
insert into producciones values (175,3,',','t');
insert into producciones values (175,4,'expr','n');
insert into producciones values (175,5,',','t');
insert into producciones values (175,6,'expr','n');
insert into producciones values (175,7,'mas_expres','n');
insert into producciones values (175,8,')','t');
insert into tabla_sintax values ('argu_deco','(',175);

-- *****> definicion de la lista de tablas del from <*****
--180: tablas:  id resto_tab t_alias lista_tab
insert into producciones values (180,1,'id','t');
insert into producciones values (180,2,'resto_tab','n');
insert into producciones values (180,3,'t_alias','n');
insert into producciones values (180,4,'lista_tab','n');
insert into tabla_sintax values ('tablas','id',180);
--181:  |   '(' select_command ')' t_alias lista_tab
insert into producciones values (181,1,'(','t');
insert into producciones values (181,2,'select_command','n');
insert into producciones values (181,3,')','t');
insert into producciones values (181,4,'t_alias','n');
insert into producciones values (181,5,'lista_tab','n');
insert into tabla_sintax values ('tablas','(',181);

--182: resto_tab:   '.' id
insert into producciones values (182,1,'.','t');
insert into producciones values (182,2,'id','t');
insert into tabla_sintax values ('resto_tab','.',182);
--183:  |
insert into producciones values (183,1,'vacio','n');
-- seguidores(resto_tab)
insert into tabla_sintax values ('resto_tab','the end',183);
insert into tabla_sintax values ('resto_tab',';',183);
insert into tabla_sintax values ('resto_tab','id',183);
insert into tabla_sintax values ('resto_tab',',',183);
insert into tabla_sintax values ('resto_tab','where',183);
insert into tabla_sintax values ('resto_tab','group',183);
insert into tabla_sintax values ('resto_tab','start',183);
insert into tabla_sintax values ('resto_tab','connect',183);
insert into tabla_sintax values ('resto_tab','union',183);
insert into tabla_sintax values ('resto_tab','intersect',183);
insert into tabla_sintax values ('resto_tab','minus',183);
insert into tabla_sintax values ('resto_tab','order',183);
insert into tabla_sintax values ('resto_tab',')',183);

--184: lista_tab:   ',' tablas
insert into producciones values (184,1,',','t');
insert into producciones values (184,2,'tablas','n');
insert into tabla_sintax values ('lista_tab',',',184);
--185:  |
insert into producciones values (185,1,'vacio','n');
-- seguidores(lista_tab)=seguidores(tablas)
insert into tabla_sintax values ('lista_tab','the end',185);
insert into tabla_sintax values ('lista_tab',';',185);
insert into tabla_sintax values ('lista_tab','where',185);
insert into tabla_sintax values ('lista_tab','group',185);
insert into tabla_sintax values ('lista_tab','start',185);
insert into tabla_sintax values ('lista_tab','connect',185);
insert into tabla_sintax values ('lista_tab','union',185);
insert into tabla_sintax values ('lista_tab','intersect',185);
insert into tabla_sintax values ('lista_tab','minus',185);
insert into tabla_sintax values ('lista_tab','order',185);
insert into tabla_sintax values ('lista_tab',')',185);

--186:t_alias:  id
insert into producciones values (186,1,'id','t');
insert into tabla_sintax values ('t_alias','id',186);
--187:  |
insert into producciones values (187,1,'vacio','n');
-- seguidores(t_alias)= ',' u seguidores(tablas)
insert into tabla_sintax values ('t_alias',',',187);
insert into tabla_sintax values ('t_alias','the end',187);
insert into tabla_sintax values ('t_alias',';',187);
insert into tabla_sintax values ('t_alias','where',187);
insert into tabla_sintax values ('t_alias','group',187);
insert into tabla_sintax values ('t_alias','start',187);
insert into tabla_sintax values ('t_alias','connect',187);
insert into tabla_sintax values ('t_alias','union',187);
insert into tabla_sintax values ('t_alias','intersect',187);
insert into tabla_sintax values ('t_alias','minus',187);
insert into tabla_sintax values ('t_alias','order',187);
insert into tabla_sintax values ('t_alias',')',187);

-- \echo >>>> tablas producciones y tabla_sintax: insertando valores... bloque 3/3

-- *****> definicion de la clausula where: condiciones <*****
--190: clausula_where:  where condition
insert into producciones values (190,1,'where','t');
insert into producciones values (190,2,'condition','n');
insert into tabla_sintax values ('clausula_where','where',190);
--191:  |
insert into producciones values (191,1,'vacio','n');
-- seguidores(clausula_where)
insert into tabla_sintax values ('clausula_where','the end',191);
insert into tabla_sintax values ('clausula_where',';',191);
insert into tabla_sintax values ('clausula_where','group',191);
insert into tabla_sintax values ('clausula_where','start',191);
insert into tabla_sintax values ('clausula_where','connect',191);
insert into tabla_sintax values ('clausula_where','union',191);
insert into tabla_sintax values ('clausula_where','intersect',191);
insert into tabla_sintax values ('clausula_where','minus',191);
insert into tabla_sintax values ('clausula_where','order',191);
insert into tabla_sintax values ('clausula_where',')',191);

--192: condition:   cond_and resto_cond
insert into producciones values (192,1,'cond_and','n');
insert into producciones values (192,2,'resto_cond','n');
-- iniciales(cond_and)=iniciales(condition)=not,$,#,[,exists,iniciales(expr)
insert into tabla_sintax values ('condition','not',192);
insert into tabla_sintax values ('condition','$',192);
insert into tabla_sintax values ('condition','#',192);
insert into tabla_sintax values ('condition','[',192);
insert into tabla_sintax values ('condition','+',192);
insert into tabla_sintax values ('condition','-',192);
insert into tabla_sintax values ('condition','prior',192);
insert into tabla_sintax values ('condition','(',192);
insert into tabla_sintax values ('condition','{',192);
insert into tabla_sintax values ('condition','exists',192);
-- * ctes *
insert into tabla_sintax values ('condition','numero',192);
insert into tabla_sintax values ('condition','sysdate',192);
insert into tabla_sintax values ('condition','uid',192);
insert into tabla_sintax values ('condition','user',192);
insert into tabla_sintax values ('condition','texto',192);
insert into tabla_sintax values ('condition','level',192);
insert into tabla_sintax values ('condition','null',192);
insert into tabla_sintax values ('condition','undefined',192);
insert into tabla_sintax values ('condition','unknown',192);
-- * columna *
insert into tabla_sintax values ('condition','id',192);
insert into tabla_sintax values ('condition','rowid',192);
insert into tabla_sintax values ('condition','rownum',192);
-- * funciones *
insert into tabla_sintax values ('condition','abs',192);
insert into tabla_sintax values ('condition','cdeg',192);
insert into tabla_sintax values ('condition','ceil',192);
insert into tabla_sintax values ('condition','floor',192);
insert into tabla_sintax values ('condition','sign',192);
insert into tabla_sintax values ('condition','sqrt',192);
insert into tabla_sintax values ('condition','chr',192);
insert into tabla_sintax values ('condition','mod',192);
insert into tabla_sintax values ('condition','power',192);
insert into tabla_sintax values ('condition','initcap',192);
insert into tabla_sintax values ('condition','lower',192);
insert into tabla_sintax values ('condition','lpad',192);
insert into tabla_sintax values ('condition','ltrim',192);
insert into tabla_sintax values ('condition','replace',192);
insert into tabla_sintax values ('condition','rpad',192);
insert into tabla_sintax values ('condition','rtrim',192);
insert into tabla_sintax values ('condition','soundex',192);
insert into tabla_sintax values ('condition','substr',192);
insert into tabla_sintax values ('condition','translate',192);
insert into tabla_sintax values ('condition','upper',192);
insert into tabla_sintax values ('condition','ascii',192);
insert into tabla_sintax values ('condition','instr',192);
insert into tabla_sintax values ('condition','length',192);
insert into tabla_sintax values ('condition','nlssort',192);
insert into tabla_sintax values ('condition','avg',192);
insert into tabla_sintax values ('condition','count',192);
insert into tabla_sintax values ('condition','max',192);
insert into tabla_sintax values ('condition','min',192);
insert into tabla_sintax values ('condition','stddev',192);
insert into tabla_sintax values ('condition','sum',192);
insert into tabla_sintax values ('condition','variance',192);
insert into tabla_sintax values ('condition','chartorowid',192);
insert into tabla_sintax values ('condition','convert',192);
insert into tabla_sintax values ('condition','hextoraw',192);
insert into tabla_sintax values ('condition','rawtohex',192);
insert into tabla_sintax values ('condition','rowidtochar',192);
insert into tabla_sintax values ('condition','to_char',192);
insert into tabla_sintax values ('condition','to_date',192);
insert into tabla_sintax values ('condition','to_number',192);
insert into tabla_sintax values ('condition','add_months',192);
insert into tabla_sintax values ('condition','last_day',192);
insert into tabla_sintax values ('condition','months_between',192);
insert into tabla_sintax values ('condition','new_time',192);
insert into tabla_sintax values ('condition','next_day',192);
insert into tabla_sintax values ('condition','round',192);
insert into tabla_sintax values ('condition','trunc',192);
insert into tabla_sintax values ('condition','dump',192);
insert into tabla_sintax values ('condition','greatest',192);
insert into tabla_sintax values ('condition','least',192);
insert into tabla_sintax values ('condition','nvl',192);
insert into tabla_sintax values ('condition','userenv',192);
insert into tabla_sintax values ('condition','vsize',192);
insert into tabla_sintax values ('condition','decode',192);

--193:cond_and: cond_not resto_and
insert into producciones values (193,1,'cond_not','n');
insert into producciones values (193,2,'resto_and','n');
-- iniciales(cond_not)=iniciales(cond_and)
insert into tabla_sintax values ('cond_and','not',193);
insert into tabla_sintax values ('cond_and','$',193);
insert into tabla_sintax values ('cond_and','#',193);
insert into tabla_sintax values ('cond_and','[',193);
insert into tabla_sintax values ('cond_and','+',193);
insert into tabla_sintax values ('cond_and','-',193);
insert into tabla_sintax values ('cond_and','prior',193);
insert into tabla_sintax values ('cond_and','(',193);
insert into tabla_sintax values ('cond_and','{',193);
insert into tabla_sintax values ('cond_and','exists',193);
-- * ctes *
insert into tabla_sintax values ('cond_and','numero',193);
insert into tabla_sintax values ('cond_and','sysdate',193);
insert into tabla_sintax values ('cond_and','uid',193);
insert into tabla_sintax values ('cond_and','user',193);
insert into tabla_sintax values ('cond_and','texto',193);
insert into tabla_sintax values ('cond_and','level',193);
insert into tabla_sintax values ('cond_and','null',193);
insert into tabla_sintax values ('cond_and','undefined',193);
insert into tabla_sintax values ('cond_and','unknown',193);
-- * columna *
insert into tabla_sintax values ('cond_and','id',193);
insert into tabla_sintax values ('cond_and','rowid',193);
insert into tabla_sintax values ('cond_and','rownum',193);
-- * funciones *
insert into tabla_sintax values ('cond_and','abs',193);
insert into tabla_sintax values ('cond_and','cdeg',193);
insert into tabla_sintax values ('cond_and','ceil',193);
insert into tabla_sintax values ('cond_and','floor',193);
insert into tabla_sintax values ('cond_and','sign',193);
insert into tabla_sintax values ('cond_and','sqrt',193);
insert into tabla_sintax values ('cond_and','chr',193);
insert into tabla_sintax values ('cond_and','mod',193);
insert into tabla_sintax values ('cond_and','power',193);
insert into tabla_sintax values ('cond_and','initcap',193);
insert into tabla_sintax values ('cond_and','lower',193);
insert into tabla_sintax values ('cond_and','lpad',193);
insert into tabla_sintax values ('cond_and','ltrim',193);
insert into tabla_sintax values ('cond_and','replace',193);
insert into tabla_sintax values ('cond_and','rpad',193);
insert into tabla_sintax values ('cond_and','rtrim',193);
insert into tabla_sintax values ('cond_and','soundex',193);
insert into tabla_sintax values ('cond_and','substr',193);
insert into tabla_sintax values ('cond_and','translate',193);
insert into tabla_sintax values ('cond_and','upper',193);
insert into tabla_sintax values ('cond_and','ascii',193);
insert into tabla_sintax values ('cond_and','instr',193);
insert into tabla_sintax values ('cond_and','length',193);
insert into tabla_sintax values ('cond_and','nlssort',193);
insert into tabla_sintax values ('cond_and','avg',193);
insert into tabla_sintax values ('cond_and','count',193);
insert into tabla_sintax values ('cond_and','max',193);
insert into tabla_sintax values ('cond_and','min',193);
insert into tabla_sintax values ('cond_and','stddev',193);
insert into tabla_sintax values ('cond_and','sum',193);
insert into tabla_sintax values ('cond_and','variance',193);
insert into tabla_sintax values ('cond_and','chartorowid',193);
insert into tabla_sintax values ('cond_and','convert',193);
insert into tabla_sintax values ('cond_and','hextoraw',193);
insert into tabla_sintax values ('cond_and','rawtohex',193);
insert into tabla_sintax values ('cond_and','rowidtochar',193);
insert into tabla_sintax values ('cond_and','to_char',193);
insert into tabla_sintax values ('cond_and','to_date',193);
insert into tabla_sintax values ('cond_and','to_number',193);
insert into tabla_sintax values ('cond_and','add_months',193);
insert into tabla_sintax values ('cond_and','last_day',193);
insert into tabla_sintax values ('cond_and','months_between',193);
insert into tabla_sintax values ('cond_and','new_time',193);
insert into tabla_sintax values ('cond_and','next_day',193);
insert into tabla_sintax values ('cond_and','round',193);
insert into tabla_sintax values ('cond_and','trunc',193);
insert into tabla_sintax values ('cond_and','dump',193);
insert into tabla_sintax values ('cond_and','greatest',193);
insert into tabla_sintax values ('cond_and','least',193);
insert into tabla_sintax values ('cond_and','nvl',193);
insert into tabla_sintax values ('cond_and','userenv',193);
insert into tabla_sintax values ('cond_and','vsize',193);
insert into tabla_sintax values ('cond_and','decode',193);

--194: resto_cond:  or condition
insert into producciones values (194,1,'or','t');
insert into producciones values (194,2,'condition','n');
insert into tabla_sintax values ('resto_cond','or',194);
--195:  |
insert into producciones values (195,1,'vacio','n');
-- seguidores(resto_cond)=seguidores(condition)
insert into tabla_sintax values ('resto_cond','the end',195);
insert into tabla_sintax values ('resto_cond',';',195);
insert into tabla_sintax values ('resto_cond',')',195);
insert into tabla_sintax values ('resto_cond','}',195);
insert into tabla_sintax values ('resto_cond','group',195);
insert into tabla_sintax values ('resto_cond','connect',195);
insert into tabla_sintax values ('resto_cond','start',195);
insert into tabla_sintax values ('resto_cond','union',195);
insert into tabla_sintax values ('resto_cond','intersect',195);
insert into tabla_sintax values ('resto_cond','minus',195);
insert into tabla_sintax values ('resto_cond','order',195);

--196: cond_not:    not cond_not
insert into producciones values (196,1,'not','t');
insert into producciones values (196,2,'cond_not','n');
insert into tabla_sintax values ('cond_not','not',196);
--197:  |   cond_elemental
insert into producciones values (197,1,'cond_elemental','n');
insert into tabla_sintax values ('cond_not','$',197);
insert into tabla_sintax values ('cond_not','#',197);
insert into tabla_sintax values ('cond_not','[',197);
insert into tabla_sintax values ('cond_not','+',197);
insert into tabla_sintax values ('cond_not','-',197);
insert into tabla_sintax values ('cond_not','prior',197);
insert into tabla_sintax values ('cond_not','(',197);
insert into tabla_sintax values ('cond_not','{',197);
insert into tabla_sintax values ('cond_not','numero',197);
insert into tabla_sintax values ('cond_not','sysdate',197);
insert into tabla_sintax values ('cond_not','uid',197);
insert into tabla_sintax values ('cond_not','user',197);
insert into tabla_sintax values ('cond_not','texto',197);
insert into tabla_sintax values ('cond_not','level',197);
insert into tabla_sintax values ('cond_not','null',197);
insert into tabla_sintax values ('cond_not','undefined',197);
insert into tabla_sintax values ('cond_not','unknown',197);
insert into tabla_sintax values ('cond_not','id',197);
insert into tabla_sintax values ('cond_not','rowid',197);
insert into tabla_sintax values ('cond_not','rownum',197);
insert into tabla_sintax values ('cond_not','abs',197);
insert into tabla_sintax values ('cond_not','cdeg',197);
insert into tabla_sintax values ('cond_not','ceil',197);
insert into tabla_sintax values ('cond_not','floor',197);
insert into tabla_sintax values ('cond_not','sign',197);
insert into tabla_sintax values ('cond_not','sqrt',197);
insert into tabla_sintax values ('cond_not','chr',197);
insert into tabla_sintax values ('cond_not','mod',197);
insert into tabla_sintax values ('cond_not','power',197);
insert into tabla_sintax values ('cond_not','initcap',197);
insert into tabla_sintax values ('cond_not','lower',197);
insert into tabla_sintax values ('cond_not','lpad',197);
insert into tabla_sintax values ('cond_not','ltrim',197);
insert into tabla_sintax values ('cond_not','replace',197);
insert into tabla_sintax values ('cond_not','rpad',197);
insert into tabla_sintax values ('cond_not','rtrim',197);
insert into tabla_sintax values ('cond_not','soundex',197);
insert into tabla_sintax values ('cond_not','substr',197);
insert into tabla_sintax values ('cond_not','translate',197);
insert into tabla_sintax values ('cond_not','upper',197);
insert into tabla_sintax values ('cond_not','ascii',197);
insert into tabla_sintax values ('cond_not','instr',197);
insert into tabla_sintax values ('cond_not','length',197);
insert into tabla_sintax values ('cond_not','nlssort',197);
insert into tabla_sintax values ('cond_not','avg',197);
insert into tabla_sintax values ('cond_not','count',197);
insert into tabla_sintax values ('cond_not','max',197);
insert into tabla_sintax values ('cond_not','min',197);
insert into tabla_sintax values ('cond_not','stddev',197);
insert into tabla_sintax values ('cond_not','sum',197);
insert into tabla_sintax values ('cond_not','variance',197);
insert into tabla_sintax values ('cond_not','chartorowid',197);
insert into tabla_sintax values ('cond_not','convert',197);
insert into tabla_sintax values ('cond_not','hextoraw',197);
insert into tabla_sintax values ('cond_not','rawtohex',197);
insert into tabla_sintax values ('cond_not','rowidtochar',197);
insert into tabla_sintax values ('cond_not','to_char',197);
insert into tabla_sintax values ('cond_not','to_date',197);
insert into tabla_sintax values ('cond_not','to_number',197);
insert into tabla_sintax values ('cond_not','add_months',197);
insert into tabla_sintax values ('cond_not','last_day',197);
insert into tabla_sintax values ('cond_not','months_between',197);
insert into tabla_sintax values ('cond_not','new_time',197);
insert into tabla_sintax values ('cond_not','next_day',197);
insert into tabla_sintax values ('cond_not','round',197);
insert into tabla_sintax values ('cond_not','trunc',197);
insert into tabla_sintax values ('cond_not','dump',197);
insert into tabla_sintax values ('cond_not','greatest',197);
insert into tabla_sintax values ('cond_not','least',197);
insert into tabla_sintax values ('cond_not','nvl',197);
insert into tabla_sintax values ('cond_not','userenv',197);
insert into tabla_sintax values ('cond_not','vsize',197);
insert into tabla_sintax values ('cond_not','decode',197);
insert into tabla_sintax values ('cond_not','exists',197);

--198: resto_and:   and cond_and
insert into producciones values (198,1,'and','t');
insert into producciones values (198,2,'cond_and','n');
insert into tabla_sintax values ('resto_and','and',198);
--199:  |
insert into producciones values (199,1,'vacio','n');
insert into tabla_sintax values ('resto_and','the end',199);
insert into tabla_sintax values ('resto_and',';',199);
insert into tabla_sintax values ('resto_and',')',199);
insert into tabla_sintax values ('resto_and','}',199);
insert into tabla_sintax values ('resto_and','or',199);
insert into tabla_sintax values ('resto_and','group',199);
insert into tabla_sintax values ('resto_and','connect',199);
insert into tabla_sintax values ('resto_and','start',199);
insert into tabla_sintax values ('resto_and','union',199);
insert into tabla_sintax values ('resto_and','intersect',199);
insert into tabla_sintax values ('resto_and','minus',199);
insert into tabla_sintax values ('resto_and','order',199);

--210: cond_elemental:  expr resto_cond_elemental
insert into producciones values (210,1,'expr','n');
insert into producciones values (210,2,'resto_cond_elemental','n');
-- iniciales(expr)
insert into tabla_sintax values ('cond_elemental','+',210);
insert into tabla_sintax values ('cond_elemental','-',210);
insert into tabla_sintax values ('cond_elemental','prior',210);
insert into tabla_sintax values ('cond_elemental','(',210);
insert into tabla_sintax values ('cond_elemental','{',210);
-- * ctes *
insert into tabla_sintax values ('cond_elemental','numero',210);
insert into tabla_sintax values ('cond_elemental','sysdate',210);
insert into tabla_sintax values ('cond_elemental','uid',210);
insert into tabla_sintax values ('cond_elemental','user',210);
insert into tabla_sintax values ('cond_elemental','texto',210);
insert into tabla_sintax values ('cond_elemental','level',210);
insert into tabla_sintax values ('cond_elemental','null',210);
insert into tabla_sintax values ('cond_elemental','undefined',210);
insert into tabla_sintax values ('cond_elemental','unknown',210);
-- * columna *
insert into tabla_sintax values ('cond_elemental','id',210);
insert into tabla_sintax values ('cond_elemental','rowid',210);
insert into tabla_sintax values ('cond_elemental','rownum',210);
-- * funciones *
insert into tabla_sintax values ('cond_elemental','abs',210);
insert into tabla_sintax values ('cond_elemental','cdeg',210);
insert into tabla_sintax values ('cond_elemental','ceil',210);
insert into tabla_sintax values ('cond_elemental','floor',210);
insert into tabla_sintax values ('cond_elemental','sign',210);
insert into tabla_sintax values ('cond_elemental','sqrt',210);
insert into tabla_sintax values ('cond_elemental','chr',210);
insert into tabla_sintax values ('cond_elemental','mod',210);
insert into tabla_sintax values ('cond_elemental','power',210);
insert into tabla_sintax values ('cond_elemental','initcap',210);
insert into tabla_sintax values ('cond_elemental','lower',210);
insert into tabla_sintax values ('cond_elemental','lpad',210);
insert into tabla_sintax values ('cond_elemental','ltrim',210);
insert into tabla_sintax values ('cond_elemental','replace',210);
insert into tabla_sintax values ('cond_elemental','rpad',210);
insert into tabla_sintax values ('cond_elemental','rtrim',210);
insert into tabla_sintax values ('cond_elemental','soundex',210);
insert into tabla_sintax values ('cond_elemental','substr',210);
insert into tabla_sintax values ('cond_elemental','translate',210);
insert into tabla_sintax values ('cond_elemental','upper',210);
insert into tabla_sintax values ('cond_elemental','ascii',210);
insert into tabla_sintax values ('cond_elemental','instr',210);
insert into tabla_sintax values ('cond_elemental','length',210);
insert into tabla_sintax values ('cond_elemental','nlssort',210);
insert into tabla_sintax values ('cond_elemental','avg',210);
insert into tabla_sintax values ('cond_elemental','count',210);
insert into tabla_sintax values ('cond_elemental','max',210);
insert into tabla_sintax values ('cond_elemental','min',210);
insert into tabla_sintax values ('cond_elemental','stddev',210);
insert into tabla_sintax values ('cond_elemental','sum',210);
insert into tabla_sintax values ('cond_elemental','variance',210);
insert into tabla_sintax values ('cond_elemental','chartorowid',210);
insert into tabla_sintax values ('cond_elemental','convert',210);
insert into tabla_sintax values ('cond_elemental','hextoraw',210);
insert into tabla_sintax values ('cond_elemental','rawtohex',210);
insert into tabla_sintax values ('cond_elemental','rowidtochar',210);
insert into tabla_sintax values ('cond_elemental','to_char',210);
insert into tabla_sintax values ('cond_elemental','to_date',210);
insert into tabla_sintax values ('cond_elemental','to_number',210);
insert into tabla_sintax values ('cond_elemental','add_months',210);
insert into tabla_sintax values ('cond_elemental','last_day',210);
insert into tabla_sintax values ('cond_elemental','months_between',210);
insert into tabla_sintax values ('cond_elemental','new_time',210);
insert into tabla_sintax values ('cond_elemental','next_day',210);
insert into tabla_sintax values ('cond_elemental','round',210);
insert into tabla_sintax values ('cond_elemental','trunc',210);
insert into tabla_sintax values ('cond_elemental','dump',210);
insert into tabla_sintax values ('cond_elemental','greatest',210);
insert into tabla_sintax values ('cond_elemental','least',210);
insert into tabla_sintax values ('cond_elemental','nvl',210);
insert into tabla_sintax values ('cond_elemental','userenv',210);
insert into tabla_sintax values ('cond_elemental','vsize',210);
insert into tabla_sintax values ('cond_elemental','decode',210);

--211:      |   '$' resto_fexpr           resto_fcond
insert into producciones values (211,1,'$','t');
insert into producciones values (211,2,'resto_fexpr','n');
insert into producciones values (211,3,'resto_fcond','n');
insert into tabla_sintax values ('cond_elemental','$',211);
--212:      |   '#' numero                resto_fcond
insert into producciones values (212,1,'#','t');
insert into producciones values (212,2,'numero','t');
insert into producciones values (212,3,'resto_fcond','n');
insert into tabla_sintax values ('cond_elemental','#',212);
--213:      |   '[' numero ',' numero ']' resto_fcond
insert into producciones values (213,1,'[','t');
insert into producciones values (213,2,'numero','t');
insert into producciones values (213,3,',','t');
insert into producciones values (213,4,'numero','t');
insert into producciones values (213,5,']','t');
insert into producciones values (213,6,'resto_fcond','n');
insert into tabla_sintax values ('cond_elemental','[',213);
--500:      |   exists '(' select_command ')' /* produccion n 500 */
insert into producciones values (500,1,'exists','t');
insert into producciones values (500,2,'(','t');
insert into producciones values (500,3,'select_command','n');
insert into producciones values (500,4,')','t');
insert into tabla_sintax values ('cond_elemental','exists',500);

--214: resto_cond_elemental:    resto_nofcond
insert into producciones values (214,1,'resto_nofcond','n');
insert into tabla_sintax values ('resto_cond_elemental','not',214);
insert into tabla_sintax values ('resto_cond_elemental','eq',214);
insert into tabla_sintax values ('resto_cond_elemental','neq',214);
insert into tabla_sintax values ('resto_cond_elemental','leq',214);
insert into tabla_sintax values ('resto_cond_elemental','geq',214);
insert into tabla_sintax values ('resto_cond_elemental','lt',214);
insert into tabla_sintax values ('resto_cond_elemental','gt',214);
insert into tabla_sintax values ('resto_cond_elemental','between',214);
insert into tabla_sintax values ('resto_cond_elemental','in',214);
insert into tabla_sintax values ('resto_cond_elemental','like',214);
--215:      |   resto_fcond
insert into producciones values (215,1,'resto_fcond','n');
insert into tabla_sintax values ('resto_cond_elemental','feq',215);
insert into tabla_sintax values ('resto_cond_elemental','fgt',215);
insert into tabla_sintax values ('resto_cond_elemental','flt',215);
insert into tabla_sintax values ('resto_cond_elemental','fgeq',215);
insert into tabla_sintax values ('resto_cond_elemental','fleq',215);
insert into tabla_sintax values ('resto_cond_elemental','mgt',215);
insert into tabla_sintax values ('resto_cond_elemental','mlt',215);
insert into tabla_sintax values ('resto_cond_elemental','nfeq',215);
insert into tabla_sintax values ('resto_cond_elemental','nfgt',215);
insert into tabla_sintax values ('resto_cond_elemental','nflt',215);
insert into tabla_sintax values ('resto_cond_elemental','nfgeq',215);
insert into tabla_sintax values ('resto_cond_elemental','nfleq',215);
insert into tabla_sintax values ('resto_cond_elemental','nmgt',215);
insert into tabla_sintax values ('resto_cond_elemental','nmlt',215);
--216:      |   is negacion fuzzy_ctes
insert into producciones values (216,1,'is','t');
insert into producciones values (216,2,'negacion','n');
insert into producciones values (216,3,'fuzzy_ctes','n');
insert into tabla_sintax values ('resto_cond_elemental','is',216);
--217:      |
insert into producciones values (217,1,'vacio','n');
insert into tabla_sintax values ('resto_cond_elemental','the end',217);
insert into tabla_sintax values ('resto_cond_elemental',';',217);
insert into tabla_sintax values ('resto_cond_elemental','and',217);
insert into tabla_sintax values ('resto_cond_elemental','or',217);
insert into tabla_sintax values ('resto_cond_elemental',')',217);
insert into tabla_sintax values ('resto_cond_elemental','}',217);
insert into tabla_sintax values ('resto_cond_elemental','group',217);
insert into tabla_sintax values ('resto_cond_elemental','connect',217);
insert into tabla_sintax values ('resto_cond_elemental','start',217);
insert into tabla_sintax values ('resto_cond_elemental','union',217);
insert into tabla_sintax values ('resto_cond_elemental','intersect',217);
insert into tabla_sintax values ('resto_cond_elemental','minus',217);
insert into tabla_sintax values ('resto_cond_elemental','order',217);

--218: resto_fcond: fcomparador fexpr umbral
insert into producciones values (218,1,'fcomparador','n');
insert into producciones values (218,2,'fexpr','n');
insert into producciones values (218,3,'umbral','n');
insert into tabla_sintax values ('resto_fcond','feq',218);
insert into tabla_sintax values ('resto_fcond','fgt',218);
insert into tabla_sintax values ('resto_fcond','flt',218);
insert into tabla_sintax values ('resto_fcond','fgeq',218);
insert into tabla_sintax values ('resto_fcond','fleq',218);
insert into tabla_sintax values ('resto_fcond','mgt',218);
insert into tabla_sintax values ('resto_fcond','mlt',218);
insert into tabla_sintax values ('resto_fcond','nfeq',218);
insert into tabla_sintax values ('resto_fcond','nfgt',218);
insert into tabla_sintax values ('resto_fcond','nflt',218);
insert into tabla_sintax values ('resto_fcond','nfgeq',218);
insert into tabla_sintax values ('resto_fcond','nfleq',218);
insert into tabla_sintax values ('resto_fcond','nmgt',218);
insert into tabla_sintax values ('resto_fcond','nmlt',218);

--220: umbral   :   thold numero
insert into producciones values (220,1,'thold','t');
insert into producciones values (220,2,'numero','t');
insert into tabla_sintax values ('umbral','thold',220);
--221:      |   numero
insert into producciones values (221,1,'numero','t');
insert into tabla_sintax values ('umbral','numero',221);
--222:      |   comparador numero
insert into producciones values (222,1,'comparador','n');
insert into producciones values (222,2,'numero','t');
insert into tabla_sintax values ('umbral','eq',222);
insert into tabla_sintax values ('umbral','neq',222);
insert into tabla_sintax values ('umbral','leq',222);
insert into tabla_sintax values ('umbral','geq',222);
insert into tabla_sintax values ('umbral','lt',222);
insert into tabla_sintax values ('umbral','gt',222);
--223:      |
insert into producciones values (223,1,'vacio','n');
insert into tabla_sintax values ('umbral','the end',223);
insert into tabla_sintax values ('umbral',';',223);
insert into tabla_sintax values ('umbral','and',223);
insert into tabla_sintax values ('umbral','or',223);
insert into tabla_sintax values ('umbral',')',223);
insert into tabla_sintax values ('umbral','}',223);
insert into tabla_sintax values ('umbral','group',223);
insert into tabla_sintax values ('umbral','connect',223);
insert into tabla_sintax values ('umbral','start',223);
insert into tabla_sintax values ('umbral','union',223);
insert into tabla_sintax values ('umbral','intersect',223);
insert into tabla_sintax values ('umbral','minus',223);
insert into tabla_sintax values ('umbral','order',223);

--224: negacion :   not
insert into producciones values (224,1,'not','t');
insert into tabla_sintax values ('negacion','not',224);
--225:      |
insert into producciones values (225,1,'vacio','n');
insert into tabla_sintax values ('negacion','null',225);
insert into tabla_sintax values ('negacion','undefined',225);
insert into tabla_sintax values ('negacion','unknown',225);

--226: fexpr    :   '$' resto_fexpr
insert into producciones values (226,1,'$','t');
insert into producciones values (226,2,'resto_fexpr','n');
insert into tabla_sintax values ('fexpr','$',226);
--227:      |   '#' numero
insert into producciones values (227,1,'#','t');
insert into producciones values (227,2,'numero','t');
insert into tabla_sintax values ('fexpr','#',227);
--228:      |   '[' numero ',' numero ']'
insert into producciones values (228,1,'[','t');
insert into producciones values (228,2,'numero','t');
insert into producciones values (228,3,',','t');
insert into producciones values (228,4,'numero','t');
insert into producciones values (228,5,']','t');
insert into tabla_sintax values ('fexpr','[',228);
--229:      |   expr
insert into producciones values (229,1,'expr','n');
--iniciales(expr)
insert into tabla_sintax values ('fexpr','+',229);
insert into tabla_sintax values ('fexpr','-',229);
insert into tabla_sintax values ('fexpr','prior',229);
insert into tabla_sintax values ('fexpr','(',229);
insert into tabla_sintax values ('fexpr','{',229);
-- * ctes *
insert into tabla_sintax values ('fexpr','numero',229);
insert into tabla_sintax values ('fexpr','sysdate',229);
insert into tabla_sintax values ('fexpr','uid',229);
insert into tabla_sintax values ('fexpr','user',229);
insert into tabla_sintax values ('fexpr','texto',229);
insert into tabla_sintax values ('fexpr','level',229);
insert into tabla_sintax values ('fexpr','null',229);
insert into tabla_sintax values ('fexpr','undefined',229);
insert into tabla_sintax values ('fexpr','unknown',229);
-- * columna *
insert into tabla_sintax values ('fexpr','id',229);
insert into tabla_sintax values ('fexpr','rowid',229);
insert into tabla_sintax values ('fexpr','rownum',229);
-- * funciones *
insert into tabla_sintax values ('fexpr','abs',229);
insert into tabla_sintax values ('fexpr','cdeg',229);
insert into tabla_sintax values ('fexpr','ceil',229);
insert into tabla_sintax values ('fexpr','floor',229);
insert into tabla_sintax values ('fexpr','sign',229);
insert into tabla_sintax values ('fexpr','sqrt',229);
insert into tabla_sintax values ('fexpr','chr',229);
insert into tabla_sintax values ('fexpr','mod',229);
insert into tabla_sintax values ('fexpr','power',229);
insert into tabla_sintax values ('fexpr','initcap',229);
insert into tabla_sintax values ('fexpr','lower',229);
insert into tabla_sintax values ('fexpr','lpad',229);
insert into tabla_sintax values ('fexpr','ltrim',229);
insert into tabla_sintax values ('fexpr','replace',229);
insert into tabla_sintax values ('fexpr','rpad',229);
insert into tabla_sintax values ('fexpr','rtrim',229);
insert into tabla_sintax values ('fexpr','soundex',229);
insert into tabla_sintax values ('fexpr','substr',229);
insert into tabla_sintax values ('fexpr','translate',229);
insert into tabla_sintax values ('fexpr','upper',229);
insert into tabla_sintax values ('fexpr','ascii',229);
insert into tabla_sintax values ('fexpr','instr',229);
insert into tabla_sintax values ('fexpr','length',229);
insert into tabla_sintax values ('fexpr','nlssort',229);
insert into tabla_sintax values ('fexpr','avg',229);
insert into tabla_sintax values ('fexpr','count',229);
insert into tabla_sintax values ('fexpr','max',229);
insert into tabla_sintax values ('fexpr','min',229);
insert into tabla_sintax values ('fexpr','stddev',229);
insert into tabla_sintax values ('fexpr','sum',229);
insert into tabla_sintax values ('fexpr','variance',229);
insert into tabla_sintax values ('fexpr','chartorowid',229);
insert into tabla_sintax values ('fexpr','convert',229);
insert into tabla_sintax values ('fexpr','hextoraw',229);
insert into tabla_sintax values ('fexpr','rawtohex',229);
insert into tabla_sintax values ('fexpr','rowidtochar',229);
insert into tabla_sintax values ('fexpr','to_char',229);
insert into tabla_sintax values ('fexpr','to_date',229);
insert into tabla_sintax values ('fexpr','to_number',229);
insert into tabla_sintax values ('fexpr','add_months',229);
insert into tabla_sintax values ('fexpr','last_day',229);
insert into tabla_sintax values ('fexpr','months_between',229);
insert into tabla_sintax values ('fexpr','new_time',229);
insert into tabla_sintax values ('fexpr','next_day',229);
insert into tabla_sintax values ('fexpr','round',229);
insert into tabla_sintax values ('fexpr','trunc',229);
insert into tabla_sintax values ('fexpr','dump',229);
insert into tabla_sintax values ('fexpr','greatest',229);
insert into tabla_sintax values ('fexpr','least',229);
insert into tabla_sintax values ('fexpr','nvl',229);
insert into tabla_sintax values ('fexpr','userenv',229);
insert into tabla_sintax values ('fexpr','vsize',229);
insert into tabla_sintax values ('fexpr','decode',229);

--230: resto_fexpr  :   id
insert into producciones values (230,1,'id','t');
insert into tabla_sintax values ('resto_fexpr','id',230);
--231:      |   '[' numero ',' numero ',' numero ',' numero ']'
insert into producciones values (231,1,'[','t');
insert into producciones values (231,2,'numero','t');
insert into producciones values (231,3,',','t');
insert into producciones values (231,4,'numero','t');
insert into producciones values (231,5,',','t');
insert into producciones values (231,6,'numero','t');
insert into producciones values (231,7,',','t');
insert into producciones values (231,8,'numero','t');
insert into producciones values (231,9,']','t');
insert into tabla_sintax values ('resto_fexpr','[',231);

-- comparadores difusos de posibilidad:
--232/238: fcomparador  :   feq | fgt | flt | fgeq | fleq | mgt | mlt
insert into producciones values (232,1,'feq','t');
insert into producciones values (233,1,'fgt','t');
insert into producciones values (234,1,'flt','t');
insert into producciones values (235,1,'fgeq','t');
insert into producciones values (236,1,'fleq','t');
insert into producciones values (237,1,'mgt','t');
insert into producciones values (238,1,'mlt','t');
insert into tabla_sintax values ('fcomparador','feq',232);
insert into tabla_sintax values ('fcomparador','fgt',233);
insert into tabla_sintax values ('fcomparador','flt',234);
insert into tabla_sintax values ('fcomparador','fgeq',235);
insert into tabla_sintax values ('fcomparador','fleq',236);
insert into tabla_sintax values ('fcomparador','mgt',237);
insert into tabla_sintax values ('fcomparador','mlt',238);

-- comparadores difusos de necesidad:
--501/507: fcomparador  :   nfeq | nfgt | nflt | nfgeq | nfleq | nmgt | nmlt
insert into producciones values (501,1,'nfeq','t');
insert into producciones values (502,1,'nfgt','t');
insert into producciones values (503,1,'nflt','t');
insert into producciones values (504,1,'nfgeq','t');
insert into producciones values (505,1,'nfleq','t');
insert into producciones values (506,1,'nmgt','t');
insert into producciones values (507,1,'nmlt','t');
insert into tabla_sintax values ('fcomparador','nfeq',501);
insert into tabla_sintax values ('fcomparador','nfgt',502);
insert into tabla_sintax values ('fcomparador','nflt',503);
insert into tabla_sintax values ('fcomparador','nfgeq',504);
insert into tabla_sintax values ('fcomparador','nfleq',505);
insert into tabla_sintax values ('fcomparador','nmgt',506);
insert into tabla_sintax values ('fcomparador','nmlt',507);

--240/242: fuzzy_ctes   :   null | undefined | unknown
insert into producciones values (240,1,'null','t');
insert into producciones values (241,1,'undefined','t');
insert into producciones values (242,1,'unknown','t');
insert into tabla_sintax values ('fuzzy_ctes','null',240);
insert into tabla_sintax values ('fuzzy_ctes','undefined',241);
insert into tabla_sintax values ('fuzzy_ctes','unknown',242);

--250: resto_nofcond:   comparador expr
insert into producciones values (250,1,'comparador','n');
insert into producciones values (250,2,'expr','n');
insert into tabla_sintax values ('resto_nofcond','eq',250);
insert into tabla_sintax values ('resto_nofcond','neq',250);
insert into tabla_sintax values ('resto_nofcond','leq',250);
insert into tabla_sintax values ('resto_nofcond','geq',250);
insert into tabla_sintax values ('resto_nofcond','lt',250);
insert into tabla_sintax values ('resto_nofcond','gt',250);
--251:      |   cond_entre
insert into producciones values (251,1,'cond_entre','n');
insert into tabla_sintax values ('resto_nofcond','between',251);
--252:      |   cond_in
insert into producciones values (252,1,'cond_in','n');
insert into tabla_sintax values ('resto_nofcond','in',252);
--253:      |   not cond_entrein
insert into producciones values (253,1,'not','t');
insert into producciones values (253,2,'cond_entrein','n');
insert into tabla_sintax values ('resto_nofcond','not',253);
--254:      |   like texto
insert into producciones values (254,1,'like','t');
insert into producciones values (254,2,'texto','t');
insert into tabla_sintax values ('resto_nofcond','like',254);

--255: cond_entre   :   between expr and expr
insert into producciones values (255,1,'between','t');
insert into producciones values (255,2,'expr','n');
insert into producciones values (255,3,'and','t');
insert into producciones values (255,4,'expr','n');
insert into tabla_sintax values ('cond_entre','between',255);

--256: cond_in  :   in arg_list
insert into producciones values (256,1,'in','t');
insert into producciones values (256,2,'arg_list','n');
insert into tabla_sintax values ('cond_in','in',256);

--257: cond_entrein:    cond_entre
insert into producciones values (257,1,'cond_entre','n');
insert into tabla_sintax values ('cond_entrein','between',257);
--258:      |   cond_in
insert into producciones values (258,1,'cond_in','n');
insert into tabla_sintax values ('cond_entrein','in',258);
--259:      |   like texto
insert into producciones values (259,1,'like','t');
insert into producciones values (259,2,'texto','t');
insert into tabla_sintax values ('cond_entrein','like',259);

--260/265: comparador   :   eq | neq | leq | geq | lt | gt
insert into producciones values (260,1,'eq','t');
insert into producciones values (261,1,'neq','t');
insert into producciones values (262,1,'leq','t');
insert into producciones values (263,1,'geq','t');
insert into producciones values (264,1,'lt','t');
insert into producciones values (265,1,'gt','t');
insert into tabla_sintax values ('comparador','eq',260);
insert into tabla_sintax values ('comparador','neq',261);
insert into tabla_sintax values ('comparador','leq',262);
insert into tabla_sintax values ('comparador','geq',263);
insert into tabla_sintax values ('comparador','lt',264);
insert into tabla_sintax values ('comparador','gt',265);

-- *****> definicion de otras de clausulas del select <*****
--270: clausula_variante:group by expr mas_expres clausula_having clausula_variante
insert into producciones values (270,1,'group','t');
insert into producciones values (270,2,'by','t');
insert into producciones values (270,3,'expr','n');
insert into producciones values (270,4,'mas_expres','n');
insert into producciones values (270,5,'clausula_having','n');
insert into producciones values (270,6,'clausula_variante','n');
insert into tabla_sintax values ('clausula_variante','group',270);
--271:  |       clausula_start connect by condition clausula_variante
insert into producciones values (271,1,'clausula_start','n');
insert into producciones values (271,2,'connect','t');
insert into producciones values (271,3,'by','t');
insert into producciones values (271,4,'condition','n');
insert into producciones values (271,5,'clausula_variante','n');
insert into tabla_sintax values ('clausula_variante','start',271);
insert into tabla_sintax values ('clausula_variante','connect',271);
--272:  |
insert into producciones values (272,1,'vacio','n');
insert into tabla_sintax values ('clausula_variante','the end',272);
insert into tabla_sintax values ('clausula_variante',';',272);
insert into tabla_sintax values ('clausula_variante','union',272);
insert into tabla_sintax values ('clausula_variante','intersect',272);
insert into tabla_sintax values ('clausula_variante','minus',272);
insert into tabla_sintax values ('clausula_variante','order',272);
insert into tabla_sintax values ('clausula_variante',')',272);

--273: clausula_start:  start with condition
insert into producciones values (273,1,'start','t');
insert into producciones values (273,2,'by','t');
insert into producciones values (273,3,'condition','n');
insert into tabla_sintax values ('clausula_start','start',273);
--274:  |
insert into producciones values (274,1,'vacio','n');
insert into tabla_sintax values ('clausula_start','connect',274);

--275: clausula_having: having condition
insert into producciones values (275,1,'having','t');
insert into producciones values (275,2,'condition','n');
insert into tabla_sintax values ('clausula_having','having',275);
--276:  |
insert into producciones values (276,1,'vacio','n');
insert into tabla_sintax values ('clausula_having','the end',276);
insert into tabla_sintax values ('clausula_having',';',276);
insert into tabla_sintax values ('clausula_having','group',276);
insert into tabla_sintax values ('clausula_having','connect',276);
insert into tabla_sintax values ('clausula_having','start',276);
insert into tabla_sintax values ('clausula_having','union',276);
insert into tabla_sintax values ('clausula_having','intersect',276);
insert into tabla_sintax values ('clausula_having','minus',276);
insert into tabla_sintax values ('clausula_having','order',276);
insert into tabla_sintax values ('clausula_having',')',276);

--280: clausula_orden:  order by expr ordenacion resto_l_orden clausula_orden
insert into producciones values (280,1,'order','t');
insert into producciones values (280,2,'by','t');
insert into producciones values (280,3,'expr','n');
insert into producciones values (280,4,'ordenacion','n');
insert into producciones values (280,5,'resto_l_orden','n');
insert into producciones values (280,6,'clausula_orden','n');
insert into tabla_sintax values ('clausula_orden','order',280);
--281:  |
insert into producciones values (281,1,'vacio','n');
insert into tabla_sintax values ('clausula_orden','the end',281);
insert into tabla_sintax values ('clausula_orden',';',281);
insert into tabla_sintax values ('clausula_orden',')',281);

--282: resto_l_orden:   ',' expr ordenacion resto_l_orden
insert into producciones values (282,1,',','t');
insert into producciones values (282,2,'expr','n');
insert into producciones values (282,3,'ordenacion','n');
insert into producciones values (282,4,'resto_l_orden','n');
insert into tabla_sintax values ('resto_l_orden',',',282);
--283:  |
insert into producciones values (283,1,'vacio','n');
insert into tabla_sintax values ('resto_l_orden','the end',283);
insert into tabla_sintax values ('resto_l_orden',';',283);
insert into tabla_sintax values ('resto_l_orden','order',283);
insert into tabla_sintax values ('resto_l_orden',')',283);

--284/285: ordenacion   :   asc | desc
insert into producciones values (284,1,'asc','t');
insert into producciones values (285,1,'desc','t');
insert into tabla_sintax values ('ordenacion','asc',284);
insert into tabla_sintax values ('ordenacion','desc',285);
--286:  |
insert into producciones values (286,1,'vacio','n');
insert into tabla_sintax values ('ordenacion','the end',286);
insert into tabla_sintax values ('ordenacion',';',286);
insert into tabla_sintax values ('ordenacion',',',286);
insert into tabla_sintax values ('ordenacion','order',286);
insert into tabla_sintax values ('ordenacion',')',286);



-- vista que contiene las tablas o vistas accesibles por el usuario: accessible_tables
-- (aade el campo obj# con el object_id de la tabla en cuestion)
-- usada por el a. semantico.
-- en versiones anteriores a oracle 8 el atributo o.type# puede llamarse o.type

\echo >>>> creando vista accessible_tables y sus comentarios...

-----------------------------------falta por realizar-------------------------------------
/* create view accessible_tables
    (owner, obj, table_name, table_type) as
select u.name, o.obj, o.name,
       decode(o.type, 2, 'table', 4, 'view')
from sys.user$ u, sys.obj$ o
where o.owner = u.user
  and o.linkname is null
  and o.type in (2, 4)
  and (o.owner = uid
       or
       obj in (select obj
                from sys.objauth$
                where grantee in (select kzsrorol from x$kzsro)
                      or grantee=uid
               )
      );

-- drop public synonym accessible_tables;
-- create public synonym accessible_tables for accessible_tables;
grant select on accessible_tables to public with grant option;

comment on table  accessible_tables is 'tables and views accessible to the user';
comment on column accessible_tables.owner is 'owner of the object';
comment on column accessible_tables.table_name is 'name of the object';
comment on column accessible_tables.table_type is 'type of the object';
comment on column accessible_tables.obj# is 'id number of the object';*/
---------------------------------------------------------------------------------------


