
----------------------------------------------------------------------
-- inserta un msg de error en la tabla de errores: fsql_errors
-- la insercion ser realiza cronologicamente ordenados por el campo indice (empezando por 1)
-- se inserta el numero de la sesion actual en el campo sessionid.
----------------------------------------------------------------------
drop function fsql_aux_inserta_error (varchar);
create function fsql_aux_inserta_error (varchar) 
returns integer as '
declare
  msgerror alias for $1;
  ultimo integer;
  idsession integer;
begin
  insert into trama values(nextval(''sec''),''fsql_aux_inserta_error'');
  select into ultimo max(indice) from fsql_all_errors where sessionid=(select pg_backend_pid());
  if ultimo is null then 
     ultimo:=0; 
  end if;
  select into idsession pg_backend_pid();
  insert into fsql_all_errors values (idsession,ultimo+1, msgerror);
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------------------
-- devuelve los ultimos 21 parametros de la llamada a la funcion fshow3 con el ')' incluido,
-- para la columna column (de tipo 3), con long. maxima de len
----------------------------------------------------------------------------------------------------------
drop function fsql_aux_resto_llamada_tipo3(varchar, numeric);
create function fsql_aux_resto_llamada_tipo3(varchar, numeric) 
returns varchar as '
declare
  column alias for $1;
  len    alias for $2;
  result varchar(350);
  i      integer;

begin
  insert into trama values(nextval(''sec''),''fsql_aux_resto_llamada_tipo3'');
  result := column || ''t,'';
  for i in 1..10 loop
    if i <= len then
      if    i=1 then result:=result       ||column||''p1,''||column||''1'';
      elsif i=2 then result:=result||'',''||column||''p2,''||column||''2'';
      elsif i=3 then result:=result||'',''||column||''p3,''||column||''3'';
      elsif i=4 then result:=result||'',''||column||''p4,''||column||''4'';
      elsif i=5 then result:=result||'',''||column||''p5,''||column||''5'';
      elsif i=6 then result:=result||'',''||column||''p6,''||column||''6'';
      elsif i=7 then result:=result||'',''||column||''p7,''||column||''7'';
      elsif i=8 then result:=result||'',''||column||''p8,''||column||''8'';
      elsif i=9 then result:=result||'',''||column||''p9,''||column||''9'';
      elsif i=10 then result:=result||'',''||column||''p10,''||column||''10'';
      end if;
    else
      result:=result||'',null,null'';
    end if;
  end loop;
  return result || '')'';
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------------------
-- modifica el atributo de fsql_query de las columnas difusas tipo 2 o 3 fuzzy_column_en_sl
-- de la select_list. en su lugar pone una llamada a la funcion correspondiente
-- para mostrar ese atributo difuso de forma coherente (funciones fshow2 y fshow3)
----------------------------------------------------------------------------------------------------------
drop function fsql_aux_fuzzy_column_en_sl(varchar, numeric,numeric,numeric,numeric,varchar);
create function fsql_aux_fuzzy_column_en_sl (
					     fsql_query.atributo%type, 
					     fsql_query.indice%type, 
					     fuzzy_col_list.f_type%type, 
					     fuzzy_col_list.obj%type, 
					     fuzzy_col_list.col%type, 
		    			     varchar)
returns int4 as '
declare
  atrib     alias for $1;
  ind       alias for $2;
  f_tipo    alias for $3;
  obj_var   fuzzy_col_list.obj%type;
  col_var   fuzzy_col_list.col%type;
  alias_var alias for $6;
  fshow3    varchar(750);
  l         fuzzy_col_list.len%type;
begin
  insert into trama values(nextval(''sec''),''fsql_aux_fuzzy_column_en_sl'');
  obj_var:=$4;
  col_var:=$5;
  if f_tipo=2 then
     update fsql_all_queries set nombre=''ok'',
       atributo=''fsql_functions_fshow2(''||obj_var||'',''||col_var||'',''||
       atrib||''t,''||atrib||''1,''||atrib||''2,''||atrib||''3,''||atrib||''4) as ''||alias_var
       where indice=ind;
  else
    select into l len from fuzzy_col_list
       where obj=obj_var and col=col_var;
    select into obj_var,col_var obj2,col2 from fuzzy_compatible_col
       where obj1=obj_var and col1=col_var;
    if obj_var is null and col_var is null then
       obj_var = null;
       col_var = null;
    end if;
    if l=1 then
       update fsql_all_queries set nombre=''ok2'',
          atributo=''fsql_functions_fshow3_len1(''||obj_var||'',''||col_var||'',''||
          atrib||''t,''||atrib||''p1,''||atrib||''1) as ''||alias_var
       where indice=ind;
    else
       fshow3:=fsql_aux_resto_llamada_tipo3(atrib,l);
       update fsql_all_queries set nombre=''ok'',
          atributo=''fsql_functions_fshow3(''||obj_var||'',''||col_var||'',''||l||'',''||fshow3||'' as ''||alias_var
       where indice=ind;
    end if;
  end if;
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve la cadena que indica el umbral de la consulta que se debe anadir tras 
-- la llamada a la funcion de comparacion.
-- usa el indice en fsql_query donde deberia empezar la clausula del umbral.
-- modifica el atributo de fsql_query para que el umbral sea valido.
----------------------------------------------------------------------------------------------
drop function fsql_aux_calcula_umbral(fsql_all_queries.indice%type);
create function fsql_aux_calcula_umbral(fsql_all_queries.indice%type) 
returns varchar as '
declare
  ind   alias for $1;
  token fsql_all_queries.nombre%type;
begin
  insert into trama values(nextval(''sec''),''fsql_aux_calcula_umbral'');
  select into token nombre from fsql_all_queries
       where indice=ind;
  if token is null then 
     token:=''sin umbral'';
  end if;
  if token=''sin umbral'' then
     return ''=1'';
  elsif token=''thold'' then 
     update fsql_all_queries set atributo=''>=''
       where indice=ind;
     return '''';
  elsif token=''numbral'' then 
     update fsql_all_queries set atributo=''>=''||atributo 
       where indice=ind;
     return '''';
  else 
     return '''';
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- calcula el margen y el much para un atributo concreto (obj,col).
-- si no estan definidos estos valores en la tabla fuzzy_approx_much:
-- inserta un error y los devuelve como null.calcula_margen_much
-- estos valores se usan con los comparadores mgt, mlt, nmgt y nmlt.
----------------------------------------------------------------------------------------------
drop function fsql_aux_calcula_margen_much( 
                                fuzzy_approx_much.obj%type,
                                fuzzy_approx_much.col%type,
                                fsql_all_queries.posicion%type,
                                varchar,
                                fsql_all_queries.atributo%type,
                                fuzzy_approx_much.margen%type,
                                fuzzy_approx_much.much%type);
create function fsql_aux_calcula_margen_much(
                                fuzzy_approx_much.obj%type,
                                fuzzy_approx_much.col%type,
                                fsql_all_queries.posicion%type,
                                varchar,
                                fsql_all_queries.atributo%type,
                                fuzzy_approx_much.margen%type,
                                fuzzy_approx_much.much%type) 
returns numeric as '
declare
  obj_var alias for $1;  
  col_var alias for $2;
  pos     alias for $3;
  st      alias for $4;
  namec   alias for $5;
  margen_var  fuzzy_approx_much.margen%type;
  much_var    fuzzy_approx_much.much%type;
  llamadafuncion integer;
begin
  insert into trama values(nextval(''sec''),''fsql_aux_calcula_margen_much'');
  margen_var:=$6;
  much_var  :=$7;
  select into margen_var,much_var margen,much from fuzzy_approx_much
    where obj=obj_var and col=col_var;
  if margen_var is null and much_var is null then
     llamadafuncion:=fsql_aux_inserta_error(''error en first en posicion ''||pos
    ||'': atributo ''||st||''.''||namec||'', (obj,col)=(''||obj_var||'',''||col_var
    ||'') no tiene definido el margen y el much en la tabla fuzzy_approx_much. ''
    ||''estos son necesarios para usar los comparadores mgt, mlt, nmgt y nmlt.'');
    margen_var:=null;
    much_var:=null;
  end if;
return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- los comparadores 'nfeq','nfgt','nfgeq','nflt' y 'nfleq' son iguales a
-- sus homonimos sin la 'n' (de posibilidad) cuando comparan con un crisp
-- (o atributos difusos tipo 1). en ese caso, se llama a la funcion de
-- posibilidad, evitando tener programada la funcion de necesidad.
-- esta funcion quita la 'n' de esos comparadores difusos, devolviendo el
-- comparador sin la 'n'.
----------------------------------------------------------------------------------------------
drop function fsql_aux_sin_n (varchar);
create function fsql_aux_sin_n (varchar)
returns varchar as '
declare
  fcomp alias for $1;  
  fcompsinn varchar(4);
begin
  insert into trama values(nextval(''sec''),''fsql_aux_sin_n'');
  if fcomp in (''nfeq'',''nfgt'',''nfgeq'',''nflt'',''nfleq'') then
     --select into fcompsinn substr(fcomp,2) from dual; -- duda tabla dual???
       fcompsinn := substr(fcomp,2);
       return fcompsinn;
  else 
     return fcomp;
  end if;   
end;
'language 'plpgsql';

