--********************** funciones de presentacin **********************--

----------------------------------------------------------------------
-- funcion que devuelve la representacion grafica de una columna difusa
-- para atributos de tipo 2
----------------------------------------------------------------------
drop function fsql_functions_fshow2 ( fuzzy_label_def.obj%type, 
		                        fuzzy_label_def.obj%type,
		                        fuzzy_col_list.f_type%type,
		                        numeric, numeric, numeric, numeric);
create function fsql_functions_fshow2 ( integer, 
		                        integer,
		                        numeric,
		                        numeric, numeric, numeric, numeric) 
returns varchar as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  f_type  alias for $3;
  f1      alias for $4;
  f2      alias for $5;
  f3      alias for $6;
  f4      alias for $7;
  result  fuzzy_object_list.fuzzy_name%type;

begin
  insert into trama values(nextval(''sec''),''fsql_functions_fshow2'');
  if    f_type=0 then return ''unknown'';  -- ||chr(0);
  elsif f_type=1 then return ''undefined'';
  elsif f_type=2 then return ''null'';
  elsif f_type=3 then return trim(to_char(f1,''9999999999''));
  elsif f_type=4 then
    select into result fuzzy_name from fuzzy_object_list
    where obj=obj_var and col=col_var and fuzzy_id=f1;
    return result;
  elsif f_type=5 then
    return ''[''||trim(to_char(f1,''9999999999''))||'',''||trim(to_char(f4,''9999999999''))||'']'';
  elsif f_type=6 then
    return trim(to_char(f1,''9999999999''))||''''||trim(to_char(f4,''9999999999''));
  elsif f_type=7 then
    return ''[''||to_char(f1,''9999999999'')   ||'',''||trim(to_char(f2+f1,''9999999999''))||
           '',''||trim(to_char(f3+f4,''9999999999''))||'',''||trim(to_char(f4,''9999999999''))||'']'';
  else
    return ''error en tipo fuzzy'';
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- devuelve la etiqueta asociada al objeto f_id de la columna (obj,col)
-- en la tabla fol. si no existe devuelve '<error>'.
----------------------------------------------------------------------
drop function fsql_functions_nombre_label (
                       fuzzy_label_def.obj%type,
                       fuzzy_label_def.obj%type,
                       fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_nombre_label (
                       fuzzy_label_def.obj%type,
                       fuzzy_label_def.obj%type,
                       fuzzy_object_list.fuzzy_id%type)
returns varchar as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  f_id    alias for $3;
  result  fuzzy_object_list.fuzzy_name%type:='''';
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nombre_label'');
  select into result fuzzy_name from fuzzy_object_list
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if result <> '''' then
     return result;
  else 
     return ''<error>'';
  end if;
end;
' language 'plpgsql';

----------------------------------------------------------------------
-- funcion que devuelve la representacion grafica de una columna difusa
-- para atributos de tipo 3.
-- suponemos que como maximo una dist. de posibilidad no tiene mas de 10 etiquetas.
-- los fpi seran de tipo numeric(3,2)
----------------------------------------------------------------------
drop function fsql_functions_fshow3 (
                     fuzzy_label_def.obj%type, 
                     fuzzy_label_def.obj%type,
 		     fuzzy_col_list.len%type,
		     fuzzy_col_list.f_type%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
	   	     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
	             numeric, fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_fshow3 (
                     fuzzy_label_def.obj%type, 
                     fuzzy_label_def.obj%type,
 		     fuzzy_col_list.len%type,
		     fuzzy_col_list.f_type%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
	   	     numeric, fuzzy_object_list.fuzzy_id%type,
		     numeric, fuzzy_object_list.fuzzy_id%type,
	             numeric, fuzzy_object_list.fuzzy_id%type)
returns varchar as '

declare
  obj_var alias for $1;
  col_var alias for $2;
  len     alias for $3;
  f_type  alias for $4;
  fp1 	  alias for $5;
  f1 	  alias for $6;
  fp2 	  alias for $7;
  f2 	  alias for $8;
  fp3 	  alias for $9;
  f3 	  alias for $10;
  fp4 	  alias for $11;
  f4 	  alias for $12;
  fp5 	  alias for $13;
  f5 	  alias for $14;
  fp6 	  alias for $15;
  f6 	  alias for $16;
  fp7 	  alias for $17;
  f7 	  alias for $18;
  fp8 	  alias for $19;
  f8 	  alias for $20;
  fp9 	  alias for $21;
  f9 	  alias for $22;
  fp10 	  alias for $23;
  f10	  alias for $24;
  result varchar(350):='''';
  p numeric;
  i integer;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fshow3'');
  p :=fp1;
  i :=1;
  if    f_type=0 then return ''unknown'';
  elsif f_type=1 then return ''undefined'';
  elsif f_type=2 then return ''null'';
  elsif f_type=3 then
    return fp1||''/''||fsql_functions_nombre_label(obj_var,col_var,f1);
  elsif f_type=4 then
    while p is not null and i<=len loop
      if i=1 then
         result:=fp1||''/''||fsql_functions_nombre_label(obj_var,col_var,f1);
	 p:=fp2;
      elsif i=2 then
         result:=result||'',''||fp2||''/''||fsql_functions_nombre_label(obj_var,col_var,f2);
	 p:=fp3;
      elsif i=3 then
         result:=result||'',''||fp3||''/''||fsql_functions_nombre_label(obj_var,col_var,f3);
	 p:=fp4;
      elsif i=4 then
         result:=result||'',''||fp4||''/''||fsql_functions_nombre_label(obj_var,col_var,f4);
	 p:=fp5;
      elsif i=5 then
         result:=result||'',''||fp5||''/''||fsql_functions_nombre_label(obj_var,col_var,f5);
	 p:=fp6;
      elsif i=6 then
         result:=result||'',''||fp6||''/''||fsql_functions_nombre_label(obj_var,col_var,f6);
	 p:=fp7;
      elsif i=7 then
         result:=result||'',''||fp7||''/''||fsql_functions_nombre_label(obj_var,col_var,f7);
	 p:=fp8;
      elsif i=8 then
         result:=result||'',''||fp8||''/''||fsql_functions_nombre_label(obj_var,col_var,f8);
	 p:=fp9;
      elsif i=9 then
         result:=result||'',''||fp9||''/''||fsql_functions_nombre_label(obj_var,col_var,f9);
	 p:=fp10;
      elsif i=10 then
         result:=result||'',''||fp10||''/''||fsql_functions_nombre_label(obj_var,col_var,f10);
      end if;
      i:=i+1;
    end loop;
    return result;
  else
    return ''error en tipo fuzzy'';
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- funcion que devuelve la representacion grafica de una columna difusa
-- para atributos de tipo 3 con longitud 1.
-- esta funcion se ha creado para aumentar la eficiencia en la representacion
-- de estos atributos cuando la longitud es 1, algo que suponemos muy usual.
----------------------------------------------------------------------
drop function fsql_functions_fshow3_len1 (
                             		    fuzzy_label_def.obj%type, 
		                            fuzzy_label_def.obj%type,
			    		    fuzzy_col_list.f_type%type,
			     		    numeric, 
			   		    fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_fshow3_len1 (
                             		    fuzzy_label_def.obj%type, 
		                            fuzzy_label_def.obj%type,
			    		    fuzzy_col_list.f_type%type,
			     		    numeric, 
			   		    fuzzy_object_list.fuzzy_id%type) 
returns varchar as '
declare
    obj_var alias for $1;    
    col_var alias for $2;
    f_type  alias for $3;
    fp1     alias for $4;
    f1      alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fshow3_len1'');
  if    f_type=0 then return ''unknown'';
  elsif f_type=1 then return ''undefined'';
  elsif f_type=2 then return ''null'';
  elsif f_type in (3,4) then 
    if fp1=1 then return  fsql_functions_nombre_label(obj_var,col_var,f1); 
    else return fp1||''/''||fsql_functions_nombre_label(obj_var,col_var,f1); 
    end if;
  else
    return ''error en tipo fuzzy'';
  end if;
end;
'language 'plpgsql';


--********************** comparador difuso feq **********************--

--********************************************************************
-- compatibilidad de atributos difusos tipo 2 con las constantes difusas:
-- unknown, undefined y null.
--********************************************************************

----------------------------------------------------------------------
-- comparacion de compatibilidad de un atributo difuso tipo 2 con la cte. difusa unknown
----------------------------------------------------------------------
drop function fsql_functions_feq_unknown (fuzzy_col_list.f_type%type);
create function fsql_functions_feq_unknown (fuzzy_col_list.f_type%type) 
returns numeric as '
declare
  f_type alias for $1;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_unknown'');
  if f_type=1 then 
     return 0; 
  else          
     return 1;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de compatibilidad de un atributo difuso tipo 2 o 3 con la cte. difusa undefined
----------------------------------------------------------------------
drop function fsql_functions_feq_undefined (fuzzy_col_list.f_type%type); 
create function fsql_functions_feq_undefined (fuzzy_col_list.f_type%type) 
returns numeric as '
declare 
  f_type alias for $1;
begin
 insert into trama values(nextval(''sec''),''fsql_functions_feq_undefined'');
  if f_type in (1,2) then 
     return 1; 
  else         
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de compatibilidad de un atributo difuso tipo 2 con la cte. difusa null
----------------------------------------------------------------------
drop function fsql_functions_feq_null (fuzzy_col_list.f_type%type);
create function fsql_functions_feq_null (fuzzy_col_list.f_type%type)
returns numeric as '
declare
  f_type alias for $1;
begin
 insert into trama values(nextval(''sec''),''fsql_functions_feq_null'');
  return 1;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp con un label (tipos 1 y 2)
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp_label  (
                                   numeric,
                                   fuzzy_label_def.obj%type, 
                                   fuzzy_label_def.obj%type,
                                   fuzzy_label_def.fuzzy_id%type);
create function fsql_functions_feq_crisp_label (
                                   numeric,
                                   fuzzy_label_def.obj%type, 
                                   fuzzy_label_def.obj%type,
                                   fuzzy_label_def.fuzzy_id%type)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2; 
  col_var   alias for $3; 
  f_id      alias for $4; 
  alfa_var  fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
 insert into trama values(nextval(''sec''),''fsql_functions_feq_crisp_label'');
  select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
    from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if crisp>alfa_var  and crisp<beta_var then 
     return round((crisp-alfa_var)/(beta_var-alfa_var),2);
  elsif 
     crisp>=beta_var and crisp<=gamma_var then
     return 1;
  elsif
     crisp>gamma_var and crisp<delta_var  then 
     return round((delta_var-crisp)/(delta_var-gamma_var),2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp (tipo 1) con un intervalo [x,y]
-- comparacion del tipo: fcol_t1 feq [3,6]
-- en ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [x-margen, x, y, y+margen]
-- si no se desea difuminar usar comparacion crisp: fcol_t1 between 3 and 6
-- feq_crisp_finter
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp_finter (numeric, numeric, numeric, numeric);
create function fsql_functions_feq_crisp_finter (
                                                 numeric,  numeric,
				                 numeric,  numeric)
returns numeric as '
declare
  crisp  alias for $1;
  x      alias for $2;
  y      alias for $3;
  margen alias for $4;
begin
 insert into trama values(nextval(''sec''),''sql_functions_feq_crisp_finter'');
  if crisp>(x-margen) and crisp<x  then 
      return round((crisp-x+margen)/margen,2);
  elsif crisp>=x and crisp<=y then 
      return 1;
  elsif crisp> y  and  crisp<y+margen then 
      return round((y+margen-crisp)/margen,2);
  else
      return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- comparacion de un valor crisp con un intervalo [x,y] (tipo 2)
-- no se exporta: se usa en feq_crisp y feq_inter
-- feq_crisp_inter
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp_inter (numeric, numeric, numeric);
create function fsql_functions_feq_crisp_inter (
  				numeric,
				numeric, numeric)
returns numeric as '
declare
  crisp alias for $1; 
  x     alias for $2; 
  y     alias for $3; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_crisp_inter '');
  if crisp between x and y then 
     return 1;
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp con un aprox (tipos 1 y 2)
-- feq_crisp_aprox
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp_aprox (numeric, numeric, numeric, numeric, numeric);
create function fsql_functions_feq_crisp_aprox (
		   				numeric, numeric, 
   		   				numeric, numeric, numeric)
returns numeric as'
declare
  crisp alias for $1;
  f1 alias for $2; 
  f2 alias for $3; 
  f3 alias for $4; 
  f4 alias for $5; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_crisp_aprox '');
  if crisp>f2 and crisp<f3 then
    return round((f4-abs(f1-crisp))/f4,2);
  else 
    return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp con un crisp que difuminamos a uno
-- aprox (f1 + - f4), por lo que desconocemos f2 y f3 (f4 es el margen).
-- ejs: fcol1 feq f1
--      fcol1 feq fcoltipo1
--      fcol1 feq expr_crisp
-- en esos casos podria provocarse un error indicando que no se pueden usar
-- comparadores difusos para comparar valores crisp. en vez de dar error,
-- difumina el valor crisp de la derecha a uno aprox con el margen del
-- atributo de la izquierda.
----------------------------------------------------------------------
drop function fsql_functions_feq_t1_t1 (numeric, numeric, numeric); 
create function fsql_functions_feq_t1_t1 (numeric, numeric, numeric) 
returns numeric as '
declare
  crisp alias for $1; 
  f1    alias for $2; 
  f4    alias for $3; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_t1_t1 '');
  if crisp>(f1-f4) and crisp<(f1+f4) then
      return round((f4-abs(f1-crisp))/f4,2);
  else 
      return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp con trapecio (tipos 1 y 2)
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp_trape (numeric, numeric, numeric, numeric, numeric);
create function fsql_functions_feq_crisp_trape (
		  	numeric, numeric, numeric, numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
  beta  fuzzy_label_def.alfa%type;
  gamma fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_crisp_trape '');
  beta :=f2+f1;
  gamma:=f3+f4;
  if    crisp>f1    and crisp<beta   then
	return round((crisp-f1)/f2,2);
  elsif crisp>=beta and crisp<=gamma then
	return 1;
  elsif crisp>gamma and crisp<f4     then
	return round((f4-crisp)/(f4-gamma),2);
  else
	return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica el grado de compatibilidad o 'igualdad' (feq) de una
-- columna difusa tipo 1 (crisp) con una columna difusa tipo 2.
-- formato ejemplo: fcol_t1 feq fcol_t2
-- feq_t1_t2
----------------------------------------------------------------------
drop function fsql_functions_feq_t1_t2 (numeric, fuzzy_label_def.obj%type, fuzzy_label_def.obj%type, fuzzy_col_list.f_type%type, numeric, numeric, numeric, numeric);
create function fsql_functions_feq_t1_t2 (
					  numeric,
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  crisp   alias for $1;
  obj_var alias for $2;
  col_var alias for $3;
  f_type  alias for $4;
  f1 	  alias for $5;
  f2 	  alias for $6;
  f3 	  alias for $7;
  f4 	  alias for $8;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_t1_t2 '');
  if    f_type=0 then
	return fsql_functions_feq_unknown(3);
  elsif f_type=1 then
	return fsql_functions_feq_undefined(3);
  elsif f_type=2 then
	return fsql_functions_feq_null(3);
  elsif f_type=3 then
    if crisp=f1  then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=4 then
	return fsql_functions_feq_crisp_label(crisp,obj_var,col_var,f1);
  elsif f_type=5 then
    if crisp between f1 and f4 then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=6 then
	return fsql_functions_feq_crisp_aprox(crisp,f1,f2,f3,f4);
  else
	return fsql_functions_feq_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor crisp (f_type=3) con otro difuso
----------------------------------------------------------------------
drop function fsql_functions_feq_crisp (numeric, fuzzy_label_def.obj%type, fuzzy_label_def.obj%type, fuzzy_col_list.f_type%type, numeric, numeric, numeric, numeric);
create function fsql_functions_feq_crisp (
			numeric,
			fuzzy_label_def.obj%type,
			fuzzy_label_def.obj%type,
			fuzzy_col_list.f_type%type,
			numeric, numeric, numeric, numeric)
returns numeric as '
declare
  crisp   alias for $1;
  obj_var alias for $2;
  col_var alias for $3;
  f_type  alias for $4; 
  f1      alias for $5;
  f2      alias for $6;
  f3      alias for $7;
  f4      alias for $8;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_crisp '');
  if    f_type=0 then
	return fsql_functions_feq_unknown(3);
  elsif f_type=1 then
	return fsql_functions_feq_undefined(3);
  elsif f_type=2 then
	return fsql_functions_feq_null(3);
  elsif f_type=3 then
    if crisp=f1  then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=4 then
	return fsql_functions_feq_crisp_label(crisp,obj_var,col_var,f1);
  elsif f_type=5 then
	return fsql_functions_feq_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then
	return fsql_functions_feq_crisp_aprox(crisp,f1,f2,f3,f4);
  else
	return fsql_functions_feq_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de un valor label con cualquier valor posible en atributos difusos tipo 2
-- excepto crisp, ya definido arriba.
--********************************************************************
----------------------------------------------------------------------
-- comparacion de un valor label con un intervalo [x,y]
----------------------------------------------------------------------
drop function fsql_functions_feq_label_inter (fuzzy_label_def.obj%type, fuzzy_label_def.obj%type, fuzzy_label_def.fuzzy_id%type, numeric, numeric);
create function fsql_functions_feq_label_inter (
					fuzzy_label_def.obj%type,
					fuzzy_label_def.obj%type,
					fuzzy_label_def.fuzzy_id%type,
					numeric, numeric)
returns numeric as '
declare
  obj_var  alias for $1; 
  col_var  alias for $2;
  f_id     alias for $3;
  x        alias for $4;
  y        alias for $5;
  a1       fuzzy_label_def.alfa%type;
  b1       fuzzy_label_def.alfa%type;
  g1       fuzzy_label_def.alfa%type;
  d1       fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_label_inter '');
  select into a1,b1,g1,d1 alfa,beta,gamma,delta  from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if d1<=x or a1>=y then
     return 0;
  elsif g1>=x and b1<=y then
     return 1;
  elsif d1>x and g1<x then
       return round((x-d1)/(g1-d1),2);
  else 
       return round((y-a1)/(b1-a1),2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor label con un aprox
----------------------------------------------------------------------
drop function fsql_functions_feq_label_aprox (
				 fuzzy_label_def.obj%type, 
				 fuzzy_label_def.obj%type,
				 fuzzy_label_def.fuzzy_id%type,
   				 numeric, numeric, numeric, numeric);
create function fsql_functions_feq_label_aprox (
				 fuzzy_label_def.obj%type, 
				 fuzzy_label_def.obj%type,
				 fuzzy_label_def.fuzzy_id%type,
   				 numeric, numeric, numeric, numeric)
returns numeric as '
declare
  obj_var  alias for $1;
  col_var  alias for $2;
  f_id     alias for $3; 
  f1       alias for $4;
  f2       alias for $5;
  f3       alias for $6;
  f4       alias for $7;
  a1 	   fuzzy_label_def.alfa%type;
  b1       fuzzy_label_def.alfa%type;
  g1       fuzzy_label_def.alfa%type;
  d1       fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_label_aprox '');
  select into a1,b1,g1,d1 alfa,beta,gamma,delta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if d1<=f2 or a1>=f3 then
     return 0;
  elsif g1>=f1 and b1<=f1 then
     return 1;
  elsif d1>f2 and g1<f1 then
     return round((d1-f2)/(f4-(g1-d1)),2);
  else 
     return round((f3-a1)/(f4+(b1-a1)),2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor label con trapecio
----------------------------------------------------------------------
drop function fsql_functions_feq_label_trape (
   		fuzzy_label_def.obj%type,  
		fuzzy_label_def.obj%type,
		fuzzy_label_def.fuzzy_id%type,
   		numeric, numeric, numeric, numeric);
create function fsql_functions_feq_label_trape (
   		fuzzy_label_def.obj%type,  
		fuzzy_label_def.obj%type,
		fuzzy_label_def.fuzzy_id%type,
   		numeric, numeric, numeric, numeric)
returns numeric as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  f_id    alias for $3;
  f1      alias for $4;
  f2      alias for $5;
  f3      alias for $6;
  f4      alias for $7;
  a1      fuzzy_label_def.alfa%type;
  b1      fuzzy_label_def.alfa%type;
  g1      fuzzy_label_def.alfa%type;
  d1      fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_label_trape '');
  select into a1,b1,g1,d1 alfa,beta,gamma,delta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if d1<=f1 or a1>=f4 then
     return 0;
  elsif g1>=f2+f1 and b1<=f3+f4 then
     return 1;
  elsif d1>f1 and g1<f2+f1 then
     return round((d1-f1)/(f2-(g1-d1)),2);
  else 
     return round((f4-a1)/((b1-a1)-f3),2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor label (f_type=4) con una columna difusa.
-- la etiqueta debe estar definida para la columna.
-- en el caso de la condicion: fcol feq $label, no se usa esta funcion, sino feq_trape,
-- para aumentar la eficiencia al no tener que hallar [a,b,c,d] para cada tupla.
----------------------------------------------------------------------
drop function fsql_functions_feq_label (
		  fuzzy_label_def.obj%type, 
  		  fuzzy_label_def.obj%type,
  		  fuzzy_label_def.fuzzy_id%type,
  		  fuzzy_label_def.obj%type, 
		  fuzzy_label_def.obj%type,
  		  fuzzy_col_list.f_type%type,
  		  numeric, numeric, numeric, numeric);
create function fsql_functions_feq_label (
		  fuzzy_label_def.obj%type, 
  		  fuzzy_label_def.obj%type,
  		  fuzzy_label_def.fuzzy_id%type,
  		  fuzzy_label_def.obj%type, 
		  fuzzy_label_def.obj%type,
  		  fuzzy_col_list.f_type%type,
  		  numeric, numeric, numeric, numeric)
returns numeric as '
declare
  obj_var  alias for $1;
  col_var  alias for $2;
  f_id     alias for $3; 
  obj2_var alias for $4;
  col2_var alias for $5;
  f_type   alias for $6;
  f1       alias for $7;
  f2       alias for $8;
  f3       alias for $9;
  f4       alias for $10;
  a1       fuzzy_label_def.alfa%type;
  b1       fuzzy_label_def.alfa%type;
  g1       fuzzy_label_def.alfa%type;
  d1       fuzzy_label_def.alfa%type;
  a2       fuzzy_label_def.alfa%type;
  b2       fuzzy_label_def.alfa%type;
  g2       fuzzy_label_def.alfa%type;
  d2       fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_label '');
  if f_type=0 then 
     return fsql_functions_feq_unknown(4);
  elsif f_type=1 then 
     return fsql_functions_feq_undefined(4);
  elsif f_type=2 then 
     return fsql_functions_feq_null(4);
  elsif f_type=3 then 
     return fsql_functions_feq_crisp_label(f1,obj_var,col_var,f_id);
  elsif f_type=4 then 
    select into a1,b1,g1,d1 alfa,beta,gamma,delta  from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f_id;
    select into a2,b2,g2,d2 alfa,beta,gamma,delta from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f1;
    if d1<=a2 or a1>=d2 then
       return 0;
    elsif g1>=b2 and b1<=g2 then
       return 1;
    elsif d1>a2 and g1<b2 then
       return round((d1-a2)/((b2-a2)-(g1-d1)),2);
    else 
       return round((d2-a1)/((b1-a1)-(g2-d2)),2);
    end if;
  elsif f_type=5 then 
     return fsql_functions_feq_label_inter(obj_var,col_var,f_id,f1,f4);
  elsif f_type=6 then 
     return fsql_functions_feq_label_aprox(obj_var,col_var,f_id,f1,f2,f3,f4);
  else                
     return fsql_functions_feq_label_trape(obj_var,col_var,f_id,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de un valor intervalo con cualquier valor posible en atributos difusos tipo 2
-- excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- comparacion de un valor interv con un aprox
----------------------------------------------------------------------
drop function fsql_functions_feq_inter_aprox (numeric, numeric, numeric, numeric, numeric, numeric);
create function fsql_functions_feq_inter_aprox (
						numeric, numeric,
						numeric, numeric,
						numeric, numeric)
returns  numeric as '
declare
  x  alias for $1;
  y  alias for $2;
  f1 alias for $3;
  f2 alias for $4;
  f3 alias for $5;
  f4 alias for $6;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_inter_aprox  '');
  if y<=f2 or x>=f3 then
       return 0;
  elsif y>=f1 and x<=f1 then
       return 1;
  elsif y>f2 and y<f1 then
       return round((y-f2)/f4,2);
  else
       return round((f3-x)/f4,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor interv con trapecio
----------------------------------------------------------------------
drop function fsql_functions_feq_inter_trape (
						numeric, numeric,
						numeric, numeric,
						numeric, numeric);
create function fsql_functions_feq_inter_trape (
						numeric, numeric,
						numeric, numeric,
						numeric, numeric)
returns  numeric as '
declare
  x  alias for $1;
  y  alias for $2;
  f1 alias for $3;
  f2 alias for $4;
  f3 alias for $5;
  f4 alias for $6;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_inter_trape  '');
  if y<=f1 or x>=f4 then
       return 0;
  elsif y>=f2+f1 and x<=f3+f4 then
       return 1;
  elsif y>f1 and x<f2+f1 then
       return round((y-f1)/f2,2);
  else
       return round((x-f4)/f3,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de un valor intervalo [x,y] (f_type=5) con otro difuso
----------------------------------------------------------------------
drop function fsql_functions_feq_inter (
					  numeric, numeric, 
  					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_feq_inter (
					  numeric, numeric, 
  					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns  numeric as '
declare
  x       alias for $1;
  y       alias for $2;
  obj_var alias for $3;
  col_var alias for $4;
  f_type  alias for $5;
  f1      alias for $6;
  f2      alias for $7;
  f3      alias for $8;
  f4      alias for $9;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_inter '');
  if    f_type=0 then 
	return fsql_functions_feq_unknown(5);
  elsif f_type=1 then 
	return fsql_functions_feq_undefined(5);
  elsif f_type=2 then return 
	fsql_functions_feq_null(5);
  elsif f_type=3 then 
	return fsql_functions_feq_crisp_inter(f1,x,y);
  elsif f_type=4 then 
	return fsql_functions_feq_label_inter(obj_var,col_var,f1,x,y);
  elsif f_type=5 then
    if f1<=y and f4>=x then 
	return 1;
    else
	return 0;
    end if;
  elsif f_type=6 then 
	return fsql_functions_feq_inter_aprox(x,y,f1,f2,f3,f4);
  else
	return fsql_functions_feq_inter_trape(x,y,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de un valor aprox con cualquier valor posible en atributos difusos tipo 2
-- excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- comparacion de un valor aprox con trapecio
----------------------------------------------------------------------
drop function fsql_functions_feq_aprox_trape (
						numeric, numeric, numeric, numeric,
						numeric, numeric, numeric ,numeric);
create function fsql_functions_feq_aprox_trape (
						numeric, numeric, numeric, numeric,
						numeric, numeric, numeric ,numeric)
 
returns numeric as '
declare
  a1 alias for $1;
  a2 alias for $2;
  a3 alias for $3;
  a4 alias for $4;
  f1 alias for $5;
  f2 alias for $6;
  f3 alias for $7;
  f4 alias for $8;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_aprox_trape '');
  if a3<=f1 or a2>=f4 then
     return 0;
  elsif a1>=f2+f1 and a1<=f3+f4 then
     return 1;
  elsif a3>f1 and a1<f2+f1 then
     return round((a3-f1)/(f2+a4),2);
  else 
     return round((f4-a2)/(a4-f3),2);
  end if;
end;
'language 'plpgsql';
select fsql_functions_feq_aprox_trape(12,4,6,4,5,6,7,5);

----------------------------------------------------------------------
-- comparacion de un aprox [a1,a2,a3,a4] (f_type=6) con otro difuso
----------------------------------------------------------------------
drop function fsql_functions_feq_aprox (
					  numeric, numeric,
					  numeric, numeric,
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_feq_aprox (
					  numeric, numeric,
					  numeric, numeric,
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  a1	  alias for $1;
  a2	  alias for $2;
  a3 	  alias for $3;
  a4 	  alias for $4;
  obj_var alias for $5;
  col_var alias for $6;
  f_type  alias for $7;
  f1	  alias for $8;
  f2	  alias for $9;
  f3	  alias for $10;
  f4	  alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_aprox '');
  if    f_type=0 then
	return fsql_functions_feq_unknown(6);
  elsif f_type=1 then
	return fsql_functions_feq_undefined(6);
  elsif f_type=2 then
	return fsql_functions_feq_null(6);
  elsif f_type=3 then
	return fsql_functions_feq_crisp_aprox(f1,a1,a2,a3,a4);
  elsif f_type=4 then
	return fsql_functions_feq_label_aprox(obj_var,col_var,f1,a1,a2,a3,a4);
  elsif f_type=5 then
	return fsql_functions_feq_inter_aprox(f1,f4,a1,a2,a3,a4);
  elsif f_type=6 then
    if a3<=f2 or a2>=f3 then
        return 0;
    elsif a1=f1 then
        return 1;
    elsif a3>f2 and a1<f1 then
        return round((a3-f2)/(a4+f4),2);
    else
	return round((f3-a2)/(a4+f4),2);
    end if;
  else
        return fsql_functions_feq_aprox_trape(a1,a2,a3,a4,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de un valor trapecio con cualquier valor posible en
-- atributos difusos tipo 2 excepto los anteriores.
--********************************************************************
----------------------------------------------------------------------
-- comparacion de un valor trape [t1,t2,t3,t4] (f_type=7) con otro difuso
----------------------------------------------------------------------
drop function fsql_functions_feq_trape (
					  numeric, numeric,
					  numeric, numeric, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_feq_trape (
					  numeric, numeric,
					  numeric, numeric, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  t1 alias for $1;
  t2 alias for $2;
  t3 alias for $3;
  t4 alias for $4;
  obj_var alias for $5;
  col_var alias for $6;
  f_type alias for $7;
  f1 alias for $8;
  f2 alias for $9;
  f3 alias for $10;
  f4 alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq_trape '');
  if    f_type=0 then
	return fsql_functions_feq_unknown(7);
  elsif f_type=1 then
	return fsql_functions_feq_undefined(7);
  elsif f_type=2 then
	return fsql_functions_feq_null(7);
  elsif f_type=3 then
	return fsql_functions_feq_crisp_trape(f1,t1,t2,t3,t4);
  elsif f_type=4 then
	return fsql_functions_feq_label_trape(obj_var,col_var,f1,t1,t2,t3,t4);
  elsif f_type=5 then
	return fsql_functions_feq_inter_trape(f1,f4,t1,t2,t3,t4);
  elsif f_type=6 then
	return fsql_functions_feq_aprox_trape(f1,f2,f3,f4,t1,t2,t3,t4);
  else
    if t4<=f1 or t1>=f4 then
       return 0;
    elsif t3+t4>=f1+f2 and t1+t2<=f3+f4 then
       return 1;
    elsif t4>f1 and t3+t4<f1+f2 then
         return round((t4-f1)/((f1+f2-f1)-(t3+t4-t4)),2);
    else
	 return round((f4-t1)/((t1+t2-t1)-(f3+f4-f4)),2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de dos valores cualesquiera en atributos difusos tipo 2
--********************************************************************
----------------------------------------------------------------------
-- funcion difusa de comparacion: "aproximadamente igual",
-- feq (fuzzy equal).
----------------------------------------------------------------------
drop function fsql_functions_feq (
  			     fuzzy_label_def.obj%type, 
			     fuzzy_label_def.obj%type,
			     fuzzy_col_list.f_type%type,
			     numeric,numeric, 
			     numeric, numeric,
			     fuzzy_label_def.obj%type,
			     fuzzy_label_def.obj%type,
			     fuzzy_col_list.f_type%type,
			     numeric,numeric, 
  			     numeric, numeric); 
create function fsql_functions_feq (
  			     	    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
			     	    fuzzy_col_list.f_type%type,
	  		            numeric,numeric, 
			     	    numeric, numeric,
			     	    fuzzy_label_def.obj%type,
			     	    fuzzy_label_def.obj%type,
			            fuzzy_col_list.f_type%type,
			            numeric,numeric, 
  			            numeric, numeric) 
returns numeric as '
declare
  obj_var  alias for $1;
  col_var  alias for $2;
  f_type1  alias for $3;
  f11      alias for $4;
  f21      alias for $5;
  f31	   alias for $6;
  f41 	   alias for $7;
  obj2_var alias for $8;
  col2_var alias for $9;
  f_type2  alias for $10;
  f12 	   alias for $11;
  f22 	   alias for $12;
  f32 	   alias for $13;
  f42 	   alias for $14;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq  '');
  if f_type1=0 then    
     return fsql_functions_feq_unknown(f_type2);
  elsif f_type1=1 then 
     return fsql_functions_feq_undefined(f_type2);
  elsif f_type1=2 then 
     return 1; 
  elsif f_type1=3 then 
     return fsql_functions_feq_crisp(f11,obj2_var,col2_var,f_type2,f12,f22,f32,f42);
  elsif f_type1=4 then 
     return fsql_functions_feq_label(obj_var,col_var,f11,obj2_var,col2_var,f_type2,f12,f22,f32,f42);
  elsif f_type1=5 then 
     return fsql_functions_feq_inter(f11,f41,obj2_var,col2_var,f_type2,f12,f22,f32,f42);
  elsif f_type1=6 then 
     return fsql_functions_feq_aprox(f11,f21,f31,f41,obj2_var,col2_var,f_type2,f12,f22,f32,f42);
  else 
     return fsql_functions_feq_trape(f11,f21,f31,f41,obj2_var,col2_var,f_type2,f12,f22,f32,f42);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- compatibilidad de dos valores cualesquiera en atributos difusos tipo 3
--********************************************************************
----------------------------------------------------------------------
-- para atributos tipo 3: comparacion de un valor label con una columna
-- en la que fuzzy_col_list.len=1 (solo admiten una etiqueta por columna)
-- los valores obj,col no tienen que ser los de la columna a comparar, sino los
-- de la columna que tiene definidas las etiquetas en fuzzy_nearness_def.
-- si la columna a comparar aparece a la izquierda en fuzzy_compatible_col,
-- los valores obj,col seran los que aparecen a la derecha en esa tabla.
----------------------------------------------------------------------
drop function fsql_functions_feq3_label_len1(
					fuzzy_label_def.obj%type,
					fuzzy_label_def.obj%type,
					fuzzy_label_def.fuzzy_id%type,
					fuzzy_col_list.f_type%type,
					numeric, numeric);
create function fsql_functions_feq3_label_len1(
					fuzzy_label_def.obj%type,
					fuzzy_label_def.obj%type,
					fuzzy_label_def.fuzzy_id%type,
					fuzzy_col_list.f_type%type,
					numeric, numeric)
returns numeric as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  f_id alias for $3; 
  f_type alias for $4;
  fp1 alias for $5;
  f1 alias for $6;
  d fuzzy_nearness_def.degree%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq3_label_len1  '');
  if f_id<f1 then
     select into d degree from fuzzy_nearness_def
       where obj=obj_var and col=col_var and fuzzy_id1=f_id and fuzzy_id2=f1;
     if d is null then
	return 0;
     else
        return round(fp1*d,2);
     end if;
  elsif f_id>f1 then
     select into d degree from fuzzy_nearness_def
       where obj=obj_var and col=col_var and fuzzy_id1=f1 and fuzzy_id2=f_id;
     if d is null then
	return 0;
     else
        return round(fp1*d,2);
     end if;
  else
     return fp1;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- para atributos tipo 3: comparacion de un valor label (f_id con posibilidad 1)
-- con una columna en la que fuzzy_col_list.len = arg. length
-- se usara en una condicion del tipo fcol feq $label, (donde label tiene pos. 1).
-- los valores obj,col no tienen que ser los de la columna a comparar, sino los
-- de la columna que tiene definidas las etiquetas en fuzzy_nearness_def.
-- si la columna a comparar aparece a la izquierda en fuzzy_compatible_col,
-- los valores obj,col seran los que aparecen a la derecha en esa tabla.
----------------------------------------------------------------------
drop function fsql_functions_feq3_label(
  					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.fuzzy_id%type,
					  fuzzy_col_list.len%type,
					  fuzzy_col_list.f_type%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_feq3_label(
  					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.fuzzy_id%type,
					  fuzzy_col_list.len%type,
					  fuzzy_col_list.f_type%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type,
					  numeric, fuzzy_object_list.fuzzy_id%type)
returns numeric as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  f_id    alias for $3;
  length  alias for $4;
  f_type  alias for $5;
  fp1	  alias for $6;
  f1	  alias for $7;
  fp2	  alias for $8;
  f2	  alias for $9;
  fp3	  alias for $10;
  f3	  alias for $11;
  fp4	  alias for $12;
  f4	  alias for $13;
  fp5	  alias for $14;
  f5	  alias for $15;
  fp6	  alias for $16;
  f6	  alias for $17;
  fp7	  alias for $18;
  f7	  alias for $19;
  fp8	  alias for $20;
  f8	  alias for $21;
  fp9	  alias for $22;
  f9	  alias for $23;
  fp10	  alias for $24;
  f10	  alias for $25;
  i       integer;
  fpi     numeric;
  fi      fuzzy_object_list.fuzzy_id%type;
  maxi    numeric;
  uno     numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq3_label '');
  i   := 1;
  fpi := fp1;
  fi  := f1; 
  maxi:= 0;
  if f_type=0 or f_type=2 then
     return 1;
  elsif f_type=1 then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions_feq3_label_len1(obj_var,col_var,f_id,f_type,fp1,f1);
  else 
     while i<=length and fpi is not null and fi is not null loop
       uno:= fsql_functions_feq3_label_len1(obj_var,col_var,f_id,f_type,fpi,fi);
       if uno>maxi then 
          maxi:=uno;
       end if;
       i:=i+1;
       if i=2 then 
          fpi:=fp2; 
          fi:=f2;
       elsif i=3 then 
          fpi:=fp3; 
          fi:=f3;
       elsif i=4  then 
          fpi:=fp4; 
          fi:=f4;
       elsif i=5  then 
          fpi:=fp5; 
          fi:=f5;
       elsif i=6  then 
          fpi:=fp6; 
          fi:=f6;
       elsif i=7  then 
          fpi:=fp7; 
          fi:=f7;
       elsif i=8  then 
          fpi:=fp8; 
          fi:=f8;
       elsif i=9  then 
          fpi:=fp9; 
          fi:=f9;
       elsif i=10 then 
          fpi:=fp10; 
          fi:=f10;
       end if;
     end loop;
     return round(maxi,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- comparacion de compatibilidad de un atributo difuso tipo 3
-- con la cte. difusa unknown o null
----------------------------------------------------------------------
drop function fsql_functions_feq3_unknown_null (
				fuzzy_col_list.len%type,
				fuzzy_col_list.f_type%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_feq3_unknown_null (
				fuzzy_col_list.len%type,
				fuzzy_col_list.f_type%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type,
				numeric, fuzzy_object_list.fuzzy_id%type)
returns numeric as '
declare
  length alias for $1;
  f_type alias for $2;
  fp1    alias for $3;
  f1     alias for $4;
  fp2    alias for $5;
  f2     alias for $6;
  fp3    alias for $7;
  f3     alias for $8;
  fp4    alias for $9;
  f4     alias for $10;
  fp5    alias for $11;
  f5     alias for $12;
  fp6    alias for $13;
  f6     alias for $14;
  fp7    alias for $15;
  f7     alias for $16;
  fp8    alias for $17;
  f8     alias for $18;
  fp9    alias for $19;
  f9     alias for $20;
  fp10   alias for $21;
  f10    alias for $22;
  maxi   numeric;
  fpi    numeric;
  fi     fuzzy_object_list.fuzzy_id%type;
  i      integer;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq3_unknown_null '');
  maxi:=fp1;
  fpi :=fp2;
  fi  :=f2;
  i   :=2;
  if    f_type=0 then
	return 1;
  elsif f_type=1 then
	return 0;
  elsif f_type=2 then
	return 1;
  elsif f_type=3 then
	return fp1;
  elsif f_type=4 then
    while i<=length and fpi is not null and fi is not null loop
      if fpi>maxi then
	maxi:=fpi;
      end if;
      i:=i+1;
      if    i=2  then
	fpi:=fp2;
	fi :=f2;
      elsif i=3  then
	fpi:=fp3;
	fi :=f3;
      elsif i=4  then
	fpi:=fp4;
	fi :=f4;
      elsif i=5  then
	fpi:=fp5;
	fi :=f5;
      elsif i=6  then
	fpi:=fp6;
	fi :=f6;
      elsif i=7  then
	fpi:=fp7;
	fi :=f7;
      elsif i=8  then
	fpi:=fp8;
	fi :=f8;
      elsif i=9  then
	fpi:=fp9;
	fi :=f9;
      elsif i=10 then
	fpi:=fp10;
	fi :=f10;
      end if;
    end loop;
    return round(maxi,2);
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- para atributos tipo 3: comparacion de un atributo tipo 3 con otro.
-- en los que fuzzy_col_list.len vale length1 y length2 respectivamente (simpre <=10).
-- ambos atributos deben ser compatibles con el atributo (obj,col).
-- (obj,col) no tiene que ser una columna de las que se comparan, sino
-- la columna que tiene definidas las etiquetas en fuzzy_nearness_def y
-- que debe ser compatible a los dos atributos que se van a comparar.
-- no funciona con muchos parametros de entrada. max.32
----------------------------------------------------------------------
drop function fsql_functions_feq3(
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.len%type,
    				    fuzzy_col_list.len%type,
	 			    fuzzy_col_list.f_type%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    fuzzy_col_list.f_type%type, 
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type);
create function fsql_functions_feq3(
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.len%type,
    				    fuzzy_col_list.len%type,
	 			    fuzzy_col_list.f_type%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    fuzzy_col_list.f_type%type, 
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type,
				    numeric, fuzzy_object_list.fuzzy_id%type) 

returns numeric as '
declare
  obj_var alias for $1;
  col_var alias for $2;
  length1 alias for $3;
  length2 alias for $4;
  f_type  alias for $5;
  fp1	  alias for $6;
  f1	  alias for $7;
  fp2	  alias for $8;
  f2	  alias for $9;
  fp3	  alias for $10;
  f3	  alias for $11;
  fp4	  alias for $12;
  f4	  alias for $13;
  fp5	  alias for $14;
  f5	  alias for $15;
  fp6	  alias for $16;
  f6	  alias for $17;
  fp7	  alias for $18;
  f7	  alias for $19;
  fp8	  alias for $20;
  f8	  alias for $21;
  fp9	  alias for $22;
  f9	  alias for $23;
  fp10	  alias for $24;
  f10	  alias for $25;
  x_type  alias for $26;
  xp1	  alias for $27;
  x1	  alias for $28;
  xp2	  alias for $29;
  x2	  alias for $30;
  xp3	  alias for $31;
  x3	  alias for $32;
  xp4	  alias for $33;
  x4	  alias for $34;
  xp5	  alias for $35;
  x5	  alias for $36;
  xp6	  alias for $37;
  x6	  alias for $38;
  xp7	  alias for $39;
  x7	  alias for $40;
  xp8	  alias for $41;
  x8	  alias for $42;
  xp9	  alias for $43;
  x9	  alias for $44;
  xp10	  alias for $45;
  x10	  alias for $46;
  i       integer;
  fpi     numeric;
  fi      fuzzy_object_list.fuzzy_id%type;
  maxi    numeric;
  uno     numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_feq3 '');
  i   := 1;
  fpi := fp1;
  fi  := f1; 
  maxi:= 0;
  if f_type=0 or f_type=2 then  
     return fsql_functions_feq3_unknown_null(length2,x_type,xp1,x1,xp2,x2,xp3,x3,xp4,
					     x4,xp5,x5,xp6,x6,xp7,x7,xp8,x8,xp9,x9,xp10,x10);
  elsif f_type=1 then 
     return fsql_functions_feq_undefined(x_type);
  elsif f_type=3 then 
     return round(fp1*fsql_functions_feq3_label(obj,col,f1,length2,x_type,xp1,x1,xp2,x2,
                                xp3,x3,xp4,x4,xp5,x5,xp6,x6,xp7,x7,xp8,x8,xp9,x9,xp10,x10),2);
  elsif f_type=4 then 
    if x_type=0 or x_type=2 then    
       return fsql_functions_feq3_unknown_null(length1,4,fp1,f1,fp2,f2,fp3,f3,fp4,f4,
						 fp5,f5,fp6,f6,fp7,f7,fp8,f8,fp9,f9,fp10,f10);
    elsif x_type=1 then
       return fsql_functions_feq_undefined(f_type);
    elsif x_type=3 then 
       return round(xp1*feq3_label(obj_var,col_var,x1,length1,4,
                             fp1,f1,fp2,f2,fp3,f3,fp4,f4,fp5 ,f5,
                             fp6,f6,fp7,f7,fp8,f8,fp9,f9,fp10,f10),2);
    elsif x_type=4 then 
      while i<=length1 and fpi is not null and fi is not null loop
        uno:=fpi*fsql_functions_feq3_label(obj_var,col_var,fi,length2,4,
					   xp1,x1,xp2,x2,xp3,x3,xp4,x4,xp5,x5,
                                           xp6,x6,xp7,x7,xp8,x8,xp9,x9,xp10,x10);
        if uno>maxi then 
           maxi:=uno;
        end if;
        i:=i+1;
        if i=2 then 
          fpi:=fp2;
          fi:=f2;
        elsif i=3  then 
          fpi:=fp3; 
          fi:=f3;
        elsif i=4  then 
          fpi:=fp4; 
          fi:=f4;
        elsif i=5  then 
          fpi:=fp5; 
          fi:=f5;
        elsif i=6  then 
          fpi:=fp6; 
          fi:=f6;
        elsif i=7  then 
          fpi:=fp7; 
          fi:=f7;
        elsif i=8  then 
          fpi:=fp8; 
          fi:=f8;
        elsif i=9  then 
          fpi:=fp9; 
          fi:=f9;
        elsif i=10 then 
          fpi:=fp10; 
          fi:=f10;
        end if;
      end loop;
      return round(maxi,2);
    end if;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- evalua el grado de cumplimiento de una condicion crisp (numerica)
-- (para calcular el cdeg de un atributo difuso tipo 1)
----------------------------------------------------------------------
drop function fsql_functions_condcrisp(
					 numeric, varchar, numeric);
create function fsql_functions_condcrisp(
					 numeric, varchar, numeric)
returns numeric as '
declare
op1        alias for $1;
comparador alias for $2;
op2        alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_condcrisp '');
  if comparador=''='' then
     if op1=op2 then
	return 1;
     else
	return 0;
     end if;
  elsif comparador=''<'' then
     if op1<op2 then
	return 1;
     else
	return 0;
     end if;
  elsif comparador=''<='' then
     if op1<=op2 then
	return 1;
     else
	return 0;
     end if;
  elsif comparador=''>'' then
     if op1>op2 then
	return 1;
     else
	return 0;
     end if;
  elsif comparador=''>='' then
     if op1>=op2 then
	return 1;
     else
	return 0;
     end if;
  else
     if op1<>op2 then
	return 1;
     else
	return 0;
     end if;
  end if;
end;
'language 'plpgsql';

--**** para todos los comparadores difusos de posibilidad (salvo feq) ****--

--********************************************************************
-- comparacion fgt, flt, fgeq, fleq, mgt y mlt de cualquier valor
-- difuso tipo 2 con las ctes difusas unknown, undefined y null.
--********************************************************************

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es 'mayor' (fgt), 'menor' (flt)
-- 'mayor o igual' (fgeq), 'menor o igual' (fleq), 'mucho mayor' (mgt) o
-- 'mucho menor' (mlt) que la cte. difusa unknown
----------------------------------------------------------------------
drop function fsql_functions_mayormenor_unknown (fuzzy_col_list.f_type%type); 
create function fsql_functions_mayormenor_unknown (fuzzy_col_list.f_type%type) 
returns numeric as'
declare
  f_type alias for $1;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_mayormenor_unknown '');
  if f_type=1 then 
     return 0; 
  else             
     return 1;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es 'mayor' (fgt), 'menor' (flt)
-- 'mayor o igual' (fgeq), 'menor o igual' (fleq), 'mucho mayor' (mgt) o
-- 'mucho menor' (mlt) que la cte. difusa undefined
----------------------------------------------------------------------
drop function fsql_functions_mayormenor_undefined();
create function fsql_functions_mayormenor_undefined()
returns numeric as '
begin
  insert into trama values(nextval(''sec''),''fsql_functions_mayormenor_undefined '');
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es 'mayor' (fgt), 'menor' (flt)
-- 'mayor o igual' (fgeq), 'menor o igual' (fleq), 'mucho mayor' (mgt) o
-- 'mucho menor' (mlt) que la cte. difusa null
----------------------------------------------------------------------
drop function fsql_functions_mayormenor_null (fuzzy_col_list.f_type%type);
create function fsql_functions_mayormenor_null (fuzzy_col_list.f_type%type)
returns numeric as '
declare
f_type alias for $1;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_mayormenor_null '');
  if f_type=1 then
	return 0;
  else  
        return 1;
  end if;
end;
'language 'plpgsql';


--********************** comparador difuso fgt **********************--

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor' (fgt) que un intervalo [x,y]
-- comparacion del tipo: fcol_t1 fgt [3,6]
-- en ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [x-margen, x, y, y+margen]
-- se difumina porque:
--	1. permite una gran expresividad, escribiendo un intervalo
--       en vez de un trapecio.
--       no obstante, esta comparacion es equivalente a fcol_t1 fgt #6
--	2. si no se desea difuminar usar comparacion crisp: fcol_t1 > 6
-- con un crisp, la posibilidad y la necesidad son iguales.
----------------------------------------------------------------------
drop function fsql_functions_fgt_crisp_finter (
					  numeric,  numeric,  
					  numeric,  numeric);
create function fsql_functions_fgt_crisp_finter (
					  numeric,  numeric,  
					  numeric,  numeric)
returns numeric as'
declare
  crisp   alias for $1;
  x       alias for $2;
  y       alias for $3;
  margen  alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_crisp_finter '');
  if crisp>=(y+margen) then 
       return 1;
  elsif crisp>y        then 
       return round( (crisp-y)/margen ,2);
  else  
       return 0;
  end if;
end;
'language 'plpgsql';
select fsql_functions_fgt_crisp_finter (4,2,3,4);

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor' (fgt) que un intervalo [x,y]
-- no se exporta: se usa en comparaciones internas.
-- este no se difumina porque el intervalo [x,y] es un atributo de una
-- relacion difusa.
----------------------------------------------------------------------
drop function fsql_functions_fgt_crisp_inter (numeric, numeric, numeric);
create function fsql_functions_fgt_crisp_inter (numeric, numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  x     alias for $2;
  y     alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_crisp_inter '');
  if crisp>y then
	return 1;
  else
	return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor' (fgt) que un valor aprox
-- caso ejemplo: fcol_t1 fgt #6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions_fgt_crisp_aprox (
			numeric, numeric, numeric, numeric, numeric);
create function fsql_functions_fgt_crisp_aprox (
			numeric, numeric, numeric, numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_crisp_aprox '');
  if    crisp>=f3 then
	return 1;
  elsif crisp> f1 then
	return round( (crisp-f1)/f4 ,2);
  else
	return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor' (fgt) que un valor crisp que
-- difuminamos a aprox
-- caso ejemplo: fcol_t1 fgt 6 (equivalente a fcol_t1 fgt #6)
----------------------------------------------------------------------
drop function fsql_functions_fgt_t1_t1 (
	        			numeric,  numeric,  numeric) ;
create function fsql_functions_fgt_t1_t1 (
	    				  numeric,  numeric,  numeric) 
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f4    alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_t1_t1 '');
  if crisp>=(f1+f4) then 
     return 1; 
  elsif crisp> f1 then 
     return round( (crisp-f1)/f4 ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';
select fsql_functions_fgt_t1_t1(4,2,3);

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor' (fgt) que un trapecio
-- caso ejemplo: fcol_t1 fgt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions_fgt_crisp_trape (
   					      numeric,
					      numeric, numeric, 
					      numeric, numeric);
create function fsql_functions_fgt_crisp_trape (
   					 	numeric,
					 	numeric, numeric, 
					 	numeric, numeric)
returns numeric as'
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_crisp_trape'');
  if crisp>=f4   then 
     return 1;
  elsif crisp>f3+f4 then 
     return round( (f3+f4-crisp)/f3 ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'mayor' (fgt) que una
-- columna tipo 2. formato: fcol_t1 fgt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions_fgt_t1_t2 (
  					  numeric, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_fgt_t1_t2 (
  					  numeric, 
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_t1_t2'');
  if    f_type=0 then
	return fsql_functions_mayormenor_unknown(3);
  elsif f_type=1 then
	return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then
	return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then
    if crisp>f1  then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=4 then
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if  crisp>=delta_var then
	return 1;
    elsif crisp> gamma_var then
	return round( (gamma_var-crisp)/(gamma_var-delta_var) ,2);
    else
	return 0;
    end if;
  elsif f_type=5 then
	return fsql_functions_fgt_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then
	return fsql_functions_fgt_crisp_aprox(crisp,f1,f2,f3,f4);
  else
	return fsql_functions_fgt_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor' (fgt) que un valor crisp
-- caso ejemplo: fcol_t2 fgt 8. tambien: fcol_t2 fgt fcol_t1
--********************************************************************
drop function fsql_functions_fgt_crisp (
   		    			  numeric,
			                  fuzzy_label_def.obj%type,  
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric,numeric);
create function fsql_functions_fgt_crisp (
   		    			  numeric,
			                  fuzzy_label_def.obj%type,  
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric,numeric)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2; 
  col_var   alias for $3;
  f_type    alias for $4; 
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_crisp'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then
    if f1>crisp  then 
        return 1;
    else 
        return 0;
    end if;
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if gamma_var>=crisp then 
        return 1;
    elsif delta_var> crisp then 
        return round((crisp-delta_var)/(gamma_var-delta_var),2);
    else  
        return 0;
    end if;
  elsif f_type=5 then 
    if f4>crisp then 
       return 1;
    else             
       return 0;
    end if;
  elsif f_type=6 then 
    if f1>=crisp then 
       return 1;
    elsif f3> crisp then 
       return round((f3-crisp)/f4,2);
    else  
       return 0;
    end if;
  else  
    if crisp>=f4 then 
       return 0;
    elsif f3+f4>=crisp then 
       return 1;
    else                    
       return round((crisp-f4)/f3,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor' (fgt) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 fgt [x,y]
--********************************************************************
drop function fsql_functions_fgt_inter (
					numeric, numeric,
					fuzzy_label_def.obj%type,
					fuzzy_label_def.obj%type,
					fuzzy_col_list.f_type%type,
					numeric, numeric,
					numeric, numeric);
create function fsql_functions_fgt_inter (
					numeric, numeric,
					fuzzy_label_def.obj%type,
					fuzzy_label_def.obj%type,
					fuzzy_col_list.f_type%type,
					numeric, numeric,
					numeric, numeric)
returns numeric as '
declare
  x 	    alias for $1;
  y 	    alias for $2;
  obj_var   alias for $3;
  col_var   alias for $4;
  f_type    alias for $5;
  f1 	    alias for $6;
  f2 	    alias for $7;
  f3 	    alias for $8;
  f4        alias for $9;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_inter'');
  if    f_type=0 then
	return fsql_functions_mayormenor_unknown(5);
  elsif f_type=1 then
	return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then
	return fsql_functions_mayormenor_null(5);
  elsif f_type=3 then
    if f1>y then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=4 then
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if    gamma_var>=y then
	return 1;
    elsif delta_var> y then
	return round((y-delta_var)/(gamma_var-delta_var),2);
    else 
	return 0;
    end if;
  elsif f_type=5 then
    if f1>y then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=6 then
    if    f1>=y then
	return 1;
    elsif f3> y then
	return round( (f3-y)/f4 ,2);
    else
	return 0;
    end if;
  else
    if    y>=f4    then
	return 0;
    elsif f3+f4>=y then
	return 1;
    else
	return round((y-f4)/f3,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor' (fgt) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 fgt #a1
--********************************************************************
drop function fsql_functions_fgt_aprox (
   				   numeric, numeric, 
				   numeric, numeric,
				   fuzzy_label_def.obj%type, 
				   fuzzy_label_def.obj%type,
				   fuzzy_col_list.f_type%type,
				   numeric, numeric, 
				   numeric, numeric);
create function fsql_functions_fgt_aprox (
   				   numeric, numeric, 
				   numeric, numeric,
				   fuzzy_label_def.obj%type, 
				   fuzzy_label_def.obj%type,
				   fuzzy_col_list.f_type%type,
				   numeric, numeric, 
				   numeric, numeric)
returns numeric as '
declare
  a1        alias for $1; 
  a2        alias for $2;
  a3        alias for $3;
  a4        alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8; 
  f2        alias for $9; 
  f3        alias for $10; 
  f4        alias for $11; 
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_aprox'');
  if f_type=0 then 
    return fsql_functions_mayormenor_unknown(6); 
  elsif f_type=1 then 
    return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
    return fsql_functions_mayormenor_null(6);
  elsif f_type=3 then 
    return fsql_functions_fgt_crisp_aprox(f1,a1,a2,a3,a4);
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if delta_var<=a1 then 
        return 0;
    elsif gamma_var<a3 then 
        return round( (a1-delta_var)/(gamma_var-delta_var-a4) ,2);
    else  
        return 1;
    end if;
  elsif f_type=5 then 
    if f4<=a1 then 
        return 0;
    elsif f4< a3 then 
        return round( (f4-a1)/a4 ,2);
    else         
        return 1;
    end if;
  elsif f_type=6 then 
    if f3<=a1 then 
        return 0;
    elsif f1< a3 then 
        return round( (f3-a1)/(a4+f4) ,2);
    else 
        return 1;
    end if;
  else 
    if f4<=a1 then 
       return 0;
    elsif f3+f4< a3 then 
       return round((a1-f4)/(f3-a4) ,2);
    else 
       return 1;
    end if;
  end if;
end;
'language 'plpgsql';
--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor' (fgt) que un trapecio
-- caso ejemplo: fcol_t2 fgt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_fgt_trape (
					  numeric, numeric, 
					  numeric, numeric,
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_fgt_trape (
					  numeric, numeric, 
					  numeric, numeric,
					  fuzzy_label_def.obj%type,
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  t1        alias for $1;
  t2        alias for $2;
  t3        alias for $3;
  t4        alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt_trape'');
  if    f_type=0 then
	return fsql_functions_mayormenor_unknown(7);
  elsif f_type=1 then
	return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then
	return fsql_functions_mayormenor_null(7);
  elsif f_type=3 then
	return fsql_functions_fgt_crisp_trape(f1,t1,t2,t3,t4);
  elsif f_type=4 then
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if  delta_var<=(t3+t4) then
	return 0;
    elsif gamma_var< t4 then
	return round( (t3+t4-delta)/(t3+gamma_var-delta_var) ,2);
    else
	return 1;
    end if;
  elsif f_type=5 then
    if  f4<=(t3+t4) then
	return 0;
    elsif f4< t4 then
	return round( (t3+t4-f4)/t3 ,2);
    else
	return 1;
    end if;
  elsif f_type=6 then
    if  f3<=(t3+t4) then
	return 0;
    elsif f1< t4 then
	return round( (t3+t4-f3)/(t3-f4) ,2);
    else
	return 1;
    end if;
  else
    if  f4   <=(t3+t4) then
	return 0;
    elsif f3+f4< t4 then
	return round( (t3+t4-f4)/(t3+f3) ,2);
    else
	return 1;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion: "aproximadamente mayor que",
-- fgt (fuzzy greater than).
-- indica si una columna difusa tipo 2 es 'mayor' (fgt) que otra
-- caso ejemplo: fcol1_t2 fgt fcol2_t2
--********************************************************************
drop function fsql_functions_fgt (
  			     fuzzy_label_def.obj%type, 
			     fuzzy_label_def.obj%type,
			     fuzzy_col_list.f_type%type,
			     numeric, numeric, 
                             numeric, numeric,
		      	     fuzzy_label_def.obj%type, 
			     fuzzy_label_def.obj%type,
			     fuzzy_col_list.f_type%type,
			     numeric, numeric, 
			     numeric, numeric);
create function fsql_functions_fgt (
	  			    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
        	                    numeric, numeric,
			      	    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric) 
returns numeric as '
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var  fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgt'');
  if f_type2=0 then 
      return fsql_functions_mayormenor_unknown(f_type1);
  elsif f_type2=1 then 
      return fsql_functions_mayormenor_undefined();
  elsif f_type2=2 then  
      return fsql_functions_mayormenor_null(f_type1);
  elsif f_type1=0 then  
      return fsql_functions_mayormenor_unknown(f_type2); 
  elsif f_type1=1 then 
      return fsql_functions_mayormenor_undefined();
  elsif f_type1=2 then 
      return fsql_functions_mayormenor_null(f_type2);
  elsif f_type2=3 then 
      return fsql_functions_fgt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta  
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
    return fsql_functions_fgt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,
                                    delta_var,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then 
    return fsql_functions_fgt_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=6 then 
    return fsql_functions_fgt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else 
    return fsql_functions_fgt_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';

--********************** comparador difuso fgeq **********************--

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que un intervalo [x,y]
-- comparacion del tipo: fcol_t1 fgeq [3,6]
-- en ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [x-margen, x, y, y+margen]
-- si no se desea difuminar usar comparacion crisp: fcol_t1 >= 3
----------------------------------------------------------------------
drop function fsql_functions_fgeq_crisp_finter (
						  numeric, numeric,
						  numeric, numeric);
create function fsql_functions_fgeq_crisp_finter (
						  numeric, numeric,
						  numeric, numeric)
returns numeric as '
declare
  crisp  alias for $1;
  x      alias for $2;
  y      alias for $3;
  margen alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp_finter'');
  if    (x-margen)>=crisp then
	return 0;
  elsif crisp>=x          then
	return 1;
  else
	return round((crisp-x+margen)/margen,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que un intervalo [x,y]
-- no se exporta
----------------------------------------------------------------------
drop function fsql_functions_fgeq_crisp_inter (numeric,numeric, numeric);
create function fsql_functions_fgeq_crisp_inter (numeric,numeric, numeric)
returns numeric as '
declare 
  crisp alias for $1; 
  x     alias for $2;
  y     alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp_inter'');
  if crisp>=x then 
     return 1;
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que un valor aprox
-- caso ejemplo: fcol_t1 fgeq #6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions_fgeq_crisp_aprox (
  						 numeric,
  					  	 numeric, numeric,
						 numeric, numeric);
create function fsql_functions_fgeq_crisp_aprox (
  						 numeric,
  					  	 numeric, numeric,
						 numeric, numeric)
returns numeric as '
declare
crisp   alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp_aprox'');
  if crisp>=f1 then 
     return 1;
  elsif crisp> f2 then 
     return round((crisp-f2)/f4,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que otro crisp que
-- difuminamos a un aprox f1 + - f4
-- caso ejemplo: fcol_t1 fgeq 6
----------------------------------------------------------------------
drop function fsql_functions_fgeq_t1_t1 (numeric,numeric, numeric);
create function fsql_functions_fgeq_t1_t1 (numeric,numeric, numeric)
returns numeric as '
declare 
  crisp alias for $1; 
  f1    alias for $2;
  f4    alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_t1_t1'');
  if    crisp>=f1 then
	return 1;
  elsif crisp> (f1-f4) then
	return round((crisp-f1+f4)/f4,2);
  else
	return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que un trapecio
-- caso ejemplo: fcol_t1 fgeq $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions_fgeq_crisp_trape (
						 numeric,
						 numeric, numeric, 
						 numeric, numeric);
create function fsql_functions_fgeq_crisp_trape (
						 numeric,
						 numeric, numeric, 
						 numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp_trape'');
  if f1>=crisp then 
      return 0;
  elsif crisp>=f2+f1 then 
      return 1;
  else                    
     return round((crisp-f1)/f2,2);
  end if;
end;
'language 'plpgsql';

 ----------------------------------------------------------------------
-- indica si un valor crisp es 'mayor o igual' (fgeq) que una etiqueta
-- no se exporta: se usa en otras funciones.
----------------------------------------------------------------------
drop function fsql_functions_fgeq_crisp_label (
						 numeric,
						 fuzzy_label_def.obj%type,
						 fuzzy_label_def.obj%type,
						 numeric);
create function fsql_functions_fgeq_crisp_label (
						 numeric,
						 fuzzy_label_def.obj%type,
						 fuzzy_label_def.obj%type,
						 numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_id     alias for $4;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp_label'');
  select into alfa_var,beta_var alfa,beta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if    alfa_var>=crisp then
	return 0;
  elsif crisp>=beta_var then
	return 1;
  else
	return round((crisp-alfa_var)/(beta_var-alfa_var),2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'mayor o igual' (fgeq) que una
-- columna tipo 2. formato: fcol_t1 fgeq fcol_t2
----------------------------------------------------------------------
drop function fsql_functions_fgeq_t1_t2 (
					   numeric,
					   fuzzy_label_def.obj%type,  
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_fgeq_t1_t2 (
					   numeric,
					   fuzzy_label_def.obj%type,  
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp   alias for $1;  
  obj_var alias for $2;    
  col_var alias for $3;
  f_type  alias for $4;
  f1      alias for $5;
  f2      alias for $6;
  f3      alias for $7;
  f4      alias for $8;
  alfa    fuzzy_label_def.alfa%type;
  beta    fuzzy_label_def.alfa%type;
begin 
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_t1_t2'');
  if f_type=0 then 
      return fsql_functions_mayormenor_unknown(3); 
  elsif f_type=1 then 
      return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
      return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then 
    if crisp>=f1 then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
      return fsql_functions_fgeq_crisp_label(crisp,obj_var,col_var,f1);
  elsif f_type=5 then 
      return fsql_functions_fgeq_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then 
      return fsql_functions_fgeq_crisp_aprox(crisp,f1,f2,f3,f4);
  else                
      return fsql_functions_fgeq_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor o igual' (fgeq) que un valor crisp
-- caso ejemplo: fcol_t2 fgeq 8. tambien: fcol_t2 fgeq fcol_t1
--********************************************************************
drop function fsql_functions_fgeq_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,  
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_fgeq_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,  
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp     alias for $1;  
  obj_var   alias for $2;    
  col_var   alias for $3;
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_crisp'');
  if    f_type=0 then
	return fsql_functions_mayormenor_unknown(3);
  elsif f_type=1 then
	return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then
	return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then
    if f1>=crisp then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=4 then
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if  gamma_var>=crisp then
	return 1;
    elsif delta_var> crisp then
	return round((crisp-delta_var)/(gamma_var-delta_var),2);
    else
	return 0;
    end if;
  elsif f_type=5 then
    if  f4>=crisp then
	return 1;
    else
	return 0;
    end if;
  elsif f_type=6 then
    if    f1>=crisp then
	return 1;
    elsif f3> crisp then
	return round((f3-crisp)/f4,2);
    else
	return 0;
    end if;
  else
    if  crisp>=f4 then
	return 0;
    elsif f3+f4>=crisp then
	return 1;
    else
	return round((crisp-f4)/f3,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor o igual' (fgeq) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 fgeq [x,y]
--********************************************************************
drop function fsql_functions_fgeq_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, numeric, numeric);
create function fsql_functions_fgeq_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, numeric, numeric)
returns numeric as '
declare
  x         alias for $1;
  y         alias for $2;
  obj_var   alias for $3;
  col_var   alias for $4;
  f_type    alias for $5;
  f1        alias for $6;
  f2        alias for $7;
  f3        alias for $8;
  f4        alias for $9;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_inter'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(5); 
  elsif f_type=1 then return 
     fsql_functions_mayormenor_undefined();
  elsif f_type=2 then return 
     fsql_functions_mayormenor_null(5);
  elsif f_type=3 then
    if f1>=x then 
       return 1; 
    else          
       return 0;
    end if;
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if gamma_var>=x then 
       return 1;
    elsif delta_var> x then 
       return round((x-delta_var)/(gamma_var-delta_var),2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
   if f4>=x then 
      return 1;
   else          
      return 0;
   end if;
  elsif f_type=6 then 
    if f1>=x then 
       return 1;
    elsif f3> x then 
       return round((f3-x)/f4,2);
    else  
       return 0;
    end if;
  else 
    if x>=f4 then 
       return 0;
    elsif f3+f4>=x  then 
       return 1;
    else                 
       return round((x-f4)/f3,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor o igual' (fgeq) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 fgeq #a1
--********************************************************************
drop function fsql_functions_fgeq_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric);
create function fsql_functions_fgeq_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric)
returns numeric as '
declare
  a1 alias for $1;
  a2 alias for $2;
  a3 alias for $3;
  a4 alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_aprox'');
  if    f_type=0 then
	return fsql_functions_mayormenor_unknown(6);
  elsif f_type=1 then
	return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then
	return fsql_functions_mayormenor_null(6);
  elsif f_type=3 then
    if  f1>=a1 then
	return 1;
    elsif f1> a2 then
	return round((f1-a2)/a4,2);
    else
	return 0;
    end if;
  elsif f_type=4 then
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if  gamma_var>=a1 then
	return 1;
    elsif delta_var> a2 then
	return round((delta_var-a2)/(a4-gamma_var+delta_var),2);
    else
	return 0;
    end if;
  elsif f_type=5 then
    if  f1>=a1 then
	return 1;
    elsif f1> a2 then
	return round((f1-a2)/a4,2);
    else
	return 0;
    end if;
  elsif f_type=6 then
    if  f1>=a1 then
	return 1;
    elsif f3> a2 then
	return round((f3-a2)/(a4+f4),2);
    else
	return 0;
    end if;
  else
    if  a2   >=f4 then
	return 0;
    elsif f3+f4>=a1 then
	return 1;
    else
	return round((f4-a2)/(a4-f3),2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'mayor o igual' (fgeq) que un trapecio
-- caso ejemplo: fcol_t2 fgeq $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_fgeq_trape (
				    	 numeric, numeric, 
				     	 numeric, numeric,
 	   			    	 fuzzy_label_def.obj%type, 
				    	 fuzzy_label_def.obj%type,
				    	 fuzzy_col_list.f_type%type,
				    	 numeric, numeric, 
				    	 numeric, numeric);
create function fsql_functions_fgeq_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as'
declare
  t1        alias for $1;
  t2        alias for $2;
  t3        alias for $3;
  t4        alias for $4;
  obj_var   alias for $5; 
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq_trape'');
  if f_type=0 then 
      return fsql_functions_mayormenor_unknown(7); 
  elsif f_type=1 then 
      return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
      return fsql_functions_mayormenor_null(7);
  elsif f_type=3 then 
    if t1>=f1 then 
      return 0;
    elsif f1>=t1+t2 then 
      return 1;
    else
      return round((f1-t1)/t2,2);
    end if;
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if t1>=delta_var then 
       return 0;
    elsif gamma_var>=t1+t2 then 
       return 1;
    else
       return round((t1-delta_var)/(gamma_var-delta_var-t2),2);
    end if;
  elsif f_type=5 then 
    if t1>=f4 then 
       return 0;
    elsif f4>=t1+t2 then 
       return 1;
    else
       return round((f4-t1)/t2,2);
    end if;
  elsif f_type=6 then 
    if t1>=f3 then 
       return 0;
    elsif f1>=t1+t2 then 
       return 1;
    else
       return round((f3-t1)/(f4+t2),2);
    end if;
  else
    if t1>=f4 then 
      return 0;
    elsif f3+f4>=t1+t2 then 
      return 1;
    else 
      return round((t1-f4)/(f3-t2),2);
    end if;
  end if;
end;
'language 'plpgsql';



--********************************************************************
-- funcion difusa de comparacion: "aproximadamente mayor o igual",
-- fgeq (fuzzy greater or equal).
-- indica si una columna difusa tipo 2 es 'mayor o igual' (fgeq) que otra
-- caso ejemplo: fcol1_t2 fgeq fcol2_t2
--********************************************************************
drop function fsql_functions_fgeq (
  				     fuzzy_label_def.obj%type,  
  				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric ,numeric); 
create function fsql_functions_fgeq (
  				     fuzzy_label_def.obj%type,  
  				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric ,numeric) 
returns numeric as'
declare
  obj1_var  alias for $1;  
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;   
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14; 
  alfa_var  fuzzy_label_def.alfa%type; 
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fgeq'');
  if f_type2=0 then 
     return fsql_functions_mayormenor_unknown(f_type1);
  elsif f_type2=1 or f_type1=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type2=2 then 
     return fsql_functions_mayormenor_null(f_type1);
  elsif f_type1=0 then 
     return fsql_functions_mayormenor_unknown(f_type2); 
  elsif f_type1=2 then 
     return fsql_functions_mayormenor_null(f_type2);
  elsif f_type2=3 then 
    return fsql_functions_fgeq_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
        return fsql_functions_fgeq_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,
					 delta_var,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then 
    return fsql_functions_fgeq_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=6 then 
    return fsql_functions_fgeq_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else 
    return fsql_functions_fgeq_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';


--********************** comparador difuso flt **********************--

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor' (flt) que un intervalo [x,y]
-- comparacion del tipo: fcol_t1 flt [3,6]
-- en ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [x-margen, x, y, y+margen]
-- si no se desea difuminar usar comparacion crisp: fcol_t1 < 3
----------------------------------------------------------------------
drop function fsql_functions_flt_crisp_finter (
  						 numeric, numeric, 
						 numeric, numeric);

create function fsql_functions_flt_crisp_finter (
  						 numeric, numeric, 
						 numeric, numeric)
returns numeric as'
declare
  crisp  alias for $1;
  x      alias for $2;
  y      alias for $3;
  margen alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_crisp_finter'');
  if crisp<=(x-margen) then 
     return 1;
  elsif crisp<x then 
     return round( (x-crisp)/margen ,2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor' (flt) que un intervalo [x,y]
-- no se exporta
----------------------------------------------------------------------
drop function fsql_functions_flt_crisp_inter (numeric, numeric, numeric);
create function fsql_functions_flt_crisp_inter (numeric, numeric, numeric)
returns numeric as '
declare
  crisp  alias for $1;
  x      alias for $2;
  y      alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_crisp_inter'');
  if crisp<x then 
     return 1;
  else 
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si un valor crisp es 'menor' (flt) que un valor aprox
-- caso ejemplo: fcol_t1 flt #6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions_flt_crisp_aprox (
					        numeric,
						numeric, numeric, 
						numeric, numeric);
create function fsql_functions_flt_crisp_aprox (
					        numeric,
						numeric, numeric, 
						numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_crisp_aprox'');
  if crisp<=f2 then 
     return 1;
  elsif crisp< f1 then 
     return round((f1-crisp)/f4 ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor' (flt) que un valor crisp que
-- se difumina a uno aprox. f1 + - f4
-- caso ejemplo: fcol_t1 flt 6
----------------------------------------------------------------------
drop function fsql_functions_flt_t1_t1 (numeric, numeric, numeric); 
create function fsql_functions_flt_t1_t1 (numeric, numeric, numeric) 
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f4    alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_t1_t1'');
  if crisp<=(f1-f4) then 
     return 1;
  elsif crisp< f1 then 
     return round( (f1-crisp)/f4 ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si un valor crisp es 'menor' (flt) que un trapecio
-- caso ejemplo: fcol_t1 flt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions_flt_crisp_trape (
  						numeric,
						numeric, numeric, 
						numeric, numeric);
create function fsql_functions_flt_crisp_trape (
  						numeric,
						numeric, numeric, 
						numeric, numeric)
returns numeric as'
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3; 
  f3    alias for $4;
  f4    alias for $5;
begin 
  insert into trama values(nextval(''sec''),''fsql_functions_flt_crisp_trape'');
  if crisp<=f1 then 
     return 1;
  elsif crisp<f1+f2 then 
     return round( (f1+f2-crisp)/f2 ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'menor' (flt) que una
-- columna tipo 2. formato: fcol_t1 flt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions_flt_t1_t2 (
  					  numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric);
create function fsql_functions_flt_t1_t2 (
  					  numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_t1_t2'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then 
    if crisp<f1 then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if crisp<=alfa_var then 
       return 1;
    elsif crisp<beta_var then 
       return round( (beta_var-crisp)/(beta_var-alfa_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    return fsql_functions_flt_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then 
    return fsql_functions_flt_crisp_aprox(crisp,f1,f2,f3,f4);
  else                
    return fsql_functions_flt_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor' (flt) que un valor crisp
-- caso ejemplo: fcol_t2 flt 8. tambien: fcol_t2 flt fcol_t1
--********************************************************************
drop function fsql_functions_flt_crisp (
					  numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_flt_crisp (
					  numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_crisp'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then 
    if f1<crisp then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj and col=col and fuzzy_id=f1;
    if alfa_var>=crisp then 
       return 0;
    elsif beta_var>crisp then 
       return round( (crisp-alfa_var)/(beta_var-alfa_var) ,2);
    else  
       return 1;
    end if;
  elsif f_type=5 then 
    if f1<crisp then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=6 then 
    if f1<=crisp then 
       return 1;
    elsif f2< crisp then 
       return round( (crisp-f2)/f4 ,2);
    else  
       return 0;
    end if;
  else  
    if f1>=crisp then 
       return 0;
    elsif f1+f2<=crisp then 
       return 1;
    else
       return round( (crisp-f1)/f2 ,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor' (flt) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 flt [x,y]
--********************************************************************
drop function fsql_functions_flt_inter (
					  numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric);
create function fsql_functions_flt_inter (
					  numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric)
returns numeric as '
declare
  x	   alias for $1;	
  y        alias for $2;  
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_inter'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(5); 
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(5);
  elsif f_type=3 then 
    if f1<x then 
       return 1;
    else
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=x then 
       return 0;
    elsif beta_var>x then 
       return round( (x-alfa_var)/(beta_var-alfa_var) ,2);
    else  
       return 1;
    end if;
  elsif f_type=5 then 
    if f1<x then 
       return 1;
    else
       return 0;
    end if;
  elsif f_type=6 then 
    if f1<=x then 
       return 1;
    elsif f2< x then 
       return round( (x-f2)/f4 ,2);
    else  
       return 0;
    end if;
  else 
    if f1>=x then 
       return 0;
    elsif f1+f2<=x then 
       return 1;
    else
       return round( (x-f1)/f2 ,2);
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor' (flt) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 flt #a1
--********************************************************************
drop function fsql_functions_flt_aprox (
					  numeric, numeric, numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric);
create function fsql_functions_flt_aprox (
					  numeric, numeric, numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric, 
					  numeric, numeric)
returns numeric as '
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_aprox'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(6);
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(6);
  elsif f_type=3 then 
    if f1<=a2 then 
       return 1;
    elsif f1>=a1 then
       return 0;
    else    
       return round( (a1-f1)/a4 ,2);
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=a1 then 
       return 0;
    elsif beta_var> a2 then 
       return round( (a1-alfa_var)/(beta_var-alfa_var+a4) ,2);
    else  
       return 1;
    end if;
  elsif f_type=5 then 
    if f1<=a2 then 
       return 1;
    elsif f1>=a1 then 
       return 0;
    else
       return round( (a1-f1)/a4 ,2);
    end if;
  elsif f_type=6 then 
    if f2>=a1 then 
       return 0;
    elsif f1> a2 then 
       return round( (a1-f2)/(f4+a4) ,2);
    else
       return 1;
    end if;
  else  
    if f1>=a1 then 
       return 0;
    elsif f2+f1> a2 then 
       return round( (a1-f1)/(f2+a4) ,2);
    else  
       return 1;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor' (flt) que un trapecio
-- caso ejemplo: fcol_t2 flt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_flt_trape (
					  numeric, numeric, 
					  numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric);
create function fsql_functions_flt_trape (
					  numeric, numeric, 
					  numeric, numeric,
					  fuzzy_label_def.obj%type, 
					  fuzzy_label_def.obj%type,
					  fuzzy_col_list.f_type%type,
					  numeric, numeric,
					  numeric, numeric)
returns numeric as'
declare
  t1       alias for $1;
  t2       alias for $2;
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt_trape'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(7);
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(7);
  elsif f_type=3 then 
    if f1<=t1 then 
       return 1;
    elsif f1>=t1+t2 then
       return 0;
    else                
       return round( (t1+t2-f1)/t2 ,2);
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=t1+t2 then
       return 0;
    elsif beta_var>t1 then 
       return round( (t1+t2-alfa_var)/(beta_var-alfa_var+t2) ,2);
    else  
       return 1;
    end if;
  elsif f_type=5 then 
    if f1<=t1 then
       return 1;
    elsif f1>=t1+t2 then 
       return 0;
    else
       return round( (t1+t2-f1)/t2 ,2);
    end if;
  elsif f_type=6 then 
    if f1<=t1 then 
       return 1;
    elsif f2< t1+t2 then 
       return round( (t1+t2-f2)/(f4+t2) ,2);
    else
       return 1;
    end if;
  else  
    if f1>=t1+t2 then 
       return 0;
    elsif f2+f1>t1 then 
       return round( (t1+t2-f1)/(f2+t2) ,2);
    else 
       return 1;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion: "aproximadamente menor que",
-- flt (fuzzy less than).
-- indica si una columna difusa tipo 2 es 'menor que' (flt) otra
-- caso ejemplo: fcol1_t2 flt fcol2_t2
--********************************************************************
drop function fsql_functions_flt (
				    fuzzy_label_def.obj%type, 
  				    fuzzy_label_def.obj%type,
  				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric,
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric);
create function fsql_functions_flt (
				    fuzzy_label_def.obj%type, 
  				    fuzzy_label_def.obj%type,
  				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric,
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric) 
returns numeric as '
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_flt'');
  if f_type2=0 then 
     return fsql_functions_mayormenor_unknown(f_type1);
  elsif f_type2=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type2=2 then 
     return fsql_functions_mayormenor_null(f_type1);
  elsif f_type1=0 then 
     return fsql_functions_mayormenor_unknown(f_type2);
  elsif f_type1=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type1=2 then 
     return fsql_functions_mayormenor_null(f_type2);
  elsif f_type2=3 then 
     return fsql_functions_flt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
        return fsql_functions_flt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,delta_var,
                                        obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then 
    return fsql_functions_flt_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=6 then 
    return fsql_functions_flt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else 
    return fsql_functions_flt_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';

--********************** comparador difuso fleq **********************--

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor o igual' (fleq) que un intervalo [x,y]
-- comparacion del tipo: fcol_t1 fleq [3,6]
-- en ese caso, difuminamos el intervalo con el margen de fcol_t1,
-- obteniendo el trapecio [x-margen, x, y, y+margen]
-- si no se desea difuminar usar comparacion crisp: fcol_t1 <= 6
----------------------------------------------------------------------
drop function fsql_functions_fleq_crisp_finter (
  						  numeric, numeric, 
						  numeric, numeric);
create function fsql_functions_fleq_crisp_finter (
  						  numeric, numeric, 
						  numeric, numeric)
returns numeric as '
declare
  crisp  alias for $1;
  x      alias for $2;
  y      alias for $3;
  margen alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_crisp_finter'');
  if (y+margen)<=crisp then 
     return 0;
  elsif y>=crisp then 
     return 1;
  else
     return round((y+margen-crisp)/margen,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor o igual' (fleq) que un valor aprox
-- caso ejemplo: fcol_t1 fleq #6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions_fleq_crisp_aprox (
  					  	 numeric,
					   	 numeric, numeric, 
					  	 numeric, numeric);
create function fsql_functions_fleq_crisp_aprox (
	  					 numeric,
					  	 numeric, numeric, 
					  	 numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_crisp_finter'');
  if crisp<=f1 then 
     return 1;
  elsif crisp< f3 then 
     return round((f3-crisp)/f4,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor o igual' (fleq) que un valor crisp que
-- se difumina a un aprox f1 + - f4
-- caso ejemplo: fcol_t1 fleq 6
----------------------------------------------------------------------
drop function fsql_functions_fleq_t1_t1 (numeric, numeric, numeric);
create function fsql_functions_fleq_t1_t1 (numeric, numeric, numeric) 
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f4    alias for $3;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_t1_t1'');
  if crisp<=f1 then 
     return 1;
  elsif crisp< (f1+f4) then 
     return round((f1+f4-crisp)/f4,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor o igual' (fleq) que un trapecio
-- caso ejemplo: fcol_t1 fleq $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions_fleq_crisp_trape (
						 numeric,
						 numeric, numeric, 
						 numeric, numeric);
create function fsql_functions_fleq_crisp_trape (
						 numeric,
						 numeric, numeric, 
						 numeric, numeric)
returns numeric as '
declare
  crisp alias for $1;
  f1    alias for $2;
  f2    alias for $3;
  f3    alias for $4;
  f4    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_crisp_trape'');
  if f4<=crisp then 
     return 0;
  elsif f3+f4>=crisp then 
     return 1;
  else 
     return round((crisp-f4)/f3,2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'menor o igual' (fleq) que una etiqueta
-- no se exporta (caso fcol_t1 fleq $label se traduce a fleq_crisp_trape)
----------------------------------------------------------------------
drop function fsql_functions_fleq_crisp_label (
  				  		 numeric,
						 fuzzy_label_def.obj%type, 
				  		 fuzzy_label_def.obj%type,
				  		 fuzzy_label_def.fuzzy_id%type); 
create function fsql_functions_fleq_crisp_label (
  				  		 numeric,
						 fuzzy_label_def.obj%type, 
				  		 fuzzy_label_def.obj%type,
				  		 fuzzy_label_def.fuzzy_id%type) 
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_id      alias for $4;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_crisp_label'');
  select into gamma_var,delta_var gamma,delta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if delta_var<=crisp then 
     return 1;
  elsif gamma_var>=crisp then 
     return 0;
  else
     return round((crisp-delta_var)/(gamma_var-delta_var),2);
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'menor o igual' (fleq) que una
-- columna tipo 2. formato: fcol_t1 fleq fcol_t2
----------------------------------------------------------------------
drop function fsql_functions_fleq_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_fleq_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_t1_t2'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then 
    if crisp<=f1 then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    return fsql_functions_fleq_crisp_label(crisp,obj_var,col_var,f1);
  elsif f_type=5 then
    if crisp<=f4 then
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=6 then 
       return fsql_functions_fleq_crisp_aprox(crisp,f1,f2,f3,f4);
  else  
       return fsql_functions_fleq_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor o igual' (fleq) que un valor crisp
-- caso ejemplo: fcol_t2 fleq 8. tambien: fcol_t2 fleq fcol_t1
--********************************************************************
drop function fsql_functions_fleq_crisp (
  					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_fleq_crisp (
  					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1	   alias for $5;
  f2	   alias for $6;
  f3 	   alias for $7;
  f4	   alias for $8;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_crisp'');
  if f_type=0 then 
     return fsql_functions_mayormenor_unknown(3);
  elsif f_type=1 then 
     return fsql_functions_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions_mayormenor_null(3);
  elsif f_type=3 then 
    if f1<=crisp then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    return fsql_functions_fgeq_crisp_label(crisp,obj_var,col_var,f1);
  elsif f_type=5 then 
    return fsql_functions_fgeq_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then 
    return fsql_functions_fgeq_crisp_aprox(crisp,f1,f2,f3,f4);
  else 
    return fsql_functions_fgeq_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor o igual' (fleq) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 fleq [x,y]
--********************************************************************
drop function fsql_functions_fleq_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric);
create function fsql_functions_fleq_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric)
returns numeric as '
declare
  x       alias for $1;
  y       alias for $2;
  obj_var alias for $3;
  col_var alias for $4;
  f_type  alias for $5;
  f1      alias for $6;
  f2	  alias for $7;
  f3	  alias for $8;
  f4	  alias for $9;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_inter'');
  return fsql_functions_fgeq(null,null,5,x,null,null,y,obj_var,col_var,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor o igual' (fleq) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 fleq #a1
--********************************************************************
drop function fsql_functions_fleq_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_fleq_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  a1      alias for $1;
  a2      alias for $2;
  a3      alias for $3;
  a4      alias for $4;
  obj_var alias for $5;
  col_var alias for $6;
  f_type  alias for $7;
  f1      alias for $8;
  f2	  alias for $9;
  f3	  alias for $10;
  f4	  alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_aprox'');
  return fsql_functions_fgeq(null,null,6,a1,a2,a3,a4,
			     obj_var,col_var,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor o igual' (fleq) que un trapecio
-- caso ejemplo: fcol_t2 fleq $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_fleq_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_fleq_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  t1      alias for $1;
  t2      alias for $2;
  t3      alias for $3;
  t4      alias for $4;
  obj_var alias for $5;
  col_var alias for $6;
  f_type  alias for $7;
  f1      alias for $8;
  f2	  alias for $9;
  f3	  alias for $10;
  f4	  alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq_trape'');
  return fsql_functions_fgeq(null,null,7,t1,t2,t3,t4,
              obj_var ,col_var ,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';


--********************************************************************
-- funcion difusa de comparacion: "aproximadamente menor o igual",
-- fleq (fuzzy less or equal).
-- indica si una columna difusa tipo 2 es 'menor o igual' (fleq) que otra
-- caso ejemplo: fcol1_t2 fleq fcol2_t2
--********************************************************************
drop function fsql_functions_fleq (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric); 
create function fsql_functions_fleq (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric) 
returns numeric as '
declare
  obj1_var alias for $1;
  col1_var alias for $2; 
  f_type1  alias for $3;
  f11      alias for $4;
  f21      alias for $5;
  f31      alias for $6;
  f41      alias for $7;
  obj2_var alias for $8;
  col2_var alias for $9;
  f_type2  alias for $10;
  f12      alias for $11;
  f22      alias for $12;
  f32      alias for $13;
  f42      alias for $14;

begin
  insert into trama values(nextval(''sec''),''fsql_functions_fleq'');
  return fsql_functions_fgeq(obj2_var,col2_var,f_type2,f12,f22,f32,f42,
              obj1_var,col1_var,f_type1,f11,f21,f31,f41);
end;
'language 'plpgsql';

--********************** comparador difuso nfeq **********************--

--********************************************************************
-- indica la necesidad de que un valor x sea f. no es conmutativa.
-- ambos valorex x y f son trapecios que se suponen bien definidos, es decir:
-- x1<=x2<=x3<=x4 y f1<=f2<=f3<=f4
--********************************************************************
drop function fsql_functions_necesidad(
    					 numeric, numeric, 
					 numeric, numeric,
			                 numeric, numeric, 
					 numeric, numeric);
create function fsql_functions_necesidad(
    					 numeric, numeric, 
					 numeric, numeric,
			                 numeric, numeric, 
					 numeric, numeric)
returns numeric as '
declare
  x1    alias for $1;
  x2    alias for $2;
  x3    alias for $3;
  x4    alias for $4;
  f1    alias for $5;
  f2    alias for $6;
  f3    alias for $7;
  f4    alias for $8;
  num1  numeric;
  num2  numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_necesidad'');
  if (x2<=f1 and x1<>f2) or (f4<=x3 and x4<>f3) then 
     return 0;
  elsif x1<f2 then
     if f3<x4 then
        num1:=(x2-f1)/((f2-f1)-(x1-x2));
        num2:=(x3-f4)/((f3-f4)-(x4-x3));
        if num1 < num2 then
           return round(num1,2);
        else
           return round(num2,2);
        end if;
     else 
        return round((x2-f1)/((f2-f1)-(x1-x2)),2);
     end if;
  elsif f3<x4 then
     return round((x3-f4)/((f3-f4)-(x4-x3)),2);
  else
     return 1;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea un valor crisp
-- caso ejemplo: fcol_t2 nfeq 8. tambien: fcol_t2 nfeq fcol_t1
-- en realidad esta comparacion se usara muy poco, ya que practicamente
-- en todos los casos esta necesidad es cero.
-- el caso mas interesante es cuando queremos ver las tuplas que toman
-- justo un valor crisp x en una columna difusa tipo 2: fcol_t2 nfeq x
-- esa condicion tambien puede ser vista usando la columna difusa tipo 2
-- en una comparacion crisp: fcol_t2 = 'x' (hay que poner las comillas).
--********************************************************************
drop function fsql_functions_nfeq_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nfeq_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfeq_crisp '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
    if f1=crisp then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
     select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
       from fuzzy_label_def
       where obj=obj_var and col=col_var and fuzzy_id=f1;
     if alfa_var=beta_var and beta_var=gamma_var 
        and gamma_var=delta_var and alfa_var=crisp then
          return 1; 
     else 
        return 0;
     end if;
  elsif f_type=5 then 
     if f1=f4 and f1=crisp then 
        return 1; 
     else 
        return 0;
     end if;
  elsif f_type=6 then 
     if f4=0 and f1=crisp then 
        return 1; 
     else
        return 0;
     end if;
  else 
     if f2=0 and f3=0 and f1=f4 and f1=crisp then
        return 1; 
     else 
        return 0;
     end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 este en un intervalo [x,y]
-- caso ejemplo: fcol_t2 nfeq [x,y]
--********************************************************************
drop function fsql_functions_nfeq_inter (
  					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric);
create function fsql_functions_nfeq_inter (
  					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric)
returns numeric as'
declare
  x         alias for $1;
  y         alias for $2;
  obj_var   alias for $3;
  col_var   alias for $4;
  f_type    alias for $5;
  f1        alias for $6;
  f2        alias for $7;
  f3        alias for $8;
  f4        alias for $9;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfeq_inter '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then
    if f1 between x and y then
       return 1; 
    else
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
        return fsql_functions_necesidad(alfa_var,beta_var,gamma_var,delta_var,x,x,y,y);
  elsif f_type=5 then 
    if f1>=x and f4<=y then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=6 then 
    return fsql_functions_necesidad(f2,f1,f1,f3,x,x,y,y);
  else 
    return fsql_functions_necesidad(f1,f2+f1,f3+f4,f4,x,x,y,y);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 este en un aprox #a1
-- caso ejemplo: fcol_t2 nfeq #a1
--********************************************************************
drop function fsql_functions_nfeq_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric);
create function fsql_functions_nfeq_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric)
returns numeric as '
declare
  a1        alias for $1;
  a2        alias for $2;
  a3        alias for $3;
  a4        alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11; 
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfeq_aprox '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions_feq_crisp_aprox(f1,a1,a2,a3,a4);
  elsif f_type=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
       from fuzzy_label_def
       where obj=obj_var and col=col_var and fuzzy_id=f1;
    return fsql_functions_necesidad(alfa_var,beta_var,gamma_var,delta_var,a2,a1,a1,a3);
  elsif f_type=5 then 
    return fsql_functions_necesidad(f1,f1,f4,f4,a2,a1,a1,a3);
  elsif f_type=6 then
    return fsql_functions_necesidad(f2,f1,f1,f3,a2,a1,a1,a3);
  else 
    return fsql_functions_necesidad(f1,f2+f1,f3+f4,f4,a2,a1,a1,a3);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 este en un trapecio
-- caso ejemplo: fcol_t2 nfeq $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_nfeq_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);

create function fsql_functions_nfeq_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  t1        alias for $1;
  t2	    alias for $2;
  t3 	    alias for $3;
  t4	    alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1	    alias for $8;
  f2        alias for $9;
  f3	    alias for $10;
  f4	    alias for $11;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfeq_trape '');
  if f_type in (0,1,2) then
     return 0;
  elsif f_type=3 then
        return fsql_functions_feq_crisp_trape(f1,t1,t2,t3,t4);
  elsif f_type=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    return fsql_functions_necesidad(alfa_var,beta_var,gamma_var,delta_var,t1,t2+t1,t3+t4,t4);
  elsif f_type=5 then 
    return fsql_functions_necesidad(f1,f1,f4,f4,t1,t2+t1,t3+t4,t4);
  elsif f_type=6 then 
    return fsql_functions_necesidad(f2,f1,f1,f3,t1,t2+t1,t3+t4,t4);
  else 
    return fsql_functions_necesidad(f1,f2+f1,f3+f4,f4,t1,t2+t1,t3+t4,t4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion que devuelve la necesidad, nfeq,
-- de que una columna difusa tipo 2 sea 'igual' a otra columna tipo 2.
-- caso ejemplo: fcol1_t2 nfeq fcol2_t2
--********************************************************************
drop function fsql_functions_nfeq (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
 				     numeric, numeric, 
				     numeric, numeric); 
create function fsql_functions_nfeq (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
 				     numeric, numeric, 
				     numeric, numeric) 
returns numeric as '
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  alfa_var  fuzzy_label_def.alfa%type; 
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type; 
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfeq  '');
  if f_type1 in (0,1,2) or f_type2 in (0,1,2) then 
     return 0;
  elsif f_type2=3 then 
     return fsql_functions_nfeq_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=4 then
     select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta
       from fuzzy_label_def
       where obj=obj2_var and col=col2_var and fuzzy_id=f12;
     return fsql_functions_nfeq_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,
				      delta_var,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then 
     return fsql_functions_nfeq_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=6 then 
     return fsql_functions_nfeq_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else
     return fsql_functions_nfeq_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';

--********************** comparador difuso nfgt **********************--

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor' (nfgt)
-- que un valor crisp
-- caso ejemplo: fcol_t2 nfgt 8. tambien: fcol_t2 nfgt fcol_t1
--********************************************************************
drop function fsql_functions_nfgt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nfgt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;  
  f1	   alias for $5;
  f2	   alias for $6;
  f3  	   alias for $7;
  f4	   alias for $8;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgt_crisp  '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
    if f1>crisp  then 
       return 1; 
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=crisp then 
       return 1;
    elsif beta_var> crisp then 
       return round( (beta_var-crisp)/(beta_var-alfa_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    if f1>crisp then 
       return 1;
    else
       return 0;
    end if;
  elsif f_type=6 then 
    if f2>=crisp then
       return 1;
    elsif f1> crisp then 
       return round( (f1-crisp)/f4 ,2);
    else
       return 0;
    end if;
  else 
    if f1>=crisp then 
       return 1;
    elsif f2+f1> crisp then 
       return round( (f1+f2-crisp)/f2 ,2);
    else  
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor' (nfgt)
-- que un intervalo [x,y]. caso ejemplo: fcol_t2 nfgt [x,y]
--********************************************************************
drop function fsql_functions_nfgt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nfgt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  x        alias for $1; 
  y        alias for $2;
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgt_inter '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then
    if f1>y then 
       return 1; 
    else
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=y then 
      return 1;
    elsif beta_var> y then 
      return round( (beta_var-y)/(beta_var-alfa_var) ,2);
    else  
      return 0;
    end if;
  elsif f_type=5 then 
    if f1>y then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=6 then 
    if f2>=y then 
       return 1;
    elsif f1> y then 
       return round( (f1-y)/f4 ,2);
    else  
       return 0;
    end if;
  else 
    if f1>=y then 
       return 1;
    elsif f2+f1> y then 
       return round( (f1+f2-y)/f2 ,2);
    else 
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor' (nfgt)
-- que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nfgt #a1
--********************************************************************
drop function fsql_functions_nfgt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
  					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nfgt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
  					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5; 
  col_var  alias for $6; 
  f_type   alias for $7; 
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgt_aprox '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions_fgt_crisp_aprox(f1,a1,a2,a3,a4);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=a3 then 
       return 1;
    elsif beta_var>a1 then 
       return round( (beta_var-a1)/(a4+beta_var-alfa_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then
    if f1>=a3 then 
       return 1;
    elsif f1> a1 then 
       return round( (f1-a1)/a4 ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then
    if f2>=a3 then
       return 1;
    elsif f1> a1 then 
       return round( (f1-a1)/(a4+f4) ,2);
    else 
       return 0;
    end if;
  else 
    if f1 >=a3 then 
       return 1;
    elsif f2+f1>a1 then 
       return round( (f2+f1-a1)/(a4+f2) ,2);
    else 
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor' (nfgt)
-- que un trapecio. caso ejemplo: fcol_t2 nfgt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_nfgt_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nfgt_trape (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  t1       alias for $1;
  t2       alias for $2;
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5; 
  col_var  alias for $6; 
  f_type   alias for $7; 
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgt_trape '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions_fgt_crisp_trape(f1,t1,t2,t3,t4);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=t4 then
       return 1;
    elsif beta_var> t3+t4 then 
       return round( (t3+t4-beta_var)/(alfa_var-beta_var+t3) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    if f1>=t4 then 
       return 1;
    elsif f1> t3+t4 then 
       return round( (t3+t4-f1)/t3 ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then 
    if f2>=t4 then 
       return 1;
    elsif f1> t3+t4 then 
       return round( (f1-t3-t4)/(f4-t3) ,2);
    else
       return 0;
    end if;
  else 
    if f1>=t4 then 
       return 1;
    elsif f1+f2>t3+t4 then 
       return round( (f1+f2-t3-t4)/(f2-t3) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- funcion difusa de comparacion: "necesariamente mayor que": nfgt
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor' (nfgt)
-- que otra. caso ejemplo: fcol1_t2 nfgt fcol2_t2
--********************************************************************
drop function fsql_functions_nfgt (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric);
create function fsql_functions_nfgt (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric,
				     numeric, numeric)
returns numeric as '
declare
  obj1_var  alias for $1; 
  col1_var  alias for $2; 
  f_type1   alias for $3; 
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8; 
  col2_var  alias for $9; 
  f_type2   alias for $10; 
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  alfa_var  fuzzy_label_def.alfa%type;  
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgt '');
  if f_type1 in (0,1,2) or f_type2 in (0,1,2) then 
     return 0;
  elsif f_type2=3 then 
    return fsql_functions_nfgt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var  alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
    return fsql_functions_nfgt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,
                                     delta_var,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then 
    return fsql_functions_nfgt_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=6 then 
    return fsql_functions_nfgt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else
    return fsql_functions_nfgt_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql'; 


--********************** comparador difuso nfgeq **********************--

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor o igual'
-- (nfgeq) que un valor crisp.
-- caso ejemplo: fcol_t2 nfgeq 8. tambien: fcol_t2 nfgeq fcol_t1
--********************************************************************
drop function fsql_functions_nfgeq_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
   					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfgeq_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
   					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6; 
  f3       alias for $7;
  f4       alias for $8;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgeq_crisp '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type in (3,5) then 
    if f1>=crisp then 
       return 1;
    else
       return 0;
    end if;
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=crisp then 
       return 1;
    elsif beta_var>crisp then return 
       round( (crisp-beta_var)/(alfa_var-beta_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=6 then
    return fsql_functions_flt_crisp_aprox(crisp,f1,f2,f3,f4);
  else  
    return fsql_functions_flt_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor o igual'
-- (nfgeq) que un intervalo [x,y]. caso ejemplo: fcol_t2 nfgeq [x,y]
--********************************************************************
drop function fsql_functions_nfgeq_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfgeq_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  x        alias for $1;
  y	   alias for $2;
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgeq_inter '');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type in (3,5) then 
    if f1>=x then 
       return 1;
    else 
       return 0;
    end if;
  else 
    return fsql_functions_flt (null,null,5,x,null,null,y,
                               obj_var,col_var,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor o igual'
-- (nfgeq) que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nfgeq #a1
--********************************************************************
drop function fsql_functions_nfgeq_aprox (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric);
create function fsql_functions_nfgeq_aprox (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric)
returns numeric as '
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgeq_aprox'');
  if f_type in (0,1,2) then 
     return 0;
  else
     return fsql_functions_flt (null,null,6,a1,a2,a3,a4,
                                obj_var,col_var,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor o igual'
-- (nfgeq) que un trapecio. caso ejemplo: fcol_t2 nfgeq $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_nfgeq_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfgeq_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  t1	   alias for $1;
  t2	   alias for $2;
  t3	   alias for $3;
  t4	   alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgeq_trape'');
  if f_type in (0,1,2) then 
     return 0;
  else 
     return fsql_functions_flt (null,null,7,t1,t2,t3,t4,
		                obj_var ,col_var ,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- funcion difusa de comparacion: "necesariamente mayor o igual que", nfgeq.
-- indica la necesidad de que una columna difusa tipo 2 sea 'mayor o igual que'
-- (nfgeq) otra. caso ejemplo: fcol1_t2 nfgeq fcol2_t2
--********************************************************************
drop function fsql_functions_nfgeq (
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric, numeric,
				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric); 
create function fsql_functions_nfgeq (
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric, numeric,
				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric) 
returns numeric as '
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;

begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfgeq'');
  if f_type1 in (0,1,2) or f_type2 in (0,1,2) then 
     return 0;
  elsif f_type2=3 then
    return fsql_functions_nfgeq_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then
    return fsql_functions_nfgeq_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else 
    return fsql_functions_flt (obj2_var,col2_var,f_type2,f12,f22,f32,f42,
                                  obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';

--*********************************************************************
--- de aki en adelante---

--********************************************************************



--********************** comparador difuso nflt **********************--

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor' (nflt)
-- que un valor crisp.
-- caso ejemplo: fcol_t2 nflt 8. tambien: fcol_t2 nflt fcol_t1
--********************************************************************
drop function fsql_functions_nflt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nflt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nflt_crisp'');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
    if f1<crisp then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if crisp>=delta_var then
       return 1;
    elsif crisp>gamma_var then 
       return round( (gamma_var-crisp)/(gamma_var-delta_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then
    return fsql_functions_fgt_crisp_inter(crisp,f1,f4);
  elsif f_type=6 then 
    return fsql_functions_fgt_crisp_aprox(crisp,f1,f2,f3,f4);
  else  
    return fsql_functions_fgt_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor' (nflt)
-- que un intervalo [x,y]. caso ejemplo: fcol_t2 nflt [x,y]
--********************************************************************
drop function fsql_functions_nflt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
    				 	   numeric, numeric);
create function fsql_functions_nflt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
    				 	   numeric, numeric)
returns numeric as '
declare
  x        alias for $1;
  y        alias for $2;
  obj_var  alias for $3;
  col_var  alias for $4; 
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nflt_inter'');
  return fsql_functions_nfgt (null,null,5,x,null,null,y,
               		      obj_var,col_var,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor' (nflt)
-- que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nflt #a1
--********************************************************************
drop function fsql_functions_nflt_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric);
create function fsql_functions_nflt_aprox (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric)
returns numeric as '
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6; 
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nflt_aprox'');
  return fsql_functions_nfgt(null,null,6,a1,a2,a3,a4,
                             obj_var, col_var,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor' (nflt) que un trapecio
-- caso ejemplo: fcol_t2 nflt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_nflt_trape (
					   numeric, numeric, 
 					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric);
create function fsql_functions_nflt_trape (
					   numeric, numeric, 
 					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric)
returns numeric as '
declare
  t1       alias for $1;
  t2       alias for $2; 
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6; 
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nflt_trape'');
  return fsql_functions_nfgt (null,null,7,t1,t2,t3,t4,
		              obj_var,col_var ,f_type,f1,f2,f3,f4);
end;
'language 'plpgsql';


--********************************************************************
-- funcion difusa de comparacion: "necesariamente menor que", nflt.
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor que'
-- (nflt) otra. caso ejemplo: fcol1_t2 nflt fcol2_t2
--********************************************************************
drop function fsql_functions_nflt (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
 				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric);
create function fsql_functions_nflt (
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
 				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric) 
returns numeric as '
declare
  obj1_var alias for $1;
  col1_var alias for $2; 
  f_type1  alias for $3;
  f11      alias for $4;
  f21      alias for $5;
  f31      alias for $6;
  f41      alias for $7;
  obj2_var alias for $8;
  col2_var alias for $9; 
  f_type2  alias for $10;
  f12      alias for $11;
  f22      alias for $12;
  f32      alias for $13;
  f42      alias for $14;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nflt'');
  return fsql_functions_nfgt (obj2_var,col2_var,f_type2,f12,f22,f32,f42,
                              obj1_var,col1_var,f_type1,f11,f21,f31,f41);
end;
'language 'plpgsql';

--********************** comparador difuso nfleq **********************--

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor o igual'
-- (nfleq) que un valor crisp.
-- caso ejemplo: fcol_t2 nfleq 8. tambien: fcol_t2 nfleq fcol_t1
--********************************************************************
drop function fsql_functions_nfleq_crisp (
					    numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric);
create function fsql_functions_nfleq_crisp (
					    numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric)
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3; 
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfleq_crisp'');
  if f_type in (0,1,2) then
     return 0;
  elsif f_type=3 then 
    if f1<=crisp  then 
       return 1;
    else
       return 0;
    end if;
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta  from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if crisp>=delta_var then 
       return 1;
    elsif crisp>gamma_var then 
       return round( (gamma_var-crisp)/(gamma_var-delta_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then
    if f4<=crisp then 
        return 1;
    else
       return 0;
    end if;
  elsif f_type=6 then 
    return fsql_functions_fgt_crisp_aprox(crisp,f1,f2,f3,f4);
  else  
    return fsql_functions_fgt_crisp_trape(crisp,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor o igual'
-- (nfleq) que un intervalo [x,y]. caso ejemplo: fcol_t2 nfleq [x,y]
--********************************************************************
drop function fsql_functions_nfleq_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfleq_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  x        alias for $1;
  y        alias for $2;
  obj_var  alias for $3;
  col_var  alias for $4; 
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfleq_inter'');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then
    if f1<=y then 
       return 1;
    else 
       return 0;
    end if;
  elsif f_type=5 then 
    if f4<=y then 
       return 1;
    else 
       return 0;
    end if;
  else 
    return fsql_functions_fgt (null,null,5,x,null,null,y,
                               obj_var,col_var,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor o igual' (nfleq)
-- que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nfleq #a1
--********************************************************************
drop function fsql_functions_nfleq_aprox (
					    numeric, numeric, 
					    numeric, numeric,
  					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfleq_aprox (
					    numeric, numeric, 
					    numeric, numeric,
  					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6; 
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfleq_aprox'');
  if f_type in (0,1,2) then 
     return 0;
  else 
     return fsql_functions_fgt(null,null,6,a1,a2,a3,a4,
                   		obj_var,col_var,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica si una columna difusa tipo 2 es 'menor o igual' (nfleq) que un trapecio
-- caso ejemplo: fcol_t2 nfleq $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions_nfleq_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
 					    numeric, numeric, 
					    numeric, numeric);
create function fsql_functions_nfleq_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
 					    numeric, numeric, 
					    numeric, numeric)
returns numeric as '
declare
  t1       alias for $1;
  t2       alias for $2; 
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6; 
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfleq_trape'');
  if f_type in (0,1,2) then
     return 0;
  else 
     return fsql_functions_fgt (null,null,7,t1,t2,t3,t4,
		                  obj_var,col_var,f_type,f1,f2,f3,f4);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion: "necesariamente menor o igual que", nfleq.
-- indica la necesidad de que una columna difusa tipo 2 sea 'menor o igual que'
-- (nfleq) otra. caso ejemplo: fcol1_t2 nfleq fcol2_t2
--********************************************************************
drop function fsql_functions_nfleq (
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric,
  				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric); 
create function fsql_functions_nfleq (
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric,
  				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
				      numeric, numeric) 
returns numeric as '
declare
  obj1_var alias for $1;
  col1_var alias for $2; 
  f_type1  alias for $3;
  f11      alias for $4;
  f21      alias for $5;
  f31      alias for $6;
  f41      alias for $7;
  obj2_var alias for $8;
  col2_var alias for $9; 
  f_type2  alias for $10;
  f12      alias for $11;
  f22      alias for $12;
  f32      alias for $13;
  f42      alias for $14;
begin
  insert into trama values(nextval(''sec''),''fsql_functions_nfleq '');
  if f_type1 in (0,1,2) or f_type2 in (0,1,2) then 
     return 0;
  elsif f_type2=3 then
    return fsql_functions_nfleq_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  elsif f_type2=5 then
    return fsql_functions_nfleq_inter(f12,f42,obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  else 
    return fsql_functions_fgt (obj2_var,col2_var,f_type2,f12,f22,f32,f42,
                               obj1_var,col1_var,f_type1,f11,f21,f31,f41);
  end if;
end;
'language 'plpgsql';
