--********************************************************************
-- comparacion fgt, flt, fgeq, fleq, mgt y mlt de cualquier valor
-- difuso tipo 2 con las ctes difusas unknown, undefined y null.
--********************************************************************

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es mayor o menor que la cte. difusa unknown
----------------------------------------------------------------------
drop function fsql_functions2_mayormenor_unknown (fuzzy_col_list.f_type%type);
create function fsql_functions2_mayormenor_unknown (fuzzy_col_list.f_type%type) 
returns numeric as '
declare
  f_type alias for $1;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mayormenor_unknown'');
  if f_type=1 then 
     return 0;
  else
     return 1;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es mayor o menor que la cte. difusa undefined
----------------------------------------------------------------------
drop function fsql_functions2_mayormenor_undefined();
create function fsql_functions2_mayormenor_undefined()
returns numeric as '
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mayormenor_undefined'');
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un atributo difuso tipo 2 es mayor o menor que la cte. difusa null
----------------------------------------------------------------------
drop function fsql_functions2_mayormenor_null (fuzzy_col_list.f_type%type);
create function fsql_functions2_mayormenor_null (fuzzy_col_list.f_type%type) 
returns numeric as '
declare
  f_type alias for $1;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mayormenor_null'');
  if f_type=1 then 
     return 0;
  else
     return 1;
  end if;
end;
'language 'plpgsql';


--*********** comparador difuso mgt  (much greater than) ***********--
-- para ver si un valor a es 'mucho mayor' que otro b, se le suma a b
-- la constante much (que depende de cada atributo y esta almacenada en
-- la tabla fuzzy_margen_much), y se compara como el comparador fgt.
-- ademas, con los comparadores mgt y mlt se difuminan los valores no difusos:
-- los valores crisp se convierten en un valor aprox y los valores
-- intervalo se convierten en un trapecio:
--	crisp n          ==> n (nmargen)
--	intervalo [x,y]  ==> $[x-margen,x,y,y+margen]
-- esta conversion se realiza porque las comparadores 'mucho...' son difusos
-- por si mismos, por lo que no tratan valores crisp.
-- por esta ultima conversion, no se pueden usar las funciones de comparacion
-- de los comparadores fgt y flt.

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho mayor' (mgt) que un intervalo [x,y]
-- el valor crisp se difumina a un aprox y el intervalo a un trapecio.
-- caso ejemplo: fcol_t1 mgt [3,8]
----------------------------------------------------------------------
drop function fsql_functions2_mgt_crisp_finter (
  						  numeric, numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt_crisp_finter (
  						  numeric, numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as '
declare 
  crisp   alias for $1;
  x       alias for $2;
  y       alias for $3;
  margen  alias for $4;
  much    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_crisp_finter'');
  if crisp>=y+much+margen then 
     return 1;
  elsif crisp+margen>y+much then
        return round( (crisp+margen-y-much)/(margen+margen) ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho mayor' (mgt) que un valor aprox
-- caso ejemplo: fcol_t1 fgt 6
-- valor aprox:  f1  f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions2_mgt_crisp_aprox (
  						 numeric,
						 numeric, numeric, 
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt_crisp_aprox (
  						 numeric,
						 numeric, numeric, 
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp   alias for $1;
  f1      alias for $2;
  f2      alias for $3;
  f3      alias for $4;
  f4      alias for $5;
  margen  alias for $6;
  much    alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_crisp_aprox'');
  if crisp>=f3+much then 
     return 1;
  elsif crisp+margen>f1+much then
    return round( (crisp+margen-f1-much)/(f4+margen) ,2);
  else 
    return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho mayor' (mgt) que un trapecio
-- caso ejemplo: fcol_t1 mgt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions2_mgt_crisp_trape (
						 numeric,
						 numeric, numeric,
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type);
create function fsql_functions2_mgt_crisp_trape (
						 numeric,
						 numeric, numeric,
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type)
returns numeric as '
declare
  crisp   alias for $1;
  f1      alias for $2;
  f2      alias for $3;
  f3      alias for $4;
  f4      alias for $5;
  margen  alias for $6;
  much    alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_crisp_trape'');
  if crisp>=f4+much then 
     return 1;
  elsif crisp+margen>f3+f4+much then
    return round( (crisp+margen-f3-f4-much)/(margen-f3) ,2);
  else  
    return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho mayor' (mgt) que una etiqueta.
-- no se exporta (caso fcol_t1 mgt $label se traduce a mgt_crisp_trape)
----------------------------------------------------------------------
drop function fsql_functions2_mgt_crisp_label (
						 numeric,
						 fuzzy_label_def.obj%type, 
						 fuzzy_label_def.obj%type,
						 fuzzy_label_def.fuzzy_id%type,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt_crisp_label (
						 numeric,
						 fuzzy_label_def.obj%type, 
						 fuzzy_label_def.obj%type,
						 fuzzy_label_def.fuzzy_id%type,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp      alias for $1;
  obj_var    alias for $2;
  col_var    alias for $3;
  f_id       alias for $4;
  margen     alias for $5;
  much       alias for $6;
  gamma_var  fuzzy_label_def.alfa%type;
  delta_var  fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_crisp_label'');
  select into gamma_var,delta_var gamma,delta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if crisp>=delta_var+much then 
     return 1;
  elsif crisp+margen>gamma_var+much then
     return round( (crisp+margen-gamma_var-much)/(delta_var-gamma_var+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp1) es 'mucho mayor' (fgt)
-- que un valor crisp, otra columna tipo 1 o una expresion crisp (crisp2).
-- formatos: fcol_t1 mgt fcol_t1, fcol_t1 mgt crisp2 o fcol_t1 mgt expr_crisp
-- este comparador es difuso 'per se' (no difuminado a partir de uno crisp)
-- por tanto sus comparaciones deben ser mas difuminadas: por ello, se difuminan
-- los 2 valores crisp a comparar suponiendo que ambos crisp son valores aprox.
----------------------------------------------------------------------
drop function fsql_functions2_mgt_t1_t1 (
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt_t1_t1 (
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp1  alias for $1;
  crisp2  alias for $2;
  margen  alias for $3;
  much    alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_t1_t1'');
  if crisp1>=crisp2+margen+much then 
     return 1;
  elsif crisp1+margen>crisp2+much then
     return round( (crisp1+margen-crisp2-much)/(margen+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';
 
----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'mucho mayor' (mgt)
-- que una columna tipo 2. formato: fcol_t1 mgt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions2_mgt_t1_t2 (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mgt_t1_t2 (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp      alias for $1;
  obj_var    alias for $2;
  col_var    alias for $3;
  f_type     alias for $4;
  f1         alias for $5;
  f2         alias for $6;
  f3         alias for $7;
  f4         alias for $8;
  margen     alias for $9;
  much       alias for $10;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_t1_t2'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then  
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type=3 then 
     return fsql_functions2_mgt_t1_t1(crisp,f1,margen,much);
  elsif f_type=4 then return 
     fsql_functions2_mgt_crisp_label(crisp,obj_var,col_var,f1,margen,much);
  elsif f_type=5 then 
     return fsql_functions2_mgt_crisp_finter(crisp,f1,f4,margen,much);
  elsif f_type=6 then 
     return fsql_functions2_mgt_crisp_aprox(crisp,f1,f2,f3,f4,margen,much);
  else
    return fsql_functions2_mgt_crisp_trape(crisp,f1,f2,f3,f4,margen,much);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho mayor' (mgt) que un crisp
-- caso ejemplo: fcol_t2 mgt 8. tambien: fcol_t2 mgt fcol_t1
--********************************************************************
drop function fsql_functions2_mgt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mgt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_type    alias for $4;
  f1        alias for $5;
  f2        alias for $6;
  f3        alias for $7;
  f4        alias for $8;
  margen    alias for $9;
  much      alias for $10;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_crisp'');
  if f_type=0 then
     return fsql_functions2_mayormenor_unknown(3);
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type=3 then 
     return fsql_functions2_mgt_t1_t1(f1,crisp,margen,much);
  elsif f_type=4 then 
     select into gamma_var,delta_var gamma,delta from fuzzy_label_def
       where obj=obj_var and col=col_var and fuzzy_id=f1;
     if gamma_var>=crisp+margen+much then 
        return 1;
     elsif delta_var> crisp+much then 
        return round( (delta_var-crisp-much)/(margen-gamma_var+delta_var) ,2);
     else 
        return 0;
     end if;
  elsif f_type=5 then 
     if f4>=crisp+margen+much then 
        return 1;
     elsif f4+margen>crisp+much then 
        return round( (f4+margen-crisp-much)/(margen+margen) ,2);
     else  
        return 0;
     end if;
  elsif f_type=6 then 
     if f1>=crisp+margen+much then 
        return 1;
     elsif f1+margen>crisp+much then 
        return round( (f3-crisp-much)/(margen+f4) ,2);
     else  
        return 0;
     end if;
  else  
     if f3+f4>=crisp+margen+much then 
        return 1;
     elsif f4>crisp+much then
        return round( (f4-crisp-much)/(margen-f3) ,2);
     else 
        return 0;
     end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho mayor' (mgt) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 mgt [x,y]
--********************************************************************
drop function fsql_functions2_mgt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  x          alias for $1;
  y          alias for $2;
  obj_var    alias for $3;
  col_var    alias for $4;
  f_type     alias for $5;
  f1         alias for $6;
  f2         alias for $7;
  f3         alias for $8;
  f4         alias for $9;
  margen     alias for $10;
  much       alias for $11;
  gamma_var  fuzzy_label_def.alfa%type;
  delta_var  fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_inter'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(5); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(5);
  elsif f_type=3 then 
     return fsql_functions2_mgt_crisp_finter(f1,x,y,margen,much);
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if gamma_var>=y+margen+much then
       return 1;
    elsif delta_var> y+much then 
       return round( (delta_var-y-much)/(margen-gamma_var+delta_var) ,2);
    else
       return 0;
    end if;
  elsif f_type=5 then 
    if f4>=y+margen+much then 
       return 1;
    elsif f1+margen>y+much then 
       return round( (f4+margen-y-much)/(margen+margen) ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then
    if f1>=y+margen+much then 
       return 1;
    elsif f3> y+much then  
       return round( (f3-y-much)/(margen+f4) ,2);
    else
       return 0;
    end if;
  else
    if f3+f4>=y+margen+much then
       return 1;
    elsif f4>y+much then 
       return round( (f4-y-much)/(margen-f3) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho mayor' (mgt) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 mgt a1
--********************************************************************
drop function fsql_functions2_mgt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mgt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type)
returns numeric as '
declare
  a1        alias for $1;
  a2        alias for $2;
  a3        alias for $3;
  a4        alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11;
  margen    alias for $12;
  much      alias for $13;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_aprox'');
  if f_type=0 then
     return fsql_functions2_mayormenor_unknown(6);
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then
     return fsql_functions2_mayormenor_null(6);
  elsif f_type=3 then
     return fsql_functions2_mgt_crisp_aprox(f1,a1,a2,a3,a4,margen,much);
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if gamma_var>=a3+much then
       return 1;
    elsif delta_var> a1+much then 
       return round( (delta_var-a1-much)/(a4-gamma_var+delta_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then
   if f4>=a3+much then 
      return 1;
   elsif f4+margen>a1+much then 
      return round( (f4+margen-a1-much)/(a4+margen) ,2);
   else
      return 0;
   end if;
  elsif f_type=6 then 
    if f1>=a3+much then 
       return 1;
    elsif f3> a1+much then 
       return round( (f3-a1-much)/(a4+f4) ,2);
    else
       return 0;
    end if;
  else 
    if f3+f4>=a3+much then 
       return 1;
    elsif f4>a1+much then 
       return round( (f4-a1-much)/(a4-f3) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho mayor' (mgt) que un trapecio
-- caso ejemplo: fcol_t2 mgt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions2_mgt_trape (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mgt_trape (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type)
returns numeric as '
declare
  t1        alias for $1;
  t2        alias for $2;
  t3        alias for $3;
  t4        alias for $4;
  obj_var   alias for $5;
  col_var   alias for $6;
  f_type    alias for $7;
  f1        alias for $8;
  f2        alias for $9;
  f3        alias for $10;
  f4        alias for $11;
  margen    alias for $12;
  much      alias for $13;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt_trape'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(7); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(7);
  elsif f_type=3 then 
     return fsql_functions2_mgt_crisp_trape(f1,t1,t2,t3,t4,margen,much);
  elsif f_type=4 then 
    select into gamma_var,delta_var gamma,delta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if gamma_var>=t4+much then 
       return 1;
    elsif delta_var> t3+t4+much then 
       return round( (delta_var-t3-t4-much)/(delta_var-gamma_var-t3) ,2);
    else 
       return 0;
    end if;
  elsif f_type=5 then
    if f4 >=t4+much then
       return 1;
    elsif f4+margen> t3+t4+much then 
       return round( (f4+margen-t3-t4-much)/(margen-t3) ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then
    if f1>=t4+much then
       return 1;
    elsif f3> t3+t4+much then 
       return round( (f3-t3-t4-much)/(f4-t3) ,2);
    else
       return 0;
    end if;
  else
    if f3+f4>=t4+much then
       return 1;
    elsif f4>t3+t4+much then 
       return round( (f4-t3-t4-much)/(-f3-t3) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion: "mucho mayor que": mgt (much greater than).
-- indica si una columna difusa tipo 2 es 'mucho mayor que' (mgt) otra
-- caso ejemplo: fcol1_t2 mgt fcol2_t2
--********************************************************************
drop function fsql_functions2_mgt (
				     fuzzy_label_def.obj%type,
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
			  	     numeric, numeric,
				     fuzzy_approx_much.margen%type,
				     fuzzy_approx_much.much%type); 
create function fsql_functions2_mgt (
				     fuzzy_label_def.obj%type,
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
				     numeric, numeric,
				     fuzzy_label_def.obj%type, 
				     fuzzy_label_def.obj%type,
				     fuzzy_col_list.f_type%type,
				     numeric, numeric, 
			  	     numeric, numeric,
				     fuzzy_approx_much.margen%type,
				     fuzzy_approx_much.much%type) 
returns numeric as '
declare
  obj1_var   alias for $1;
  col1_var   alias for $2;
  f_type1    alias for $3;
  f11        alias for $4;
  f21        alias for $5;
  f31        alias for $6;
  f41        alias for $7;
  obj2_var   alias for $8;
  col2_var   alias for $9;
  f_type2    alias for $10;
  f12        alias for $11;
  f22        alias for $12;
  f32        alias for $13;
  f42        alias for $14;
  margen     alias for $15;
  much       alias for $16;
  alfa_var   fuzzy_label_def.alfa%type;  
  gamma_var  fuzzy_label_def.alfa%type;
  beta_var   fuzzy_label_def.alfa%type;  
  delta_var  fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mgt'');
  if f_type2=0 then 
     return fsql_functions2_mayormenor_unknown(f_type1);
  elsif f_type2=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type2=2 then 
     return fsql_functions2_mayormenor_null(f_type1);
  elsif f_type1=0 then 
     return fsql_functions2_mayormenor_unknown(f_type2); 
  elsif f_type1=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type1=2 then 
     return fsql_functions2_mayormenor_null(f_type2);
  elsif f_type2=3 then 
    return fsql_functions2_mgt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=4 then
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
    return fsql_functions2_mgt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,delta_var,
				     obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=5 then
    return fsql_functions2_mgt_inter(f12,f42,obj1_var,col1_var,f_type1,
                                     f11,f21,f31,f41,margen,much);
  elsif f_type2=6 then
    return fsql_functions2_mgt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,
 				     f11,f21,f31,f41,margen,much);
  else 
    return fsql_functions2_mgt_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,
				     f11,f21,f31,f41,margen,much);
  end if;
end;
'language 'plpgsql';


--*********** comparador difuso mlt  (much less than) ***********--
-- para ver si un valor a es 'mucho menor' que otro b, se le resta a b
-- la constante much (que depende de cada atributo y esta almacenada en
-- la tabla fuzzy_margen_much), y se compara como el comparador flt.
-- los crisp e intervalo son difuminados a aprox y trapecio respectivamente.

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho menor' (mlt) que un intervalo [x,y]
-- caso ejemplo: fcol_t1 mlt [3,8]
----------------------------------------------------------------------
drop function fsql_functions2_mlt_crisp_finter (
  						  numeric,
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt_crisp_finter (
  						  numeric, numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as '
declare 
  crisp   alias for $1;
  x       alias for $2;
  y       alias for $3;
  margen  alias for $4;
  much    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_crisp_finter'');
  if crisp<=x-margen-much then 
     return 1;
  elsif crisp-margen<x-much then
     return round( (x-much-crisp+margen)/(margen+margen) ,2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho menor' (mlt) que un valor aprox
-- caso ejemplo: fcol_t1 mlt 6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions2_mlt_crisp_aprox (
						 numeric,
 						 numeric, numeric, 
 						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
 						 fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt_crisp_aprox (
						 numeric,
 						 numeric, numeric, 
 						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
 						 fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp   alias for $1;
  f1      alias for $2;
  f2      alias for $3;
  f3      alias for $4;
  f4      alias for $5;
  margen  alias for $6;
  much    alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_crisp_aprox'');
  if crisp <=f2-much then
     return 1;
  elsif crisp-margen<f1-much then 
     return round( (f1-much-crisp+margen)/(f4+margen) ,2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si un valor crisp es 'mucho menor' (mlt) que un trapecio
-- caso ejemplo: fcol_t1 mlt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions2_mlt_crisp_trape (
						 numeric,
						 numeric, numeric,
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt_crisp_trape (
						 numeric,
						 numeric, numeric,
						 numeric, numeric,
						 fuzzy_approx_much.margen%type,
						 fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp   alias for $1;
  f1      alias for $2;
  f2      alias for $3;
  f3      alias for $4;
  f4      alias for $5;
  margen  alias for $6;
  much    alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_crisp_trape'');
  if crisp<=f1-much then 
     return 1;
  elsif crisp-margen<f1+f2-much then
     return round( (f1+f2-much-crisp+margen)/(f2+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp1) es 'mucho menor' (mlt)
-- que un valor crisp u otra columna tipo 1 (crisp2).
-- formato: fcol_t1 mlt fcol_t1, o tambien  fcol_t1 mlt crisp2
----------------------------------------------------------------------
drop function fsql_functions2_mlt_t1_t1 (
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mlt_t1_t1 (
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type)
returns numeric as '
declare
  crisp1 alias for $1;
  crisp2 alias for $2;
  margen alias for $3;
  much   alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_t1_t1'');
  if crisp1<=crisp2-margen-much then
     return 1;
  elsif crisp1-margen<crisp2-much then
     return round( (crisp2-much-crisp1+margen)/(margen+margen) ,2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'mucho menor' (mlt)
-- que una columna tipo 2. formato: fcol_t1 mlt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions2_mlt_t1_t2 (
    					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mlt_t1_t2 (
    					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  margen   alias for $9;
  much     alias for $10;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_t1_t2'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3);
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then
     return fsql_functions2_mayormenor_null(3);
  elsif f_type=3 then 
     return fsql_functions2_mlt_t1_t1(crisp,f1,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if crisp<=alfa_var-much then 
       return 1;
    elsif crisp-margen<beta_var-much then 
       return round( (beta_var-much-crisp+margen)/(beta_var-alfa_var+margen) ,2);
    else 
       return 0;
    end if;
  elsif f_type=5 then
       return fsql_functions2_mlt_crisp_finter(crisp,f1,f4,margen,much);
  elsif f_type=6 then 
       return fsql_functions2_mlt_crisp_aprox(crisp,f1,f2,f3,f4,margen,much);
  else 
     return fsql_functions2_mlt_crisp_trape(crisp,f1,f2,f3,f4,margen,much);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho menor' (mlt) que un valor crisp
-- caso ejemplo: fcol_t2 mlt 8. tambien: fcol_t2 mlt fcol_t1
--********************************************************************
drop function fsql_functions2_mlt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mlt_crisp (
					   numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  margen   alias for $9;
  much     alias for $10; 
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_crisp'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type in (3,5,6) then
     return fsql_functions2_mlt_t1_t1(f1,crisp,margen,much);
  elsif f_type=4 then
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if beta_var<=crisp-margen-much then 
       return 1;
    elsif alfa_var<crisp-much then 
       return round( (crisp-much-alfa_var)/(beta_var-alfa_var+margen) ,2);
    else  
       return 0;
    end if;
  else  
    if f1+f2<=crisp-margen-much then
       return 1;
    elsif f1<crisp-much then
       return round( (crisp-much-f1)/(f2+margen) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho menor' (mlt) que un intervalo [x,y]
-- caso ejemplo: fcol_t2 mlt [x,y]
--********************************************************************
drop function fsql_functions2_mlt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
 					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt_inter (
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric, 
 					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as '
declare
  x        alias for $1;
  y        alias for $2;
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
  margen   alias for $10;
  much     alias for $11; 
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_inter'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then  
     return fsql_functions2_mayormenor_null(3);
  elsif f_type in (3,5) then
     return fsql_functions2_mlt_t1_t1(f1,x,margen,much);
  elsif f_type=4 then
    select into alfa_var,beta_var alfa,beta  from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if beta_var<=x-margen-much then 
       return 1;
    elsif alfa_var< x-much then 
       return round( (x-much-alfa_var)/(beta_var-alfa_var+margen) ,2);
    else 
       return 0;
    end if;
  elsif f_type=6 then 
    if f1<=x-margen-much then 
       return 1;
    elsif f2< x-much then 
       return round( (x-much-f2)/(f4+margen) ,2);
    else  
       return 0;
    end if;
  else  
    if f1+f2<=x-margen-much then 
       return 1;
    elsif f1< x-much then 
       return round( (x-much-f1)/(f2+margen) ,2);
    else  
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho menor' (mlt) que un aprox [a1,a2,a3,a4]
-- caso ejemplo: fcol_t2 mlt a1
--********************************************************************
drop function fsql_functions2_mlt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type);
create function fsql_functions2_mlt_aprox (
					   numeric, numeric, 
					   numeric, numeric,
					   fuzzy_label_def.obj%type, 
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type)
returns numeric as'
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_aprox'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type in (3,5) then 
     return fsql_functions2_mlt_crisp_aprox(f1,a1,a2,a3,a4,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if beta_var<=a2-much then
       return 1;
    elsif alfa_var< a1-much then
       return round( (a1-much-alfa_var)/(beta_var-alfa_var+a4) ,2);
    else  
       return 0;
    end if;
  elsif f_type=6 then 
    if f1<=a2-much then
       return 1;
    elsif f2< a1-much then 
       return round( (a1-much-f2)/(f4+a4) ,2);
    else 
       return 0;
    end if;
  else 
    if f1+f2<=a2-much then 
       return 1;
    elsif f1<a1-much then 
       return round( (a1-much-f1)/(f2+a4) ,2);
    else  
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- indica si una columna difusa tipo 2 es 'mucho menor' (mlt) que un trapecio
-- caso ejemplo: fcol_t2 mlt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions2_mlt_trape (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt_trape (
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_label_def.obj%type,
					   fuzzy_label_def.obj%type,
					   fuzzy_col_list.f_type%type,
					   numeric, numeric,
					   numeric, numeric,
					   fuzzy_approx_much.margen%type,
					   fuzzy_approx_much.much%type) 
returns numeric as'
declare
  t1       alias for $1;
  t2       alias for $2;
  t3       alias for $3; 
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt_trape'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type in (3,5) then
    return fsql_functions2_mlt_crisp_trape(f1,t1,t2,t3,t4,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if beta_var<=t1-much then 
       return 1;
    elsif alfa_var< t1+t2-much then 
       return round( (t1+t2-much-alfa_var)/(beta_var-alfa_var+t2) ,2);
    else  
       return 0;
    end if;
  elsif f_type=6 then 
    if f1<=t1-much then 
       return 1;
    elsif f2< t1+t2-much then 
       return round( (t1+t2-much-f2)/(f4+t2) ,2);
    else 
       return 0;
    end if;
  else  
    if f1+f2<=t1-much then 
       return 1;
    elsif f1< t1+t2-much then 
       return round( (t1+t2-much-f1)/(f2+t2) ,2);
    else  
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- funcion difusa de comparacion: "mucho menor que": mlt (much less than).
-- indica si una columna difusa tipo 2 es 'mucho menor que' (mlt) otra
-- caso ejemplo: fcol1_t2 mlt fcol2_t2
--********************************************************************
drop function fsql_functions2_mlt (
				    fuzzy_label_def.obj%type,
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric,
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric,
				    numeric, numeric,
				    fuzzy_approx_much.margen%type,
				    fuzzy_approx_much.much%type); 
create function fsql_functions2_mlt (
				    fuzzy_label_def.obj%type,
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric, 
				    numeric, numeric,
				    fuzzy_label_def.obj%type, 
				    fuzzy_label_def.obj%type,
				    fuzzy_col_list.f_type%type,
				    numeric, numeric,
				    numeric, numeric,
				    fuzzy_approx_much.margen%type,
				    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  margen    alias for $15;
  much      alias for $16;
  alfa_var  fuzzy_label_def.alfa%type;
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type; 
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_mlt'');
  if f_type2=0 then 
     return fsql_functions2_mayormenor_unknown(f_type1);
  elsif f_type2=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type2=2 then 
     return fsql_functions2_mayormenor_null(f_type1);
  elsif f_type1=0 then 
     return fsql_functions2_mayormenor_unknown(f_type2);
  elsif f_type1=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type1=2 then 
     return fsql_functions2_mayormenor_null(f_type2);
  elsif f_type2=3 then
    return fsql_functions2_mlt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=4 then 
    select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
      from fuzzy_label_def
      where obj=obj2_var and col=col2_var and fuzzy_id=f12;
    return fsql_functions2_mlt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,delta_var,
                                     obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=5 then 
    return fsql_functions2_mlt_inter(f12,f42,obj1_var,col1_var,f_type1,f11,
                                     f21,f31,f41,margen,much);
  elsif f_type2=6 then 
    return fsql_functions2_mlt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,
                                     f11,f21,f31,f41,margen,much);
  else 
    return fsql_functions2_mlt_trape(f12,f22,f32,f42,obj1_var,col1_var,f_type1,
                                     f11,f21,f31,f41,margen,much);
  end if;
end;
'language 'plpgsql';


--********************** comparador difuso nmgt **********************--

----------------------------------------------------------------------
-- indica la necesidad de que un valor crisp sea 'mucho mayor' (nmgt)
-- que un intervalo [x,y].
-- el valor crisp se difumina a un aprox y el intervalo a un trapecio.
-- caso ejemplo: fcol_t1 nmgt [3,8]
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_crisp_finter (
						   numeric, 
						   numeric, numeric,
						   fuzzy_approx_much.margen%type,
						   fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_crisp_finter (
						   numeric, 
						   numeric, numeric,
						   fuzzy_approx_much.margen%type,
						   fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp  alias for $1;
  x      alias for $2; 
  y      alias for $3;
  margen alias for $4;
  much   alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_crisp_finter'');
  if crisp-margen>=y+much+margen then 
     return 1;
  elsif crisp>y+much then
     return round( (crisp-y-much)/(margen+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica la necesidad de que un valor crisp sea 'mucho mayor' (nmgt)
-- que un valor aprox. caso ejemplo: fcol_t1 fgt 6
-- valor aprox:  f1  f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_crisp_aprox (
						  numeric,
						  numeric, numeric,
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_crisp_aprox (
						  numeric,
						  numeric, numeric,
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp  alias for $1;
  f1     alias for $2;
  f2     alias for $3;
  f3     alias for $4;
  f4     alias for $5;
  margen alias for $6;
  much   alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_crisp_aprox'');
  if crisp-margen>=f3+much then 
     return 1;
  elsif crisp>f1+much then
     return round( (crisp-f1-much)/(f4+margen) ,2);
  else  
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica la necesidad de que un valor crisp sea 'mucho mayor' (nmgt)
-- que un trapecio. caso ejemplo: fcol_t1 nmgt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_crisp_trape (
						  numeric,
						  numeric, numeric,
 						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_crisp_trape (
						  numeric,
						  numeric, numeric,
 						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp  alias for $1;
  f1     alias for $2;
  f2     alias for $3;
  f3     alias for $4;
  f4     alias for $5;
  margen alias for $6;
  much   alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_crisp_trape'');
  if crisp-margen>=f4+much then
     return 1;
  elsif crisp>f3+f4+much then
     return round( (crisp-f3-f4-much)/(margen-f3) ,2);
  else
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica la necesidad de que un valor crisp sea 'mucho mayor' (nmgt) que una etiqueta.
-- no se exporta (caso fcol_t1 nmgt $label se traduce a nmgt_crisp_trape)
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_crisp_label (
						  numeric,
						  fuzzy_label_def.obj%type, 
						  fuzzy_label_def.obj%type,
						  fuzzy_label_def.fuzzy_id%type,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_crisp_label (
						  numeric,
						  fuzzy_label_def.obj%type, 
						  fuzzy_label_def.obj%type,
						  fuzzy_label_def.fuzzy_id%type,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp     alias for $1;
  obj_var   alias for $2;
  col_var   alias for $3;
  f_id      alias for $4;
  margen    alias for $5;
  much      alias for $6;
  gamma_var fuzzy_label_def.alfa%type;
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_crisp_label'');
  select into gamma_var,delta_var gamma,delta from fuzzy_label_def
    where obj=obj_var and col=col_var and fuzzy_id=f_id;
  if crisp-margen>=delta_var+much then 
    return 1;
  elsif crisp>gamma_var+much then
    return round( (crisp-delta_var-much)/(delta_var-gamma_var+margen) ,2);
  else 
    return 0;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- indica la necesidad de que una columna difusa tipo 1 (crisp1) sea
-- 'mucho mayor' (nmgt) que un valor crisp, columna tipo 1 o expresion crisp (crisp2).
-- formatos: fcol_t1 nmgt fcol_t1, fcol_t1 nmgt crisp2 o fcol_t1 nmgt expr_crisp
-- este comparador es difuso 'per se' (no difuminado a partir de uno crisp)
-- por tanto sus comparaciones deben ser mas difuminadas: por ello, se difuminan
-- los 2 valores crisp a comparar suponiendo que ambos crisp son valores aprox.
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_t1_t1 (
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_t1_t1 (
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp1 alias for $1;
  crisp2 alias for $2;
  margen alias for $3;
  much   alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_t1_t1'');
  if crisp1-margen>=crisp2+margen+much then
     return 1;
  elsif crisp1>crisp2+much then
     return round( (crisp1-crisp2-much)/(margen+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';




----------------------------------------------------------------------
-- indica la necesidad de que una columna difusa tipo 1 (crisp) sea
-- 'mucho mayor' (nmgt) que una columna tipo 2: fcol_t1 nmgt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions2_nmgt_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp   alias for $1;
  obj_var alias for $2;
  col_var alias for $3;
  f_type  alias for $4;
  f1      alias for $5;
  f2      alias for $6;
  f3      alias for $7;
  f4      alias for $8;
  margen  alias for $9;
  much    alias for $10;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_t1_t2'');
  if f_type=0 then 
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type=3 then
     return fsql_functions2_nmgt_t1_t1(crisp,f1,margen,much);
  elsif f_type=4 then
     return fsql_functions2_nmgt_crisp_label(crisp,obj_var,col_var,f1,margen,much);
  elsif f_type=5 then 
     return fsql_functions2_nmgt_crisp_finter(crisp,f1,f4,margen,much);
  elsif f_type=6 then 
     return fsql_functions2_nmgt_crisp_aprox(crisp,f1,f2,f3,f4,margen,much);
  else            
     return fsql_functions2_nmgt_crisp_trape(crisp,f1,f2,f3,f4,margen,much);
  end if;
end;
'language 'plpgsql';

--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mucho mayor'
-- (nmgt) que un crisp.
-- caso ejemplo: fcol_t2 nmgt 8. tambien: fcol_t2 nmgt fcol_t1
--********************************************************************
drop function fsql_functions2_nmgt_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  margen   alias for $9;
  much     alias for $10;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_crisp'');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions2_nmgt_t1_t1(f1,crisp,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=crisp+margen+much then
       return 1;
    elsif beta_var> crisp+much then 
       return round( (beta_var-crisp-much)/(margen+beta_var-alfa_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    if f1-margen>=crisp+margen+much then 
       return 1;
    elsif f1>crisp+much then 
       return round( (f1-crisp-much)/(margen+margen) ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then 
    if f2>=crisp+margen+much then
       return 1;
    elsif f1>crisp+much then 
       return round( (f1-crisp-much)/(margen+f4) ,2);
    else
       return 0;
    end if;
  else 
    if f1>=crisp+margen+much then 
       return 1;
    elsif f1+f2>crisp+much then 
       return round( (f1+f2-crisp-much)/(margen+f2) ,2);
    else 
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';




--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mucho mayor'
-- (nmgt) que un intervalo [x,y]. caso ejemplo: fcol_t2 nmgt [x,y]
--********************************************************************
drop function fsql_functions2_nmgt_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
				   	    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
				   	    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  x        alias for $1; 
  y        alias for $2; 
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
  margen   alias for $10;
  much     alias for $11;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_inter'');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions2_nmgt_crisp_finter(f1,x,y,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=y+margen+much then 
       return 1;
    elsif beta_var> y+much then
       return round( (beta_var-y-much)/(margen+beta_var-alfa_var) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    if f1-margen>=y+margen+much then 
       return 1;
    elsif f1>y+much then 
       return round( (f1-y-much)/(margen+margen) ,2);
    else
       return 0;
    end if;
  elsif f_type=6 then 
    if f2>=y+margen+much then 
       return 1;
    elsif f1> y+much then 
       return round( (f1-y-much)/(margen+f4) ,2);
    else 
       return 0;
    end if;
  else 
    if f1>=y+margen+much then 
       return 1;
    elsif f1+f2>y+much then 
       return round( (f1+f2-y-much)/(margen+f2) ,2);
    else 
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';



--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mucho mayor'
-- (nmgt) que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nmgt a1
--********************************************************************
drop function fsql_functions2_nmgt_aprox (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
 					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt_aprox (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
 					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_aprox'');
  if f_type in (0,1,2) then
     return 0;
  elsif f_type=3 then 
     return fsql_functions2_nmgt_crisp_aprox(f1,a1,a2,a3,a4,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=a3+much then
       return 1;
    elsif beta_var> a1+much then 
       return round( (beta_var-a1-much)/(a4+beta_var-alfa_var) ,2);
    else 
       return 0;
    end if;
  elsif f_type=5 then 
   if f1-margen>=a3+much then 
      return 1;
   elsif f1> a1+much then 
      return round( (f1-a1-much)/(a4+margen) ,2);
   else
      return 0;
   end if;
  elsif f_type=6 then
    if f2>=a3+much then 
       return 1;
    elsif f1> a1+much then 
       return round( (f1-a1-much)/(a4+f4) ,2);
    else  
       return 0;
    end if;
  else 
    if f1 >=a3+much then
       return 1;
    elsif f2+f1> a1+much then 
       return round( (f1+f2-a1-much)/(a4+f2) ,2);
    else  
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';




--********************************************************************
-- indica la necesidad de que una columna difusa tipo 2 sea 'mucho mayor'
-- (nmgt) que un trapecio. caso ejemplo: fcol_t2 nmgt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions2_nmgt_trape (
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmgt_trape (
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type)
returns numeric as'
declare
  t1       alias for $1;
  t2       alias for $2;
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13;
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt_trape'');
  if f_type in (0,1,2) then
     return 0;
  elsif f_type=3 then 
     return fsql_functions2_nmgt_crisp_trape(f1,t1,t2,t3,t4,margen,much);
  elsif f_type=4 then 
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if alfa_var>=t4+much then
       return 1;
    elsif beta_var> t3+t4+much then 
       return round( (beta_var-t3-t4-much)/(beta_var-alfa_var-t3) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
   if f1-margen>=t4+much then
      return 1;
   elsif f1> t3+t4+much then
      return round( (f1-t3-t4-much)/(margen-t3) ,2);
   else
      return 0;
   end if;
  elsif f_type=6 then 
    if f2>=t4+much then
       return 1;
    elsif f1> t3+t4+much then
       return round( (f1-t3-t4-much)/(f4-t3) ,2);
    else
       return 0;
    end if;
  else 
    if f1>=t4+much then
       return 1;
    elsif f1+f2> t3+t4+much then 
       return round( (f1+f2-t3-t4-much)/(f2-t3) ,2);
    else
       return 0;
    end if;
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- funcion difusa de comparacion: "necesidad de mucho mayor que": nmgt.
-- indica la necesidad de que una columna difusa tipo 2 sea 'mucho mayor que'
-- (nmgt) otra. caso ejemplo: fcol1_t2 nmgt fcol2_t2
--********************************************************************
drop function fsql_functions2_nmgt (
				      fuzzy_label_def.obj%type, 
   				      fuzzy_label_def.obj%type,
 				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
			 	      numeric, numeric,
				      fuzzy_label_def.obj%type, 	
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
			 	      numeric, numeric, 
				      numeric, numeric,
				      fuzzy_approx_much.margen%type,
				      fuzzy_approx_much.much%type); 
create function fsql_functions2_nmgt (
				      fuzzy_label_def.obj%type, 
   				      fuzzy_label_def.obj%type,
 				      fuzzy_col_list.f_type%type,
				      numeric, numeric, 
			 	      numeric, numeric,
				      fuzzy_label_def.obj%type, 	
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
			 	      numeric, numeric, 
				      numeric, numeric,
				      fuzzy_approx_much.margen%type,
				      fuzzy_approx_much.much%type) 
returns numeric as'
declare
  obj1_var  alias for $1;
  col1_var  alias for $2;
  f_type1   alias for $3;
  f11       alias for $4;
  f21       alias for $5;
  f31       alias for $6;
  f41       alias for $7;
  obj2_var  alias for $8;
  col2_var  alias for $9;
  f_type2   alias for $10;
  f12       alias for $11;
  f22       alias for $12;
  f32       alias for $13;
  f42       alias for $14;
  margen    alias for $15;
  much      alias for $16;
  alfa_var  fuzzy_label_def.alfa%type;
  gamma_var fuzzy_label_def.alfa%type;
  beta_var  fuzzy_label_def.alfa%type;  
  delta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmgt'');
  if f_type2=0 then 
     return fsql_functions2_mayormenor_unknown(f_type1);
  elsif f_type2=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type2=2 then 
     return fsql_functions2_mayormenor_null(f_type1);
  elsif f_type1=0 then 
     return fsql_functions2_mayormenor_unknown(f_type2); 
  elsif f_type1=1 then 
     return fsql_functions2_mayormenor_undefined();
  elsif f_type1=2 then 
     return fsql_functions2_mayormenor_null(f_type2);
  elsif f_type2=3 then 
     return fsql_functions2_nmgt_crisp(f12,obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=4 then 
     select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta 
       from fuzzy_label_def
       where obj=obj2_var and col=col2_var and fuzzy_id=f12;
     return fsql_functions2_nmgt_trape(alfa_var,beta_var-alfa_var,gamma_var-delta_var,delta_var,
				       obj1_var,col1_var,f_type1,f11,f21,f31,f41,margen,much);
  elsif f_type2=5 then
     return fsql_functions2_nmgt_inter(f12,f42,obj1_var,col1_var,f_type1,
				       f11,f21,f31,f41,margen,much);
  elsif f_type2=6 then -- aprox
     return fsql_functions2_nmgt_aprox(f12,f22,f32,f42,obj1_var,col1_var,f_type1,
				       f11,f21,f31,f41,margen,much);
  else 
     return fsql_functions2_nmgt_trape(f12,f22,f32,f42,obj1_var,col1_var,
				       f_type1,f11,f21,f31,f41,margen,much);
  end if;
end;
'language 'plpgsql';


--********************** comparador difuso nmlt **********************--

----------------------------------------------------------------------
-- indica la necesidad de que un valor crisp sea 'mucho menor' (nmlt)
-- que un intervalo [x,y]. caso ejemplo: fcol_t1 nmlt [3,8]
----------------------------------------------------------------------
drop function fsql_functions2_nmlt_crisp_finter (
						   numeric,
						   numeric, numeric,
						   fuzzy_approx_much.margen%type,
						   fuzzy_approx_much.much%type); 
create function fsql_functions2_nmlt_crisp_finter (
						   numeric,
						   numeric, numeric,
						   fuzzy_approx_much.margen%type,
						   fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp   alias for $1;
  x       alias for $2;
  y       alias for $3; 
  margen  alias for $4;
  much    alias for $5;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_crisp_finter'');
  if crisp+margen<=x-margen-much then
     return 1;
  elsif crisp<x-much then 
     return round( (x-much-crisp)/(margen+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';



----------------------------------------------------------------------
-- mide la necesidad de que un valor crisp sea 'mucho menor' (nmlt)
-- que un valor aprox. caso ejemplo: fcol_t1 nmlt 6
-- valor aprox:  f1 + - f4 (donde f4 es el margen: f1-f4=f2 y f1+f4=f3)
----------------------------------------------------------------------
drop function fsql_functions2_nmlt_crisp_aprox (
 						  numeric,
						  numeric, numeric,
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_crisp_aprox (
 						  numeric,
						  numeric, numeric,
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type)
returns numeric as'
declare
  crisp  alias for $1;
  f1     alias for $2;
  f2     alias for $3;
  f3     alias for $4;
  f4     alias for $5;
  margen alias for $6;
  much   alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_crisp_aprox'');
  if crisp+margen<=f2-much then 
     return 1;
  elsif crisp< f1-much then 
     return round( (f1-much-crisp)/(f4+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- mide la necesidad de que un valor crisp sea 'mucho menor' (nmlt)
-- que un trapecio. caso ejemplo: fcol_t1 nmlt $[1,4,7,9]
----------------------------------------------------------------------
drop function fsql_functions2_nmlt_crisp_trape (
						  numeric,
						  numeric, numeric, 
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type); 
create function fsql_functions2_nmlt_crisp_trape (
						  numeric,
						  numeric, numeric, 
						  numeric, numeric,
						  fuzzy_approx_much.margen%type,
						  fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp  alias for $1;
  f1     alias for $2;
  f2     alias for $3;
  f3     alias for $4;
  f4     alias for $5;
  margen alias for $6;
  much   alias for $7;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_crisp_trape'');
  if crisp+margen<=f1-much then 
     return 1;
  elsif crisp<f1+f2-much then
     return round( (f1+f2-much-crisp)/(f2+margen) ,2);
  else 
     return 0;
  end if;
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp1) es 'mucho menor' (nmlt)
-- que un valor crisp u otra columna tipo 1 (crisp2).
-- formato: fcol_t1 nmlt fcol_t1, o tambien  fcol_t1 nmlt crisp2
----------------------------------------------------------------------
drop function fsql_functions2_nmlt_t1_t1 (
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_t1_t1 (
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type)
returns numeric as'
declare
  crisp1 alias for $1;
  crisp2 alias for $2;
  margen alias for $3;
  much   alias for $4;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_t1_t1'');
  return fsql_functions2_nmgt_t1_t1(crisp2,crisp1,margen,much);
end;
'language 'plpgsql';


----------------------------------------------------------------------
-- indica si una columna difusa tipo 1 (crisp) es 'mucho menor' (nmlt)
-- que una columna tipo 2. formato: fcol_t1 nmlt fcol_t2
----------------------------------------------------------------------
drop function fsql_functions2_nmlt_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type); 
create function fsql_functions2_nmlt_t1_t2 (
					    numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  margen   alias for $9;
  much     alias for $10;  
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_t1_t2'');
  if f_type=0 then
     return fsql_functions2_mayormenor_unknown(3); 
  elsif f_type=1 then
     return fsql_functions2_mayormenor_undefined();
  elsif f_type=2 then 
     return fsql_functions2_mayormenor_null(3);
  elsif f_type=3 then 
     return fsql_functions2_nmlt_t1_t1(crisp,f1,margen,much);
  elsif f_type=4 then
    select into alfa_var,beta_var alfa,beta from fuzzy_label_def
      where obj=obj_var and col=col_var and fuzzy_id=f1;
    if crisp+margen<=alfa_var-much then
       return 1;
    elsif crisp< beta_var-much then 
       return round(  (beta_var-crisp-much)/(beta_var-alfa_var+margen) ,2);
    else  
       return 0;
    end if;
  elsif f_type=5 then 
    return fsql_functions2_nmlt_crisp_finter(crisp,f1,f4,margen,much);
  elsif f_type=6 then 
    return fsql_functions2_nmlt_crisp_aprox(crisp,f1,f2,f3,f4,margen,much);
  else
    return fsql_functions2_nmlt_crisp_trape(crisp,f1,f2,f3,f4,margen,much);
  end if;
end;
'language 'plpgsql';


--********************************************************************
-- mide la necesidad de que una columna difusa tipo 2 sea 'mucho menor' (nmlt)
-- que un valor crisp. caso ejemplo: fcol_t2 nmlt 8, o fcol_t2 nmlt fcol_t1
--********************************************************************
drop function fsql_functions2_nmlt_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_crisp (
					    numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type)
returns numeric as'
declare
  crisp    alias for $1;
  obj_var  alias for $2;
  col_var  alias for $3;
  f_type   alias for $4;
  f1       alias for $5;
  f2       alias for $6;
  f3       alias for $7;
  f4       alias for $8;
  margen   alias for $9;
  much     alias for $10;  
  alfa_var fuzzy_label_def.alfa%type;
  beta_var fuzzy_label_def.alfa%type;
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_crisp'');
  if f_type in (0,1,2) then 
     return 0;
  elsif f_type=3 then 
     return fsql_functions2_nmgt_t1_t1(crisp,f1,margen,much);
  elsif f_type=4 then
     return fsql_functions2_nmgt_crisp_label(crisp,obj_var,col_var,f1,margen,much);
  elsif f_type=5 then
     return fsql_functions2_nmgt_crisp_finter(crisp,f1,f4,margen,much);
  elsif f_type=6 then
     return fsql_functions2_nmgt_crisp_aprox(crisp,f1,f2,f3,f4,margen,much);
  else
     return fsql_functions2_nmgt_crisp_trape(crisp,f1,f2,f3,f4,margen,much);
  end if;
end;
'language 'plpgsql';



--********************************************************************
-- mide la necesidad de que una columna difusa tipo 2 sea 'mucho menor'
-- (nmlt) que un intervalo [x,y]. caso ejemplo: fcol_t2 nmlt [x,y]
--********************************************************************
drop function fsql_functions2_nmlt_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_inter (
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type)
returns numeric as'
declare
  x        alias for $1;
  y        alias for $2; 
  obj_var  alias for $3;
  col_var  alias for $4;
  f_type   alias for $5;
  f1       alias for $6;
  f2       alias for $7;
  f3       alias for $8;
  f4       alias for $9;
  margen   alias for $10;
  much     alias for $11;  
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_inter'');
  return fsql_functions2_nmgt (null,null,5,x,null,null,y,obj_var,
                               col_var,f_type,f1,f2,f3,f4,margen,much);
end;
'language 'plpgsql';


--********************************************************************
-- mide la necesidad de que una columna difusa tipo 2 sea 'mucho menor'
-- (nmlt) que un aprox [a1,a2,a3,a4]. caso ejemplo: fcol_t2 nmlt a1
--********************************************************************
drop function fsql_functions2_nmlt_aprox (
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_aprox (
					    numeric, numeric, 
					    numeric, numeric,
					    fuzzy_label_def.obj%type, 
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type)
returns numeric as'
declare
  a1       alias for $1;
  a2       alias for $2;
  a3       alias for $3;
  a4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_aprox'');
  return fsql_functions2_nmgt (null,null,6,a1,a2,a3,a4,obj_var,
                               col_var ,f_type,f1,f2,f3,f4,margen,much);
end;
'language 'plpgsql';


--********************************************************************
-- mide la necesidad de que una columna difusa tipo 2 sea 'mucho menor'
-- (nmlt) que un trapecio. caso ejemplo: fcol_t2 nmlt $[t1,t2,t3,t4]
--********************************************************************
drop function fsql_functions2_nmlt_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt_trape (
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_label_def.obj%type,
					    fuzzy_label_def.obj%type,
					    fuzzy_col_list.f_type%type,
					    numeric, numeric,
					    numeric, numeric,
					    fuzzy_approx_much.margen%type,
					    fuzzy_approx_much.much%type) 
returns numeric as'
declare
  t1       alias for $1;
  t2       alias for $2;
  t3       alias for $3;
  t4       alias for $4;
  obj_var  alias for $5;
  col_var  alias for $6;
  f_type   alias for $7;
  f1       alias for $8;
  f2       alias for $9;
  f3       alias for $10;
  f4       alias for $11;
  margen   alias for $12;
  much     alias for $13; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt_trape'');
  return fsql_functions2_nmgt (null,null,7,t1,t2,t3,t4,obj_var,
                               col_var,f_type,f1,f2,f3,f4,margen,much);
end;
'language 'plpgsql';



--********************************************************************
-- funcion difusa de comparacion: "necesariamente mucho menor que": nmlt
-- mide la necesidad de que una columna difusa tipo 2 sea 'mucho menor que'
-- otra. caso ejemplo: fcol1_t2 nmlt fcol2_t2
--********************************************************************
drop function fsql_functions2_nmlt (
				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric, numeric,
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric ,numeric,
				      fuzzy_approx_much.margen%type,
				      fuzzy_approx_much.much%type);
create function fsql_functions2_nmlt (
				      fuzzy_label_def.obj%type,
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric, numeric,
				      fuzzy_label_def.obj%type, 
				      fuzzy_label_def.obj%type,
				      fuzzy_col_list.f_type%type,
				      numeric, numeric,
				      numeric ,numeric,
				      fuzzy_approx_much.margen%type,
				      fuzzy_approx_much.much%type) 	
returns numeric as'
declare
  obj1_var alias for $1;
  col1_var alias for $2;
  f_type1  alias for $3;
  f11      alias for $4;
  f21      alias for $5;
  f31      alias for $6;
  f41      alias for $7;
  obj2_var alias for $8;
  col2_var alias for $9;
  f_type2  alias for $10;
  f12      alias for $11;
  f22      alias for $12;
  f32      alias for $13;
  f42      alias for $14;
  margen   alias for $15;
  much     alias for $16; 
begin
  insert into trama values(nextval(''sec''),''fsql_functions2_nmlt'');
  return fsql_functions2_nmgt (obj2_var,col2_var,f_type2,f12,f22,f32,f42,obj1_var,
			       col1_var,f_type1,f11,f21,f31,f41,margen,much);
end;
'language 'plpgsql';

