-- fichero fsql_pkg.sql
----------------------------------------------------------------------

--  consulta  constant integer:= 301;
--  s_inicial constant producciones.parte_der%type := 'consulta';
--  fin       constant producciones.parte_der%type := 'the end';
--  audsid    fsql_query.sessionid%type; -- identificativo de la sesion actual

  -- tipos para la pila del a. sintactico
--  type tpila_simbolo  is table of producciones.parte_der%type
--                         index by binary_integer;
--  type tpila_terminal is table of producciones.terminal_der%type
--                         index by binary_integer;

drop sequence serial;
create sequence serial start 1;
select nextval('serial');

drop table pila;
create table pila
       (tope     integer primary key default nextval('serial'),
        simbolo  varchar,
        terminal char);


----------------------------------------------------------------------
-- inserta un msg de error en la tabla de errores: fsql_errors
-- la insercion ser realiza cronologicamente ordenados por el campo indice (empezando por 1)
-- se inserta el numero de la sesion actual en el campo sessionid.
----------------------------------------------------------------------
drop function fsql_pkg_insertar_error (varchar);
create function fsql_pkg_insertar_error (varchar) 
returns integer as '
declare
  msgerror     alias for $1;
  llamafuncion integer;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_insertar_error'');
  llamafuncion:=fsql_aux_inserta_error(msgerror);
  return llamafuncion;
end;
'language 'plpgsql';


-------------------------------------------------------------------------------------
-- ***** ***** ***** ***** *****  analizador lexico  ***** ***** ***** ***** ***** --
-------------------------------------------------------------------------------------

----------------------------------------------------------------------
-- inserta un token en la tabla
-- fsql_query: indice es un numero incrementado sucesivamente (desde 0)
--              nombre es el nombre del token
--              atributo es la cadena que forma el token (sin espacios)
-- si el estado en el que queda el automata tras ese token es un estado no terminal
-- devuelve un codigo de error. devuelve 0 si es un estado terminal y el token se
-- inserto en la tabla correctamente.
----------------------------------------------------------------------
drop function fsql_pkg_inserta_token (	varchar, numeric,
		                        fsql_all_queries.posicion%type);
create function fsql_pkg_inserta_token (varchar, numeric,
		                        fsql_all_queries.posicion%type )
returns numeric as'
declare
  cadena   	alias for $1;
  estado   	alias for $2;
  posicion 	alias for $3;
  i        	integer;
  indi    	fsql_all_queries.indice%type;
  nomtok   	fsql_all_queries.nombre%type;
  llamafuncion  integer;
  idsession     numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_inserta_token'');
    if (estado=18) then
      llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||posicion||'': ''||
        ''comparador de desigualdad (!=,^=) no terminado.'');
      return 2;
    elsif (estado=23) or (estado=25) then
      llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||posicion||'': ''||
        ''cadena o texto no terminado correctamente (faltan comillas).'');
      return 3;
    elsif (estado=31) or (estado=32) then
      llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||posicion||'': ''||
        ''numero en notacion exponencial mal terminado.'');
      return 4;
    elsif (estado=35) then
      llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||posicion||'': ''||
        ''operador de concatenacion || mal terminado.'');
      return 5;
    elsif (estado = 9)  then
	 nomtok := ''gt'';
    elsif (estado = 11) then
	 nomtok := ''lt'';
    elsif (estado = 12) then
	 nomtok := ''eq'';
    elsif (estado = 16) then
	 nomtok := ''geq'';
    elsif (estado = 17) then
	 nomtok := ''leq'';
    elsif (estado = 19) then
	 nomtok := ''neq'';
    elsif (estado = 24) then
	 nomtok := ''cadena'';
    elsif (estado = 26) then
	 nomtok := ''texto'';
    elsif (estado = 13) or (estado = 14) or (estado = 33) then
	 nomtok := ''numero'';
    elsif (estado = 15) then
      select into i count(*) from reservadas where palabra=cadena;
      if i=0 then
         nomtok := ''id'';
      else
         nomtok := cadena;
      end if;
    elsif estado in (37,38,39,40) then
      return 0;
    else
      nomtok := cadena;
    end if;
    select into indi max(indice) from fsql_all_queries;
    if indi >= 0 then
         indi:=indi+1;
    else indi:=0;
    end if;
    select into idsession pg_backend_pid();
    insert into fsql_all_queries values(idsession,indi,posicion,nomtok,cadena);
    return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- analizador lexico para una consulta en fsql
-- usa     : tabla de palabras reservadas (reservadas)
--           tabla de transiciones del automata (t_transi)
-- genera  : si no hay error: tabla con los tokens de la consulta (fsql_query)
--           si hay error   : inserta en tabla fsql_errors el msg de error
-- devuelve:   0  si no hay error
--           <>0  si hay error
----------------------------------------------------------------------
drop function fsql_pkg_fsql_lexico (varchar);
create function fsql_pkg_fsql_lexico (varchar) 
returns integer as '
declare
  consulta       alias for $1;
  maxlong_id     integer;     
  maxlong_cadtxt integer; 
  long           numeric;
  retor1         varchar;
  retor2         varchar;
  pos            integer; 
  lex_error      numeric; 
  estado_act     t_transi.estado%type; 
  estado_sig     t_transi.sig_estado%type; 
  cadena         varchar(32767);
  car            varchar;                
  msgerror       varchar(2000);      
  indi           fsql_query.indice%type; 
  llamafuncion   numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_lexico'');
  maxlong_id     :=30;  
  maxlong_cadtxt :=2000; 
  long           :=length(consulta); 
  retor1         :=chr(13);
  retor2         :=chr(10);
  pos            :=1; 
  lex_error      :=0; 
  estado_act     :=0; 
  cadena         :='''';
  while (pos<=long) loop

--    car:=upper(substring(consulta from pos for 1)); 
    car:=substring(consulta from pos for 1); 
    if ascii(car)=9 then 
       car:='' '';
    end if;  
    select into estado_sig sig_estado from t_transi
    where (t_transi.estado = estado_act) and
          (t_transi.caracter = ascii(car));
    if estado_sig is null then
       if estado_act=23 or estado_act=25 or estado_act=37 or estado_act=39 then
          estado_sig:=estado_act;
       elsif estado_act=40 then 
         estado_sig:=39;
       else 
         estado_sig:=0;
       end if;
    end if;
    if estado_sig<>0 then
       if estado_act=23 or estado_act=25 then  
          if length(cadena)=maxlong_cadtxt then 
             lex_error:=1;
             llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||pos||'': ''||
             ''cadena o texto demasiado larga.'');
             cadena:=substring(consulta from pos for 1);
          else
             cadena:=cadena||substring(consulta from pos for 1);
          end if;
       elsif estado_act in (37,39) then 
          --null; 
       elsif car<>'' '' then 
          if length(cadena)=30 then
             lex_error:=1;
             llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||pos||'': ''||
               ''identificador tiene mas de 30 caracteres.'');
             cadena:=car;
          else
            cadena:=cadena || car;
          end if;
       end if;   
       if pos=long then 
          lex_error:=fsql_pkg_inserta_token(cadena,estado_sig,pos);
       else
          estado_act:=estado_sig;
       end if;
    elsif estado_act<>0 then
       lex_error:=fsql_pkg_inserta_token(cadena,estado_act,pos-1);
       if lex_error=0 then 
          estado_act:=0;
          cadena:='''';
          if car <> '' '' and car <> retor1 and car <> retor2 then
             pos:=pos-1;
          end if; 
       else 
          estado_act:=0;
          cadena:='''';
       end if;
    else 
       if car <> '' '' and car <> retor1 and car <> retor2 then
          lex_error:=1;
          llamafuncion:=fsql_aux_inserta_error(''error lexico en posicion ''||pos||'': ''
            ||''simbolo ''||car||'' (ascii ''||ascii(car)
            ||'') no reconocido por la gramatica y es ignorado.'');
       end if;
    end if;
    pos:=pos+1;
  end loop;
  select into lex_error count(*) from fsql_errors;
  return lex_error; 
end;
'language 'plpgsql';


-------------------------------------------------------------------------------------
-- ***** ***** ***** ***** ***** analiz.  sintactico ***** ***** ***** ***** ***** --
-------------------------------------------------------------------------------------

----------------------------------------------------------------------
-- introduce en la pila todos los simbolos de la parte derecha de la produccion,
-- en orden inverso (de dcha a izda)
----------------------------------------------------------------------
drop function fsql_pkg_introducir_pila (numeric);
create function fsql_pkg_introducir_pila (numeric) 
returns integer as '
declare
 
  produccion       alias for $1;
  simbolo	   record;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_introducir_pila'');
  for simbolo in select parte_der, terminal_der from producciones
         where num_prod=produccion
         order by posicion desc loop
    if simbolo.parte_der <> ''vacio'' then
	insert into pila values(nextval(''serial''),simbolo.parte_der,simbolo.terminal_der);
    end if;
  end loop;
return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- devuelve el simbolo del tope de la pila y si es terminal ('t') o nt ('n')
----------------------------------------------------------------------
-- funcion reeplazada por un select

----------------------------------------------------------------------
-- devuelve el nombre del i-esimo token (segun el orden de la consulta)
-- o sea, devuelve el campo fsql_query.nombre con fsql_query.indice=i
-- si el numero de tokens existentes es menor que i, devuelve fin
----------------------------------------------------------------------
drop function fsql_pkg_sig_token (integer);
create function fsql_pkg_sig_token (integer) 
returns fsql_all_queries.nombre%type as '
declare
  i     alias for $1;
  token fsql_all_queries.nombre%type;
  maxi  integer;
begin
  insert into trama values(nextval(''sec''),''function fsql_pkg_sig_token'');
  select into maxi max(indice) from fsql_all_queries;
  if (i <= maxi) then
     select into token nombre from fsql_all_queries where fsql_all_queries.indice=i;
     return token;
  else 
     return ''the end'';
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- cambia algunos simbolos terminales en el msg de error.
-- msg de error del tipo: "encontrado ...(1)... cuando esperaba ...(2)..."
-- el parametro 'parte' indica la parte (1 o 2) donde va el simbolo que cambiamos
----------------------------------------------------------------------
drop function fsql_pkg_cambia (varchar, integer); 
create function fsql_pkg_cambia (varchar, integer) 
returns varchar as '
declare
  simbt alias for $1;
  parte alias for $2;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_cambia'');
  if simbt=''the end'' then
     return '' <fin>'';
  elsif simbt=''eq'' then 
     return '' ='';
  elsif simbt=''neq'' then 
     return '' <>'';
  elsif simbt=''gt'' then 
     return '' >'';
  elsif simbt=''lt'' then
     return '' <'';
  elsif simbt=''leq'' then 
     return '' <='';
  elsif simbt=''geq'' then 
     return '' >='';
  elsif simbt=''id'' then 
     return '' <identificador>'';
  elsif simbt=''numero'' then
     return '' <numero>'';
  elsif simbt=''cadena'' then
     return '' <cadena>'';
  elsif simbt=''concat'' then 
     return '' ||'';
  elsif simbt=''texto'' then 
     return '' <texto>'';
  elsif simbt=''abs'' then 
     if parte=2 then
        return '' <funcion>'';
     end if;
  elsif simbt=''cdeg'' or simbt=''ceil'' or simbt=''floor'' or simbt=''sign'' or
        simbt=''sqrt'' or simbt=''chr'' or simbt=''mod'' or simbt=''power'' or
        simbt=''initcap'' or simbt=''lower'' or simbt=''lpad'' or simbt=''ltrim'' or
        simbt=''replace'' or simbt=''rpad'' or simbt=''rtrim'' or simbt=''soundex'' or 
        simbt=''substr'' or simbt=''translate'' or simbt=''upper'' or simbt=''ascii'' or 
        simbt=''instr'' or simbt=''length'' or simbt=''nlssort'' or simbt=''avg'' or
        simbt=''count'' or simbt=''max'' or simbt=''min'' or simbt=''stddev'' or
        simbt=''sum'' or simbt=''variance'' or simbt=''chartorowid'' or simbt=''convert'' or    
        simbt=''hextoraw'' or simbt=''rawtohex'' or simbt=''rowidtochar'' or
        simbt=''to_char'' or simbt=''to_date'' or simbt=''to_number'' or simbt=''add_months'' or
        simbt=''last_day'' or simbt=''months_between'' or simbt=''new_time'' or
        simbt=''next_day'' or simbt=''round'' or simbt=''trunc'' or simbt=''dump'' or
        simbt=''greatest'' or simbt=''least'' or simbt=''nvl'' or simbt=''userenv'' or
        simbt=''vsize'' or simbt=''decode'' then
          if parte=2 then
             return '''';
          end if;
  end if;
  return '' ''||simbt;
end;
'language 'plpgsql';
--select fsql_pkg_cambia('vsize',2);

----------------------------------------------------------------------
-- analizador sintactico de los tokens de la tabla fsql_query, generados por el a. lexico
-- usa   : tabla con los tokens ordenados (fsql_query)
--         tabla con las producciones de la gramatica (producciones)
--         tabla de transiciones segun la gramatica ll(1) (tabla_sintax)
-- genera: si no hay error: modifica tabla fsql_query con nueva informacion
--         si hay error   : inserta en tabla fsql_errors el msg de error
-- devuelve:   0  si no hay error
--           <>0  si hay error
----------------------------------------------------------------------

drop function fsql_pkg_fsql_sintactico ();
create function fsql_pkg_fsql_sintactico () 
returns integer as '
declare
  entrada integer;
  token         fsql_all_queries.nombre%type;
  simbolo_tope  producciones.parte_der%type;
  terminal_tope producciones.terminal_der%type;
  sintax_error integer;
  prod_a_aplicar tabla_sintax.num_prod%type;
  posicion1       fsql_all_queries.posicion%type;
  nombre_del_id  fsql_all_queries.atributo%type;
  msgerror       varchar(32767);
  funcion_activa boolean; 
  into_select_list boolean;
  llamadafuncion integer;
  llama_token    fsql_all_queries.nombre%type;
  llama_intropila integer;
  llama_cambia varchar;
  llama_cambia2 varchar;
  num_secuencia integer;
  esperando record;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_sintactico'');
  entrada  :=0;
  sintax_error :=0;
  nombre_del_id :='''';
  funcion_activa :=''f''; 
  into_select_list :=''f'';
---inicializar pila------------------
  delete from pila;
  select into num_secuencia (select setval(''serial'',1));
  insert into pila values(num_secuencia,''the end'',''n'');
-------------
  simbolo_tope :=''consulta'';
  terminal_tope:=''n'';
  token := fsql_pkg_sig_token(entrada);

  while simbolo_tope<>''the end'' and sintax_error=0 loop
    if terminal_tope = ''t'' then
      if simbolo_tope = token then
        if    token=''select'' then
	  into_select_list:=''t'';
        elsif token=''from''   then
	  into_select_list:=''f'';
        elsif token=''cdeg'' and not into_select_list then
           select into posicion1 posicion from fsql_all_queries where indice=entrada;
           llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||posicion1
           ||'': llamada a funcion cdeg mal situada. debe aparecer en la select_list.'');
        elsif token=''id'' then
            -- columnas:
           if prod_a_aplicar=60 then
              update fsql_all_queries set nombre=''column'' where indice=entrada;
           elsif prod_a_aplicar=65 then
              update fsql_all_queries set nombre=''t.column''where indice=entrada;
              update fsql_all_queries set nombre=''t.''  where indice=entrada-2;
           elsif prod_a_aplicar=68 then
              update fsql_all_queries set nombre=''t.''  where indice=entrada-2;
           elsif prod_a_aplicar=71 then
              update fsql_all_queries set nombre=''s.t.column''where indice=entrada;
              update fsql_all_queries set nombre=''t.''        where indice=entrada-2;
              update fsql_all_queries set nombre=''s.t.''      where indice=entrada-4;
           elsif prod_a_aplicar=29 then
              update fsql_all_queries set nombre=''c_alias'' where indice=entrada;
           -- tablas:
           elsif prod_a_aplicar=180 then
              update fsql_all_queries set nombre=''tabla'' where indice=entrada;
           elsif prod_a_aplicar=182 then
              update fsql_all_queries set nombre=''s.tabla''  where indice=entrada;
              update fsql_all_queries set nombre=''t_scheme'' where indice=entrada-2;
           elsif prod_a_aplicar=186 then
              update fsql_all_queries set nombre=''t_alias'' where indice=entrada;
           end if;
        elsif token=''cadena'' and prod_a_aplicar=28 then
           update fsql_all_queries set nombre=''c_alias'' where indice=entrada;
        elsif token='','' and prod_a_aplicar=23 then
           update fsql_all_queries set nombre='', en sl'' where indice=entrada;
        elsif token in (''eq'',''neq'',''leq'',''geq'',''lt'',''gt'')
              and prod_a_aplicar between 260 and 265 then 
           update fsql_all_queries set nombre=''comparador'' where indice=entrada;
        elsif token=''numero'' and prod_a_aplicar=221 then
           update fsql_all_queries set nombre=''numbral'' where indice=entrada;
        elsif token=''*'' then
           if prod_a_aplicar=149 then -- * de un cdeg(*)
              update fsql_all_queries set nombre=''*column'' where indice=entrada;
           elsif prod_a_aplicar=66 then
              update fsql_all_queries set nombre=''t.*'' where indice=entrada;
              update fsql_all_queries set nombre=''t.''  where indice=entrada-2;
           elsif prod_a_aplicar=72 then
              update fsql_all_queries set nombre=''s.t.*'' where indice=entrada;
              update fsql_all_queries set nombre=''t.''    where indice=entrada-2;
              update fsql_all_queries set nombre=''s.t.''  where indice=entrada-4;
           elsif prod_a_aplicar=20 then
              update fsql_all_queries set nombre=''todas'' where indice=entrada;
           end if;
        elsif token=''%'' then
           if prod_a_aplicar=67 then
              update fsql_all_queries set nombre=''t.%'' where indice=entrada;
              update fsql_all_queries set nombre=''t.''  where indice=entrada-2;
           elsif prod_a_aplicar=73 then
              update fsql_all_queries set nombre=''s.t.%''where indice=entrada;
              update fsql_all_queries set nombre=''t.''   where indice=entrada-2;
              update fsql_all_queries set nombre=''s.t.'' where indice=entrada-4;
           elsif prod_a_aplicar=21 then
              update fsql_all_queries set nombre=''todo'' where indice=entrada;
           end if;

        elsif token=''('' and funcion_activa then
           update fsql_all_queries set nombre=''( function'' where indice=entrada;
        elsif token='')'' and funcion_activa then
           update fsql_all_queries set nombre='') function'' where indice=entrada;
           funcion_activa:=''f'';
        elsif prod_a_aplicar between 90 and 148 then
           funcion_activa:=''t'';
        end if;

----------- ok: leemos el siguiente simbolo de la pila y el siguiente token de la entrada
	 select into simbolo_tope, terminal_tope simbolo, terminal from pila 
		where tope=(select max(tope) from pila);
	 delete from pila where tope=(select max(tope) from pila);
	 select into num_secuencia (select setval(''serial'',max(tope)) from pila);
--------------------
         entrada := entrada + 1;
         token := fsql_pkg_sig_token(entrada);
      else
	llama_token:=fsql_pkg_sig_token(entrada+1);
        if simbolo_tope=''numero'' and token=''-'' and llama_token=''numero'' then
           delete from fsql_all_queries where indice=entrada;
           update fsql_all_queries set indice=indice-1 where indice>entrada;
           update fsql_all_queries set atributo=''-''||atributo where indice=entrada;
           if prod_a_aplicar=221 then
              update fsql_all_queries set nombre=''numbral'' where indice=entrada;
           end if;
---------- ok: leemos el siguiente simbolo de la pila y el siguiente token de la entrada
	   select into simbolo_tope, terminal_tope simbolo, terminal from pila 
		where tope=(select max(tope) from pila);
	   delete from pila where tope=(select max(tope) from pila);
	   select into num_secuencia (select setval(''serial'',max(tope)) from pila);
----------------------------------------
           entrada := entrada + 1;
           token := fsql_pkg_sig_token(entrada);
        else
          sintax_error:=1;
        end if;
      end if;

    else 
        select into prod_a_aplicar num_prod from tabla_sintax where
               (tabla_sintax.simbolo_nt = simbolo_tope) and
               (tabla_sintax.simbolo_t  = token);
	if not found then
           prod_a_aplicar:=0;
        end if;

      if prod_a_aplicar <> 0 then
         if prod_a_aplicar=223 and token<>''the end'' then
            update fsql_all_queries set nombre=''sin umbral'' where indice=entrada;
         end if;
	 llama_intropila:=fsql_pkg_introducir_pila(prod_a_aplicar);
-------- leemos el nuevo simbolo del tope de la pila:
	 select into simbolo_tope, terminal_tope simbolo, terminal from pila 
		where tope=(select max(tope) from pila);
	 delete from pila where tope=(select max(tope) from pila);
	 select into num_secuencia (select setval(''serial'',max(tope)) from pila);
---------------------------
      else
         sintax_error:=2;
      end if;
    end if;
  end loop;

  if sintax_error<>0 then
     if token=''the end'' then
        token:=''el fin'';
        entrada:=entrada-1;
     end if;

     select into posicion1 posicion from fsql_all_queries where indice=entrada;
     if token=''id'' then
        select into nombre_del_id '' ''||atributo from fsql_all_queries where indice=entrada;
     end if;

     if sintax_error=1 then
	llama_cambia:=fsql_pkg_cambia(token,1);
	llama_cambia2:=fsql_pkg_cambia(simbolo_tope,2);
        llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||posicion1||
          '': encontrado''||llama_cambia||nombre_del_id||
          '' cuando esperaba''||llama_cambia2||''.'');
     elsif sintax_error=2 then
	llama_cambia:=fsql_pkg_cambia(token,1);
        msgerror:=''error sintactico en posicion ''||posicion1||
          '': encontrado''||llama_cambia||nombre_del_id||'' cuando esperaba: '';
----------------
--duda en cursor
---------------
--        for esperado in esperados(simbolo_tope) loop
--            llama_cambia:=fsql_pkg_cambia(esperado.simbolo_t,2);
--        llama_cambia:=fsql_pkg_cambia(simbolo_tope,2);
--        msgerror:=msgerror||llama_cambia;
--        end loop;
--        llamadafuncion:=fsql_aux_inserta_error(msgerror);
     end if;
--------------------------

  else
     if token = ''the end'' then
        return 0;
     else
        select into posicion1 posicion from fsql_all_queries where indice=entrada;
        llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||posicion1||
          '': esperaba el fin cuando encontra: ''||token||''.'');
     end if;
  end if;

--  commit;
  select into sintax_error count(*) from fsql_errors;
  return sintax_error;

end;
'language 'plpgsql';

-------------------------------------------------------------------------------
-- ***** ***** conversor: fsql --> sql  (funcion fsql2sql) ***** ***** ***** --
-------------------------------------------------------------------------------

----------------------------------------------------------------------
-- actualiza valores en la vista fsql_options y algunas estadisticas de fsql_stats
-- si se produce desbordamiento, se pone el contador de nuevo a 0
----------------------------------------------------------------------

drop function fsql_pkg_actualiza_fsql_opt (integer,timestamp);
create function fsql_pkg_actualiza_fsql_opt (integer,timestamp)
returns integer as'
declare
  nerrors 	alias for $1;
  time_inicial 	alias for $2;
  time_final 	timestamp;
  session_id numeric;
  mini 		integer;
  minf 		integer;
  segi 		integer;
  segf 		integer;
  segundos 	integer;
  session_anterior numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_actualiza_fsql_opt'');
  select into session_anterior num from fsql_stats where evento=''ultimo_sessionid'';
  select into session_id pg_backend_pid();
  if session_anterior <> session_id then
     update fsql_stats set num=session_id where evento=''ultimo_sessionid'';
     update fsql_stats set num=num+1 where evento=''cambios_de_sessionid'';
  end if;
  select into time_final now();
  mini:=to_number(to_char(time_inicial,''mi''),''99'');
return mini;
  segi:=to_number(to_char(time_inicial,''ss''),''99'');
  minf:=to_number(to_char(time_final,''mi''),''99'');
  segf:=to_number(to_char(time_final,''ss''),''99'');
  if minf>=mini then
     segundos:=(minf*60 + segf) - (mini*60 + segi);
  else
     segundos:=(minf*60 + segf + 3600) - (mini*60 + segi);
  end if;
  if segundos<0 then 
     segundos:=1;
  end if;
    update fsql_stats set num=num+segundos where evento=''tiempo_total_accesos'';
    update fsql_stats set num=num+1 
	where evento=''accesos_para_traducciones'';
  if nerrors=0 then
       update fsql_stats set num=num+segundos 
	where evento=''tiempo_accesos_sin_errores'';
       update fsql_stats set num=num+1        
	where evento=''accesos_sin_errores'';
  else
       update fsql_stats set num=num+1        
	where evento=''total_errores_cometidos'';
  end if;
  update fsql_stats set num=segundos 
	where evento=''tiempo_ultima_traduccion'';
  insert into fsql_all_info values (user,''tiempo_traduccion'',
      to_char(segundos,''99'')||'' seg.'');
  update fsql_stats set num=nerrors 
	where evento=''errores_ultima_traduccion'';
  insert into fsql_all_info values (user,''num_errores'',to_char(nerrors,''99''));
   return 0;
end;
' language 'plpgsql';

----------------------------------------------------------------------
-- funcion que traduce una consulta en fsql a sql.
-- devuelve el numero de errores cometidos: lexicos, sintacticos y semanticos.
-- al final de cada analisis se hace un commit, por lo que aqui no es necesario.
-- si el numero de errores es 0, la consulta sql se obtiene concatenando los valores del
-- campo atributo de las filas de la tabla fsql_query ordenadas por el campo indice.
----------------------------------------------------------------------

drop function fsql_pkg_fsql2sql (varchar);
create function fsql_pkg_fsql2sql (varchar)
returns integer as '
declare
  consulta 	alias for $1;
  nerrors 	integer;
  time_inicial 	timestamp;
  llamadafuncion integer;
  audsid 	integer;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql2sql'');
  select into time_inicial now();
  select into audsid pg_backend_pid();
  update fsql_all_info set valor=to_char(now(),''dd-mm-yyyy, hh24:mi:ss'')
    where owner=''fsql server'' and opcion=''fecha_ultimo_uso'';

  delete from fsql_all_queries;
  delete from fsql_all_errors;

  if consulta='''' or consulta is null then
     llamadafuncion:=fsql_aux_inserta_error(''error: consulta vacia.'');
     return 1;
  end if;
     
  if substring(consulta from 1 for 1)=''!'' then

     llamadafuncion:=fsql_pkg_fsql_lexico(substring(consulta from 2 for length(consulta)-1));
     return llamadafuncion;
  end if;

  nerrors:=fsql_pkg_fsql_lexico(consulta);

  nerrors :=fsql_pkg_fsql_sintactico();

  if nerrors<>0 then
     llamadafuncion:=fsql_pkg_actualiza_fsql_opt (nerrors,time_inicial);
     return nerrors;
  else
     nerrors :=fsql_semantic_semantico();
   --  llamadafuncion:=fsql_pkg_actualiza_fsql_opt (nerrors,time_inicial);
     return nerrors;
  end if;
  return 0;
end;
' language 'plpgsql';

----------------------------------------------------------------------
-- funcion que concatena el resultado sql de una sentencia fsql, devolviendo
-- la sentencia resultante en una cadena.
-- posible problema: que la consulta sea muy grande y exceda del tamano maximo para
-- cadenas de oracle.
-- tamanos maximos, por tipos (en oracle7): char (32767), long (32760) y varchar2 (32767).
-- esta funcion se incluye para:
--     a) simplificar posibles llamadas al servidor si el resultado tiene menos
--        de 32767 caracteres, ya que realiza la concatenacion automaticamente.
--        salvo en sentencias muy grandes, es dificil sobrepasar ese limite.
--     b) en futuras versiones de oracle pueden incluirse tipos de datos con
--        mayores limites.
-- puede usarse tras fsql2sql, si no hubo errores.
----------------------------------------------------------------------

drop function fsql_pkg_concat();
create function fsql_pkg_concat()
returns varchar as '
declare
  anterior_sin_esp boolean;
  sentenciasql     varchar(32767);
  longitud_valor   numeric(5);
  longitud_total   numeric(5);
  ch               char;
  valor record;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_concat'');
  anterior_sin_esp := ''f'';
  sentenciasql:='''';
  longitud_total:=0;

  for valor in select atributo from fsql_all_queries
                where atributo is not null and sessionid=(select pg_backend_pid())
                order by indice loop
     ch:= substr(valor.atributo,1,1);
     longitud_valor:=length(valor.atributo);
     longitud_total:=longitud_total + longitud_valor;
     if longitud_total>32767 then
	return '''';
     end if;
     if anterior_sin_esp or
       (longitud_valor = 1 and
       (ch = '','' or ch = ''.'' or ch = ''='' or ch = '';'' or ch = ''-'' or ch = ''+'' or
        ch = ''('' or ch = '')'' or ch = ''/'' or ch = ''*'' or ch = ''>'' or ch = ''<'')) then
        sentenciasql := sentenciasql || valor.atributo;
        anterior_sin_esp := not anterior_sin_esp;
     else
        sentenciasql := sentenciasql || '' '' || valor.atributo;
     end if;
  end loop;

  return sentenciasql;
end;
'language 'plpgsql';

--select fsql_pkg_concat()

----------------------------------------------------------------------
-- borra las tuplas de fsql_query y fsql_errors utilizadas por la session actual.
-- este procedimiento se debe usar cuando no se vayan a efectuar mas
-- consultas fsql en la sesion actual.
-- no se debe usar en cada nueva consulta fsql, solo al final.
-- ademas, tambien se eliminan las tuplas de sesiones que no existan ya: si existen
-- tuplas de este tipo es senal de que el cliente de esa sesion olvido ejecutar este
-- procedimiento antes de salir de su sesion. con esto conseguimos evitar que las
-- tablas fsql_* crezcan demasiado (lo cual solo ocurrira si nadie ejecuta fsql_fin)
----------------------------------------------------------------------

---------------------------------------------falta revisar---------------------------------

drop function fsql_pkg_fsql_fin();
create function fsql_pkg_fsql_fin() 
returns integer as'
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_fin'');
  -- borramos tuplas de sesiones inexistentes (las existentes estan en v$session)
  delete from fsql_all_queries where sessionid not in (select pg_user.usesysid from pg_user);
  delete from fsql_all_errors  where sessionid not in (select pg_user.usesysid from pg_user);
  -- actualizar la fecha de ultimo uso de esta funcion:
  update fsql_all_info set valor=to_char(now(),''dd-mm-yyyy, hh24:mi:ss'')
    where owner=''fsql server'' and opcion=''fecha_ultimo_fin'';
  -- actualizar numero de ejecuciones de esta funcion
  update fsql_stats set num=num+1 where evento=''ejecuciones_fsql_fin'';
  
-- /*exception when others then
    update fsql_stats set num=0     where evento=''ejecuciones_fsql_fin'';
--  end;
--  commit; */
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- dado un esquema.tabla (sch.tab), calcula y devuelve:
--	* numero de obj de la tabla (0 si no existe),
-- este procedimiento puede ser usado por los clientes fsql para efectuar
-- distintas operaciones con la fmb: ver etiquetas de una columna...
----------------------------------------------------------------------

drop function fsql_pkg_fsql_obj (varchar, varchar);
create function fsql_pkg_fsql_obj (varchar, varchar)
returns accessible_tables.obj%type as '
declare
  sch alias for $1;
  tab alias for $2;
  obj_id accessible_tables.obj%type;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_obj'');
    select into obj_id obj from accessible_tables
      where owner=sch and table_name=tab;
  if not found then
      obj_id:=0;
  end if;
  return obj_id;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- dado un esquema.tabla.columna (sch.tab.col), calcula y devuelve:
--	* el column_id de la columna (0 si no existe) y
-- este procedimiento puede ser usado por los clientes fsql para efectuar
-- distintas operaciones con la fmb: ver etiquetas de una columna...
----------------------------------------------------------------------

drop function fsql_pkg_fsql_col (varchar, varchar, varchar);
create function fsql_pkg_fsql_col (varchar, varchar, varchar)
  returns numeric as '
declare
  sch alias for $1;
  tab alias for $2;
  col alias for $3;
  col_id numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_col'');
    select into col_id atttypid from pg_attribute where attname = col and attrelid = (select relfilenode from pg_class  where relname = tab and relowner = (select pg_user.usesysid from pg_user where usename = sch));
    if not found then
      col_id:=0;
    end if;
  return col_id;
end;
'language 'plpgsql';

----------------------------------------------------------------------
-- dado un esquema.tabla.columna (sch.tab.col), calcula y devuelve:
--	* tipo difuso que tiene en fcl (0 si no es difusa).
-- este procedimiento puede ser usado por los clientes fsql para efectuar
-- distintas operaciones con la fmb: ver etiquetas de una columna...
----------------------------------------------------------------------

drop function fsql_pkg_fsql_ftype (numeric,numeric);
create function fsql_pkg_fsql_ftype (numeric,numeric)
returns numeric as'
declare
  obj_id alias for $1;
  col_id alias for $2;
  f_typ  fuzzy_col_list.f_type%type;
begin
  insert into trama values(nextval(''sec''),''fsql_pkg_fsql_ftype'');
  select into f_typ f_type from fuzzy_col_list
      where obj=obj_id and col=col_id;
  if not found then  
     f_typ:=0; -- esa columna no es difusa
  end if;
  return f_typ;

end;
'language 'plpgsql';


----------------------------------------------------------------------
-- pediente--
/*-------------------------falta hacer--------------------------------------------
 exception when others then
 update fsql_stats set num=0     where evento='total_paquete_fsql_pkg';
---------------------------------------------------------------------------------*/

  -- actualizar dato en fsql_stats
  update fsql_stats set num=1 where evento='total_paquete_fsql_pkg';


