-- fichero fsql_sem.sql

drop table all_alias;
create table all_alias (
    n_alias  varchar(30), 
    n_scheme varchar(30), 
    n_table  varchar(30)); 

--crea tabla cdeg
drop table cdeg;
create table cdeg (
  indice   numeric(10),
  atributo varchar(2000));

--crea tabla columna para traspaso de variables de tipo querytype
drop table columna;
create table columna (
  indice   numeric(10),
  posicion numeric(10),
  nombre varchar(100));
insert into columna 
        values(0,0,'');

--crea tabla de variables globales y setea los valores
drop table variables;
create table variables (
    scheme varchar(30), 
    tab  varchar(30),
    obj numeric,
    col numeric,
    f_tipo numeric(1),
    tupla integer,
    off_set integer,
    f_not varchar(100),
    f_and varchar(100),
    f_or  varchar(100),
    trata_fuzzy_atrib varchar(100),
    max_cdeg integer,
    maxind numeric);

delete from variables;
insert into variables
	values('public','latabla',0,0,0,0,0,'','','','',0,0);

drop function fsql_semantic_halt();
create function fsql_semantic_halt()
returns numeric as '
declare
  a numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_halt'');
  select into a indice from fsql_all_queries where atributo=''algo imposiblexx'';
  return a;
end;
'language 'plpgsql';

-------------------------------------------------------------------------------------
-- devuelve el propietario y el nombre de una tabla real dada la tabla usada en la consulta:
-- si el nombre usado es un alias devuelve ea propietario y tabla correspondiente y si no,
-- devuelve el owner y tabla propuestos originalmente (dados como argumentos).

drop function fsql_semantic_nombre_owner_table (varchar,
                               varchar);
create function fsql_semantic_nombre_owner_table (varchar,
                               varchar)
returns varchar as '
declare
  sch 		alias for $1;
  tab 		alias for $2;
  sch_var 	varchar;
  tab_var 	varchar;
  cadena_var 	varchar;
  i 		integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_nombre_owner_table'');
      select into  sch_var n_scheme from all_alias where n_alias=tab;
      select into  tab_var n_table from all_alias where n_alias=tab;
      cadena_var:=  sch_var ||  ''='' ||tab_var;
      return cadena_var;
end;
' language 'plpgsql';
--select fsql_semantic_nombre_owner_table ('rossana','pajarraka');
-------------------------------------------------------------------------------------
-- devuelve el identificador de objeto (obj) de una tabla real dado el nombre de la
-- tabla usada en la consulta: si el nombre usado es un alias devuelve el obj de la
-- tabla a la que corresponde y si no, devuelve el obj# de la tabla dada.
-------------------------------------------------------------------------------------
drop function fsql_semantic_obj_id (varchar, varchar) ;
create function fsql_semantic_obj_id (varchar, varchar) 
returns numeric as '
declare
  schemein alias for $1;
  tablein    alias for $2;
  i              integer;
  obj_var numeric;
  sch_var     varchar;
  tab_var     varchar;
  llamadafuncion integer;
  user_var     pg_user.usesysid%type;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_obj_id'');
  -- ver si es un alias
      select into  sch_var n_scheme from all_alias where n_alias=tablein ;
      select into  tab_var n_table from all_alias where n_alias=tablein ;
if found then
      select into  user_var usesysid from pg_user where usename=user ;
      select into obj_var relfilenode from pg_class
           where relowner=user_var and relname=name(tab_var);
      return obj_var;
else
 -- si no existe un alias con ese nombre, devolvemos el obj# del schemein.tablain
      select into  user_var usesysid from pg_user where usename=user ;
      select into obj_var relfilenode from pg_class
          where relowner=user_var and relname=name(tablein);
      if found then
          return obj_var;

      else -- error: no tiene definidos los valores
          llamadafuncion:=fsql_aux_inserta_error(''error semantico: tabla, vista o alias mal situado (''
             ||schemein||''.''||tablein||'').'');
         return 0;
      end if;
end if;
end;
' language 'plpgsql';


-------------------------------------------------------------------------------------
-- devuelve el nombre de una columna cuyos datos se dan por argumentos.
-- tiene en cuenta si el nombre de tabla dado es un alias.
-------------------------------------------------------------------------------------
drop function fsql_semantic_nombre_columna (varchar, varchar, numeric) ;
create function fsql_semantic_nombre_columna (varchar, varchar, numeric) 
returns varchar as '
declare
  schemein alias for $1;
  tablein alias for $2;
  col_id alias for $3;
  i   integer;
  col pg_attribute.attname%type;
  sch_var     varchar;
  tab_var     varchar;
  tabid_var     pg_class.relfilenode%type;
  user_var     pg_user.usesysid%type;
  cadena     varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_nombre_columna'');
  -- ver si es un alias
      select into  sch_var n_scheme from all_alias where n_alias=tablein ;
      select into  tab_var n_table from all_alias where n_alias=tablein ;
if found then
      if sch_var =  schemein then
  --         select into  user_var usesysid from pg_user where usename=user ;
         select into  tabid_var relfilenode from pg_class where relname=name(tab_var) ;
           select into col attname from pg_attribute
               where attrelid=tabid_var and attnum=col_id;
          cadena:=text(col);
         return cadena;
      end if;
else
  -- si no existe un alias con ese nombre:
           select into  user_var usesysid from pg_user 
                 where usename=user ;
           select into  tabid_var relfilenode from pg_class 
                where relname=name(tablein) and relowner=user_var;
           select into col attname from pg_attribute
               where attrelid=tabid_var and attnum=col_id;
          cadena:=text(col);
         return cadena;
end if;
end;
' language 'plpgsql';
--select fsql_semantic_nombre_columna ('trabajo','fuzzy_col_list',3);
-------------------------------------------------------------------------------------
-- devuelve el numero de columnas de una determinada tabla o alias de tabla.
-------------------------------------------------------------------------------------
drop function fsql_semantic_numero_columnas (varchar, varchar);
create function fsql_semantic_numero_columnas (varchar, varchar) 
returns integer as '
declare
  schemein alias for $1;
  tablein alias for $2;
  sch_var     varchar;
  tab_var     varchar;
  tabid_var     pg_class.relfilenode%type;
  user_var     pg_user.usesysid%type;
  i            integer;
  num_columnas integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_numero_columnas'');
  -- ver si es un alias
         select into  sch_var n_scheme from all_alias where n_alias=tablein ;
         select into  tab_var n_table from all_alias where n_alias=tablein ;
if found then
      if sch_var =  schemein then
   --      select into  user_var usesysid from pg_user where usename=user ;
         select into  tabid_var relfilenode from pg_class where relname=name(tab_var) ;
         select into num_columnas count(*) from pg_attribute  
               where attrelid=tabid_var and attnum>0;
         return num_columnas;
      end if;
else
  -- si no existe un alias con ese nombre:
           select into  user_var usesysid from pg_user 
                 where usename=user ;
           select into  tabid_var relfilenode from pg_class 
                where relname=name(tablein) and relowner=user_var;
         select into num_columnas count(*) from pg_attribute  
               where attrelid=tabid_var and attnum>0;
         return num_columnas;
end if;
end;
' language 'plpgsql';
--select fsql_semantic_numero_columnas ('trabajo','fuzzy_col_list');
-------------------------------------------------------------------------------------
-- devuelve el numero de columnas de una determinada tabla o alias de tabla.
-------------------------------------------------------------------------------------
drop function fsql_semantic_hay_columna_en_tabla (varchar, varchar, varchar);
create function fsql_semantic_hay_columna_en_tabla (varchar, varchar, varchar)
returns boolean as '
declare
  schemein alias for $1;
  tablein alias for $2;
  colin alias for $3;
  sch_var     varchar;
  tab_var     varchar;
  tabid_var     pg_class.relfilenode%type;
  user_var     pg_user.usesysid%type;
  i      integer;
  n_objs integer;
  salida boolean;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_hay_columna_en_tabla'');
   salida := ''f'';
  -- ver si es un alias
         select into  sch_var n_scheme from all_alias where n_alias=tablein ;
         select into  tab_var n_table from all_alias where n_alias=tablein ;
if found then
      if sch_var =  schemein then
         select into  tabid_var relfilenode from pg_class where relname=name(tab_var) ;
         select into n_objs count(*) from pg_attribute  
               where attrelid=tabid_var and attname=name(colin);
         salida:=''t'';
         return salida; -- devuelve true si existe la columna
      end if;
else
  -- si no existe un alias con ese nombre:
           select into  user_var usesysid from pg_user 
                 where usename=user;
           select into  tabid_var relfilenode from pg_class 
                where relname=name(tablein) and relowner=user_var;
         select into n_objs count(*) from pg_attribute  
               where attrelid=tabid_var and attname=name(colin);
         if n_objs > 0 then
            salida:=''t'';
         end if;
         return salida; -- devuelve true si existe la columna
end if;
end;
' language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el propietario de una tabla/vista cuyo nombre se pasa por argumentos (tab)
-- si se existe algun error, devuelve null;
-- naturalmente, esta funciun se usa cuando el usuario no especifica el propietario en la consulta.
-- esta funciun comprueba que esa tabla estu puesta en la cluusula from
--    a) si no aparece en la cluusula from genera un error
--  b) si hay una tabla con ese nombre en el from, se devuelve su propietario
--  c) si hay mus de una tabla con ese nombre en el from:
--       seguramente pertenecen a distintos from (de subconsultas).
-- requisitos: se supone que ya se ha chequeado que las tablas del from existen y son
--             accesibles por el usuario actual.
----------------------------------------------------------------------------------------------
drop function fsql_semantic_propietario_tabla (numeric(10), varchar(2000));
create function fsql_semantic_propietario_tabla (numeric(10), varchar(2000))
returns varchar as '
declare
  var_posicion alias for $1;
  var_atributo alias for $2;
  n_objs      integer;
  sch_var     varchar(30);
  propietario varchar(30);
  fila	      record;
  llamadafuncion integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_propietario_tabla'');
  -- ver si es un alias
      select into sch_var n_scheme from all_alias where n_alias=var_atributo ;
  if found then
      return sch_var;
  end if;

  -- contar el numero de tablas del from con ese nombre
  select into n_objs count(*) from fsql_all_queries
    where nombre like ''%tabla'' and atributo=var_atributo;

  if n_objs=0 then -- caso a)
--   podriamos no dar aqui el error: este lo daria oracle al mandar la consulta
     llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||var_posicion
       ||'': tabla o vista ''||var_atributo||'' no consta en la clausula from.'');
     return null;
  elsif n_objs=1 then -- caso b)

  for fila in select indice,posicion,nombre,atributo from fsql_all_queries
       where nombre like ''%tabla'' and atributo=var_atributo loop
     if fila.nombre=''tabla'' then
        -- si no se pone el propietario se supone el usuario
--        select into propietario user;
          propietario:=''public'';
     else 
        select into propietario atributo from fsql_all_queries
          where indice=fila.indice-2;
     end if;
  end loop;


  else -- caso c)
    select into n_objs count(*) from fsql_all_queries
      where nombre=''tabla'' and atributo=var_atributo;
    if n_objs<>0 then
 --       select into propietario user;
        propietario:=''public'';
    else

      for fila in select indice,posicion,nombre,atributo from fsql_all_queries
          where nombre=''s.tabla'' and atributo=var_atributo and
                indice=(select min(indice) from fsql_all_queries
                         where nombre=''s.tabla'' and atributo=var_atributo) loop

         select into propietario atributo from fsql_all_queries
           where indice=fila.indice-2;
      end loop;

    end if;
  end if;
  return ''public'';
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- indica si existe o no la columna indicada en una tupla de fsql_query;
-- en caso afirmativo se devuelve tabla y esquema correspondientes schema.tab.columna
-- si en la consulta no se facilita la tabla se buscaru entre las tablas del from
----------------------------------------------------------------------------------------------
drop function fsql_semantic_existe_columna (numeric(10), varchar(100), varchar(2000),
				            varchar, varchar);
create function fsql_semantic_existe_columna (numeric(10), varchar(100), varchar(2000), 					      varchar, varchar)
returns boolean as '
declare
  columna_indice alias for $1;
  columna_nombre alias for $2;
  columna_atributo alias for $3;
  scheme_entrada alias for $4;
  tab_entrada alias for $5;
  encontradatabla boolean;
  salida boolean;
  llamadafuncion boolean;
  tabla record;
  var_scheme varchar;
  var_tab varchar;

begin
  insert into trama values(nextval(''sec''),''fsql_semantic_existe_columna'');
  var_scheme:=scheme_entrada;
  var_tab:=tab_entrada;

  if columna_nombre=''column'' then
     encontradatabla:=''f'';

     for tabla in select indice,posicion,nombre,atributo from fsql_all_queries
     where nombre like ''%tabla'' loop
     if tabla.nombre is null then
       exit;
     end if;

       if tabla.nombre=''tabla'' then

        --  var_scheme:=fsql_semantic_propietario_tabla(tabla.posicion,tabla.atributo);

        --  update variables set scheme=var_scheme;

	  var_scheme:=''public'';
	  update variables set scheme=''public'';
          if var_scheme is null then
             salida:=''f'';
             return salida;
          end if;
       else 
          select into var_scheme atributo from fsql_all_queries
            where indice=tabla.indice-2;
--          update variables set scheme=var_scheme;
          update variables set scheme=''public'';
       end if;
       select into var_scheme scheme from variables;
       llamadafuncion:=fsql_semantic_hay_columna_en_tabla(var_scheme,tabla.atributo,columna_atributo);
       if llamadafuncion=''t'' then
          encontradatabla:=''t'';
          var_tab:=tabla.atributo; 
          update variables set tab=var_tab;
          exit;
       end if;
     end loop;
     if encontradatabla=''t'' then
        salida:=''t'';
        return salida;
     else
        salida:=''f'';
        return salida;
     end if;

  elsif columna_nombre=''t.column'' then
     for tabla in select indice,posicion,nombre,atributo from fsql_all_queries
       where indice=columna_indice-2 loop
     var_tab:=tabla.atributo;
     update variables set tab=var_tab;
--     var_scheme:=fsql_semantic_propietario_tabla(tabla.posicion,tabla.atributo);
--     update variables set scheme=var_scheme;
     update variables set scheme=''public'';
     var_scheme:=''public'';
     if var_scheme is null then
        salida:=''f'';
        return salida;
     end if; -- la consulta contiene un error en esa tabla
     exit;
     end loop;
  else 
     select into var_tab atributo from fsql_all_queries
       where indice=columna_indice-2;
     update variables set tab=var_tab;
     select into var_scheme atributo from fsql_all_queries
       where indice=columna_indice-4;
--     update variables set scheme=var_scheme;
     update variables set scheme=''public'';
  end if;
  llamadafuncion:=fsql_semantic_hay_columna_en_tabla(var_scheme,var_tab,columna_atributo);
  return llamadafuncion;

end;
' language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el tipo fuzzy (1,2 u 3) de la columna en la tabla fuzzy_col_list (fcl)
-- si existe en fcl, ademus, devuelve en obj y col los identificadores de la columna
-- si no existe la columna en fcl, devuelve 0.
----------------------------------------------------------------------------------------------
drop function fsql_semantic_tipo_en_fcl(varchar, varchar, varchar, fuzzy_col_list.obj%type, fuzzy_col_list.col%type);
create function fsql_semantic_tipo_en_fcl(varchar, varchar, varchar, fuzzy_col_list.obj%type, fuzzy_col_list.col%type)
  returns fuzzy_col_list.f_type%type as '
declare
  scheme1  alias for $1;
  tabla   alias for $2;
  columna alias for $3;
  obj_var     alias for $4;
  col_var     alias for $5;
  obj_var2 fuzzy_col_list.obj%type;
  col_var2 fuzzy_col_list.col%type;
  tipo fuzzy_col_list.f_type%type;
  s       varchar(30);
  t       varchar(30);
  llamadafuncion varchar;
  i int4;
  bandera boolean;
  cadena varchar;
  tabid_var     pg_class.relfilenode%type;
  user_var     pg_user.usesysid%type;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_tipo_en_fcl'');
  s:=scheme1;
  t:=tabla;
  obj_var2:=fsql_semantic_obj_id(scheme1,tabla);
  update variables set obj=obj_var2;
  llamadafuncion:=fsql_semantic_nombre_owner_table(s,t);
  if llamadafuncion is not null then
     s:='''';
     t:='''';
     bandera=''f'';
    for i in 1..length(llamadafuncion) loop
       cadena:=substr(llamadafuncion,i,1);
       if cadena = ''='' then
          bandera=''t'';
       end if;
       if not bandera then
          s:=s || cadena;
       elsif cadena <> ''='' then
          t:=t || cadena;
       end if;
    end loop;
  end if;

  select into  user_var usesysid from pg_user 
    where usename=user ;
  select into  tabid_var relfilenode from pg_class 
    where relname=name(t) and relowner=user_var;
  select into col_var2 attnum from pg_attribute
    where attrelid=tabid_var and attname=name(columna);
  update variables set col=col_var2;
  select into tipo f_type from fuzzy_col_list
    where obj=obj_var2 and col=col_var;
  if not found then
     return 0;
  else
     return tipo;
  end if;
end;'
  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- examina una columna de la consulta (fsql_query) para ver si existe o no.
-- si no existe (como crisp o como difusa) inserta un error en fsql_errors
-- si existe, devuelve si una columna de la consulta es difusa o no
-- obtiene sus valores de obj (identificador de tabla), col y su tipo difuso
----------------------------------------------------------------------------------------------
drop function fsql_semantic_es_fuzzy_column (numeric(10),numeric(10),varchar(100),
			  varchar(2000),varchar,varchar, fuzzy_col_list.f_type%type,
			  fuzzy_col_list.obj%type, fuzzy_col_list.col%type);
create function fsql_semantic_es_fuzzy_column (numeric(10),numeric(10),varchar(100),
			  varchar(2000),varchar,varchar, fuzzy_col_list.f_type%type,
			  fuzzy_col_list.obj%type, fuzzy_col_list.col%type) 
returns boolean as '
declare
  columna_indice alias for $1;
  columna_posicion alias for $2;
  columna_nombre alias for $3;
  columna_atributo alias for $4;
  scheme_entrada alias for $5;
  tab_entrada alias for $6;
  f_tipo1 alias for $7;
  obj_entrada alias for $8;
  col_entrada alias for $9;
  obj_var numeric;
  col_var numeric;
  f_tipo_var numeric(1);
  column_indice numeric(10);
  column_nombre varchar(100);
  column_atributo varchar(2000);
  column_posicion numeric(10);
  scheme_var varchar;
  tab_var varchar;
  llamadafuncion boolean;
  llamadafuncionerror integer;
  cadena varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_es_fuzzy_column'');
  column_indice:=columna_indice;
  column_nombre:=columna_nombre;
  column_atributo:=columna_atributo;
  column_posicion:=columna_posicion;
  obj_var:=obj_entrada;
  col_var:=col_entrada;
  f_tipo_var:=f_tipo1;
  scheme_var:=scheme_entrada;
  tab_var:=tab_entrada;
  update variables set tab=tab_var;
  update variables set scheme=scheme_var;
  if column_nombre=''\*column'' then 
	return ''t''; 
  elsif column_atributo in (''currval'',''nextval'',''level'',''rowid'',''rownum'') then
     update fsql_all_queries set nombre=''crisp_col'' where indice=column_indice;
     return ''f'';
  else
   llamadafuncion:=fsql_semantic_existe_columna(column_indice,column_nombre,column_atributo,scheme_var,tab_var);
  if llamadafuncion=''t'' then
     select into scheme_var scheme from variables;
     select into tab_var tab from variables;
     f_tipo_var:=fsql_semantic_tipo_en_fcl(scheme_var,tab_var,column_atributo,obj_var,col_var);
     update variables set f_tipo=f_tipo_var;
     select into obj_var obj from variables;
     select into col_var col from variables;
     if f_tipo_var<>1 then 
	update fsql_all_queries set nombre=''crisp_col''
          where indice=column_indice;
	return ''f'';
     end if;
     return ''t'';
  else
     column_atributo:=column_atributo||''t'';
     llamadafuncion:=fsql_semantic_existe_columna(column_indice,column_nombre,column_atributo,scheme_var,tab_var);
     if llamadafuncion = ''f'' then 
	select into scheme_var scheme from variables;
	select into tab_var tab from variables;
	update fsql_all_queries set nombre=''ok'' where indice=column_indice;
        if column_nombre=''column'' then
	   cadena:=substr(column_atributo,1,length(column_atributo)-1);
	   llamadafuncionerror:=fsql_aux_inserta_error(''error semantico en posicion ''||column_posicion||'': nombre de columna ''||cadena ||'' no valido.'');
        elsif column_nombre=''t.column'' then
	   cadena:=substr(column_atributo,1,length(column_atributo)-1);
	   llamadafuncionerror:=fsql_aux_inserta_error(''error semantico en posicion ''||column_posicion||'': nombre de columna ''||tab_var||''.''||cadena||'' no vulido.'');
        else
	   cadena:=substr(column_atributo,1,length(column_atributo)-1);
	   llamadafuncionerror:=fsql_aux_inserta_error(''error semantico en posicion ''||column_posicion||'': nombre de columna ''||scheme_var||''.''||tab_var||''.''||cadena||'' no vulido.'');
	end if;
     else 
	f_tipo_var:=fsql_semantic_tipo_en_fcl(scheme_var,tab_var,column_atributo,obj_var,col_var);
	update variables set f_tipo=f_tipo_var;
	select into obj_var obj from variables;
	select into col_var col from variables;
	column_atributo:=substr(column_atributo,1,length(column_atributo)-1);
        if f_tipo_var=0 then 
	  llamadafuncionerror:=fsql_aux_inserta_error(''error en first en posicion ''||column_posicion||'': columna difusa ''||scheme_var||''.''||tab_var||''.''||column_atributo||  '' no existe en fuzzy_col_list, (obj,col)=(''||obj_var||'',''||col_var||'').'');
	else
	  return ''t'';
	end if;
    end if;
  end if;
  end if;
  return ''f'';
end;
' language 'plpgsql';
drop function fsql_semantic_trata_fuzzy_column (numeric(10),numeric(10),
					varchar(100),varchar(2000),fsql_all_queries.nombre%type,
					fsql_all_queries.nombre%type,fuzzy_col_list.f_type%type,
					fuzzy_col_list.obj%type,fuzzy_col_list.obj%type);
create function fsql_semantic_trata_fuzzy_column (numeric(10),numeric(10),
					varchar(100),varchar(2000),fsql_all_queries.nombre%type,
					fsql_all_queries.nombre%type,fuzzy_col_list.f_type%type,
					fuzzy_col_list.obj%type,fuzzy_col_list.obj%type)
returns integer as '
declare
  columna_indice alias for $1;
  columna_posicion alias for $2;
  columna_nombre alias for $3;
  columna_atributo alias for $4;
  scheme_var alias for $5;
  tab_var alias for $6;
  f_tipo_var alias for $7;
  obj1 alias for $8;
  col1 alias for $9;
  token_ant fsql_all_queries.nombre%type;
  token_sig fsql_all_queries.nombre%type;
  alias_var    varchar(30);
  st        varchar(62);
  margen_var    fuzzy_approx_much.margen%type;
  much_var      fuzzy_approx_much.much%type;
  umbral    varchar(2);
  fcomp     varchar(5);
  fcompsinn varchar(4);
  alfa_var  fsql_all_queries.atributo%type;
  beta_var  fsql_all_queries.atributo%type;
  gamma_var fsql_all_queries.atributo%type;
  delta_var fsql_all_queries.atributo%type;
  f_id      fuzzy_label_def.fuzzy_id%type;
  pos       fsql_all_queries.posicion%type;
  columna2  record;
  scheme2   fsql_all_queries.nombre%type;
  tab2      fsql_all_queries.nombre%type;
  f_tipo2   fuzzy_col_list.f_type%type;
  obj_var      fuzzy_col_list.obj%type;
  col_var      fuzzy_col_list.col%type;
  obj2_var      fuzzy_col_list.obj%type;
  col2_var      fuzzy_col_list.col%type;
  ind       fsql_all_queries.indice%type;
  length1   fuzzy_col_list.len%type;
  length2   fuzzy_col_list.len%type;
  argstipo3 varchar(1500);
  argstipo3_var varchar(1500);
  llamafuncion integer;
  cuenta_filas integer;
  caracter varchar;  llamafuncion2 boolean;  cadena varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_trata_fuzzy_column'');
  obj_var := obj1;
  col_var := col1;  scheme2:=''public'';
  if columna_nombre=''*column'' then
     caracter:=''*\\\cdeg'';
     update fsql_all_queries set nombre=caracter where indice=columna_indice;

     update fsql_all_queries set atributo=null
       where indice between columna_indice-2 and columna_indice-1;
     return 1;
  end if;

  if columna_nombre=''column'' then
--    st:=null;
    st:=''''; select into token_ant,pos nombre,posicion from fsql_all_queries
      where indice=columna_indice-1;
  elsif columna_nombre=''t.column'' then
    st:=tab_var||''.'';
    select into token_ant,pos nombre,posicion from fsql_all_queries
      where indice=columna_indice-3;
    update fsql_all_queries set atributo=null
      where indice between columna_indice-2 and columna_indice-1;
  elsif columna_nombre=''s.t.column'' then
    st:=scheme_var||''.''||tab_var||''.'';
    select into token_ant,pos nombre,posicion from fsql_all_queries
      where indice=columna_indice-5;
    update fsql_all_queries set atributo=null
      where indice between columna_indice-4 and columna_indice-1;
  end if;

  select into token_sig nombre from fsql_all_queries
      where indice=columna_indice+1;
  if not found then
	token_sig:=null;
  end if;

--***** ***** ***** ***** ***** select list ***** ***** ***** ***** *****

  if (token_ant in (''select'','', en sl'',''all'',''distinct'')) and
     (token_sig in (''from'',''c_alias'','', en sl'')) then

     if f_tipo_var=2 or f_tipo_var=3 then
        if token_sig<>''c_alias'' then
           alias_var:='' ''||columna_atributo;
        else 
		alias_var:=null;
        end if;
        llamafuncion:=fsql_aux_fuzzy_column_en_sl(st||columna_atributo,columna_indice,f_tipo_var,obj_var,col_var,alias_var);
     end if;

  elsif token_sig='') function'' then

    if columna_nombre=''column'' then
       ind:=columna_indice-2;
       select into token_ant nombre from fsql_all_queries where indice=ind;
    elsif columna_nombre=''t.column'' then
       ind:=columna_indice-4;
       select into token_ant nombre from fsql_all_queries where indice=ind;
    else
       ind:=columna_indice-6;
       select into token_ant nombre from fsql_all_queries where indice=ind;
    end if;
    if token_ant=''cdeg'' then
       caracter:=''\\\cdeg'';
       update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter
         where indice=columna_indice;

       update fsql_all_queries set atributo=null
         where indice between ind and ind+1;
    else

       if f_tipo_var=2 or f_tipo_var=3 then
          llamafuncion:=fsql_aux_fuzzy_column_en_sl(st||columna_atributo,columna_indice,f_tipo_var,obj_var,col_var,alias_var);
       end if;
    end if;

-- ***** ***** clausula where: 8 tipos de condiciones fuzzy ***** *****


--***** ***** ***** antes de un fcomparador: fcol <fcomp> <expr> ***** ***** *****
  elsif token_sig in (''fgt'',''flt'',''feq'',''fgeq'',''fleq'',''mgt'',''mlt'',
                      ''nfgt'',''nflt'',''nfeq'',''nfgeq'',''nfleq'',''nmgt'',''nmlt'') then
    fcomp:=token_sig;
    update fsql_all_queries set atributo=null 
      where indice=columna_indice+1;

    select into token_sig nombre from fsql_all_queries
      where indice=columna_indice+2;

--***** ***** ***** valor aproximado: fcol  ***** ***** *****
    if token_sig=''aki_falta_gato'' then
       if f_tipo_var=3 then
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': columna difusa ''||st||columna_atributo||
            '' es tipo 3 y no se puede comparar con un valor aproximado '' || ''aki_falta_gato'' || ''n.'');
       else
           select into margen_var,much_var margen,much from fuzzy_approx_much where obj=obj_var and col=col_var;
	   if not found then
             llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
               '': columna difusa ''||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var||''), no tiene el margen establecido para poder usar valores aproximados n:''||'' introducir uno en la tabla fuzzy_approx_much.'');
	   else
           select into token_sig atributo from fsql_all_queries
             where indice=columna_indice+3;

           umbral:=fsql_aux_calcula_umbral(columna_indice+4);
           if f_tipo_var=2 then
              if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

                 llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		 if margen_var is null then
			return 1;
		 end if;

caracter:=''\\\\'';
                 update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                   atributo=''fsql_functions2_''||fcomp||''_aprox(''||
                   token_sig||'',''||trim(to_char(to_number(token_sig,''9999999999'')-margen_var,''9999999999''))||'',''||
                   trim(to_char(to_number(token_sig,''9999999999'')+margen_var,''9999999999''))||'',''||margen_var||'',''||
                   obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''||
                   st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                   st||columna_atributo||''3,''||st||columna_atributo||''4,''
                   ||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                   where indice=columna_indice;
              else
caracter:=''\\\\'';
                 update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                   atributo=''fsql_functions_''||fcomp||''_aprox(''||
                   token_sig||'',''||trim(to_char(to_number(token_sig,''9999999999'')-margen_var,''9999999999''))||'',''||
                   trim(to_char(to_number(token_sig,''9999999999'')+margen_var,''9999999999''))||'',''||margen_var||'',''||
                   obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''||
                   st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                   st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral
                   where indice=columna_indice;
              end if;
           else
             if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions2_''||fcomp||''_crisp_aprox(''
                  ||st||columna_atributo||'',''||token_sig||'',''
                  ||trim(to_char(to_number(token_sig,''9999999999'')-margen_var,''9999999999''))||'',''
                  ||trim(to_char(to_number(token_sig,''9999999999'')+margen_var,''9999999999''))||'',''||margen_var
                  ||'',''||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                  where indice=columna_indice;
             else
caracter:=''\\\\'';
                fcompsinn:=fsql_aux_sin_n(fcomp);
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions_''||fcompsinn||''_crisp_aprox(''
                  ||st||columna_atributo||'',''||token_sig||'',''
                  ||trim(to_char(to_number(token_sig,''9999999999'')-margen_var,''9999999999''))||'',''
                  ||trim(to_char(to_number(token_sig,''9999999999'')+margen_var,''9999999999''))||'',''||margen_var||'')''||umbral
                  where indice=columna_indice;
             end if;
           end if;
           update fsql_all_queries set atributo=null
             where indice between columna_indice+2 and columna_indice+3;
           
           end if;
       end if;

--***** ***** ***** valor intervalo: fcol <fcomp> [n,m] ***** ***** *****
    elsif token_sig=''['' then
       if f_tipo_var=3 then
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': columna difusa ''||st||columna_atributo||
            '' es tipo 3 y no se puede comparar con un intervalo [n,m].'');
       elsif f_tipo_var=2 then
         if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
            update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
              atributo=''fsql_functions2_''||fcomp||''_inter(''
              where indice=columna_indice;

            update fsql_all_queries set atributo=null where indice=columna_indice+2;

            umbral:=fsql_aux_calcula_umbral(columna_indice+7);

            llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
            if margen_var is null then
		return 1;
	    end if;
            update fsql_all_queries set atributo='',''||obj_var||'',''||col_var||'',''
              ||st||columna_atributo||''t,''
              ||st||columna_atributo||''1,''||st||columna_atributo||''2,''
              ||st||columna_atributo||''3,''||st||columna_atributo||''4,''
              ||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
              where indice=columna_indice+6;
         else
caracter:=''\\\\'';
            update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
              atributo=''fsql_functions_''||fcomp||''_inter(''
              where indice=columna_indice;

            update fsql_all_queries set atributo=null where indice=columna_indice+2;

            umbral:=fsql_aux_calcula_umbral(columna_indice+7);
            update fsql_all_queries set atributo='',''||obj_var||'',''||col_var||'',''||
              st||columna_atributo||''t,''||
              st||columna_atributo||''1,''||st||columna_atributo||''2,''||
              st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral
              where indice=columna_indice+6;
         end if;
       else

         fcompsinn:=fsql_aux_sin_n(fcomp);
         if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
            update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
              atributo=''fsql_functions2_''||fcompsinn||''_crisp_finter(''||st||columna_atributo||'',''
              where indice=columna_indice;

            update fsql_all_queries set atributo=null where indice=columna_indice+2;

            umbral:=fsql_aux_calcula_umbral(columna_indice+7);

            llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
            if margen_var is null then
		return 1;
	    end if;

            update fsql_all_queries set atributo='',''||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
              where indice=columna_indice+6;
         else
caracter:=''\\\\'';
            update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
              atributo=''fsql_functions_''||fcompsinn||''_crisp_finter(''||st||columna_atributo||'',''
              where indice=columna_indice;

            update fsql_all_queries set atributo=null where indice=columna_indice+2;

            umbral:=fsql_aux_calcula_umbral(columna_indice+7);

            llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
            if margen_var is null then
		return 1;
	    end if;
            update fsql_all_queries set atributo='',''||trim(to_char(margen_var,''9999999999''))||'')''||umbral
              where indice=columna_indice+6;
         end if;
       end if;

    elsif token_sig=''$'' then
      select into token_sig nombre from fsql_all_queries
        where indice=columna_indice+3;

--***** ***** ***** valor trapecio: fcol <fcomp> $[a,b,c,d] ***** ***** *****
      if token_sig=''['' then
        if f_tipo_var=3 then
           llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
             '': columna difusa ''||st||columna_atributo||
             '' es tipo 3 y no se puede comparar con un trapecio $[a,b,c,d].'');
        else

          select into alfa_var  atributo from fsql_all_queries where indice=columna_indice+4;
          select into beta_var  atributo from fsql_all_queries where indice=columna_indice+6;
          select into gamma_var atributo from fsql_all_queries where indice=columna_indice+8;
          select into delta_var atributo from fsql_all_queries where indice=columna_indice+10;

          if to_number(alfa_var,''9999999999'') >to_number(beta_var,''9999999999'')  or
             to_number(beta_var,''9999999999'') >to_number(gamma_var,''9999999999'') or
             to_number(gamma_var,''9999999999'')>to_number(delta_var,''9999999999'') then
             llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion
             ||'': trapecio posibilistico mal definido: $[a,b,c,d] tal que a<=b<=c<=d.''
             ||'' valores actuales: $[''||to_number(alfa,''9999999999'')||'',''||to_number(beta_var,''9999999999'')||'',''
             ||to_number(gamma_var,''9999999999'')||'',''||to_number(delta_var,''9999999999'')||''].'');
          end if;
          umbral:=fsql_aux_calcula_umbral(columna_indice+12);
          if f_tipo_var=2 then

             if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

                llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		   return 1;
		end if;
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions2_''||fcomp||''_trape(''
                  ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                  ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta||'',''
                  ||obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''||
                  st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                  st||columna_atributo||''3,''||st||columna_atributo||''4,''
                  ||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                  where indice=columna_indice;
             else
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions_''||fcomp||''_trape(''
                  ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                  ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var||'',''
                  ||obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''||
                  st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                  st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral
                  where indice=columna_indice;
             end if;

          else

             if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

                llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
                if margen_var is null then
		   return 1;
		end if;
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions2_''||fcomp||''_crisp_trape(''||st||columna_atributo||'',''
                  ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                  ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var
                  ||'',''||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                  where indice=columna_indice;
             else
                fcompsinn:=fsql_aux_sin_n(fcomp);
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions_''||fcompsinn||''_crisp_trape(''||st||columna_atributo||'',''||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa,''9999999999''),''9999999999''))||'',''
                  ||trim(to_char(to_number(gamma,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var||'')''||umbral
                  where indice=columna_indice;
             end if;
          end if;

          update fsql_all_queries set atributo=null
            where indice between columna_indice+2 and columna_indice+11;
        end if;

--***** ***** ***** valor etiqueta: fcol <fcomp> $label ***** ***** *****
      else
        select into alfa_var,pos atributo,posicion from fsql_all_queries
          where indice=columna_indice+3;
        umbral:=fsql_aux_calcula_umbral(columna_indice+4);
        if f_tipo_var=2 then
            select into cuenta_filas count(*) from fuzzy_object_list
              where obj=obj_var and col=col_var and fuzzy_name=alfa_var;

            select into f_id fuzzy_id from fuzzy_object_list
              where obj=obj_var and col=col_var and fuzzy_name=alfa_var;
          if not found then
              select into pos posicion from fsql_all_queries
                where indice=columna_indice+3;
              llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                '': no esta definida la etiqueta ''||alfa_var||'' para la columna difusa tipo 2 ''
                ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var
                ||''): definirla en fuzzy_object_list y fuzzy_label_def.'');
	  elsif cuenta_filas > 1 then
              select into pos posicion from fsql_all_queries
                where indice=columna_indice+3;
              llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                '': la etiqueta ''||alfa_var||'' esta definida multiples veces en fuzzy_object_list para la columna difusa tipo 2 ''
                ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var||'').'');
	  else
              select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta from fuzzy_label_def
                where obj=obj_var and col=col_var and fuzzy_id=f_id;
--	      if not found then
--                llamafuncion:=fsql_aux_inserta_error(''error en first en posicion ''||pos||
--                  '': etiqueta ''||alfa_var||'' definida en fuzzy_object_list para el atributo tipo 2''
--                  ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var
--                  ||''), y no definida en fuzzy_label_def.'');
--                return 1;
--              else
 --                if to_number(alfa_var,''9999999999'') >to_number(beta_var,''9999999999'')  or
--                    to_number(beta_var,''9999999999'') >to_number(gamma_var,''9999999999'') or
--                    to_number(gamma_var,''9999999999'')>to_number(delta_var,''9999999999'') then
--                    llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
--                    '': trapecio posibilistico de la etiqueta mal definido: $[a,b,c,d] tal que a<=b<=c<=d.''||'' actualmente definida como $[''||to_number(alfa_var,''9999999999'')||'',''||to_number(beta_var,''9999999999'')||'',''||to_number(gamma_var,''9999999999'')||'',''||to_number(delta_var,''9999999999'')||''].'');
--              end if;
            
--            end if;

            if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

               llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
               if margen_var is null then
		  return 1;
	       end if;
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions2_''||fcomp||''_trape(''
                 ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                 ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var||'',''
                 ||obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''
                 ||st||columna_atributo||''1,''||st||columna_atributo||''2,''
                 ||st||columna_atributo||''3,''||st||columna_atributo||''4,''
                 ||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                 where indice=columna_indice;
            else
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter where indice=columna_indice;
                cadena := ''fsql_functions_''||fcomp||''_trape(''||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var||'',''||obj_var||'',''||col_var||'',''||st||columna_atributo||''t,''||st||columna_atributo ||''1,''||st||columna_atributo||''2,''||st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral;
             update fsql_all_queries set atributo=cadena where indice=columna_indice;
            end if;

            update fsql_all_queries set atributo=null
              where indice between columna_indice+2 and columna_indice+3;

          end if; --- begin exception too_many_rows end
        elsif f_tipo_var=1 then

            select into cuenta_filas count(*) from fuzzy_object_list
              where obj=obj_var and col=col_var and fuzzy_name=alfa_var;

            select into f_id fuzzy_id from fuzzy_object_list
              where obj=obj_var and col=col_var and fuzzy_name=alfa_var;
          if not found then
              select into pos posicion from fsql_all_queries
                where indice=columna_indice+3;
              llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                '': no esta definida la etiqueta ''||alfa_var||'' para la columna difusa tipo 1 ''
                ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var
                ||''): definirla en fuzzy_object_list y fuzzy_label_def.'');
          elsif cuenta_filas > 1 then 
              select into pos posicion from fsql_all_queries
                where indice=columna_indice+3;
              llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                '': la etiqueta ''||alfa_var||'' esta definida multiples veces en fuzzy_object_list para la columna difusa tipo 1 ''
                ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var||'').'');
	  else
              select into alfa_var,beta_var,gamma_var,delta_var alfa,beta,gamma,delta from fuzzy_label_def
                where obj=obj_var and col=col_var and fuzzy_id=f_id;

            if not found then
                llamafuncion:=fsql_aux_inserta_error(''error en first en posicion ''||pos||
                  '': etiqueta ''||alfa_var||'' definida en fuzzy_object_list para el atributo tipo 1''
                  ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var
                  ||''), y no definida en fuzzy_label_def.'');
                return 1;
	    else
              if to_number(alfa_var,''9999999999'') >to_number(beta_var,''9999999999'')  or
                 to_number(beta_var,''9999999999'') >to_number(gamma_var,''9999999999'') or
                 to_number(gamma_var,''9999999999'')>to_number(delta_var,''9999999999'') then
                 llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                 '': trapecio posibilistico de la etiqueta mal definido: $[a,b,c,d] tal que a<=b<=c<=d.''||'' actualmente definida como $[''||to_number(alfa_var,''9999999999'')||'',''||to_number(beta_var,''9999999999'')||'',''||to_number(gamma_var,''9999999999'')||'',''||to_number(delta_var,''9999999999'')||''].'');
              end if;

            end if;  -- de el not found

            if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

               llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		  return 1;
		end if;
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions2_''||fcomp||''_crisp_trape(''||st||columna_atributo||'',''
                 ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                 ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var
                 ||'',''||trim(to_char(margen_var,''9999999999''))||'',''||trim(to_char(much_var,''9999999999''))||'')''||umbral
                 where indice=columna_indice;
            else
               fcompsinn:=fsql_aux_sin_n(fcomp);
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions_''||fcompsinn||''_crisp_trape(''||st||columna_atributo||'',''
                 ||alfa_var||'',''||trim(to_char(to_number(beta_var,''9999999999'')-to_number(alfa_var,''9999999999''),''9999999999''))||'',''
                 ||trim(to_char(to_number(gamma_var,''9999999999'')-to_number(delta_var,''9999999999''),''9999999999''))||'',''||delta_var||'')''||umbral
                 where indice=columna_indice;
            end if;

            update fsql_all_queries set atributo=null
              where indice between columna_indice+2 and columna_indice+3;

          end if; -- begin exception too_many_rows end
        else
            if fcomp<>''feq'' then
               llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
                 '': no esta definido el operador ''||fcomp||
                 '' sobre atributos tipo 3 como el utilizado: ''||st||columna_atributo||''.'');
            else
              select into length1 len from fuzzy_col_list where obj=obj_var and col=col_var;

              select into obj2_var,col2_var obj2,col2 from fuzzy_compatible_col
                where obj1=obj_var and col1=col_var;
              if not found then
		 obj2_var:=obj_var;
		 col2_var:=col_var;
              end if;

              select into cuenta_filas count(*) from fuzzy_object_list
                where obj=obj2_var and col=col2_var and fuzzy_name=alfa_var;

              select into f_id fuzzy_id from fuzzy_object_list
                where obj=obj2_var and col=col2_var and fuzzy_name=alfa_var;
              if not found then
                  if obj_var=obj2_var and col_var=col2_var then
			argstipo3:=null;
                  else
			argstipo3:='', compatible con (''||obj2_var||'',''||col2_var||'')'';
                  end if;
                  select into pos posicion from fsql_all_queries
                    where indice=columna_indice+3;
                  llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                    '': no esta definida la etiqueta ''||alfa_var||'' para la columna difusa tipo 3 ''||
                    st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var||'')''||argstipo3
                    ||'': definirla en fuzzy_object_list y en fuzzy_nearness_def.'');

              elsif cuenta_filas > 1 then
                  if obj_var=obj2_var and col_var=col2_var then
			argstipo3:=null;
                  else
			argstipo3:='', compatible con (''||obj2_var||'',''||col2_var||'')'';
                  end if;
                  select into pos posicion from fsql_all_queries
                    where indice=columna_indice+3;
                  llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
                    '': la etiqueta ''||alfa_var||'' est definida multiples veces en fuzzy_object_list para la columna difusa tipo 3 ''
                    ||st||columna_atributo||'', (obj,col)=(''||obj_var||'',''||col_var||'')''||argstipo3||''.'');
	      else
                if length1=1 then
caracter:=''\\\\'';
                   update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                     atributo=''fsql_functions_feq3_label_len1(''||
                     obj2_var||'',''||col2_var||'',''||f_id||'',''||st||columna_atributo||''t,''||
                     st||columna_atributo||''p1,''||st||columna_atributo||''1)''||umbral
                     where indice=columna_indice;
                else
                   argstipo3:=fsql_aux_resto_llamada_tipo3(st||columna_atributo,length1);
caracter:=''\\\\'';
                   update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                     atributo=''fsql_functions_feq3_label(''||
                     obj2_var||'',''||col2_var||'',''||f_id||'',''||length1||'',''||argstipo3||umbral
                     where indice=columna_indice;
                end if;

                update fsql_all_queries set atributo=null
                  where indice between columna_indice+2 and columna_indice+3;

              end if; --- begin exception too_many_rows end
            end if;
          end if;
      end if;

--***** ***** ***** ctes. difusas: fcol <fcomp> <cte. difusa> ***** ***** *****

--- aki duda
    elsif token_sig in (''unknown'',''undefined'',''null'') then
      if fcomp<>''feq'' then
         llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
           '': no puede usarse el comparador difuso ''||fcomp||
           '' para comparar un atributo (''||st||columna_atributo||
           '') con la constante ''||token_sig||'': usar feq o is [not].'');
      else
        if (f_tipo_var=2) or (f_tipo_var=3 and token_sig=''undefined'') then
caracter:=''\\\\'';
           update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
             atributo=''fsql_functions_feq_''||token_sig||''(''||st||columna_atributo||''t)''
             where indice=columna_indice;
        elsif f_tipo_var=3 then
           select into length1 len from fuzzy_col_list where obj=obj_var and col=col_var;
           argstipo3:=fsql_aux_resto_llamada_tipo3(st||columna_atributo,length1);
caracter:=''\\\\'';
           update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
             atributo=''fsql_functions_feq3_unknown_null(''||length1||'',''||argstipo3
             where indice=columna_indice;
        else
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': columna ''|| st||columna_atributo||
            '' es tipo 1, y no puede compararse con la constante difusa ''||token_sig||''.'');
          return 1;
        end if;

        update fsql_all_queries set atributo=null
          where indice=columna_indice+2;

        ind:=columna_indice+2;
        loop
          ind:=ind+1;

          select into token_sig nombre from fsql_all_queries where indice=ind;
          if not found then
		token_sig:=''sin umbral'';
          end if;
	  if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
		exit;
	  end if;
        end loop;

        umbral:=fsql_aux_calcula_umbral(ind);
        if umbral is not null then
           update fsql_all_queries set atributo=atributo||umbral where indice=ind-1;
        end if;
      end if;


--***** ***** ***** expresion: fcol <fcomp> <expr> ***** ***** *****

    else
      ind:=-1;
      if token_sig=''s.t.'' then
         ind:=columna_indice+6;
         select into columna2 indice,posicion,nombre,atributo from fsql_all_queries
           where indice=ind;
      elsif token_sig=''t.'' then
         ind:=columna_indice+4;
         select into columna2 indice,posicion,nombre,atributo from fsql_all_queries
           where indice=ind;
      elsif token_sig=''column'' then
         ind:=columna_indice+2;
         select into columna2 indice,posicion,nombre,atributo from fsql_all_queries
           where indice=ind;
      end if;

--***** ***** ***** columna: fcol1 <fcomp> fcol2 ***** ***** *****
      llamafuncion2:=fsql_semantic_es_fuzzy_column(columna2.indice,columna2.posicion,columna2.nombre,columna2.atributo,scheme2,tab2,f_tipo2,obj2,col2);
      if ind<>-1 and llamafuncion2 = ''t'' then
        update fsql_all_queries set nombre=''ok'',atributo=null
          where indice between columna_indice+2 and ind-1;
caracter:=''\\\\'';
        update fsql_all_queries set nombre=scheme2||''.''||tab2||''.''||columna2.atributo||caracter||''2''||caracter,
          atributo=null where indice=ind;

        if columna2.nombre=''t.column'' then
           columna2.atributo:=tab2||''.''||columna2.atributo;
        else	   if columna2.nombre=''s.t.column'' then
              columna2.atributo:=scheme2||''.''||tab2||''.''||columna2.atributo;			  end if;
        end if;

        if f_tipo_var=2 and (f_tipo2 in (1,2)) then
          if f_tipo2=2 then

             if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
                llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		   return 1;
		end if;
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme||''.''||tab||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions2_''||fcomp||''(''||obj_var||'',''||col_var||'',''||
                  st||columna_atributo||''t,''||
                  st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                  st||columna_atributo||''3,''||st||columna_atributo||''4,''||
                  obj2_var||'',''||col2_var||'',''||
                  columna2.atributo||''t,''||columna2.atributo||''1,''||columna2.atributo||''2,''||
                  columna2.atributo||''3,''||columna2.atributo||''4,''
                  ||to_char(margen_var,''9999999999'')||'',''||to_char(much_var, ,''9999999999'')||'')'' 
                  where indice=columna_indice;
             else
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme||''.''||tab||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions_''||fcomp||''(''||obj_var||'',''||col_var||'',''||
                  st||columna_atributo||''t,''||
                  st||columna_atributo||''1,''||st||columna_atributo||''2,''||
                  st||columna_atributo||''3,''||st||columna_atributo||''4,''||
                  obj2_var||'',''||col2_var||'',''||
                  columna2.atributo||''t,''||columna2.atributo||''1,''||columna2.atributo||''2,''||
                  columna2.atributo||''3,''||columna2.atributo||''4)''
                  where indice=columna_indice;
             end if;

             loop
               ind:=ind+1;

                 select into token_sig nombre from fsql_query where indice=ind;
               if not found then
		  token_sig:=''sin umbral'';
               end if;
		if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit;
		end if;
             end loop;

             umbral:=fsql_aux_calcula_umbral(ind);
             if umbral is not null then
                update fsql_all_queries set atributo=atributo||umbral where indice=ind-1;
             end if;
          else

            if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
                 update fsql_all_queries set nombre=scheme||''.''||tab_var||''.''||columna_atributo||caracter,
                   atributo=''fsql_functions2_''||fcomp||''_crisp(''||columna2.atributo
                   where indice=columna_indice;
            else
caracter:=''\\\\'';
		update fsql_all_queries set nombre=scheme||''.''||tab_var||''.''||columna_atributo||caracter,
                   atributo=''fsql_functions_''||fcomp||''_crisp(''||columna2.atributo
                   where indice=columna_indice;
            end if;

            ind:=columna_indice+2;
            loop
              ind:=ind+1;
                select into token_sig nombre from fsql_all_queries where indice=ind;
              if not found then
		 token_sig:=''sin umbral'';
              end if;
	      if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
		 exit;
	      end if;
            end loop;

            umbral:=fsql_aux_calcula_umbral(ind);
            if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

               llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		  return 1;
		end if;
               update fsql_all_queries set atributo=atributo||'',''||obj_var||'',''||col_var||'',''
                 ||st||columna_atributo||''t,''
                 ||st||columna_atributo||''1,''||st||columna_atributo||''2,''
                 ||st||columna_atributo||''3,''||st||columna_atributo||''4,''
                 ||to_char(margen_var, ''9999999999'')||'',''||to_char(much_var, ''9999999999'')||'')''||umbral
                 where indice=ind-1;
            else
               update fsql_all_queries set atributo=atributo||'',''||obj_var||'',''||col_var||'',''
                 ||st||columna_atributo||''t,''
                 ||st||columna_atributo||''1,''||st||columna_atributo||''2,''
                 ||st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral
                 where indice=ind-1;
            end if;
          end if;

        elsif f_tipo_var=3 and f_tipo2=3 then
          if fcomp<>''feq'' then
             llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion
               ||'': no esta definido el comparador difuso ''||fcomp
               ||'' sobre atributos tipo 3 (''||st||columna_atributo
               ||''): usar feq o is [not].'');
          else

            select into length1 len  from fuzzy_col_list where obj=obj_var and col=col_var;
            select into length2 len  from fuzzy_col_list where obj=obj2_var and col=col2_var;

	    select into obj_var,col_var obj2,col2 from fuzzy_compatible_col
                    where obj1=obj1 and col1=col1;
	    update variables set obj = obj_var;
	    update variables set col = col_var;
    --        if not found then
--		null; -- aki duda
  --          end if;
            select into obj2_var,col2_var obj2,col2  from fuzzy_compatible_col
                    where obj1=obj2_var and col1=col2_var;

  --          if not found then
--		null; -- aki tb
  --          end if;
            if obj_var<>obj2_var or col_var<>col2_var then
               llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
                 '': no se pueden comparar atributos tipo 3 incompatibles (''||
                 st||columna_atributo||'' y ''||columna2.atributo||
                 ''): se debe indicar su compatibilidad en la tabla fuzzy_compatible_col.'');
            else

              argstipo3:=fsql_aux_resto_llamada_tipo3(st||columna_atributo,length1);
              argstipo3:=substr(argstipo3,1,length(argstipo3)-1);  --aki funcion
	      argstipo3_var:=fsql_aux_resto_llamada_tipo3(columna2.atributo,length2);
              argstipo3:=argstipo3||'',''|| argstipo3_var;
caracter:=''\\\\'';
              update fsql_all_queries set nombre=scheme2||''.''||tab||''.''||columna_atributo||caracter,
                atributo=''fsql_functions_feq3(''||obj_var||'',''||col_var||'',''||
                length1||'',''||length2||'',''||argstipo3
                where indice=columna_indice;

              loop
                ind:=ind+1;
                select into token_sig nombre from fsql_all_queries where indice=ind;
                if not found then
		   token_sig:=''sin umbral'';
                end if;
                if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit; 
		end if;
              end loop;

              umbral:=fsql_aux_calcula_umbral(ind);

              if umbral is not null then
                 update fsql_all_queries set atributo=atributo||umbral where indice=ind-1;
              end if;
            end if;
          end if;
        elsif f_tipo_var=1 then
          if f_tipo2=1 then
             if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
                update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                  atributo=''fsql_functions2_''||fcomp||''_t1_t1(''
                  ||st||columna_atributo||'',''||columna2.atributo
                  where indice=columna_indice;

                ind:=columna_indice+2;
                loop ind:=ind+1;
                  select into token_sig nombre from fsql_all_queries where indice=ind;
                  if not found then
			token_sig:=''sin umbral'';
                  end if;
                  if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit;
		  end if;
                end loop;
                umbral:=fsql_aux_calcula_umbral(ind);
                llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
                if margen_var is null then
		   return 1;
		end if;
                update fsql_all_queries set atributo=atributo||'',''
                  ||to_char(margen_var)||'',''||to_char(much_var)||'')''||umbral
                  where indice=ind-1;
             else

               fcompsinn:=fsql_aux_sin_n(fcomp);
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions_''||fcompsinn||''_t1_t1(''||st||columna_atributo
                          ||'',''||columna2.atributo
                 where indice=columna_indice;

               ind:=columna_indice+2;
               loop
                 ind:=ind+1;
                 select into token_sig nombre from fsql_all_queries where indice=ind;
                 if not found then
		    token_sig:=''sin umbral'';
                 end if;
                 if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit;
		 end if;
               end loop;

               umbral:=fsql_aux_calcula_umbral(ind);
               llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		  return 1;
		end if;
               update fsql_all_queries set atributo=atributo||'',''||to_char(margen_var)||'')''||umbral
                 where indice=ind-1;

             end if;

          elsif f_tipo2=3 then
             llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
               '': no se pueden comparar atributos tipo 1 (''||st||columna_atributo||
               '') y tipo 3 (''||columna2.atributo||'').'');
          else 

            if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then

               llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
		if margen_var is null then
		   return 1;
		end if;
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions2_''||fcomp||''_t1_t2(''
                 ||st||columna_atributo||'',''||obj2_var||'',''||col2_var||'',''
                 ||columna2.atributo||''t,''
                 ||columna2.atributo||''1,''||columna2.atributo||''2,''
                 ||columna2.atributo||''3,''||columna2.atributo||''4''
                 ||'',''||to_char(margen_var, ''9999999999'')||'',''||to_char(much_var, ''9999999999'')||'')''
                 where indice=columna_indice;
            else
               fcompsinn:=fsql_aux_sin_n(fcomp);
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions_''||fcompsinn||''_t1_t2(''
                 ||st||columna_atributo||'',''||obj2_var||'',''||col2_var||'',''
                 ||columna2.atributo||''t,''
                 ||columna2.atributo||''1,''||columna2.atributo||''2,''
                 ||columna2.atributo||''3,''||columna2.atributo||''4)''
                 where indice=columna_indice;
            end if;

            loop
              ind:=ind+1;
              select into token_sig nombre from fsql_all_queries where indice=ind;
              if not found then
		 token_sig:=''sin umbral'';
              end if;
              if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
		 exit;
	      end if;
            end loop;

            umbral:=fsql_aux_calcula_umbral(ind);
            if umbral is not null then
               update fsql_all_queries set atributo=columna_atributo||umbral where indice=ind-1;
            end if;
          end if;
        else
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': comparacion difusa ''||fcomp||
            '' con columnas de distintos tipos (''||st||columna_atributo||
            '' es tipo ''||f_tipo_var||'' y ''||columna2.atributo||
            '' es tipo ''||f_tipo2||'').'');

          update fsql_all_queries set nombre=''ok'' where indice=columna2.indice;
        end if;

--***** ***** ***** expresion crisp: fcol <fcomp> <expr crisp> ***** ***** *****
      else 
        if f_tipo_var=3 then
           llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
             '': no se puede comparar un atributo tipo 3 (''||st||columna_atributo||
             '') con una expresion crisp.'');
           if fcomp<>''feq'' then
              llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion
                ||'': no esta definido el comparador difuso ''||fcomp
                ||'' sobre atributos tipo 3 (''||st||columna_atributo
                ||''): usar feq o is [not].'');
           end if;
        elsif f_tipo_var=2 then
          -- cambiamos la columna por el principio de la llamada a fcomp_crisp
          if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then
caracter:=''\\\\'';
               update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
                 atributo=''fsql_functions2_''||fcomp||''_crisp(''
                 where indice=columna_indice;
          else 
caracter:=''\\\\'';
update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna.atributo||caracter,
                 atributo=''fsql_functions_''||fcomp||''_crisp(''
                 where indice=columna_indice;
          end if;
          -- calculamos la posicion donde deberia estar el umbral
          ind:=columna_indice+2;
          loop
            ind:=ind+1;
            
              select into token_sig nombre from fsql_all_queries where indice=ind;
            if not found then
		token_sig:=''sin umbral''; -- columna al final de la consulta
            end if;
	    if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
		exit;
	    end if;
          end loop;
          umbral:=fsql_aux_calcula_umbral(ind);
          if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then -- fcol_t2 mgt expr_crisp
             -- con estos comparadores hay que calcular dos valores: margen y much
             llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
             if margen_var is null then
		return 1; 
	     end if; -- aki revisar
             update fsql_all_queries set atributo=atributo||'',''||obj_var||'',''||col_var||'',''||
               st||columna_atributo||''t,''||
               st||columna_atributo||''1,''||st||columna_atributo||''2,''||
               st||columna_atributo||''3,''||st||columna_atributo||''4,''
               ||to_char(margen_var, ''9999999999'')||'',''||to_char(much_var, ''9999999999'')||'')''||umbral
               where indice=ind-1;
          else
             update fsql_all_queries set atributo=atributo||'',''||obj_var||'',''||col_var||'',''||
               st||columna_atributo||''t,''||
               st||columna_atributo||''1,''||st||columna_atributo||''2,''||
               st||columna_atributo||''3,''||st||columna_atributo||''4)''||umbral
               where indice=ind-1;
          end if;
        else-- f_tipo=1
          if fcomp in (''mgt'',''mlt'',''nmgt'',''nmlt'') then -- fcol_t1 mgt expr_crisp
             -- comparacion de dos atributos tipo 1 con los comparadores (de posibilidad o necesidad)
             -- "mucho mayor que" (mgt/nmgt) o "mucho menor que" (mlt/nmlt):
             -- cambiamos la columna por el principio de la llamada a fcomp_t1_t1
caracter:=''\\\\'';
             update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
               atributo=''fsql_functions2.''||fcomp||''_t1_t1(''||st||columna_atributo||'',''
               where indice=columna_indice;
             -- calculamos la posicion donde deberia estar el umbral
             ind:=columna.indice+2;
             loop
               ind:=ind+1;
                 select into token_sig nombre from fsql_all_queries where indice=ind;
		 if not found then
			token_sig:=''sin umbral''; -- columna al final de la consulta
                 end if;
                 if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit;
		 end if;
             end loop;
             -- calculamos el texto a aadir por el umbral y lo aadimos al final del
             -- token anterior, junto con el resto de la llamada a fcomp_t1_t1
             -- de esta forma, la expresion crisp queda como segundo parametro de fcomp_t1_t1
             umbral:=fsql_aux_calcula_umbral(ind);
             llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
             if margen_var is null then 
		return 1; 
	     end if;
             update fsql_all_queries set atributo=atributo
               ||'',''||to_char(margen_var,''9999999999'')||'',''||to_char(much_var,''9999999999'')||'')''||umbral
               where indice=ind-1;
          else
             -- comparacion fcol1 fcomp expr_crisp: en este caso se difumina
             -- la parte derecha de la comparacion, como si fuera un aprox
             fcompsinn:=fsql_aux_sin_n(fcomp); -- quitamos la n del comparador si es necesario
caracter:=''\\\\'';
             update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
               atributo=''fsql_functions.''||fcompsinn||''_t1_t1(''||st||columna_atributo||'',''
               where indice=columna_indice;
             -- calculamos la posicion donde deberia estar el umbral
             ind:=columna_indice+2;
             loop
               ind:=ind+1;
                 select into token_sig nombre from fsql_all_queries where indice=ind;
                 if not found then
			token_sig:=''sin umbral''; -- columna al final de la consulta
                 end if;
                 if token_sig in (''sin umbral'',''thold'',''numbral'',''comparador'') then
			exit;
		 end if;
             end loop;
             -- calculamos el texto a anadir por el umbral y lo atendimos al final del
             -- token anterior, junto con el resto de la llamada a la funcion
             -- de esta forma, la expresion crisp queda como segundo parametro de fcomp_t1_t1
             umbral:=fsql_aux_calcula_umbral(ind);
             llamafuncion:=fsql_aux_calcula_margen_much(obj_var,col_var,pos,st,columna_atributo,margen_var,much_var);
             if margen_var is null then 
		return 1;
	     end if;
             update fsql_all_queries set atributo=atributo
               ||'',''||to_char(margen_var)||'')''||umbral
               where indice=ind-1;
          end if;
        end if;
      end if;

    end if;

--***** ***** ***** despues de un fcomparador: <expr> <fcomp> fcol ***** ***** *****
  elsif token_ant in (''fgt'',''flt'',''feq'',''fgeq'',''fleq'',''mgt'',''mlt'',
                      ''nfgt'',''nflt'',''nfeq'',''nfgeq'',''nfleq'',''nmgt'',''nmlt'') then
    llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||pos||
      '': comparador difuso ''||token_ant||
      '' debe tener una columna difusa justo a su izquierda (tipo 1, 2 o 3). formato: <fuzzy_column> ''||
      token_ant||'' <expr>.'');

  elsif token_sig=''\\is'' then  
    select into token_sig nombre from fsql_all_queires where indice=columna_indice+2;
    if token_sig=''\\not'' then
       select into token_sig nombre from fsql_all_queries where indice=columna_indice+3;
       if f_tipo_var=1 then
          if token_sig=''\\null'' then -- se refiere al null de oracle (no al difuso)
             return 1;
          else
             llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
               '': atributo tipo 1 ''||st||columna_atributo||
               '' no puede compararse mediante'' || ''\\ is not '' || ''con la constante difusa '' ||token_sig||''.'');
             return 1;
          end if;
       end if;
       -- sustituir columna por la comparacion pertinente
       if token_sig=''unknown'' then
caracter:=''\\\\'';
         update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
           atributo=st||columna_atributo||''t<>0''
           where indice=columna_indice;
       elsif token_sig=''undefined'' then
caracter:=''\\\\'';
         update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
           atributo=st||columna_atributo||''t<>1''
           where indice=columna_indice;
       else 
caracter:=''\\\\'';
         update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
           atributo=st||columna_atributo||''t<>2''
           where indice=columna_indice;
       end if;

       update fsql_all_queries set atributo=null where indice=columna_indice+3;
     elsif f_tipo_var=1 then
       if token_sig=''\\null'' then 
          return 1;
       else
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': atributo tipo 1 ''||st||columna_atributo||
            '' no puede compararse mediante '' || ''\\is '' || ''con la constante difusa ''||token_sig||''.'');
          return 1; -- aki tb. arriba
       end if;
    elsif token_sig=''unknown'' then -- sustituir columna por la comparacion pertinente
caracter:=''\\\\'';
      update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
        atributo=st||columna_atributo||''t=0''
        where indice=columna_indice;
    elsif token_sig=''undefined'' then
caracter:=''\\\\'';
      update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna_atributo||caracter,
        atributo=st||columna.atributo||''t=1''
        where indice=columna.indice;
    else 
caracter:=''\\\\'';

      update fsql_all_queries set nombre=scheme_var||''.''||tab_var||''.''||columna.atributo||caracter,
        atributo=st||columna_atributo||''t=2''
        where indice=columna_indice;
    end if;
   
    update fsql_all_queries set atributo=null
      where indice between columna_indice+1 and columna_indice+2;

--***** ***** ***** ***** ***** en otro caso: error ***** ***** ***** ***** *****

  else
    if f_tipo_var<>1 then
       if trata_fuzzy_atrib=''error'' then -- opcion 1: dar un error
          llamafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||
            '': el atributo difuso ''||st||columna_atributo||'' esta mal situado.'');
       elsif trata_fuzzy_atrib=''tipo_valor'' then -- opcion 2: tipo del valor
         update fsql_all_queries set atributo=atributo||''t'' where indice=columna_indice;
       else
         llamafuncion:=fsql_aux_fuzzy_column_en_sl(st||columna_atributo,columna_indice,f_tipo_var,obj_var,col_var,'''');
       end if;
    end if;
  end if;

  return 0;
end;
'language 'plpgsql';
----------------------------------------------------------------------------------------------
-- busca el parentesis derecho ')' que cierra la llamada a una funcion
-- empieza buscando en el atributo de la tupla condicion y sigue en las
-- tuplas sucesivas.
-- devuelve: tupla  --> numero de tupla en la que lo encontro (0 si es en condicion)
--           offset --> posicion del parentesis en dicha tupla
----------------------------------------------------------------------------------------------
drop function fsql_semantic_busca_rparent (numeric(10), varchar(2000),
					   integer, integer);
create function fsql_semantic_busca_rparent (numeric(10), varchar(2000),
					     integer, integer)
returns integer as '
declare
  condicion_indice alias for $1;
  condicion_atributo alias for $2;
  tupla_entrada alias for $3;
  off_set_entrada alias for $4;
  tupla_var integer;
  off_set_var integer;
  cadena varchar(2000);
  pos  integer;
  cont integer;
  long integer;
  ch   char;
  encontrado boolean;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_busca_rparent'');
  cadena:=condicion_atributo;
  cont:=0;
  ch:='''';
  encontrado:=''f'';
  off_set_var:=off_set_entrada;
  tupla_var:=0;
  update variables set tupla=tupla_var;
  while not encontrado loop
    pos:=1;
    long:=length(cadena);
    loop
      ch:=substr(cadena,pos,1);
      if ch=''('' then
	cont:=cont+1;
      elsif ch='')'' then
	cont:=cont-1;
      end if;
      if pos>=long or (ch='')'' and cont=0) then
	exit;
      end if;
      pos:=pos+1;
    end loop;

    if ch='')'' and cont=0 then
	off_set_var:=pos;
	encontrado:=''t'';
    else
	loop
	 tupla_var:=tupla_var+1;
         select into cadena atributo from fsql_all_queries 
		where indice=condicion_indice+tupla_var;
	 if cadena is not null then
	   exit;
	 end if;
	end loop;
    end if;
  end loop;
  update variables set tupla=tupla_var;
  update variables set off_set=off_set_var;
  return 0;
end;
'  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el grado de cumplimiento en una condicion difusa para una columna
-- entrada: tupla de fsql_query donde estaba la columna en la clausula where.
-- en general, es la condicion que esta puesta, eliminando el comparador crisp
-- y el umbral de cumplimiento.
-- requisito: condicion.atributo is not null (que no sea col2 en: col1 <fcomp> col2)
----------------------------------------------------------------------------------------------
drop function fsql_semantic_grado_condicion(numeric(10), varchar(2000), integer);
create function fsql_semantic_grado_condicion(numeric(10), varchar(2000), integer)
returns varchar as '
declare
  condicion_indice alias for $1;
  condicion_atributo alias for $2;
  tupla_entrada alias for $3;
  grado_cond varchar(2000);
  atrib varchar(2000);
  tupla_var integer;
  off_set_var integer;
  cadena varchar;
  llamadafuncion integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_grado_condicion'');
  tupla_var:=tupla_entrada;
  grado_cond:='''';
  cadena:=substr(condicion_atributo,1,14);
  if cadena = ''fsql_functions'' then
	 llamadafuncion:=fsql_semantic_busca_rparent(condicion_indice,condicion_atributo,tupla_var,off_set_var);
	select into tupla_var tupla from variables;
	select into off_set_var off_set from variables;
     if tupla_var=0 then
	return substr(condicion_atributo,1,off_set_var);
     else
	grado_cond:=condicion_atributo ;
	for i in 1..tupla_var-1 loop
	  select into atrib atributo from fsql_all_queries
		 where indice=condicion_indice+i;
	  grado_cond:=grado_cond||atrib;
	end loop;
	select into atrib atributo from fsql_all_queries
		 where indice=condicion.indice+tupla_var;
	return grado_cond||substr(atrib,1,off_set_var);
     end if;
  else
  update variables set tupla=0;
    return ''1'';
  end if;
end;
'  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el grado de cumplimiento en una condiciun crisp con una columna
-- entrada: tupla de fsql_query donde estaba la columna en la cluusula where.
-- se traduce por una llamada a fsql_functions.compcrisp(op1, comparador, op2)
-- si no encuentra el comparador crisp devuelve null
----------------------------------------------------------------------------------------------
drop function fsql_semantic_grado_condcrisp(numeric(10), integer);
create function fsql_semantic_grado_condcrisp(numeric(10), integer)
returns varchar as '
declare
  condicion_indice alias for $1;
  tupla_entrada alias for $2;
  token record;
  op1   varchar(2000);
  op2   varchar(2000);
  comparador varchar(2);
  tupla_var integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_grado_condcrisp'');
  op1:='''';
  op2:='''';
  tupla_var:=condicion_indice-1;
  update variables set tupla=tupla_var;
  loop
    select into token * from fsql_all_queries
	where indice=tupla_var;
    if not found then
	token.nombre:=''fin'';
    elsif token.nombre in (''where'',''not'',''and'',''or'',''('',''{'') or tupla_var=0 then
	exit;
    end if;
    tupla_var:=tupla_var-1;
  end loop;
   update variables set tupla=tupla_var;
  loop
    tupla_var:=tupla_var+1;
    select into token * from fsql_all_queries
            where indice=tupla_var;
    if not found then
	return null;
    end if;
    if token.nombre=''comparador'' then

	exit;
    end if;
    op1:=op1||token.atributo;
  end loop;
--   op1:=op1||token.atributo;
   comparador:=token.atributo;
   update variables set tupla=tupla_var;
  loop
    tupla_var:=tupla_var+1;
    select into token * from fsql_all_queries
            where indice=tupla_var;
    if not found then
	token.nombre:=''fin'';
    end if;
    if token.nombre in (''and'', ''or'', ''fin'', ''}'', '')'', '';'', ''group'', ''connect'', ''start'', ''union'', ''intersect'', ''minus'', ''order'') then
	exit;
    end if;
    op2:=op2||token.atributo;
  end loop;
--  op2:=op2||token.atributo;
  tupla_var:=tupla_var-condicion_indice-1;
  update variables set tupla=tupla_var;
  return ''fsql_functions_condcrisp(''||op1||'',''||chr(39)||comparador||chr(39)||'',''||op2||'')'';
end;
'  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- lee las opciones de configuracion del usuario para el servidor fsql:
-- 1. funciones a utilizar en los operadores logicos not, and y or.
--    estas estan almacenadas, para cada usuario, en la vista fsql_options.
--    en caso de que no esten almacenadas ahi, se usan las funciones por defecto.
--            operacion logica  funcion por defecto otro caso
--            ----------------  ------------------- ---------
--            not a         1-a             f_not(a)
--            a and b           least(a,b)          f_and(a,b)
--            a or  b           greatest(a,b)       f_or (a,b)
--    requisitos: los parametros almacenados en el campo fslq_options.valor
--                debe ser funciones alcanzables por el usuario y deben tener 1, 2 y 2
--                argumentos respectivamente para not, and y or.
-- 2. tipo de tratamiento para los atributos difusos en situacion inusual:
--    valores validos:
--            error      --> genera un error
--            tipo_valor --> utiliza el tipo del valor del atributo: tipo number(1)
--                           (concatenar 't' al nombre del atributo)
--            represent  --> utiliza la representacion grafica del atributo: tipo varchar2
--                           (opcion por defecto)
----------------------------------------------------------------------------------------------
drop function fsql_semantic_lee_options();
create function fsql_semantic_lee_options() 
returns integer as '
declare
  f_not_var varchar(100);
  f_and_var varchar(100);
  f_or_var  varchar(100);
  trata_fuzzy_atrib_var varchar(100);
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_lee_options'');
  select into f_not_var valor from fsql_all_info where opcion=''not'' and owner=(select current_user);
    if not found then
	f_not_var:=''1-'';
    end if;
  update variables set f_not=f_not_var;
  select into f_and_var valor from fsql_options where opcion=''and'' and owner=(select current_user);
    if not found then
	f_and_var:=''least'';
    end if;
  update variables set f_and=f_and_var;
  select into f_or_var valor from fsql_options where opcion=''or'' and owner=(select current_user);
    if not found then
	f_or_var:=''greatest'';
    end if;
  update variables set f_or=f_or_var;
  select into trata_fuzzy_atrib_var valor from fsql_options where opcion=''trata_fuzzy_atrib''
     and owner=(select current_user);
     if not found then
	trata_fuzzy_atrib_var:=''represent'';
     end if;
  update variables set trata_fuzzy_atrib=trata_fuzzy_atrib_var;
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- cambia operadores logicos not, and y or de la tabla cdeg, entre las posiciones inicio y fin,
-- cuando se trata de un cdeg(*) y hay que tratar todas las condiciones.
-- utiliza las funciones calculadas por lee_options;
-- requisito: entre las posiciones inicio+1 y fin-1 no deben existir parentesis
----------------------------------------------------------------------------------------------
drop function fsql_semantic_cambia_oper_logicos(integer, numeric(10), numeric(10));
create function fsql_semantic_cambia_oper_logicos(integer, numeric(10), numeric(10))
returns numeric(10) as '
declare
  max_cdeg_entrada alias for $1;
  inicio alias for $2;
  fin_entrada alias for $3;
  max_cdeg_var integer;
  fin_var numeric(10);
  off_set_var integer;
  pos  numeric(10);
  atributo_var varchar(2000);
  atributo_var2 varchar(2000);
  f_not_var varchar(100);
  f_and_var varchar(100);
  f_or_var  varchar(100);
  cadena varchar(2000);
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_cambia_oper_logicos'');
  fin_var:=fin_entrada;
  max_cdeg_var:=max_cdeg_entrada;
  off_set_var:=0;
  pos:=inicio;
  select into atributo_var atributo from cdeg where indice=inicio;
  if atributo_var in (''('',''{'') then
     fin_var:=fin_var-2;
     for i in inicio..fin_var loop
	select into atributo_var atributo from cdeg where indice=i+1;
	update cdeg set atributo=atributo_var where indice=i;
     end loop;
     off_set_var:=2;
  end if;
  select into f_not_var f_not from variables;
  while pos<=fin_var loop
    select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''not'' then
	select into atributo_var atributo from cdeg where indice=pos+1;
	if f_not_var=''1-'' then
	  if    atributo_var=''1'' then
		update cdeg set atributo=''0'' where indice=pos;
	  elsif atributo_var=''0'' then
		update cdeg set atributo=''1'' where indice=pos;
	  else
		cadena:=''(1-(''||atributo_var||''))'';
		update cdeg set atributo=cadena where indice=pos;
	  end if;
	else
	  cadena:=f_not_var||''(''||atributo_var||''))'';
	  update cdeg set atributo=cadena where indice=pos;
	end if;
	fin_var:=fin_var-1;
	off_set_var:=off_set_var+1;
	for i in (pos+1)..fin_var loop
	 select into atributo_var atributo from cdeg where indice=i+1;
	 update cdeg set atributo=atributo_var where indice=i;
	end loop;
    end if;
    pos:=pos+1;
  end loop;

  select into f_and_var f_and from variables;
  pos:=inicio+1;
  while pos<=fin_var loop
    select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''and'' then
	pos:=pos-1;
	select into atributo_var atributo from cdeg where indice=pos;
	select into atributo_var2 atributo from cdeg where indice=pos+2;
	if f_and_var=''least'' then
	  if  atributo_var2=''1'' or atributo_var=''0'' then
		cadena:=null;
	  elsif atributo_var2=''0'' then
		update cdeg set atributo=''0'' where indice=pos;
	  elsif atributo_var=''1'' then
		update cdeg set atributo=atributo_var2 where indice=pos;
	  else
		cadena:=''least(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
	  end if;
	else
	  cadena:=f_and_var||''(''||atributo_var||'',''||atributo_var2||'')'';
	  update cdeg set atributo=cadena where indice=pos;
	end if;
	for i in pos+1..(fin_var-2) loop
	 select into atributo_var atributo from cdeg where indice=i+2;
	 update cdeg set atributo=atributo_var where indice=i;
	end loop;
	fin_var:=fin_var-2;
	off_set_var:=off_set_var+2;
    end if;
    pos:=pos+1;
  end loop;
  select into f_or_var f_or from variables;
  pos:=inicio+1;
  while pos<=fin_var loop
	select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''or'' then
	pos:=pos-1;
	select into atributo_var atributo from cdeg where indice=pos;
	select into atributo_var2 atributo from cdeg where indice=pos+2;
       if f_or_var=''greatest'' then
	  if atributo_var=''1'' or atributo_var2=''1'' then
		update cdeg set atributo=''1'' where indice=pos;
	  elsif atributo_var=''0'' or atributo_var2=''0'' then
	     if atributo_var=''0'' then
		update cdeg set atributo=atributo_var2 where indice=pos;
             end if;
	  else
		cadena:=''greatest(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
          end if;
       else
	  cadena:=f_or_var||''(''||atributo_var||'',''||atributo_var2||'')'';
	  update cdeg set atributo=cadena where indice=pos;
       end if;
       for i in pos+1..(fin_var-2) loop
	 select into atributo_var atributo from cdeg where indice=i+2;
	 update cdeg set atributo=atributo_var where indice=i;
       end loop;
       fin_var:=fin_var-2;
       off_set_var:=off_set_var+2;
    end if;
    pos:=pos+1;
  end loop;
  max_cdeg_var:=max_cdeg_var-off_set_var;
  for i in (fin_var+1)..max_cdeg_var loop
    select into atributo_var atributo from cdeg where indice=i+off_set_var;
    update cdeg set atributo=atributo_var where indice=i;
  end loop;
  update variables set max_cdeg=max_cdeg_var;
  return fin_var;
end;
'  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- cambia operadores logicos not, and y or de la tabla cdeg, entre las posiciones inicio y fin:
-- cuando se trata de un cdeg(columna) y puede haber condiciones que se deben eliminar.
-- si un operando es igual a  indica que se tratara como si no estuviera.
-- utiliza las funciones calculadas por lee_options;
-- requisito: entre las posiciones inicio+1 y fin-1 no deben existir parentesis
----------------------------------------------------------------------------------------------
drop function fsql_semantic_cambia_oper_logicos2(integer, numeric(10), numeric(10));
create function fsql_semantic_cambia_oper_logicos2(integer, numeric(10), numeric(10))
returns numeric(10) as '
declare
  max_cdeg_entrada alias for $1;
  inicio alias for $2;
  fin_entrada alias for $3;
  max_cdeg_var integer;
  fin_var numeric(10);
  off_set_var integer;
  pos  numeric(10);
  atributo_var varchar(2000);
  atributo_var2 varchar(2000);
  f_not_var varchar(100);
  f_and_var varchar(100);
  f_or_var  varchar(100);
  cadena varchar(2000);
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_cambia_oper_logicos2'');
  fin_var:=fin_entrada;
  max_cdeg_var:=max_cdeg_entrada;
  off_set_var:=0;
  pos:=inicio;
  select into atributo_var atributo from cdeg where indice=inicio;
  if atributo_var in (''('',''{'') then
     fin_var:=fin_var-2;
     for i in inicio..fin_var loop
	select into atributo_var atributo from cdeg where indice=i+1;
	update cdeg set atributo=atributo_var where indice=i;
     end loop;
     off_set_var:=2;
  end if;
  select into f_not_var f_not from variables;
  while pos<=fin_var loop
    select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''not'' then
	select into atributo_var atributo from cdeg where indice=pos+1;
       if atributo_var=''\\134\\134'' then
          off_set_var:=off_set_var+1;
          fin_var:=fin_var-1;
          for i in pos..fin_var loop
		select into atributo_var atributo from cdeg where indice=i+1;
		update cdeg set atributo=atributo_var where indice=i;
          end loop;
	  select into atributo_var atributo from cdeg where indice=pos-1;
          if pos-1>=inicio and atributo_var in (''and'',''or'') then
             off_set_var:=off_set_var+2;
             fin_var:=fin_var-2;
             for i in (pos-1)..fin_var loop
		select into atributo_var atributo from cdeg where indice=i+2;
		update cdeg set atributo=atributo_var where indice=i;
             end loop;
          else
		select into atributo_var atributo from cdeg where indice=pos+1;
		if pos+1<=fin_var and atributo_var in (''and'',''or'') then
		off_set_var:=off_set_var+2;
		fin_var:=fin_var-2;
		  for i in pos..fin_var loop
			select into atributo_var atributo from cdeg where indice=i+2;
			update cdeg set atributo=atributo_var where indice=i;
		  end loop;
		end if;
          end if;
       else
	 if f_not_var=''1-'' then
	    if atributo_var=''1'' then
		update cdeg set atributo=''0'' where indice=pos;
	    elsif atributo_var=''0'' then
		update cdeg set atributo=''1'' where indice=pos;
	    else
		cadena:=''(1-(''||atributo_var||''))'';
		update cdeg set atributo=cadena where indice=pos;
            end if;
	 else
		cadena:=f_not_var||''(''||atributo_var||''))'';
		update cdeg set atributo=cadena where indice=pos;
	 end if;
	 fin_var:=fin_var-1;
	 off_set_var:=off_set_var+1;
	 for i in (pos+1)..fin_var loop
		select into atributo_var atributo from cdeg where indice=i+1;
		update cdeg set atributo=atributo_var where indice=i;
         end loop;
       end if;
    end if;
    pos:=pos+1;
  end loop;

  select into f_and_var f_and from variables;
  pos:=inicio+1;
  while pos<=fin_var loop
    select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''and'' then
	pos:=pos-1;
	select into atributo_var atributo from cdeg where indice=pos;
	select into atributo_var2 atributo from cdeg where indice=pos+2;
       if atributo_var=''\\134\\134'' then
	  select into atributo_var atributo from cdeg where indice=pos+2;
	  update cdeg set atributo=atributo_var where indice=pos;
       elsif atributo_var2=''\\134\\134'' then
		cadena:=null;
       else
         if f_and_var=''least'' then
            if atributo_var2=''1'' or atributo_var=''0'' then
		cadena:=null;
	    elsif atributo_var2=''0'' then
		update cdeg set atributo=''0'' where indice=pos;
	    elsif atributo_var=''1'' then
		update cdeg set atributo=atributo_var2 where indice=pos;
            else
		cadena:=''least(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
            end if;
         else
		cadena:=f_and_var||''(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
         end if;
       end if;
       for i in pos+1..(fin_var-2) loop
	 select into atributo_var atributo from cdeg where indice=i+2;
	 update cdeg set atributo=atributo_var where indice=i;
       end loop;
       fin_var:=fin_var-2;
       off_set_var:=off_set_var+2;
    end if;
    pos:=pos+1;
  end loop;

  select into f_or_var f_or from variables;
  pos:=inicio+1;
  while pos<=fin_var loop
    select into atributo_var atributo from cdeg where indice=pos;
    if atributo_var=''or'' then
	pos:=pos-1;
	select into atributo_var atributo from cdeg where indice=pos;
	select into atributo_var2 atributo from cdeg where indice=pos+2;
       if atributo_var=''\\134\\134'' then
		update cdeg set atributo=atributo_var2 where indice=pos;
       elsif atributo_var2=''\\134\\134'' then
		cadena:=null;
       else
	 if f_or_var=''greatest'' then
	    if atributo_var=''1'' or atributo_var2=''1'' then
		update cdeg set atributo=''1'' where indice=pos;
	    elsif atributo_var2=''0'' then
		cadena:=null;
	    elsif atributo_var=''0'' then
		update cdeg set atributo=atributo_var2 where indice=pos;
	    else
		cadena:=''greatest(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
	    end if;
	 else
		cadena:=f_or_var||''(''||atributo_var||'',''||atributo_var2||'')'';
		update cdeg set atributo=cadena where indice=pos;
         end if;
       end if;
       for i in pos+1..(fin_var-2) loop
	 select into atributo_var atributo from cdeg where indice=i+2;
	 update cdeg set atributo=atributo_var where indice=i;
       end loop;
	fin_var:=fin_var-2;
	off_set_var:=off_set_var+2;
    end if;
    pos:=pos+1;
  end loop;

  max_cdeg_var:=max_cdeg_var-off_set_var;
  for i in (fin_var+1)..max_cdeg_var loop
    select into atributo_var atributo from cdeg where indice=i+off_set_var;
    update cdeg set atributo=atributo_var where indice=i;
  end loop;
  update variables set max_cdeg=max_cdeg_var;
  return fin_var;
end;
'  language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el anterior operador lugico, tras una comparaciun crisp
----------------------------------------------------------------------------------------------
drop function fsql_semantic_operador_anterior(numeric(10));
create function fsql_semantic_operador_anterior(numeric(10))
returns varchar as '
declare
  columna_indice alias for $1;
  cont integer;
  nomb varchar(100);
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_operador_anterior'');
  cont:=columna_indice-1;
  loop
    select into nomb nombre from fsql_all_queries where indice=cont;
    if nomb in (''or'',''and'',''where'') or cont<0 then
	exit;
    end if;
    cont:=cont-1;
  end loop;
  if nomb is null then
	return ''x'';
  else
	return nomb;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- devuelve el siguiente operador lugico, tras una comparaciun crisp
----------------------------------------------------------------------------------------------
drop function fsql_semantic_operador_siguiente(numeric(10));
create function fsql_semantic_operador_siguiente(numeric(10))
returns varchar as '
declare
  columna_indice alias for $1;
  cont integer;
  indi integer;
  nomb varchar(100);
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_operador_siguiente'');
  cont:=columna_indice+1;
  select into indi max(indice) from fsql_all_queries;
  loop
    select into nomb nombre from fsql_all_queries where indice=cont;
    if nomb in 
(''and'' ,''or'' ,'';'' ,''group'' ,''connect'' ,''start'' ,''union'' ,''intersect'' ,''minus'' ,''order'') or cont>indi then
	exit;
    end if;
    cont:=cont+1;
  end loop;
  if nomb is null then
	return ''x'';
  else
	return nomb;
  end if;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- trata el caso de un cdeg que no es aplicable, ya que no aparece el campo en la clausula where
----------------------------------------------------------------------------------------------
drop function fsql_semantic_cdegnoaplicable(numeric(10),numeric(10));
create function fsql_semantic_cdegnoaplicable(numeric(10),numeric(10))
returns integer as '
declare
  columna_indice alias for $1;
  columna_posicion alias for $2;
  inicio numeric(10);
  fin    numeric(10);
  nomb  varchar(100);
  atrib varchar(2000);
  indi integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_cdegnoaplicable'');
  select into indi max(indice) from fsql_all_queries;
  inicio:=columna_indice+2;
  if columna_posicion<>0 then
	update fsql_all_queries set atributo=null where indice=columna_indice;
  else
     fin:=columna_indice+1;
     loop
	select into nomb,atrib nombre,atributo from fsql_all_queries where indice=fin;
	if nomb in ('', en sl'',''from'') and atrib in ('','',''from'') or fin>indi then
	   exit;
	end if;
       fin:=fin+1;
     end loop;
     if nomb = '', en sl'' then
	update fsql_all_queries set atributo=null where indice between columna_indice and fin;
     else
	inicio:=columna_indice-1;
	loop
	  select into nomb,atrib nombre,atributo from fsql_all_queries where indice=inicio;
	  if nomb in ('', en sl'',''select'') and atrib in ('','',''select'') then
	     exit;
	  end if;
	  inicio:=inicio-1;
	end loop;
	if nomb = '', en sl'' then
	   update fsql_all_queries set atributo=null where indice between inicio and fin-1;
        else
	   update fsql_all_queries set atributo=null where indice between inicio+1 and fin-1;
	end if;
     end if;
  end if;
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- calcula el grado de compatibilidad, cdeg, de un atributo difuso concreto.
-- este se calcula segun las condiciones en las que aparezca este atributo
-- en la clausula where:
-- not a --> 1-a;   a and b --> min(a,b);   a or b --> max(a,b);
----------------------------------------------------------------------------------------------
drop function fsql_semantic_calcula_cdeg(numeric(10),numeric(10),varchar(100),
					 varchar(2000),numeric(10));
create function fsql_semantic_calcula_cdeg(numeric(10),numeric(10),varchar(100),
					 varchar(2000),numeric(10))
returns integer as '
declare

  columna_indice alias for $1;
  columna_posicion alias for $2;
  columna_nombre alias for $3;
  columna_atributo alias for $4;
  maxind alias for $5;
  maxind_var integer;
  inicio_var numeric(10);
  fin_var    numeric(10);
  nomb   varchar(100);
  condic record;
  cont   integer;
  tupla_var  integer;
  stc    varchar(92);

  max_cdeg_var integer;
  haya_parentesis boolean;

  scheme_var varchar(30);
  tab_var    varchar(30);
  f_tipo_var numeric(1);
  obj_var numeric;
  col_var numeric;
  cadena varchar;
  cadena2 varchar;
  cadena3 varchar;
  cadena4 varchar;
  cadena5 varchar;
  llama_funcion integer;
  llama_funcion2 boolean;
  atributo_var varchar(2000);

  ind numeric(10);
  atr varchar(2000);
  final integer;
  ini integer;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_calcula_cdeg'');
  select into tupla_var tupla from variables;
  select into scheme_var scheme from variables;
  select into tab_var tab from variables;
  select into f_tipo_var f_tipo from variables;
  select into obj_var obj from variables;
  select into col_var col from variables;

  scheme_var:=''public'';
  maxind_var:=maxind;
  inicio_var:=columna_indice+1;
  cont:=0;
  haya_parentesis:=''t'';

  delete from cdeg;
  select into final max(indice) from fsql_all_queries;
  ini:=0;
     loop
	select into ind,atr indice,atributo from fsql_all_queries where indice=ini;
	if ini>final then
	   exit;
	elsif found then
	   insert into cdeg values(ind,atr);
	end if;
	ini:=ini+1;
     end loop;

  stc:=substr(columna_nombre,1,length(columna_nombre)-4);
  cadena:='' as "cdeg(''||columna_atributo||'')"'';
  update fsql_all_queries set nombre=''cdeg c_alias'',atributo=cadena
    where indice=columna_indice+1;

  loop
	select into nomb nombre from fsql_all_queries where indice=inicio_var;
	if (nomb=''where'' and cont=0) or inicio_var=maxind_var then
		exit;
	end if;
	if nomb=''select'' then
		cont:=cont+1;
	elsif nomb=''where''  then
		cont:=cont-1;
	end if;
	inicio_var:=inicio_var+1;
  end loop;

  if nomb<>''where'' then
	llama_funcion:=fsql_semantic_cdegnoaplicable(columna_indice,columna_posicion);
	return 0;
  end if;

  inicio_var:=inicio_var+1;
  fin_var:=inicio_var;
  cont:=0;
  loop
	select into nomb nombre from fsql_all_queries where indice=fin_var;
	if fin_var>=maxind_var or
              nomb in (''group'', ''connect'' ,''start'' ,''union'' ,''intersect'' ,''minus'' ,''order'' ,'';'') or
              (nomb='')'' and cont=0) then
		exit;
	end if;
	if nomb=''('' then
		cont:=cont+1;
	elsif nomb='')'' then
		cont:=cont-1;
	end if;
	fin_var:=fin_var+1;
  end loop;
  if nomb in (''group'' ,''connect'' ,''start'' ,''union'' ,''intersect'' ,''minus'' ,''order'' ,'';'') then
     fin_var:=fin_var-1;
  end if;

  max_cdeg_var:=0;
  cont:=inicio_var;
  cadena:=''*''||''\\134'';
  if stc= cadena then
     while cont<=fin_var loop
	select into condic indice,posicion,nombre,atributo from fsql_all_queries
         where indice=cont;
	if condic.atributo is not null then
	  cadena:=substr(condic.nombre,length(condic.nombre),1);
	  cadena2:=substr(condic.nombre,length(condic.nombre)-7,8);
	  cadena3:=substr(condic.nombre,length(condic.nombre)-5,6);
          if cadena = ''\\134'' then
		max_cdeg_var:=max_cdeg_var+1;
		cadena:=fsql_semantic_grado_condicion(condic.indice, condic.atributo ,tupla_var);
		update cdeg set atributo=cadena where indice=max_cdeg_var;
		cont:=cont+tupla_var;

	  elsif condic.atributo in (''and'',''or'') then
		select into atributo_var atributo from cdeg where indice=max_cdeg_var;
	     if atributo_var not in (''not'',''and'',''or'') then
		max_cdeg_var:=max_cdeg_var+1;
	     end if;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo=''not'' then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo in (''('','')'') and cadena2 <> ''function'' then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo in (''{'',''}'') then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.nombre=''crisp_col'' or	cadena3 = ''column'' then
		max_cdeg_var:=max_cdeg_var+1;
		select into tupla_var tupla from variables;
		cadena:=fsql_semantic_grado_condcrisp(condic.indice,tupla_var);
		update cdeg set atributo=cadena where indice=max_cdeg_var;

		select into atributo_var atributo from cdeg where indice=max_cdeg_var;
	     if atributo_var is null then
		max_cdeg_var:=max_cdeg_var-1;
	     else
		cont:=cont+tupla_var;
		cadena:=fsql_semantic_operador_anterior(condic.indice);
		cadena2:=fsql_semantic_operador_siguiente(condic.indice);
		if cadena<>''or'' and cadena2<>''or'' then
		   update cdeg set atributo=''1'' where indice=max_cdeg_var;
		end if;
	     end if;
	  end if;
	end if;
	cont:=cont+1;
     end loop;

  else
     while cont<=fin_var loop
	select into condic indice,posicion,nombre,atributo from fsql_all_queries
         where indice=cont;
	cadena:=substr(condic.nombre,length(condic.nombre)-2,3);
	cadena2:=''\\134''||''2''||''\\134'';
	cadena3:=substr(condic.nombre,length(condic.nombre)-5,6);
	cadena4:=substr(condic.nombre,length(condic.nombre),1);
	cadena5:=substr(condic.nombre,length(condic.nombre)-7,8);
	if cadena <> cadena2 then
	  if condic.nombre=stc then
		max_cdeg_var:=max_cdeg_var+1;
		select into tupla_var tupla from variables;
		cadena:=fsql_semantic_grado_condicion(condic.indice, condic.atributo ,tupla_var);
		update cdeg set atributo=cadena where indice=max_cdeg_var;
		cont:=cont+tupla_var;
	  elsif cadena3 = ''column'' then
		max_cdeg_var:=max_cdeg_var+1;
		llama_funcion2:=fsql_semantic_es_fuzzy_column(condic.indice, condic.posicion, condic.nombre, condic.atributo,scheme_var,tab_var,f_tipo_var,obj_var,col_var);
		select into scheme_var scheme from variables;
		scheme_var:= ''public'';
		select into tab_var tab from variables;
		cadena3:=scheme_var||''.''||tab_var||''.''||condic.atributo||''\\134'';
	    if llama_funcion2=''t'' and	stc=cadena3 then
		cadena:=fsql_semantic_operador_anterior(condic.indice);
		cadena2:=fsql_semantic_operador_siguiente(condic.indice);
		if cadena=''or'' or cadena2=''or'' then
		   select into tupla_var tupla from variables;
		   cadena3:=fsql_semantic_grado_condcrisp(condic.indice,tupla_var);
		   update cdeg set atributo=cadena3 where indice=max_cdeg_var;
		   if cadena3 is null then
			max_cdeg_var:=max_cdeg_var-1;
		   else
			select into tupla_var tupla from variables;
			cont:=cont+tupla_var;
		   end if;
		else
		   update cdeg set atributo=''1'' where indice=max_cdeg_var;
		end if;
	    else
		cadena:=''\\134''||''\\134'';
		update cdeg set atributo=cadena where indice=max_cdeg_var;
	    end if;

	  elsif cadena4 = ''\\134'' or condic.nombre=''crisp_col'' then
		max_cdeg_var:=max_cdeg_var+1;
		cadena:=''\\134''||''\\134'';

		update cdeg set atributo=cadena where indice=max_cdeg_var;
	  elsif condic.atributo in (''and'',''or'') then
		select into atributo_var atributo from cdeg where indice=max_cdeg_var;
	     if atributo_var not in (''not'',''and'',''or'') then
		max_cdeg_var:=max_cdeg_var+1;
	     end if;
	     update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo=''not'' then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo in (''{'',''}'') then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
	  elsif condic.atributo in (''('','')'') and cadena4 <> ''function'' then
		max_cdeg_var:=max_cdeg_var+1;
		update cdeg set atributo=condic.atributo where indice=max_cdeg_var;
		--cdeg(max_cdeg_var):=condic.atributo;
	  end if;

	else
	  cadena:=stc||''2''||''\\134'';
	  if condic.nombre=cadena then
		tupla_var:=condic.indice-2;
		update variables set tupla=tupla_var;
		cadena2:=''\\134'';
	     loop
		select into condic indice,posicion,nombre,atributo from fsql_all_queries
                 where indice=tupla_var;
		if condic.nombre = cadena2 then
			exit;
		end if;
		tupla_var:=tupla_var-1;
	     end loop;
		update variables set tupla=tupla_var;
		cadena:=fsql_semantic_grado_condicion(condic.indice, condic.atributo ,tupla_var);
		update cdeg set atributo=cadena where indice=max_cdeg_var;
	  end if;
	end if;
	cont:=cont+1;
     end loop;
  end if;

  if max_cdeg_var=0 then
	max_cdeg_var:=1;
	cadena:=''\\134''||''\\134'';
	update cdeg set atributo=cadena where indice=1;
  end if;
  select into atributo_var atributo from cdeg where indice=max_cdeg_var;
  while atributo_var in (''not'',''and'',''or'') loop
	max_cdeg_var:=max_cdeg_var-1;
	select into atributo_var atributo from cdeg where indice=max_cdeg_var;
  end loop;

  while haya_parentesis=''t'' loop
	inicio_var:=1;
	fin_var:=1;
	select into atributo_var atributo from cdeg where indice=fin_var;
    while fin_var<=max_cdeg_var and atributo_var not in ('')'',''}'') loop
      if atributo_var in (''('',''{'') then
	inicio_var:=fin_var;
      end if;
	fin_var:=fin_var+1;
	select into atributo_var atributo from cdeg where indice=fin_var;
    end loop;

    if fin_var>max_cdeg_var then
	cadena:=''*''||''\\134'';
	if stc=cadena then
	   fin_var:=fsql_semantic_cambia_oper_logicos(max_cdeg_var,1,max_cdeg_var);
           select into max_cdeg_var max_cdeg from variables;
	else
	   fin_var:=fsql_semantic_cambia_oper_logicos2(max_cdeg_var,1,max_cdeg_var);
           select into max_cdeg_var max_cdeg from variables;
	end if;
	haya_parentesis:=''f'';
    else
	cadena:=''*''||''\\134'';
	if stc= cadena then
	   fin_var:=fsql_semantic_cambia_oper_logicos(max_cdeg_var,inicio_var,fin_var);
           select into max_cdeg_var max_cdeg from variables;
	else
	   fin_var:=fsql_semantic_cambia_oper_logicos2(max_cdeg_var,inicio_var,fin_var);
           select into max_cdeg_var max_cdeg from variables;
	end if;
    end if;
  end loop;
  select into atributo_var atributo from cdeg where indice=1;
  cadena:=''\\134''||''\\134'';
  if atributo_var=cadena then
	llama_funcion:=fsql_semantic_cdegnoaplicable(columna_indice,columna_posicion);
  else
	update fsql_all_queries set atributo=atributo_var where indice=columna_indice;
  end if;
  return 0;
end;
'language 'plpgsql';

-- ***** ***** ***** *****  control de comodines (* y %)  ***** ***** ***** *****

----------------------------------------------------------------------------------------------
-- incluye las columnas cuando se usan comodines de los tipos: "t.*" o "s.t.*"
-- si las tablas no tienen atributos difusos (tipos 2 o 3) se dejan los comodines
----------------------------------------------------------------------------------------------
drop function fsql_semantic_incluye_columnas_st_asterisco (numeric(10),numeric(10),
							   varchar(100));
create function fsql_semantic_incluye_columnas_st_asterisco (numeric(10),numeric(10),
							   varchar(100))
returns integer as '
declare
  columna_indice alias for $1;
  columna_posicion alias for $2;
  columna_nombre alias for $3;
  token_ant fsql_all_queries.nombre%type;
  token_sig fsql_all_queries.nombre%type;
  inicio_from fsql_all_queries.indice%type;
  fin_from    fsql_all_queries.indice%type;
  sch    varchar(30);
  tab    record;
  tabla record;
  st     varchar(62);
  tsch   varchar(30);
  n_objs integer;
  existe boolean;
  obj_var    fuzzy_col_list.obj%type;
  col_var    fuzzy_col_list.col%type;
  obj2_var   fuzzy_col_list.obj%type;
  col2_var   fuzzy_col_list.col%type;
  todas  varchar(2000);
  num_columnas integer;
  nombre_col   varchar;
  f_tipo       fuzzy_col_list.f_type%type;
  length3      fuzzy_col_list.len%type;
  llamadafuncion integer;
  cadena varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_incluye_columnas_st_asterisco'');
  existe:=''f'';
  todas:='''';

  if columna_nombre=''t.*'' then
    select into tab indice,posicion,nombre,atributo from fsql_all_queries
      where indice=columna_indice-2;
    st:=tab.atributo||''.'';
    sch:=fsql_semantic_propietario_tabla(tab.posicion,tab.atributo);
    sch:=''public'';
    if sch is null then
	return 1;
    end if;
    select into token_ant nombre from fsql_all_queries
      where indice=columna_indice-3;
  else
    select into tab indice,posicion,nombre,atributo from fsql_all_queries
      where indice=columna_indice-2;
    select into sch atributo from fsql_all_queries
      where indice=columna_indice-4;
    st:=sch||''.''||tab.atributo||''.'';
    st:=''public''||''.''||tab.atributo||''.'';
    select into token_ant nombre from fsql_all_queries
      where indice=columna_indice-5;
  end if;

    select into token_sig nombre from fsql_all_queries
      where indice=columna_indice+1;
    if not found then
	token_sig:=null;
    end if;

  if (token_ant in (''select'','', en sl'')) and
     (token_sig in (''from'',''c_alias'','', en sl'')) then
     if token_sig=''c_alias'' then
	llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||columna_posicion||'': comodin ''||st||''* no debe tener alias.'');
     end if;

     -- encontrar el from
     inicio_from:=columna_indice+1;
     loop
	select into token_sig nombre from fsql_all_queries where indice=inicio_from;
	if token_sig=''from'' then
	   exit;
	end if;
	inicio_from:=inicio_from+1;
     end loop;
     inicio_from:=inicio_from+1;

     fin_from:=inicio_from+1;
     loop
	select into token_sig nombre from fsql_all_queries where indice=fin_from;
	if not found then
	   token_sig:=''fin'';
	end if;
	if token_sig in (''fin'','';'',''where'',''group'',''connect'',''start'',
                          ''union'',''intersect'',''minus'',''order'','')'') then
	   exit;
	end if;
	fin_from:=fin_from+1;
     end loop;
     fin_from:=fin_from-1;

    for tabla in select indice,nombre,atributo from fsql_all_queries
                  where  nombre like ''%tabla'' and
                         indice between inicio_from and fin_from loop
      if tabla.nombre=''tabla'' then
         existe:=''t'';
      else
         select into tsch atributo from fsql_all_queries
           where indice=tabla.indice-2;
      end if;
      if tabla.atributo=tab.atributo and tsch=sch then
         existe:=''t'';
      end if;
    end loop;

    if not existe then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||'': no existe la tabla del comodin (''||sch||''.''||tab.atributo||
         ''.*) en la clausula from correspondiente.'');
       return 1;
    end if;


    obj_var:=fsql_semantic_obj_id(sch,tab.atributo);

    select into n_objs count(*) from fuzzy_col_list
      where obj=obj_var and f_type in (2,3);
    if n_objs=0 then
	return 0;
    end if;

    if columna_nombre=''t.*'' then
       update fsql_all_queries set atributo=null
         where indice between columna_indice-2 and columna_indice-1;
    elsif columna_nombre=''s.t.*'' then
       update fsql_all_queries set atributo=null
         where indice between columna_indice-4 and columna_indice-1;
    end if;

    num_columnas:=fsql_semantic_numero_columnas(sch,tab.atributo);

    col_var:=1;
    while col_var<=num_columnas loop

      nombre_col:=fsql_semantic_nombre_columna(sch,tab.atributo,col_var);

	select into f_tipo,length3 f_type,len from fuzzy_col_list
              where obj=obj_var and col=col_var;
	if not found then
	   f_tipo:=0;
	end if;

      if col_var<>1 then
	todas:=todas||'','';
      end if;
      if f_tipo=2 then
	nombre_col:=substr(nombre_col,1,length(nombre_col)-1);
	todas:=todas||''fsql_functions_fshow2(''||obj_var||'',''||col_var||'',''||
                st||nombre_col||''t,''||st||nombre_col||''1,''||st||nombre_col||''2,''||
                st||nombre_col||''3,''||st||nombre_col||''4) as ''||nombre_col;
	col_var:=col_var+5;
      elsif f_tipo=3 then
	nombre_col:=substr(nombre_col,1,length(nombre_col)-1);
	select into obj2_var,col2_var obj2,col2 from fuzzy_compatible_col
                 where obj1=obj_var and col1=col_var;
	if not found then
	   obj2_var:=obj_var;
	   col2_var:=col_var;
	end if;
	if length3=1 then
	   todas:=todas||''fsql_functions_fshow3_len1(''||obj2_var||'',''||col2_var||'',''||
                  st||nombre_col||''t,''||st||nombre_col||''p1,''||st||nombre_col||''1) as ''||nombre_col;
	   col_var:=col_var+3;
	else
	   cadena:=fsql_aux_resto_llamada_tipo3(st||nombre_col,length3);
	   todas:=todas||''fsql_functions_fshow3(''||obj2_var||'',''||col2_var||'',''||length3
                  ||'',''||cadena||'' as ''||nombre_col;
	   col_var:=col_var+1+2*length3;
	end if;
      else
	 todas:=todas||st||nombre_col;
	 col_var:=col_var+1;
      end if;
    end loop;

    update fsql_all_queries set atributo=todas where indice=columna_indice;

  else
     llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||columna_posicion||
       '': en esta posicion no se admiten comodines como "''||st||''*".'');
  end if;
 return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- incluye las columnas cuando se usa un comodin *
-- si una tabla no tiene atributos conflictivos (difusos tipos 2 o 3) se deja como [s.]t.*
----------------------------------------------------------------------------------------------
drop function fsql_semantic_incluye_columnas_asterisco (numeric(10),numeric(10),
							   varchar(100));
create function fsql_semantic_incluye_columnas_asterisco (numeric(10),numeric(10),
							   varchar(100))
returns integer as '
declare
  columna_indice alias for $1;
  columna_posicion alias for $2;
  columna_nombre alias for $3;
  token_sig   fsql_all_queries.nombre%type;
  inicio_from fsql_all_queries.indice%type;
  fin_from    fsql_all_queries.indice%type;
  st     varchar(62);
  tsch   varchar(30);
  talias varchar(30);
  n_objs integer;
  tabla record;
  obj_var  fuzzy_col_list.obj%type;
  col_var  fuzzy_col_list.col%type;
  obj2_var fuzzy_col_list.obj%type;
  col2_var fuzzy_col_list.col%type;
  todas  varchar(2000);
  num_columnas integer;
  nombre_col varchar;
  f_tipo   fuzzy_col_list.f_type%type;
  length3  fuzzy_col_list.len%type;
  cadena varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_incluye_columnas_asterisco'');
  inicio_from:=columna_indice+1;
  fin_from:=inicio_from+1;
  todas:='''';
  loop
    select into token_sig nombre from fsql_all_queries where indice=fin_from;
    if not found then
	token_sig:=''fin'';
    end if;
    if token_sig in (''fin'','';'',''where'',''group'',''connect'',''start'',
                       ''union'',''intersect'',''minus'',''order'','')'') then
       exit;
    end if;
    fin_from:=fin_from+1;
  end loop;
  fin_from:=fin_from-1;

  for tabla in select indice,posicion,nombre,atributo from fsql_all_queries
                where  nombre like ''%tabla'' and
                       indice between inicio_from and fin_from loop

    select into talias nombre from fsql_all_queries where indice=tabla.indice+1;
    if not found then
	talias:=null;
    end if;
    if talias=''t_alias'' then
       select into tabla.atributo atributo from fsql_all_queries where indice=tabla.indice+1;
    end if;

    if tabla.nombre=''tabla'' then
         tsch:=fsql_semantic_propietario_tabla(tabla.posicion,tabla.atributo);
         if tsch is null then
	    return 1;
	 end if;
         tsch:=''public'';
         st:=tabla.atributo||''.'';
    else
	 select into tsch atributo from fsql_all_queries where indice=tabla.indice-2;
         st:=''public''||''.''||tabla.atributo||''.'';
    end if;

    obj_var:=fsql_semantic_obj_id(tsch,tabla.atributo);

    select into n_objs count(*) from fuzzy_col_list
      where obj=obj_var and f_type in (2,3);

    if n_objs=0 then
       todas:=todas||st||''*,'';
    else
       num_columnas:=fsql_semantic_numero_columnas(tsch,tabla.atributo);
       col_var:=1;
       while col_var<=num_columnas loop

       nombre_col:=fsql_semantic_nombre_columna(tsch,tabla.atributo,col_var);

         select into f_tipo,length3 f_type,len from fuzzy_col_list
                 where obj=obj_var and col=col_var;
         if not found then
	    f_tipo:=0;
         end if;

         if f_tipo=2 then
            nombre_col:=substr(nombre_col,1,length(nombre_col)-1);
            todas:=todas||''fsql_functions_fshow2(''||obj_var||'',''||col_var||'',''||
                   st||nombre_col||''t,''||st||nombre_col||''1,''||st||nombre_col||''2,''||
                   st||nombre_col||''3,''||st||nombre_col||''4) as ''||nombre_col||'','';

            col_var:=col_var+5;
         elsif f_tipo=3 then
            nombre_col:=substr(nombre_col,1,length(nombre_col)-1);
            select into obj2_var,col2_var obj2,col2 from fuzzy_compatible_col
                    where obj1=obj_var and col1=col_var;
            if not found then
		obj2_var:=obj_var;
		col2_var:=col_var;
            end if;
            if length3=1 then
               todas:=todas||''fsql_functions_fshow3_len1(''||obj2_var||'',''||col2_var||'',''||st||nombre_col||''t,''||st||nombre_col||''p1,''||st||nombre_col||''1) as ''||nombre_col||'','';
               col_var:=col_var+3;
            else
		cadena:=fsql_aux_resto_llamada_tipo3(st||nombre_col,length3);
              todas:=todas||''fsql_functions_fshow3(''||obj2_var||'',''||col2_var||'',''||length3||'',''||cadena||'' as ''||nombre_col||'','';
              col_var:=col_var+1+2*length3;
            end if;
         else
            todas:=todas||st||'' as ''||nombre_col||'','';
            col_var:=col_var+1;
         end if;

       end loop;
    end if;
  end loop;

  update fsql_all_queries set atributo=substr(todas,1,length(todas)-1)
    where indice=columna_indice;
 return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- incluye las columnas cuando se usan comodines de los tipos: "t.%" o "s.t.%"
-- si las tablas no tienen atributos conflictivos (difusos tipos 2 o 3) se cambian
-- por "t.*" o "s.t.*" y se incluyen los cdeg de los tipos 1, si los hay.
-- los cdeg son incluidos en la tabla fsql_query como si hubiesen sido escritos en la
-- consulta inicial, poniendo su posicion a cero, y son tratados, como un cdeg normal,
-- por el procedimiento "calcula_cdeg".
-- si un atributo difuso no aparece en la clausula where, su cdeg no es aplicable y por tanto
-- no aparecera su cdeg si se usa el comodin % (sera eliminado en calcula_cdeg).
----------------------------------------------------------------------------------------------
drop function fsql_semantic_incluye_columnas_st_porciento (numeric(10),numeric(10),
							   varchar(100));
create function fsql_semantic_incluye_columnas_st_porciento (numeric(10),numeric(10),
							   varchar(100))
returns integer as '
declare
  columna_indice_entrada alias for $1;
  columna_posicion_entrada alias for $2;
  columna_nombre_entrada alias for $3;

  columna_indice numeric(10);
  columna_posicion numeric(10);
  columna_nombre varchar(100);
  token_ant fsql_all_queries.nombre%type;
  token_sig fsql_all_queries.nombre%type;
  inicio_from fsql_all_queries.indice%type;
  fin_from    fsql_all_queries.indice%type;
  sch    varchar(30);
  tab    record;
  tabla  record;
  col_id record;
  col_tab record;
  st     varchar(62);
  tsch   varchar(30);
  n_objs integer;
  existe boolean;
  obj_var    fuzzy_col_list.obj%type;
  nombre_col varchar;
  llamadafuncion integer;
  audsid numeric;
  maxind_var numeric;
  valor numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_incluye_columnas_st_porciento'');
  columna_indice = columna_indice_entrada;
  columna_posicion = columna_posicion_entrada;
  columna_nombre = columna_nombre_entrada;
  existe:=''f'';
  select into audsid pg_backend_pid();
  select into maxind_var maxind from variables;
  if columna_nombre=''t.%'' then
    select into tab indice,posicion,nombre,atributo from fsql_all_queries
      where indice=columna_indice-2;
    st:=tab.atributo||''.'';
    sch:=fsql_semantic_propietario_tabla(tab.posicion,tab.atributo);
    sch:=''public'';
    select into token_ant nombre from fsql_all_queries where indice=columna_indice-3;
  else
    select into tab indice,posicion,nombre,atributo from fsql_all_queries where indice=columna_indice-2;
    select into sch atributo from fsql_all_queries where indice=columna_indice-4;
    st:=''public''||''.''||tab.atributo||''.'';
  --  st:=sch||''.''||tab.atributo||''.'';
    select into token_ant nombre from fsql_all_queries where indice=columna_indice-5;
  end if;

  select into token_sig nombre from fsql_all_queries where indice=columna_indice+1;
  if not found then
	token_sig:=null;
  end if;

  if (token_ant in (''select'','', en sl'')) and
     (token_sig in (''from'',''c_alias'','', en sl'')) then
     if token_sig=''c_alias'' then
        llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||columna_posicion||'': comodin ''||st||''% no debe tener alias.'');
     end if;

     inicio_from:=columna_indice+1;
     loop
	select into token_sig nombre from fsql_all_queries where indice=inicio_from;
	if token_sig=''from'' then
	  exit;
	end if;
	inicio_from:=inicio_from+1;
     end loop;
     inicio_from:=inicio_from+1;
     fin_from:=inicio_from+1;
     loop
	select into token_sig nombre from fsql_all_queries where indice=fin_from;
	if not found then
	  token_sig:=''fin'';
	end if;
	if token_sig in (''fin'','';'',''where'',''group'',''connect'',''start'',
                          ''union'',''intersect'',''minus'',''order'','')'') then
	   exit;
	end if;
       fin_from:=fin_from+1;
     end loop;
     fin_from:=fin_from-1;

    for tabla in select indice,nombre,atributo from fsql_all_queries
                  where  nombre like ''%tabla'' and
                         indice between inicio_from and fin_from loop
      if tabla.nombre=''tabla'' then
         existe:=''t'';
      else
	 select into tsch atributo from fsql_all_queries where indice=tabla.indice-2;
      end if;
      if tabla.atributo=tab.atributo and tsch=sch then
	 existe:=''t'';
      end if;
    end loop;

    if not existe then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_posicion||'': no existe la tabla del comodin (''||sch||''.''||tab.atributo||
         ''.%) en la clausula from correspondiente.'');
       return 1;
    end if;

    obj_var:=fsql_semantic_obj_id(sch,tab.atributo);

    select into n_objs count(*) from fuzzy_col_list where obj=obj_var and f_type in (2,3);
    if n_objs=0 then
       update fsql_all_queries set atributo=''*'' where indice=columna_indice;

       select into n_objs count(*) from fuzzy_col_list where obj=obj_var and f_type=1;
       if n_objs=0 then
          return 1;
       else
          for col_id in (select col from fuzzy_col_list where obj=obj_var and f_type=1) loop

            nombre_col:=fsql_semantic_nombre_columna(sch,tab.atributo,col_id.col);
            if columna_nombre=''t.%'' then
       valor:=maxind_var;
       while valor>columna_indice loop
           update fsql_all_queries set indice=valor+7
             where indice = valor;
           valor:=valor-1;
       end loop;
          --     update fsql_all_queries set indice=indice+7
            --     where indice between columna_indice+1 and maxind_var;
               insert into fsql_all_queries values (audsid,columna_indice+1,0,'', en sl'','','');
               insert into fsql_all_queries values (audsid,columna_indice+2,0,''cdeg'',''cdeg'');
               insert into fsql_all_queries values (audsid,columna_indice+3,0,''( function'',''('');
               insert into fsql_all_queries values (audsid,columna_indice+4,0,''t.'',tab.atributo);
               insert into fsql_all_queries values (audsid,columna_indice+5,0,''.'',''.'');
               insert into fsql_all_queries values (audsid,columna_indice+6,0,''t.column'',nombre_col);
               insert into fsql_all_queries values (audsid,columna_indice+7,0,'') function'','')'');
               columna_indice:=columna_indice+7;
               maxind_var:=maxind_var+7;
            else
       valor:=maxind_var;
       while valor>columna_indice loop
           update fsql_all_queries set indice=valor+9
             where indice = valor;
           valor:=valor-1;
       end loop;
            --   update fsql_all_queries set indice=indice+9
              --   where indice between columna_indice+1 and maxind_var;
               insert into fsql_all_queries values (audsid,columna_indice+1,0,'', en sl'','','');
               insert into fsql_all_queries values (audsid,columna_indice+2,0,''cdeg'',''cdeg'');
               insert into fsql_all_queries values (audsid,columna_indice+3,0,''( function'',''('');
               insert into fsql_all_queries values (audsid,columna_indice+4,0,''s.t.'',sch);
               insert into fsql_all_queries values (audsid,columna_indice+5,0,''.'',''.'');
               insert into fsql_all_queries values (audsid,columna_indice+6,0,''t.'',tab.atributo);
               insert into fsql_all_queries values (audsid,columna_indice+7,0,''.'',''.'');
               insert into fsql_all_queries values (audsid,columna_indice+8,0,''s.t.column'',nombre_col);
               insert into fsql_all_queries values (audsid,columna_indice+9,0,'') function'','')'');
               columna_indice:=columna_indice+9;
               maxind_var:=maxind_var+9;
            end if;
          end loop;
	     update columna set indice=columna_indice;
             update variables set maxind=maxind_var;
          return 1;
       end if;
    end if;

    columna_nombre:=substr(columna_nombre,1,length(columna_nombre)-1)||''*'';
   -- columna_atributo:=''*'';

    llamadafuncion:=fsql_semantic_incluye_columnas_st_asterisco(columna_indice,columna_posicion,columna_nombre);

    for col_tab in (select col,f_type from fuzzy_col_list
                  where obj=obj_var and f_type between 1 and 3 order by col) loop

    nombre_col:=fsql_semantic_nombre_columna(sch,tab.atributo,col_tab.col);
      if col_tab.f_type in (2,3) then
         nombre_col:=substr(nombre_col,1,length(nombre_col)-1);
      end if;

      if columna_nombre=''t.*'' then
       valor:=maxind_var;
       while valor>columna_indice loop
           update fsql_all_queries set indice=valor+7
             where indice = valor;
           valor:=valor-1;
       end loop;
      --   update fsql_all_queries set indice=indice+7
        --   where indice between columna_indice+1 and maxind_var;
         insert into fsql_all_queries values (audsid,columna_indice+1,0,'', en sl'','','');
         insert into fsql_all_queries values (audsid,columna_indice+2,0,''cdeg'',''cdeg'');
         insert into fsql_all_queries values (audsid,columna_indice+3,0,''( function'',''('');
         insert into fsql_all_queries values (audsid,columna_indice+4,0,''t.'',tab.atributo);
         insert into fsql_all_queries values (audsid,columna_indice+5,0,''.'',''.'');
         insert into fsql_all_queries values (audsid,columna_indice+6,0,''t.column'',nombre_col);
         insert into fsql_all_queries values (audsid,columna_indice+7,0,'') function'','')'');
         columna_indice:=columna_indice+7;
         maxind_var:=maxind_var+7;
         update variables set maxind=maxind_var;
      else
       valor:=maxind_var;
       while valor>columna_indice loop
           update fsql_all_queries set indice=valor+9
             where indice = valor;
           valor:=valor-1;
       end loop;
      --   update fsql_all_queries set indice=indice+9
        --   where indice between columna_indice+1 and maxind_var;
         insert into fsql_all_queries values (audsid,columna_indice+1,0,'', en sl'','','');
         insert into fsql_all_queries values (audsid,columna_indice+2,0,''cdeg'',''cdeg'');
         insert into fsql_all_queries values (audsid,columna_indice+3,0,''( function'',''('');
         insert into fsql_all_queries values (audsid,columna_indice+4,0,''s.t.'',sch);
         insert into fsql_all_queries values (audsid,columna_indice+5,0,''.'',''.'');
         insert into fsql_all_queries values (audsid,columna_indice+6,0,''t.'',tab.atributo);
         insert into fsql_all_queries values (audsid,columna_indice+7,0,''.'',''.'');
         insert into fsql_all_queries values (audsid,columna_indice+8,0,''s.t.column'',nombre_col);
         insert into fsql_all_queries values (audsid,columna_indice+9,0,'') function'','')'');
         columna_indice:=columna_indice+9;
         maxind_var:=maxind_var+9;
      end if;
    end loop;
  else
     llamadafuncion:=fsql_aux_inserta_error(''error sintactico en posicion ''||columna_posicion||'': en esta posicion no se admiten comodines como "''||st||''%".'');
  end if;
  update variables set maxind=maxind_var;
  update columna set indice=columna_indice, posicion=columna_posicion, nombre=columna_nombre;
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- incluye las columnas cuando se usa un comodin %
-- si las tablas no tienen atributos conflictivos (difusos tipos 2 o 3) se cambian
-- por "t.*" o "s.t.*" y se incluyen los cdeg de los tipos 1, si los hay.
-- si un atributo difuso no aparece en la clausula where, su cdeg no es aplicable y por tanto
-- no aparecera su cdeg si se usa el comodin %, i.e. sera eliminado en calcula_cdeg.
----------------------------------------------------------------------------------------------
drop function fsql_semantic_incluye_columnas_porciento (numeric(10),numeric(10),
							   varchar(100));
create function fsql_semantic_incluye_columnas_porciento (numeric(10),numeric(10),
							   varchar(100))
returns integer as '
declare
  columna_indice_entrada alias for $1;
  columna_posicion_entrada alias for $2;
  columna_nombre_entrada alias for $3;

  columna_indice numeric(10);
  columna_posicion numeric(10);
  columna_nombre varchar(100);

  token_sig   fsql_all_queries.nombre%type;
  talias      fsql_all_queries.nombre%type;
  inicio_from fsql_all_queries.indice%type;
  fin_from    fsql_all_queries.indice%type;
  ind         fsql_all_queries.indice%type;
  tsch   varchar(30);
  tabla record;
  audsid numeric;
  maxind_var numeric;
  valor numeric;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_incluye_columnas_porciento'');
  columna_indice = columna_indice_entrada;
  columna_posicion = columna_posicion_entrada;
  columna_nombre = columna_nombre_entrada;
  select into audsid pg_backend_pid();
  select into maxind_var maxind from variables;
  inicio_from:=columna_indice+1;

  fin_from:=inicio_from+1;
  loop
    select into token_sig nombre from fsql_all_queries where indice=fin_from;
    if not found then
	token_sig:=''fin'';
    end if;
    if token_sig in (''fin'','';'',''where'',''group'',''connect'',''start'',
                       ''union'',''intersect'',''minus'',''order'','')'') then
	exit;
    end if;
    fin_from:=fin_from+1;
  end loop;
  fin_from:=fin_from-1;

  ind:=columna_indice;
  update fsql_all_queries set posicion=
         (select posicion from fsql_all_queries where indice=ind-1)
         where indice=ind;
  update fsql_all_queries set nombre=
         (select nombre from fsql_all_queries where indice=ind-1)
         where indice=ind;
  update fsql_all_queries set atributo=
         (select atributo from fsql_all_queries where indice=ind-1)
         where indice=ind;
  update fsql_all_queries set atributo=null where indice=ind-1;

  for tabla in select indice,nombre,atributo from fsql_all_queries
                where  nombre like ''%tabla'' and
                       indice between inicio_from and fin_from loop

    select into talias nombre from fsql_all_queries
            where indice=tabla.indice+1+(ind-columna_indice);
    if not found then
	talias:=null;
    end if;
    if talias=''t_alias'' then
       select into tabla.atributo atributo from fsql_all_queries
         where indice=tabla.indice+1+(ind-columna_indice);
    end if;

    if tabla.nombre=''tabla'' then
   --    update fsql_all_queries set indice=indice+4
    --     where indice between ind+1 and maxind_var;
       valor:=maxind_var;
       while valor>ind loop
           update fsql_all_queries set indice=valor+4
             where indice = valor;
           valor:=valor-1;
       end loop;
     --  delete from fsql_all_queries 
     --   where indice between ind+1 and maxind_var;
       insert into fsql_all_queries values (audsid,ind+1,0,''t.'',tabla.atributo);
       insert into fsql_all_queries values (audsid,ind+2,0,''.'',''.'');
       insert into fsql_all_queries values (audsid,ind+3,0,''t.%'',''%'');
       insert into fsql_all_queries values (audsid,ind+4,0,'', en sl'','','');
       ind:=ind+4;

       maxind_var:=maxind_var+4;
    else
       select into tsch atributo from fsql_all_queries
         where indice=tabla.indice-2+(ind-columna_indice);
       valor:=maxind_var;
       while valor>ind loop
           update fsql_all_queries set indice=valor+4
             where indice = valor;
           valor:=valor-1;
       end loop;
     --  update fsql_all_queries set indice=indice+6
       --  where indice between ind+1 and maxind_var;
       insert into fsql_all_queries values (audsid,ind+1,0,''s.t.'',tsch);
       insert into fsql_all_queries values (audsid,ind+2,0,''.'',''.'');
       insert into fsql_all_queries values (audsid,ind+3,0,''t.'',tabla.atributo);
       insert into fsql_all_queries values (audsid,ind+4,0,''.'',''.'');
       insert into fsql_all_queries values (audsid,ind+5,0,''s.t.%'',''%'');
       insert into fsql_all_queries values (audsid,ind+6,0,'', en sl'','','');
       ind:=ind+6;
       maxind_var:=maxind_var+6;
    end if;
  end loop;

  update fsql_all_queries set atributo=null where indice=ind;
  update variables set maxind=maxind_var;
  return 0;
end;
'language 'plpgsql';

----------------------------------------------------------------------------------------------
-- analizador semantico para una consulta en fsql
-- requisito: la sentencia de fsql_query debe ser correcta lexica y sintacticamente.
-- devuelve : numero de errores encontrados (0 si ha sido correcta).
-- modifica en fsql_query la columna atributo con la traduccion de fsql a sql
----------------------------------------------------------------------------------------------
drop function fsql_semantic_semantico();
create function fsql_semantic_semantico()
 returns integer as '
declare  
  ind     fsql_all_queries.indice%type;
  maxind_var  fsql_all_queries.indice%type;
  nombre_var  fsql_all_queries.nombre%type;
  scheme_var  varchar(30);
  tab_var     varchar(30);
  stalias varchar(61);
  tabla   record;
  aliascdeg record;
  alias_var record;
  columna_var record;
  colcdeg record;
  n_objs integer;
  f_tipo_var fuzzy_col_list.f_type%type;
  obj_var    fuzzy_col_list.obj%type;
  col_var    fuzzy_col_list.col%type;
  hay_not boolean;
  llamadafuncion integer;
  llamadafuncion2 boolean;
  cadena varchar;
begin
  insert into trama values(nextval(''sec''),''fsql_semantic_semantico'');
  hay_not:=''f'';
--  select into audsid pg_backend_pid();
  select into maxind_var max(indice) from fsql_all_queries;
  select into obj_var,col_var,f_tipo_var obj,col,f_tipo from variables;
  n_objs:=0;
  for alias_var in select atributo,indice from fsql_all_queries
                  where nombre=''t_alias'' loop
    select into tab_var,stalias nombre,atributo from fsql_all_queries
      where indice=alias_var.indice-1;
    if tab_var=''s.tabla'' then
       select into scheme_var atributo from fsql_all_queries
         where indice=alias_var.indice-3;
    else
     --  select into scheme_var user;
       scheme_var:=''public'';
    end if;

    n_objs:=n_objs+1;
    insert into all_alias values (alias_var.atributo,scheme_var,stalias);

  end loop;

  -----------------------------------------------
  for tabla in select indice,posicion,nombre,atributo from fsql_all_queries
     where  nombre like ''%tabla'' loop

    if tabla.nombre=''tabla'' then
      -- select into scheme_var user;
       scheme_var:=''public'';
    else
       select into scheme_var atributo from fsql_all_queries where indice=tabla.indice-2;
    end if;

    select into n_objs count(*) from pg_class
      where relname=tabla.atributo and relowner=(select pg_user.usesysid from pg_user where usename=(select user));

    if n_objs=0 then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||tabla.posicion
          ||'': tabla o vista ''||tabla.atributo||'' no existe.'');
    elsif n_objs>1 then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||tabla.posicion
          ||'': tabla o vista ''||tabla.atributo||'' ambigua (no completamente especificada).'');
    end if;
  end loop;

  -----------------------------------------------

  select into n_objs count(*) from fsql_all_errors;
  if n_objs>0 then
     return n_objs;
  end if;

  ------------------------------------
  ind:=1;
   update variables set maxind=maxind_var;
  while ind<=maxind_var loop
    select into columna_var indice,posicion,nombre,atributo from fsql_all_queries where indice=ind;

    if columna_var.nombre=''todas'' then
      llamadafuncion:=fsql_semantic_incluye_columnas_asterisco(columna_var.indice, columna_var.posicion, columna_var.nombre);
    elsif columna_var.nombre in (''t.*'',''s.t.*'') then
      llamadafuncion:=fsql_semantic_incluye_columnas_st_asterisco(columna_var.indice, columna_var.posicion, columna_var.nombre);
    elsif columna_var.nombre in (''t.%'',''s.t.%'') then
      
      llamadafuncion:=fsql_semantic_incluye_columnas_st_porciento(columna_var.indice, columna_var.posicion, columna_var.nombre);
      select into ind indice from columna;
  --    ind:=columna.indice;
    elsif columna_var.nombre=''todo'' then
      llamadafuncion:=fsql_semantic_incluye_columnas_porciento(columna_var.indice, columna_var.posicion, columna_var.nombre);
    end if;
    select into maxind_var maxind from variables;
    ind:=ind+1;
  end loop;

  llamadafuncion:=fsql_semantic_lee_options();

  ------------------------------------
  for ind in 1..maxind_var loop
    select into columna_var indice,posicion,nombre,atributo from fsql_all_queries where indice=ind;

    if columna_var.nombre like ''%column'' then
  --  if columna_var.nombre = ''column'' then
        SELECT into obj_var, col_var,f_tipo_var obj,col,f_type from fuzzy_col_list where com = ''public.'' ||tab_var||''.''||columna_var.atributo;
        update variables set obj=obj_var;
        update variables set col=col_var;
        update variables set f_tipo=f_tipo_var;
	llamadafuncion2:=fsql_semantic_es_fuzzy_column(columna_var.indice, columna_var.posicion, columna_var.nombre, columna_var.atributo ,scheme_var,tab_var,f_tipo_var,obj_var,col_var);
        select into scheme_var,tab_var,f_tipo_var,obj_var,col_var scheme,tab,f_tipo,obj,col from variables;
       if llamadafuncion2 then
 	llamadafuncion:=fsql_semantic_trata_fuzzy_column(columna_var.indice, columna_var.posicion, columna_var.nombre, columna_var.atributo,scheme_var,tab_var,f_tipo_var,obj_var,col_var);
        select into scheme_var,tab_var,obj_var,col_var scheme,tab,obj,col from variables;
       end if;
    elsif columna_var.nombre=''\\not'' then
       if hay_not then
	  llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_var.posicion||'': no se pueden poner dos negaciones (not) juntas. use parentesis.'');
       else
	  hay_not:=''t'';
       end if;
    else
	hay_not:=''f'';
    end if;
  end loop;

  ------------------------------------

  for ind in 1..maxind_var loop
    select into columna_var indice,posicion,nombre,atributo from fsql_all_queries where indice=ind;
    if columna_var.atributo in (''unknown'',''undefined'') then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_var.posicion||'': constante difusa ''||columna_var.atributo||'' esta mal situada.'');
    elsif columna_var.atributo in(''fgt'',''flt'',''feq'',''fgeq'',''fleq'',''mgt'',''mlt'', ''nfgt'',''nflt'',''nfeq'',''nfgeq'',''nfleq'',''nmgt'',''nmlt'') then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_var.posicion||'': comparador difuso ''||columna_var.atributo||
         '' debe tener una columna difusa justo a su izquierda (tipo 1, 2 o 3). formato: <fuzzy_column> ''||columna_var.atributo||'' <expr>.'');

    elsif columna_var.atributo=''cdeg'' then
       llamadafuncion:=fsql_aux_inserta_error(''error semantico en posicion ''||columna_var.posicion||'': cdeg (compatibility degree) solo es aplicable a atributos con tratamiento difuso (tipos 1, 2 o 3).'');
    end if;
  end loop;

  ------------------------------------
  select into n_objs count(*) from fsql_all_errors;
  if n_objs>0 then
     return n_objs;
  end if;

  ------------------------------------
  cadena :=''%''||''\\\\''||''cdeg'';
  for colcdeg in select indice,posicion,nombre,atributo from fsql_all_queries
                    where nombre like cadena loop

    llamadafuncion:=fsql_semantic_calcula_cdeg(colcdeg.indice,colcdeg.posicion,colcdeg.nombre,colcdeg.atributo,maxind_var);

  end loop;

  for aliascdeg in select indice from fsql_all_queries
                      where nombre = ''cdeg c_alias'' loop
    ind:=aliascdeg.indice+1;
    loop
      select into nombre_var nombre from fsql_all_queries where indice=ind;
      if not found then
	 nombre_var:=''fin'';
      end if;
      if nombre_var in (''c_alias'',''cdeg c_alias'','', en sl'',''from'',''fin'') then
	 exit;
      end if;
      ind:=ind+1;
    end loop;

    ind:=ind-1;
    if nombre_var in (''c_alias'',''cdeg c_alias'') then

       update fsql_all_queries set atributo='''' where indice=aliascdeg.indice;
    elsif nombre_var in ('', en sl'',''from'') and (ind<>aliascdeg.indice) then

       update fsql_all_queries set indice=-1       where indice = aliascdeg.indice;
       update fsql_all_queries set indice=indice-1 where indice between aliascdeg.indice+1 and ind;
       update fsql_all_queries set indice=ind,nombre=''op c_alias'' where indice=-1;
    end if;
  end loop;

  select into n_objs count(*) from fsql_all_errors;
  return n_objs;

end;
'language 'plpgsql';
