-- Archivo papelera.sql
-------------------------------------------------------------------
-- INSTALACIÓN de una Base de Datos Difusa SOBRE Cartulina.     --
-- CREACIÓN de las TABLAS insercin de algunas tuplas en ellas,  --
-- así como creacin de elementos en la FMB de esta Bd.          --
-- Para la instalacin no hace fALTA desinstalarla PREviamente.  --
-------------------------------------------------------------------

DROP TABLE especialista;
CREATE TABLE especialista(
  fila           numeric , 
  rut            varchar ,
  habilidadt     numeric(1) NOT NULL, 
  habilidad1     numeric(3),
  habilidad2     numeric(3),
  habilidad3     numeric(3),
  habilidad4     numeric(3),
  experienciat   numeric(1) NOT NULL,
  experienciaP1  numeric(3,2), 
  experiencia1   numeric(3),
  experienciaP2  numeric(3,2), 
  experiencia2   numeric(3),
  experienciap3  numeric(3,2), 
  experiencia3   numeric(3),
  experienciap4  numeric(3,2), 
  experiencia4   numeric(3),
  experticiat    numeric(1),
  PRIMARY KEY(rut));  


DROP TABLE paciente;
CREATE TABLE paciente(
  fila          numeric    , 
  rut	 	    varchar(10) NOT NULL,
  nombre        varchar(50),
  direccion     varchar(50),
  color_pielt 	numeric(1) NOT NULL, 
	check(Color_pielT between 0 and 4), 
  nombre_pielp1 numeric(3,2),  
  nombre_piel1 	numeric(3),
  nombre_pielp2 numeric(3,2), 
  nombre_piel2 	numeric(3),
  nombre_pielp3 numeric(3,2), 
  nombre_piel3 	numeric(3),
  nombre_pielp4 numeric(3,2), 
  nombre_piel4 	numeric(3),
  PRIMARY KEY(rut));


DROP TABLE asistencia;

CREATE TABLE asistencia(
  fila         numeric, 
  porcentaje   numeric, 
  fecha	 	   DATE NOT NULL,  
  PRIMARY KEY(fila));
  
    
-- **********  Fin de creacin de Tablas  *********


drop function ej2();
create function ej2() 
returns integer as '
declare

  t_especialista   numeric;
  t_paciente	   numeric;
  t_asistencia	   numeric;
  
  c_cporcentaje    numeric;
  c_cnombre_piel   numeric;
  c_phabilidad 	   numeric;
  c_pexperiencia   numeric;
  c_pexperticia    numeric;

begin

-- (>>>> insertando valores en la fmb sobre esta bd difusa...);

  -- calcular obj para las tablas con columnas difusas:

  select into t_especialista relfilenode from pg_class where relname=''especialista'';
  select into t_paciente relfilenode from pg_class where relname=''paciente'';
  select into t_asistencia relfilenode from pg_class where relname=''asistencia'';

  
 -- calcular col de las columnas difusas:

   select into c_cnombre_piel attnum
    from pg_attribute a, pg_statio_user_tables b
    where 
         b.relname = ''paciente'' and 
         a.attrelid = b.relid and 
         a.attname = ''color_pielt'';

  select into c_phabilidad attnum
    from pg_attribute a, pg_statio_user_tables b
    where 
         b.relname = ''especialista'' and 
         a.attrelid = b.relid and 
         a.attname = ''habilidadt'';

  select into c_pexperiencia attnum
    from pg_attribute a, pg_statio_user_tables b
    where 
         b.relname = ''especialista'' and 
         a.attrelid = b.relid and 
         a.attname = ''experienciat'';

  select into c_pexperticia attnum
    from pg_attribute a, pg_statio_user_tables b
    where 
         b.relname = ''especialista'' and 
         a.attrelid = b.relid and 
         a.attname = ''experticiat'';
		 
  select into c_cporcentaje attnum
    from pg_attribute a, pg_statio_user_tables b
    where 
         b.relname = ''asistencia'' and 
         a.attrelid = b.relid and 
         a.attname = ''porcentaje'';
		 
		 
  -- Significado de los Tipo 5, 6 y 7:
  insert into fuzzy_degree_sig values(1,''Grado_Experticia'');

		 
-- atributos con tratamiento difuso: tipos 1 al 8

  insert into fuzzy_col_list values (t_asistencia,c_cporcentaje,8,1,null,null,''public''||''.asistencia.porcentaje'');
  insert into fuzzy_col_list values (t_especialista,c_phabilidad,2,4,null,null,''public''||''.especialista.habilidad'');
  insert into fuzzy_col_list values (t_especialista,c_pexperiencia,3,4,null,null,''public''||''.especialista.experiencia'');
  insert into fuzzy_col_list values (t_especialista,c_pexperticia,6,1,1,null,''public''||''.especialista.experticia'');
  insert into fuzzy_col_list values (t_paciente,c_cnombre_piel,4,4,null,null,''public''||''.paciente.nombre_piel'');

  
  -- objetos para las tablass:

  insert into fuzzy_object_list values(t_asistencia,c_cporcentaje,0,''porcentaje_asistencia'',8);  
  insert into fuzzy_object_list values(t_paciente,c_cnombre_piel,0,''blanca'',1);
  insert into fuzzy_object_list values(t_paciente,c_cnombre_piel,1,''amarilla'',1);
  insert into fuzzy_object_list values(t_paciente,c_cnombre_piel,2,''cafe'',1);
  insert into fuzzy_object_list values(t_paciente,c_cnombre_piel,3,''negra'',1);
  
  insert into fuzzy_object_list values(t_especialista,c_phabilidad,0,''poca'',0);
  insert into fuzzy_object_list values(t_especialista,c_phabilidad,1,''normal'',0);
  insert into fuzzy_object_list values(t_especialista,c_phabilidad,2,''mucha'',0);
  insert into fuzzy_object_list values(t_especialista,c_phabilidad,3,''muchisima'',0);
  
  insert into fuzzy_object_list values(t_especialista,c_pexperiencia,0,''principiante'',0);
  insert into fuzzy_object_list values(t_especialista,c_pexperiencia,1,''con_experiencia'',0);
  insert into fuzzy_object_list values(t_especialista,c_pexperiencia,2,''experimentado'',0);
  insert into fuzzy_object_list values(t_especialista,c_pexperiencia,3,''experto'',0);

  insert into fuzzy_object_list values(t_especialista,c_pexperticia,c_phabilidad,''grado_habilidad'',6);
  insert into fuzzy_object_list values(t_especialista,c_pexperticia,c_pexperiencia,''grado_experiencia'',6);

  -- definicin de las etiquetas linguisticas:
  insert into fuzzy_label_def values(t_especialista,c_phabilidad,0,0,15,34,46);
  insert into fuzzy_label_def values(t_especialista,c_phabilidad,1,42,51,71,82);
  insert into fuzzy_label_def values(t_especialista,c_phabilidad,2,76,85,100,100);
  

  -- definicin de los Tipo 6:
  insert into fuzzy_degree_cols values(t_especialista,c_pexperticia,t_especialista,c_phabilidad);
  insert into fuzzy_degree_cols values(t_especialista,c_pexperticia,t_especialista,c_pexperiencia);

    
-- definicin de:	1) márgenes para valores aprox en cada columna y
--			        2) distancia mínima para afirmar en los comparadores mgt y mlt.

  insert into fuzzy_approx_much values(t_especialista,c_phabilidad,71,76);

  
 -- definicion de las relaciones de similitud:

  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,0,1,.8);
  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,0,2,.5);
  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,0,3,.2);
  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,1,2,.4);
  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,1,3,.9);
  insert into fuzzy_nearness_def values(t_especialista,c_pexperiencia,2,3,.6);

  
  -- *****  inserciones de los cuantificadores de las tablas ***** --
  insert into fuzzy_qualifiers_def values(t_especialista,c_pexperticia,c_phabilidad,0.66);
  insert into fuzzy_qualifiers_def values(t_especialista,c_pexperticia,c_pexperiencia,0.34);

  
  -- *****  inserciones de los valores de las tablas ***** --
  insert into especialista values (1,111,4,33,NULL,NULL,NULL,4,.1,0,.3,1,NULL,NULL,NULL,NULL,NULL);
  insert into especialista values (2,222,4,42,NULL,NULL,NULL,4,.23,.36,.62,.14,NULL,NULL,NULL,NULL,NULL);
  insert into especialista values (3,333,4,88,NULL,NULL,NULL,4,.33,0,.6,.6,NULL,NULL,NULL,NULL,NULL);

  insert into paciente values (0,''000'',''Mario Molina'',''12 Sur 321'',4,.2,0,.35,1,.7,2,.8,3);
  insert into paciente values (1,''111'',''Nicolas Moya'',''Chacabuco 321'',4,.1,0,.3,1,.7,2,.9,3);
  insert into paciente values (2,''222'',''Edith Araneda'',''2 Sur 1242'',4,.94,0,.6,1,.2,2,0,3);
  insert into paciente values (3,''333'',''Constanza Hernandez'',''Freire 825'',4,.23,0,.38,1,1,2,.6,3);
  insert into paciente values (4,''444'',''Felipe Melendez'',''33 Oriente 3567'',4,.56,0,1,1,.65,2,.8,3);

  insert into asistencia values (1,0.63,''02-01-2008'');
  insert into asistencia values (2,0.91,''03-01-2008'');
  insert into asistencia values (3,0.83,''05-01-2008'');
  insert into asistencia values (4,0.74,''06-01-2008'');
  insert into asistencia values (5,0.67,''07-01-2008'');
  insert into asistencia values (6,0.88,''08-01-2008'');
  insert into asistencia values (7,0.82,''09-01-2008'');
 
   
  return 0;
  commit;
end;
'language 'plpgsql';

select ej2();

-- **************
-- fin de la instalacion: si existieron errores, revise su texto.
-- **************
