// AnadirBD.cpp : implementation file
//

#include "stdafx.h"
#include "Proyecto.h"
#include "ProyectoDoc.h"
#include "ProyectoView.h"
#include "AnadirBD.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SIGMA_POR_DEFECTO "3.00"

/////////////////////////////////////////////////////////////////////////////
// CAnadirBD dialog


CAnadirBD::CAnadirBD(CWnd* pParent /*=NULL*/)
	: CDialog(CAnadirBD::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnadirBD)
	m_TxtNombreBD = _T("");
	m_TxtSigma = _T("");
	//}}AFX_DATA_INIT
}


void CAnadirBD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnadirBD)
	DDX_Text(pDX, IDC_NOMBREBD, m_TxtNombreBD);
	DDX_Text(pDX, IDC_EDIT_SIGMA, m_TxtSigma);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAnadirBD, CDialog)
	//{{AFX_MSG_MAP(CAnadirBD)
	ON_BN_CLICKED(IDC_AYUDA, OnAyuda)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnadirBD message handlers

// ************* //
// ** EVENTOS ** //
// ************* //

// ** Inicio ejecucin ventana ** //

// Se dispara al iniciar la ejecucin de la ventana
BOOL CAnadirBD::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CenterWindow();

	m_TxtSigma = SIGMA_POR_DEFECTO;
	UpdateData(false);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ** Botones ** //

// Se dispara cuando se pulsa el botn "Aceptar"
void CAnadirBD::OnOK() 
{
	UpdateData(true);

	// Comprobaciones //
	if (m_TxtNombreBD.GetLength() == 0) // Debe introducirse un nombre no vacio
	{
		AfxMessageBox("Introduzca un nombre de grupo correcto.");
		return;
	}
	if (Vacia(m_TxtNombreBD)) // Que no comience por un espacio en blanco
	{
		AfxMessageBox("Introduzca un nombre de grupo correcto.");
		return;
	}
	if (m_TxtSigma.GetLength() == 0) // No sirve un sigma vacio
	{
		AfxMessageBox("Introduzca un sigma correcto.");
		return;
	}
	if (!SoloNumeros(m_TxtSigma)) // Sigma debe ser un nmero
	{
		AfxMessageBox("Introduzca un sigma correcto.");
		return;
	}

	// No hay errores: Termino la ejecucin de esta ventana
	CDialog::OnOK();
}

// Se dispara cuando se pulsa el botn "Ayuda"
void CAnadirBD::OnAyuda() 
{
	HtmlHelp(NULL, workdir + "\\Ayuda\\Ayuda.chm::/anadirgi.htm",HH_DISPLAY_TOPIC,0);	
}

// ******************** //
// ** PROCEDIMIENTOS ** //
// ******************** //

bool CAnadirBD::Vacia(CString s)
{
	int i;

	for (i=0;i<s.GetLength();i++)
	{
		if (s[i] != ' ')
			return false;
	}

	return true;
}

bool CAnadirBD::SoloNumeros(CString s)
{
	int i;

	for (i=0;i<s.GetLength();i++)
	{
		if (!(((s[i] >= '0') && (s[i] <= '9')) || (s[i] == '.')))
			return false;
	}

	return true;
}
