//{{AFX_INCLUDES()
#include "msflexgrid.h"
//}}AFX_INCLUDES
#if !defined(AFX_BUSQDATOS_H__09981852_DE15_4A0E_9A75_119302D331EE__INCLUDED_)
#define AFX_BUSQDATOS_H__09981852_DE15_4A0E_9A75_119302D331EE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// BusqDatos.h : header file
//

#include "CImagen.h"
#include "CContorno.h"
#include "CForma.h"

/////////////////////////////////////////////////////////////////////////////
// CBusqDatos dialog

// Defino esta estructura temporal que se utiliza en este formulario y en
// "Busqueda". Sirve para almacenar los resultados parciales de los parecidos
// de las imgenes que se van encontrando en las base de datos.
struct StParecido
{
	char nombre[100];	// nombre de la imagen
	int parecido;		// parecido mayor con la imagen que se busca
	int numpuntos;		// nmero de puntos de la imagen
};

class CBusqDatos : public CDialog
{
// Construction
public:
	CBusqDatos(CWnd* pParent = NULL);   // standard constructor

	CForma datos;			// Tiene todos los datos de la forma a buscar
	StParecido *stpar;		// Contiene los parecidos con las imgenes buscadas	
	ODatabase *m_pBd;		// Puntero a la conexin con la base de datos Oracle
	CWinThread *pThread;	// Hebra que realiza la ejecucin de la bsqueda
	COpciones *m_Opt;		// Opciones seleccionadas en el formulario "Configuracin"
	int total_filas;		// N total de imgenes que se van a analizar en la bsqueda	
	int total_analiz;		// N total de imgenes ya analizadas en la bsqueda
	bool ejecucion;			// Si ejecucion vale false debe detenerse la ejecucin de la hebra

// Dialog Data
	//{{AFX_DATA(CBusqDatos)
	enum { IDD = IDD_BUSQDATOS };
	CButton	m_ButSubir;
	CButton	m_ButBajar;
	CButton	m_ButImportar;
	CButton	m_ButGenerar;
	CStatic	m_Label;
	CProgressCtrl	m_Barra;
	CEdit	m_Distancia;
	CEdit	m_Curvatura;
	CButton	m_ButEliminar;
	CComboBox	m_CmbSigno;
	CEdit	m_NPuntos;
	CEdit	m_Orden;
	CButton	m_Marco;
	CStatic	m_Image;
	CComboBox	m_BD;
	CButton	m_ButBuscar;
	CMSFlexGrid	m_Grid;
	BOOL	m_ChkTodas;
	CMSFlexGrid	m_Grid2;
	CString	m_TxtNPuntos;
	CString	m_TxtOrden;
	CString	m_TxtSigno;
	CString	m_TxtBD;
	CString	m_TxtCurvatura;
	CString	m_TxtDistancia;
	int		m_Desc;
	CString	m_TxtMejores;
	CString	m_TxtParecido;
	int		m_Parec;
	BOOL	m_ChkImagen;
	BOOL	m_ChkMejora;
	BOOL	m_ChkRotacion;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBusqDatos)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	// Bsqueda como imagen
	void BuscarComoImagen();
	// Bsqueda como patrn
	void BuscarComoPatron();
	// Realizamos la bsqueda (como imagen). La vble 'usarbarra' nos dice si debemos mostrar la barra de progreso
	int BuscarImagen(int npuntos, int usarbarra);
	// Realizamos la bsqueda sobre la tabla temporal PuntoM (para las imgenes con < de 'npuntos' ptos)
	int BuscarImagenM(int npuntos);
	// Realizamos la bsqueda (como patrn).
	int BuscarPatron(int npuntos, int ini, int total_filas);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos >= que valor y <= que valor_fin
	void InsertarMayores(int valor, int valor_fin, int punto);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos = que valor
	void InsertarIguales(int valor);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos < que valor
	int InsertarMenores(int valor);
	// Elimina 'nptosref' puntos de la imagen 'nombre' hasta tener 'nptos' puntos, que
	// es el nmero de puntos de la imagen a buscar
	void SuprimirPuntos(CString nombre, int nptos, int nptosref);
	// Elimina el punto 'i' de la imagen 'nombre', que tiene 'nptos' puntos
	void SuprimirPuntoMej(CString nombre, int nptos, int i);
	// Guardo en la tabla temporal 'PuntoM' la imagen a buscar con un punto menos (el menor)
	void CargarMenor(int nummenor, int numref);
	// Guardo en la tabla temporal 'PuntoM' la imagen a buscar con un punto menos (el mejor)
	void CargarMenor1Mej(int npuntos, int numi);
	// Convertimos la consulta FSQL en una SQL vlida equivalente
	bool PreConsulta(CString *sSQL, CString *sSQLNueva);
	// Pone los ttulos al grid con los resultados obtenidos
	void IniciaGrid();
	// Pone los ttulos al grid de los puntos caractersticos de la supuesta imagen a buscar	
	void IniciaGrid2();
	// Almacena en la tabla temporal 'Resultado' los resultados de la bsqueda
	void GuardarResultados();
	// Mostramos los resultados obtenidos en la pantalla
	void MostrarResultados(int modo);
	// Pone a 0 el campo 'penalizacin' de la tabla 'Imagen' de todas las imgenes implicadas en la bsqueda anterior
	void ActualizarPenalizaciones(int valor);
	// Calculamos la penalizacin que supone en la bsqueda eliminar el punto de curvatura 'curvat'
	int ObtenerPenalizacion(int curvat, int numptos);
	// Borramos la tabla temporal PuntoCons de la base de datos
	void BorrarPuntoCons();
	// Borramos la tabla temporal PuntoM de la base de datos
	void BorrarPuntoM();
	// Borramos la tabla temporal Resultado de la base de datos
	void BorrarResultados();
	// Dibuja la imagen seleccionada en el grid
	void DibujarImagen();
	// Carga los valores de distancia, curvatura y signo de la fila del grid seleccionada a las cajas
	void CargarCajas();
	// Habilita o deshabilita controles en funcin de la fila seleccionada
	void ComprobarBotones();
	// Permite comprobar que no se seleccionan a la vez "Rotacin" y "1-Mejora" cuando se pulsa "1-Mejora"
	void CompruebaOpciones();
	// Permite comprobar que no se seleccionan a la vez "Rotacin" y "1-Mejora" cuando se pulsa "Rotacin"
	void CompruebaOpciones2();
	// Habilita (true) o deshabilita los botones (false) segn el valor de 'modo'
	void HabilitarControles(bool modo);
	// Cargo todos los grupos de imgenes en el combo correspondiente
	void CargarComboGruposImagenes();	
	// Llama a OnSelChangeGrid
	void SelectGrid();
	// Devuelve el mximo n de puntos que hay en una imagen de la base de datos
	int MaximoNumPuntos(int todas);
	// Devuelve el n de imgenes que van a utilizarse en la bsqueda
	int TotalImagenes(int valor, int npuntos, int todas);
	// Devuelve la posicin en la que se halla la imagen 'str' en la estructura 'parec'
	int Posicion(StParecido *parec, CString str, int total_filas);
	// Devuelve true si existe alguna imagen con 'npuntos' puntos. false en caso contrario
	bool ExistenPuntos(int npuntos);
	// Devuelve true si 's' es un nmero vlido en el intervalo [a,b]
	bool EsNumero(CString s, int a, int b);
	// Muestra un mensaje descriptivo del error sucedido en alguna fase de la bsqueda
	void MostrarError(int error);

	// Generated message map functions
	//{{AFX_MSG(CBusqDatos)
	virtual BOOL OnInitDialog();
	afx_msg void OnButBusqueda();
	virtual void OnCancel();
	afx_msg void OnSelChangeGrid();
	afx_msg void OnTodas();
	afx_msg void OnGenerar();
	afx_msg void OnSelChangeGrid2();
	afx_msg void OnChangeCurvatura();
	afx_msg void OnChangeDistancia();
	afx_msg void OnChangeSigno();
	afx_msg void OnImportar();
	afx_msg void OnEliminar();
	afx_msg void OnEditchangeCmbSigno();
	afx_msg void OnSelchangeCmbCurvatura();
	afx_msg void OnSelchangeCmbDistancia();
	afx_msg void OnSelchangeCmbSigno();
	afx_msg void OnChkReales();
	afx_msg void OnChangeEditCurvatura();
	afx_msg void OnChangeEditDistancia();
	afx_msg void OnAsc();
	afx_msg void OnDesc();
	afx_msg void OnChangeEditMejores();
	afx_msg void OnChangeEditParecido();
	afx_msg void OnNombre();
	afx_msg void OnNpuntos();
	afx_msg void OnParec();
	afx_msg void OnChkMejora();
	afx_msg void OnChkRotacion();
	afx_msg void OnButSubir();
	afx_msg void OnButBajar();
	afx_msg void OnAyuda();
	DECLARE_EVENTSINK_MAP()
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BUSQDATOS_H__09981852_DE15_4A0E_9A75_119302D331EE__INCLUDED_)
