// CCamino.cpp. Implementacin de la clase CCamino

#include "stdafx.h"
#include "resource.h"
#include "CCamino.h"
#include "windowsx.h"

CCamino::CCamino()
{
	longitud = 0;
	num_puntos = 0;
	ptos = NULL;
}

CCamino::CCamino(long num_ptos)
{
	longitud = 0;
	num_puntos = num_ptos;
	ptos = (CPoint *) malloc((size_t) (sizeof(CPoint) * num_puntos));
}

CCamino::~CCamino()
{
	longitud = 0;
	delete ptos;
}

CCamino::CCamino(const CCamino& src)
{
	int i;

	longitud = src.longitud;
	num_puntos = src.num_puntos;
	ptos = (CPoint *) malloc((size_t) (sizeof(CPoint) * num_puntos));
	
	for (i=0;i<num_puntos;i++)
		ptos[i] = src.ptos[i];
}

const CCamino& CCamino::operator =(const CCamino& camSrc)
{
	int i;
	
	longitud = camSrc.longitud;
	num_puntos = camSrc.num_puntos;
	
	for (i=0;i<longitud;i++)
		ptos[i] = camSrc.ptos[i];
	
	return *this;
}

void CCamino::AnadirPunto(CPoint vecino)
{
	int i;

	for (i=num_puntos - 1;i>0;i--)
		ptos[i] = ptos[i-1];

	ptos[0] = vecino;
	
	longitud++;
}

void CCamino::BorrarPuntoPos(int pos)
{
	int i;

	// Si la posicin que recibo es mayor que el n de ptos
	// del camino, no hago nada
	if (pos > (longitud - 1))
		return;

	// En otro caso, borro el punto desplazando hacia la izda.
	// los puntos del camino
	for (i=pos;i<longitud - 1;i++)
		ptos[i] = ptos[i+1];
	
	longitud--;	
	
}

bool CCamino::EstaEnRama(CPoint vecino)
{
	int i;

	for (i=0;i<longitud;i++)
	{
		if (ptos[i] == vecino)
			return true;
	}

	return false;
}

int CCamino::PosExtremo(CPoint extremo)
{
	// PRECOND: El punto 'extremo' debe ser extremo efectivamente.
	if (extremo == ptos[0])
		return 0;

	return (longitud - 1);
}
