// CCamino.h. Declaracin de la clase CCamino

//** Es una sucesin de puntos que representan un camino a travs del
//** contorno de la imagen. Utilizado por la clase CContorno.

#ifndef __CCamino_H__
#define __CCamino_H__

class CCamino : public CObject
{
public:
	int longitud;   // Longitud actual del camino
	int num_puntos; // N mximo de puntos que puede tener el camino
	CPoint *ptos;   // Sucesin de puntos que conforma el camino
public:
	// Constructores
	CCamino();
	CCamino(long num_ptos);

	// Destructor
	~CCamino();

	// Constructor de copia
	CCamino(const CCamino&);

	const CCamino& operator =(const CCamino& camSrc);

	// Otras funciones miembro //
	
	// Aade el punto 'vecino' al camino
	void AnadirPunto(CPoint vecino);
	// Borra el punto situado en la posicin 'pos' del camino
	void BorrarPuntoPos(int pos);
	// Devuelve true si el punto 'vecino' est en el camino.
	bool EstaEnRama(CPoint vecino);
	// Nos dice si 'extremo' es el extremo izdo. o dcho. del camino
	int PosExtremo(CPoint extremo);
};

#endif // __CCamino_H__