// CCurvatura.h. Declaracin de la clase CCurvatura
//
#ifndef __CCurvatura_H__
#define __CCurvatura_H__

#include "CIntervalo.h"

class CCurvatura : public CObject
{
public:
	int num_puntos;			// N total de puntos del contorno de la imagen 
	int num_intervalos;		// N de intervalos que se han obtenido a partir de k
	double umbral_inf;		// Umbral inferior a tener en cuenta al calcular los intervalos
	double umbral_sup;		// Umbral superior A tener en cuenta al calcular los intervalos
	double *k;				// Funcin de curvatura del contorno
	CIntervalo *intervalos; // Puntos caractersticos de cada uno de los intervalos obtenidos

public:
	// Constructores
	CCurvatura();
	CCurvatura(int num_ptos);

	// Destructor
	~CCurvatura();

	// Calcula la funcin de curvatura y los intervalos obtenidos a partir de ella
	int CalcularCurvatura(float vx[], float vy[], int NptosContor, double sigma, int maxinter, int ui, int us, int punto);
	// Calcula la funcin de curvatura
	void Lcurvatura(float vx[], float vy[], int NptosContor, double sigma);
	// Calcula las derivadas 1 y 2 de la funcion densidad (campana), de una normal de parametro sigma
	void Derivadas(double sigma,double d1g[],double d2g[]);
	void Convoluciona1(float x[],double resp[],double dev[],int N);
	void Convlv(double data[],int n,double respns[],int m,int isign,double ans[]);
	void Twofft(double data1[],double data2[],double fft1[],double fft2[],int n);
	void Four1(double data[],int nn,int isign);
	void Realft(double data[],int n,int isign);
	// Obtenemos los intervalos (zonas que superan los umbrales) para esa funcin de curvatura
	int ObtenerIntervalos(int maxinter);
	// A partir de los intervalos obtenemos los puntos caractersticos de cada intervalo y 
	// las distancias, curvaturas y signos de todos los puntos caractersticos
	void ObtenerPuntosCaracteristicos();
	// Devuelve el punto que tiene curvatura mxima del intervalo 'interv'
	int MaximoPunto(int interv);
	// Devuelve el punto que tiene curvatura mnima del intervalo 'interv'
	int MinimoPunto(int interv);
	// Devuelve la distancia entre los puntos 'p1' y 'p2'
	int Distancia(int p1, int p2);
	// Devuelve un punto de la curvatura que tenga un 'rango'
	// de puntos que no formen parte de ningn intervalo
	int ObtenerPuntoLiso(int rango);
	// Devuelve si es plano el intervalo [intini,intfin]
	bool IntervaloPlano(int intini, int intfin);
};

#endif // __CCurvatura_H__
