// CForma.h. Declaracin de la clase CForma

#ifndef __CForma_H__
#define __CForma_H__

#include "CCurvatura.h"
#include "CImagen.h"
#include "CCamino.h"
#include "COpciones.h"

class CForma : public CObject
{
public:	
	int num_puntos;		// N de puntos caractersticos de la forma
	int longitud;		// Longitud del contorno de la forma (n de ptos)
	int dimensx;		// Anchura de la imagen (en pixels)
	int dimensy;		// Altura de la imagen  (en pixels)
	float sigma;		// Sigma con el que calculamos la curvatura
	CImagen m_DIB;		// Imagen seleccionada
	CCurvatura curva;	// Curvatura de la imagen

public:
	// Constructor
	CForma();
	// Destructor
	~CForma();
public:
	// Abre la imagen y devuelve sus dimesiones y los posibles errores
	int AbrirImagen(CString nomb, CString *dimex, CString *dimey);
	// Obtiene todos los datos de la imagen (curvatura, contorno, etc.)
	int ObtenerDatos(int dimx, int dimy, float sigm, CString nombre, int margenumbral,
					 int numvecinos, int maxptos, int umbral_inf, int umbral_sup, int contraste,
					 int umbralizada, int contorno, int grafica, CString dir);
	// Representa la grfica de curvatura de la imagen con los umbrales superior e inferior
	int RepresentarGrafica(CString nombre);
	// Escribe en un fichero la imagen umbralizada
	int EscribirUmbralizada(CString nombre, unsigned char *s);
	// Escribe en un fichero el contorno
	int EscribirContorno(CString nombre, CCamino *cnt, CIntervalo *inter, int punto);
};

#endif // __CForma_H__