// CImagen. Declaracin de la clase CImagen
//
#ifndef __CImagen_H__
#define __CImagen_H__

#include <windowsx.h>  // para GlobalAllocPtr y GlobalReAllocPtr

///////////////////////////////////////////////////////////////////
class CImagen : public CObject
{
    DECLARE_SERIAL(CImagen)
public:
	char *m_lpDib;			// comienzo del fichero
    DWORD m_dwLongDib;		// longitud total del fichero
    int   m_nBitsColor;		// nmero de bits de color por pxel
	int	  m_colores_paleta; // nmero de colores de la paleta (si hay). 0 si no hay
	int histograma[256];	// histograma de la imagen							
    
    // Estructura del DIB
    LPBITMAPFILEHEADER m_lpBmFH;
    LPBITMAPINFOHEADER m_lpBmIH;
    LPBITMAPINFO       m_lpBmI;
    LPSTR              m_lpBits;
     
public:
    // Constructor
    CImagen();

    // Destructor
    ~CImagen();

    // Devuelve el nmero de bits por pxel de la imagen
	int GetBitsColor();    
	// Devuelve un puntero a la estructura BITMAPINFO
    LPBITMAPINFO GetlpBmI();    
     // Devuelve el nmero total de bytes del fichero
	DWORD GetLong();
    // Crea un DIB
	bool CrearImagenMonocromo(int height, int width);
    // Lee un mapa de bits desde un fichero y lo carga en la estructura
	bool LeerBmp(CFile *pFich);
    // Escribe un mapa de bits en un fichero desde la estructura
	bool EscribirBmp(CFile *pFich);
    // Visualiza un trozo del mapa de bits (o entero) en la pantalla con el tamao deseado
    bool VisualizarDib( CDC *, CPoint origen, int scrx, int scry, int destx, int desty);
    // Visualiza un mapa de bits estrechndolo o amplindolo a la cuadrcula indicada
	bool AjustarDib(CDC *, CPoint origen, CSize Tam);
	// Obtener el color de un pixel y la posicin de ese color en la paleta de colores
	bool GetBmpPixel(int i, int j, RGBQUAD *color, int *pos);
    // Poner un pixel a un color determinado
	bool SetBmpPixel(int i, int j, RGBQUAD color);
	// Devuelve true si la imagen es slo de grises y de 256 colores. false en otro caso
	bool EsGamaGrises256();
	// Mejoramos la imagen mediante el aumento de contraste
	bool AumentoContraste();
	// Ponemos a 0 todos los colores del histograma
	void InicializarHistograma();
	// Calculamos el histograma de la imagen
	void CalcularHistograma();
	// Calculamos el color ms pequeo (oscuro) que aparece en el histograma
	int MinimoColorHistograma();
	// Calculamos el color ms grande (claro) que aparece en el histograma
	int MaximoColorHistograma();
	// Mostramos la imagen con 2 colores unicamente, fondo (negro) y objeto (blanco)
	bool Umbralizar(int margen);
	// Devolvemos el color ms abundante de la imagen y su frecuencia (valor del histograma)
	void ColorMasFrecuenteHistograma(int *maximo, int *frecuencia);
	// Aplica un filtro que elimina ruido y aristas muy delgadas
	bool FiltroAntiRuido(int num_vecinos);
	// Devuelve el nmero de vecinos que tiene un punto del objeto (blanco) en la imagen
	int NumVecinos(int i, int j);
	// Devuelve true si el objeto obtenido es el objeto realmente. false si es el fondo	
	bool FormaValida();
	// Devuelve el nmero de puntos del objeto que tocan los extremos
	int NumPuntosExtremo();
	// Modifica la paleta del archivo de imagen por una paleta de grises predeterminada
	void CrearPaletaGrises();
private:
    // Asigna el espacio necesario para almacenar en memoria la imagen
	bool AsignarMem(bool bReasignar = false);
};

#endif // __CImagen_H__
///////////////////////////////////////////////////////////////////
