// CIntervalo.h. Declaracin de la clase CIntervalo

//** Representa los intervalos considerados tras obtener la funcin de
//** curvatura de la imagen, es decir, aquellos puntos representativos
//** que van a caracterizarla. Cada intervalo posee su punto de inicio,
//** punto de fin, punto central (mximo o mnimo), su valor de curvatura
//** (real y relativa al mximo), su valor de distancia (real y relativa
//** al mximo) y su signo (0 si es convexo y 1 si es cncavo).

#ifndef __CIntervalo_H__
#define __CIntervalo_H__

class CIntervalo : public CObject
{
public:
	int inicio;			// Inicio del intervalo
	int fin;			// Fin del intervalo
	int punto;			// Punto mximo o mnimo (segn el signo)
	int val_curv;		// Valor de curvatura en % respecto al mximo
	int signo;			// Signo del intervalo: 0 = + y 1 = -.
	int dist_sigr;		// Distancia al siguiente punto real
	int dist_sig;		// Distancia al siguiente en % respecto a la long. total
	CPoint pixel;
public:
	// Constructores
	CIntervalo();
};

#endif // __CIntervalo_H__