// Conexion.cpp : implementation file
//

#include "stdafx.h"
#include "Proyecto.h"
#include "ProyectoDoc.h"
#include "ProyectoView.h"
#include "Conexion.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConexion dialog


CConexion::CConexion(CWnd* pParent /*=NULL*/)
	: CDialog(CConexion::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConexion)
	m_TxtUsuario = _T("");
	m_TxtContrasena = _T("");
	m_TxtDatabase = _T("");
	//}}AFX_DATA_INIT

	// Realizamos un enlace a la BD
	m_pBd = ((CProyectoView *) pParent)->GetDocument()->m_db;
	// Realizamos un enlace a la configuracin actual
	m_Opt = ((CProyectoView *) pParent)->GetDocument()->opt;
}


void CConexion::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConexion)
	DDX_Text(pDX, IDC_EDIT_USUARIO, m_TxtUsuario);
	DDX_Text(pDX, IDC_EDIT_CONTRASENA, m_TxtContrasena);
	DDX_Text(pDX, IDC_EDIT_DATABASE, m_TxtDatabase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConexion, CDialog)
	//{{AFX_MSG_MAP(CConexion)
	ON_BN_CLICKED(IDC_ACEPTAR, OnAceptar)
	ON_BN_CLICKED(IDC_BUT_AYUDA, OnButAyuda)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConexion message handlers

void CConexion::OnAceptar() 
{
	UpdateData(true);
	
	// Cierro la conexin actual
	m_pBd->ExecuteSQL("BEGIN FSQL_PKG.FSQL_FIN; END;");
	m_pBd->Close();
	
	OStartup();

	// Compruebo si falla la conexin
	if (m_pBd->Open(m_TxtDatabase, m_TxtUsuario, m_TxtContrasena) == OFAILURE)
	{
		// Cierro la conexin
		m_pBd->ExecuteSQL("BEGIN FSQL_PKG.FSQL_FIN; END;");
		m_pBd->Close();
		
		MessageBox("El usuario, contrasea o base de datos introducidos no corresponden a ninguna cuenta Oracle", "Fuzzy Finder", MB_ICONERROR);
		
		// Abro la conexin antigua, es decir, dejo todo como estaba antes de pulsar "Aceptar"
		OStartup();
		m_pBd->Open("", m_Opt->usuario, m_Opt->contrasena);
		return; 
	}

	m_Opt->usuario = m_TxtUsuario;
	m_Opt->contrasena = m_TxtContrasena;
	m_Opt->database = m_TxtDatabase;
	
	CDialog::OnOK();
}

BOOL CConexion::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_TxtUsuario = m_Opt->usuario;
	m_TxtContrasena = m_Opt->contrasena;
	m_TxtDatabase = m_Opt->database;

	UpdateData(false);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConexion::OnCancel() 
{
	
	CDialog::OnCancel();
}

void CConexion::OnButAyuda() 
{
	HtmlHelp(NULL, m_Opt->workdir + "\\Ayuda\\Ayuda.chm::/conexion.htm", HH_DISPLAY_TOPIC, 0);
}
