// Importar.cpp : implementation file
//

#include "stdafx.h"
#include "Proyecto.h"
#include "ProyectoDoc.h"
#include "ProyectoView.h"
#include "BusqDatos.h"
#include "Importar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ANCHO_CUADRICULA 200
#define ALTO_CUADRICULA 152

/////////////////////////////////////////////////////////////////////////////
// CImportar dialog

// Columnas del grid que contiene las imgenes de la Base de Datos
enum En
{
	imagen = 0,
	directorio = 1,
	numpuntos = 2,
	longitud = 3
};
// Columnas del grid que contiene los puntos caractersticos de cada imagen
enum En2
{
	orden = 0,
	curvatura = 1,
	signo = 2,
	distancia = 3,
	distanciareal = 4
};

CImportar::CImportar(CWnd* pParent /*=NULL*/)
	: CDialog(CImportar::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImportar)
	m_Eleccion = -1;
	m_TxtBD = _T("");
	m_ChkReales = FALSE;
	m_ValHor = 0;
	m_ValVer = 0;
	//}}AFX_DATA_INIT

	// Realizamos un enlace a la BD
	m_pBd = ((CBusqDatos *) pParent)->m_pBd;
}


void CImportar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImportar)
	DDX_Control(pDX, IDC_SCR_VER, m_ScrVer);
	DDX_Control(pDX, IDC_SCR_HOR, m_ScrHor);
	DDX_Control(pDX, IDC_RAD_NORMAL, m_RadVista);
	DDX_Control(pDX, IDC_VISTA, m_Image);
	DDX_Control(pDX, IDC_COMBOBD, m_BD);
	DDX_Control(pDX, IDC_GRID, m_Grid);
	DDX_Control(pDX, IDC_GRID2, m_Grid2);
	DDX_Radio(pDX, IDC_RAD_NORMAL, m_Eleccion);
	DDX_CBString(pDX, IDC_COMBOBD, m_TxtBD);
	DDX_Check(pDX, IDC_CHK_REALES, m_ChkReales);
	DDX_Scroll(pDX, IDC_SCR_HOR, m_ValHor);
	DDX_Scroll(pDX, IDC_SCR_VER, m_ValVer);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CImportar, CDialog)
	//{{AFX_MSG_MAP(CImportar)
	ON_CBN_SELCHANGE(IDC_COMBOBD, OnSelchangeCombobd)
	ON_BN_CLICKED(IDC_RAD_CONTORNO, OnRadContorno)
	ON_BN_CLICKED(IDC_RAD_CONTRASTE, OnRadContraste)
	ON_BN_CLICKED(IDC_RAD_GRAFICA, OnRadGrafica)
	ON_BN_CLICKED(IDC_RAD_NORMAL, OnRadNormal)
	ON_BN_CLICKED(IDC_RAD_UMBRAL, OnRadUmbral)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_AYUDA, OnAyuda)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImportar message handlers

BEGIN_EVENTSINK_MAP(CImportar, CDialog)
    //{{AFX_EVENTSINK_MAP(CImportar)
	ON_EVENT(CImportar, IDC_GRID, 69 /* SelChange */, OnSelChangeGrid, VTS_NONE)
	ON_EVENT(CImportar, IDC_GRID2, -605 /* MouseDown */, OnMouseDownGrid2, VTS_I2 VTS_I2 VTS_I4 VTS_I4)
	ON_EVENT(CImportar, IDC_GRID2, -607 /* MouseUp */, OnMouseUpGrid2, VTS_I2 VTS_I2 VTS_I4 VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

// ************* //
// ** EVENTOS ** //
// ************* //

// ** Inicio ejecucin ventana ** //

// Se dispara al iniciar la ejecucin de la ventana
BOOL CImportar::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CenterWindow();

	m_Eleccion = 0;

	// Inicializar las scrollbars
	m_ScrHor.SetScrollRange(0,20,true);
	m_ScrHor.SetScrollPos(0,true);
	m_ScrHor.EnableScrollBar(ESB_ENABLE_BOTH);	
	m_ScrVer.SetScrollRange(0,20,true);
	m_ScrVer.SetScrollPos(0,true);
	m_ScrVer.EnableScrollBar(ESB_ENABLE_BOTH);

	pDC = GetWindowDC();
	
	UpdateData(false);
	
	// Inicializo las variables de seleccin de filas
	rw = 1;
	rwsel = 1;

	// Cargo los grupos de imgenes y selecciono el primero de ellos
	CargaBDs();
	m_BD.SetCurSel(0);
	
	// Carga el grid de las imgenes
	CargaGrid();

	// Dibujo la primera imagen y muestro su vista en la pantalla
	DibujarImagen(false);
	CargarGrid2();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ** Fin ejecucin ventana ** //

// Se dispara cuando pulsamos el botn "Cerrar"
void CImportar::OnCancel() 
{
	CDialog::OnCancel();
}

// ** Botones ** //

// Se dispara cuando pulsamos el botn "Aceptar"
void CImportar::OnOK() 
{
	CMSFlexGrid *outgrid;
	CString snpuntos;
	int i, npuntos, total, tmp, fila_ini;
	char sorden[10];
	
	UpdateData(true);

	if (m_Grid2.GetRow() == 0)
		return;

	outgrid = &((CBusqDatos *) GetParent())->m_Grid2;
	snpuntos = m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) numpuntos);
	npuntos = atoi(snpuntos);

	if (rwsel < rw)
	{
		tmp = rw;
		rw = rwsel;
		rwsel = tmp;
	}
	
	total = rwsel - rw + 1;
	
	fila_ini = outgrid->GetRow();
	InsertaDatosEnGrid(outgrid,total);

	if (fila_ini == 0)
		fila_ini = 1;
	
	for (i=0;i<total;i++)
	{
		itoa(i + fila_ini, sorden, 10);
		outgrid->SetTextMatrix(i + fila_ini,(En2) orden, sorden);
		
		outgrid->SetTextMatrix(i + fila_ini,(En2) curvatura, m_Grid2.GetTextMatrix(i + rw,(En2) curvatura));
		
		if (m_ChkReales == 0)
		{
			outgrid->SetTextMatrix(i + fila_ini,(En2) distancia, m_Grid2.GetTextMatrix(i + rw,(En2) distancia));
		}
		else
		{
			outgrid->SetTextMatrix(i + fila_ini,(En2) distancia, m_Grid2.GetTextMatrix(i + rw,(En2) distanciareal));
		}

		outgrid->SetTextMatrix(i + fila_ini,(En2) signo, m_Grid2.GetTextMatrix(i + rw,(En2) signo));
	}

	if (m_ChkReales == 0)
		((CBusqDatos *) GetParent())->m_ChkImagen = false;
	else
		((CBusqDatos *) GetParent())->m_ChkImagen = true;
	
	CDialog::OnOK();
}

// Se dispara cuando pulsamos el botn "Ayuda"
void CImportar::OnAyuda() 
{
	HtmlHelp(NULL, workdir + "\\Ayuda\\Ayuda.chm::/importar.htm", HH_DISPLAY_TOPIC, 0);
}

// ** Option buttons ** //

void CImportar::OnRadNormal() 
{
	PulsaRad();
}

void CImportar::OnRadContraste() 
{
	PulsaRad();
}

void CImportar::OnRadUmbral() 
{
	PulsaRad();
}

void CImportar::OnRadContorno() 
{
	PulsaRad();
}

void CImportar::OnRadGrafica() 
{
	PulsaRad();
}

// ** Combos ** //

void CImportar::OnSelchangeCombobd() 
{
	CargaGrid();

	DibujarImagen(false);

	CargarGrid2();	
}

// ** Grids ** //

void CImportar::OnSelChangeGrid() 
{
	CargarGrid2();			

	DibujarImagen(false);
}

void CImportar::OnMouseDownGrid2(short Button, short Shift, long x, long y) 
{
	DibujarImagen(false);

	rw = m_Grid2.GetRow();	
}

void CImportar::OnMouseUpGrid2(short Button, short Shift, long x, long y) 
{
	rwsel = m_Grid2.GetRowSel();
}

// ** Scrolling ** //

// Se dispara cuando se produce un scrolling en el formulario (con la barra horizontal)
void CImportar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	switch(nSBCode)
	{
	case  SB_LINELEFT:
		m_ScrHor.SetScrollPos(m_ScrHor.GetScrollPos() - 1);
		break;
	case  SB_LINERIGHT:
		m_ScrHor.SetScrollPos(m_ScrHor.GetScrollPos() + 1);
		break;
	case SB_THUMBPOSITION:
		m_ScrHor.SetScrollPos(nPos);
		break;
	}

	DibujarImagen(true);
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

// Se dispara cuando se produce un scrolling en el formulario (con la barra vertical)
void CImportar::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	switch(nSBCode)
	{
	case  SB_LINEDOWN:
		m_ScrVer.SetScrollPos(m_ScrVer.GetScrollPos() + 1);
		break;
	case  SB_LINEUP:
		m_ScrVer.SetScrollPos(m_ScrVer.GetScrollPos() - 1);
		break;
	case SB_THUMBPOSITION:
		m_ScrVer.SetScrollPos(nPos);
		break;
	}

	DibujarImagen(true);
	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

// ** OnPaint ** //
void CImportar::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	MostrarImagen();

	// Do not call CDialog::OnPaint() for painting messages
}

// ******************** //
// ** PROCEDIMIENTOS ** //
// ******************** //

void CImportar::IniciaGrid()
{	
	m_Grid.SetRedraw(false);
	
	m_Grid.Clear();
	m_Grid.SetRows(2);
	
	m_Grid.SetColAlignment((En) imagen, 1);
	m_Grid.SetColWidth((En) imagen, 1500);
	m_Grid.SetTextMatrix(0,(En) imagen, "Imagen");

	m_Grid.SetColWidth((En) directorio, 2600);
	m_Grid.SetTextMatrix(0,(En) directorio, "En la carpeta...");

	m_Grid.SetColWidth((En) numpuntos, 850);
	m_Grid.SetTextMatrix(0,(En) numpuntos, "N Puntos");
	
	m_Grid.SetColWidth((En) longitud, 700);
	m_Grid.SetTextMatrix(0,(En) longitud, "Longitud");

	m_Grid.SetRedraw(true);
}

void CImportar::IniciaGrid2()
{
	m_Grid2.SetRedraw(false);
	
	m_Grid2.Clear();
	m_Grid2.SetRows(1);
	
	m_Grid2.SetColWidth((En2) orden, 600);
	m_Grid2.SetTextMatrix(0,(En2) orden, "Orden");

	m_Grid2.SetColWidth((En2) curvatura, 900);
	m_Grid2.SetTextMatrix(0,(En2) curvatura, "Curvatura");

	m_Grid2.SetColWidth((En2) signo, 600);
	m_Grid2.SetTextMatrix(0,(En2) signo, "Signo");

	m_Grid2.SetColWidth((En2) distancia, 890);
	m_Grid2.SetTextMatrix(0,(En2) distancia, "Distancia");

	m_Grid2.SetColWidth((En2) distanciareal, 890);
	m_Grid2.SetTextMatrix(0,(En2) distanciareal, "Dist. Real");

	m_Grid2.SetRedraw(true);
}

void CImportar::CargaGrid()
{
	ODynaset dynaIm;
	CString sSQL;
	int i = 1, pos, npuntos, longi;
	char cad[100], strtmp[4], *pdest;
	
	IniciaGrid();
	
	UpdateData(true);

	sSQL = "SELECT * FROM Grupo,Imagen WHERE GrNombre = '" + m_TxtBD + "'";
	sSQL = sSQL + " AND Imagen.GrNombre = Grupo.Nombre ORDER BY Imagen.Nombre";

	dynaIm.Open(*m_pBd, sSQL);

	if (!dynaIm.IsEOF())
	{
		while (!dynaIm.IsEOF())
		{			
			m_Grid.SetRows(m_Grid.GetRows() + 1);

			dynaIm.GetFieldValue("NOMBRE",cad,100);

			CString str(cad);	
			pdest = strrchr(cad, '\\');
			pos = pdest - cad + 1;

			m_Grid.SetTextMatrix(i,(En) imagen,str.Right(str.GetLength() - pos));
			
			m_Grid.SetTextMatrix(i,(En) directorio, str.Left(pos - 1));

			dynaIm.GetFieldValue("NUMPUNTOS",&npuntos);
			itoa(npuntos,strtmp,10);
			m_Grid.SetTextMatrix(i,(En) numpuntos, strtmp);

			dynaIm.GetFieldValue("LONGITUD",&longi);
			itoa(longi,strtmp,10);
			m_Grid.SetTextMatrix(i,(En) longitud, strtmp);

			dynaIm.MoveNext();
			i++;
		}
	}
}

void CImportar::CargarGrid2()
{
	ODynaset dynaPto;
	CString sSQL, img;
	char strtmp[4];
	int i = 1, iorden, icurvat, isigno, idist;

	IniciaGrid2();

	img = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) directorio) + "\\";
	img = img + m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) imagen);
	img.Replace("'","''");
	sSQL = "SELECT * FROM Punto WHERE INombre = '" + img;
	sSQL = sSQL + "' ORDER BY Orden";
	dynaPto.Open(*m_pBd, sSQL);
	img.Replace("''","'");

	if (!dynaPto.IsEOF())
	{
		while (!dynaPto.IsEOF())
		{			
			m_Grid2.SetRows(m_Grid2.GetRows() + 1);

			dynaPto.GetFieldValue("Orden",&iorden);
			itoa(iorden,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) orden, strtmp);

			dynaPto.GetFieldValue("Curvatura",&icurvat);
			itoa(icurvat,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) curvatura, strtmp);
			
			dynaPto.GetFieldValue("Signo",&isigno);
			if (isigno == 0)
				m_Grid2.SetTextMatrix(i, (En2) signo, "+");
			else
				m_Grid2.SetTextMatrix(i, (En2) signo, "-");

			dynaPto.GetFieldValue("Distancia",&idist);
			itoa(idist,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) distancia, strtmp);

			dynaPto.GetFieldValue("Distancia_Real",&idist);
			itoa(idist,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) distanciareal, strtmp);

			dynaPto.MoveNext();
			i++;
		}
	}
}

void CImportar::CargaBDs()
{
	ODynaset dynaBD;
	char cad[100];
	int i = 0;
	
	// Borro el posible contenido anterior del combo
	m_BD.ResetContent();

	// Abro un recordset para cargar el combo con las bases de datos
	dynaBD.Open(*m_pBd,"SELECT Nombre FROM Grupo ORDER BY Nombre");
		
	if (!dynaBD.IsEOF())
	{
		while (!dynaBD.IsEOF())
		{			
			dynaBD.GetFieldValue("nombre", cad,100);
			CString str(cad);
			m_BD.InsertString(i, str);

			dynaBD.MoveNext();
			i++;
		}
	}
	
	dynaBD.Close();	
}

void CImportar::PulsaRad()
{
	DibujarImagen(false);
}

void CImportar::DibujarImagen(int scrolling)
{
	CFile pFich;
	CRect rect(434,32,638,190);
	CString im, dir, res, res2, resul, resul2, tmp, strorden;
	int ok;
	bool xok, yok;

	m_Image.SetBitmap(NULL);

	im = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) imagen);
	if (im.GetLength() != 0)
	{
		dir = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) directorio);
		res = dir + "\\" + im;
		res2 = dir_vistas + "\\" + im;
	}

	resul = res.Left(res.GetLength() - 4);
	resul2 = res2.Left(res2.GetLength() - 4);
	
	UpdateData(true);

	switch(m_Eleccion)
	{
	case 0:
		resul = resul + ".bmp";
		break;
	case 1:
		resul = resul2 + "v2.bmp";
		break;
	case 2:
		resul = resul2 + "v3.bmp";
		break;
	case 3:
		resul = resul2 + "v4.bmp";
		break;
	case 4:
		resul = resul2 + "v5.bmp";
		break;
	}

	ok = pFich.Open(resul,CFile::modeRead);
	
	if (ok == 0)
	{
		// Si no existe la imagen, ponemos la imagen por defecto
		resul = workdir + "\\Novista.bmp";
		pFich.Open(resul,CFile::modeRead);
		dib.CImagen::~CImagen();
		dib.CImagen::CImagen();
		dib.LeerBmp(&pFich);
	}
	else
	{
		dib.CImagen::~CImagen();
		dib.CImagen::CImagen();
		dib.LeerBmp(&pFich);
	}

	xok = false;
	yok = false;
	// Calculamos el scroll en el eje x
	if (dib.m_lpBmIH->biWidth > 200)
	{
		scrx = m_ValHor * (dib.m_lpBmIH->biWidth - 200) / 20;
		m_ScrHor.EnableScrollBar(ESB_ENABLE_BOTH);
	}
	else
	{
		scrx = 0;
		m_ScrHor.EnableScrollBar(ESB_DISABLE_BOTH);
		xok = true;
	}
	if (dib.m_lpBmIH->biHeight > 152)
	{
		scry = (20 - m_ValVer) * (dib.m_lpBmIH->biHeight - 152) / 20;
		m_ScrVer.EnableScrollBar(ESB_ENABLE_BOTH);
	}
	else
	{
		scry = 0;
		m_ScrVer.EnableScrollBar(ESB_DISABLE_BOTH);
		yok = true;
	}

	if (m_Eleccion == 3) // Vamos a pintar la grafica
	{
		tmp = m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) directorio) + "\\"; 
		tmp = tmp + m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) imagen);
		strorden = m_Grid2.GetTextMatrix(m_Grid2.GetRow(), (En2) orden);
		if (strorden.GetLength() != 0)
			SeleccionarPunto(tmp, atoi(strorden));
	}	
	
	if (xok && yok)
	{
		modo = 0;
		if (!scrolling) 
			// Si no vamos a hacer scroll ejecutamos OnPaint, para que borre
			// lo pintado anteriormente
			InvalidateRect(rect,true);
		else
			// Si vamos a hacer scroll no necesitamos ejecutar OnPaint, puesto
			// que no necesitamos borrar lo anterior (lo sobreescribimos).
			MostrarImagen();
	}
	else
	{
		modo = 1;
		if (!scrolling)
			// Si no vamos a hacer scroll ejecutamos OnPaint, para que borre
			// lo pintado anteriormente
			InvalidateRect(rect,true);
		else
			// Si vamos a hacer scroll no necesitamos ejecutar OnPaint, puesto
			// que no necesitamos borrar lo anterior (lo sobreescribimos).
			MostrarImagen();
	}
}

void CImportar::MostrarImagen()
{
	if (modo == 0)
		dib.AjustarDib(pDC,CPoint(438,62),CSize(200,152));
	else
		dib.VisualizarDib(pDC, CPoint(438,62), scrx, scry, ANCHO_CUADRICULA, ALTO_CUADRICULA);
}

void CImportar::InsertaDatosEnGrid(CMSFlexGrid *outgrid, int total)
{  
	int fila_ini, total_antes, i;
	char sorden[10];

	fila_ini = outgrid->GetRow();

	total_antes = outgrid->GetRows() - 1;
	outgrid->SetRows(total_antes + total + 1);

	if (total_antes > 0)
	{
		for (i=total_antes;i>=fila_ini;i--)
		{
			itoa(i + total, sorden, 10);
			outgrid->SetTextMatrix(i + total,(En2) orden, sorden);
			outgrid->SetTextMatrix(i + total,(En2) curvatura, outgrid->GetTextMatrix(i,(En2) curvatura));
			outgrid->SetTextMatrix(i + total,(En2) distancia, outgrid->GetTextMatrix(i,(En2) distancia));
			outgrid->SetTextMatrix(i + total,(En2) signo, outgrid->GetTextMatrix(i,(En2) signo));
		}
	}
}

void CImportar::SeleccionarPunto(CString imagen, int orden)
{
	CString sSQL;
	ODynaset dyna;
	RGBQUAD colorb, colorn;
	char sorden[10];
	int ipixelx, ipixely;

	colorb.rgbBlue = 255;
	colorb.rgbGreen = 255;
	colorb.rgbRed = 255;
	colorn.rgbBlue = 0;
	colorn.rgbGreen = 0;
	colorn.rgbRed = 0;

	itoa(orden,sorden,10);
	sSQL = "SELECT pixelx,pixely FROM Punto WHERE INombre = '" + imagen;
	sSQL = sSQL + "' AND Orden = " + CString(sorden);
	dyna.Open(*m_pBd, sSQL);

	dyna.GetFieldValue("pixelx",&ipixelx);
	dyna.GetFieldValue("pixely",&ipixely);

	
	// Dibuja un circulito alrededor del punto caracterstico correspondiente
	dib.SetBmpPixel(ipixelx + 2, ipixely, colorb);
	dib.SetBmpPixel(ipixelx + 2, ipixely + 1, colorb);
	dib.SetBmpPixel(ipixelx + 2, ipixely - 1, colorb);
	dib.SetBmpPixel(ipixelx, ipixely - 2, colorb);
	dib.SetBmpPixel(ipixelx + 1, ipixely - 2, colorb);
	dib.SetBmpPixel(ipixelx - 1, ipixely - 2, colorb);
	dib.SetBmpPixel(ipixelx - 2, ipixely, colorb);
	dib.SetBmpPixel(ipixelx - 2, ipixely + 1, colorb);
	dib.SetBmpPixel(ipixelx - 2, ipixely - 1, colorb);
	dib.SetBmpPixel(ipixelx, ipixely + 2, colorb);
	dib.SetBmpPixel(ipixelx + 1, ipixely + 2, colorb);
	dib.SetBmpPixel(ipixelx - 1, ipixely + 2, colorb);
}