//{{AFX_INCLUDES()
#include "msflexgrid.h"
//}}AFX_INCLUDES
#if !defined(AFX_IMPORTAR_H__29F0CE69_D455_4DB6_8EC9_E1E30161BC9D__INCLUDED_)
#define AFX_IMPORTAR_H__29F0CE69_D455_4DB6_8EC9_E1E30161BC9D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Importar.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CImportar dialog

class CImportar : public CDialog
{
// Construction
public:
	CImportar(CWnd* pParent = NULL);   // standard constructor
	
	ODatabase *m_pBd;	// Puntero a la conexin con la base de datos Oracle
	CString dir_vistas; // Directorio donde se hallan las vistas de las imgenes
	CString workdir;	// Directorio donde se halla el ejecutable
	CDC *pDC;		    // Puntero a un contexto de dispositivo (para dibujar).
	CImagen dib;		// Imagen analizada en cada momento.
	int scrx, scry;		// Trozo de la imagen a visualizar (scrx,scry) en la cuadrcula.
	int modo;			// Si vale 0 -> Ajustamos la imagen a la cuadricula (imagen < cuadricula).
						// Si vale 1 -> Visualizamos la imagen con sus proporciones + 2 scrollbars.
	int rw, rwsel;		// Fila seleccionada inicial y fila seleccionada final

// Dialog Data
	//{{AFX_DATA(CImportar)
	enum { IDD = IDD_IMPORTAR };
	CScrollBar	m_ScrVer;
	CScrollBar	m_ScrHor;
	CButton	m_RadVista;
	CStatic	m_Image;
	CComboBox	m_BD;
	CMSFlexGrid	m_Grid;
	CMSFlexGrid	m_Grid2;
	int		m_Eleccion;
	CString	m_TxtBD;
	BOOL	m_ChkReales;
	int		m_ValHor;
	int		m_ValVer;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImportar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Pone los ttulos al grid de las imgenes de la Base de Datos
	void IniciaGrid();
	// Pone los ttulos al grid de los puntos caractersticos de las imgenes
	void IniciaGrid2();
	// Carga el grid con las imgenes de cada grupo de imgenes
	void CargaGrid();
	// Carga el grid con los puntos caractersticos de la imagen seleccionada en el otro grid
	void CargarGrid2();
	// Carga en el combo todos los grupos de imgenes de la Base de Datos
	void CargaBDs();
	// Nos permite dibujar la vista seleccionada por el usuario (normal, contraste, ...)
	void PulsaRad();
	// Prepara la imagen para ser dibujada por "MostrarImagen"
	void DibujarImagen(int scrolling);
	// Muestra la imagen en pantalla, ajustada o con scroll
	void MostrarImagen();
	// Dibuja una marca en la vista, dependiendo del punto seleccionado en el grid
	void SeleccionarPunto(CString imagen, int orden);
	// Inserta los puntos caractersticos seleccionados en el grid
	// 'outgrid' a partir de la ltima fila seleccionada en dicho grid
	void InsertaDatosEnGrid(CMSFlexGrid *outgrid, int total);

	// Generated message map functions
	//{{AFX_MSG(CImportar)
	virtual void OnCancel();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeCombobd();
	afx_msg void OnRadContorno();
	afx_msg void OnRadContraste();
	afx_msg void OnRadGrafica();
	afx_msg void OnRadNormal();
	afx_msg void OnRadUmbral();
	virtual void OnOK();
	afx_msg void OnSelChangeGrid();
	afx_msg void OnMouseDownGrid2(short Button, short Shift, long x, long y);
	afx_msg void OnMouseUpGrid2(short Button, short Shift, long x, long y);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
	afx_msg void OnAyuda();
	DECLARE_EVENTSINK_MAP()
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMPORTAR_H__29F0CE69_D455_4DB6_8EC9_E1E30161BC9D__INCLUDED_)
