// ProyectoView.cpp : implementation of the CProyectoView class
//

#include "stdafx.h"
#include "Proyecto.h"
#include "ProyectoDoc.h"
#include "ProyectoView.h"
#include "Busqueda.h"
#include "BusqDatos.h"
#include "Modificar.h"
#include "Configuracion.h"
#include "Conexion.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProyectoView

IMPLEMENT_DYNCREATE(CProyectoView, CView)

BEGIN_MESSAGE_MAP(CProyectoView, CView)
	//{{AFX_MSG_MAP(CProyectoView)
	ON_COMMAND(ID_BUSCARIM, OnBuscarim)
	ON_COMMAND(ID_MODIFICARBD, OnModificarbd)
	ON_COMMAND(ID_OPCIONES, OnOpciones)
	ON_COMMAND(ID_BUSCARDAT, OnBuscardat)
	ON_COMMAND(ID_BUT_MODIF, OnButModif)
	ON_COMMAND(ID_BUT_BUSQ, OnButBusq)
	ON_COMMAND(ID_BUT_BUSQD, OnButBusqd)
	ON_COMMAND(ID_BUT_CONF, OnButConf)
	ON_COMMAND(ID_CONTENIDO, OnContenido)
	ON_COMMAND(ID_BUT_AYUDA, OnButAyuda)
	ON_COMMAND(ID_CONEXION, OnConexion)
	ON_COMMAND(ID_BUT_CONEXION, OnButConexion)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProyectoView construction/destruction

CProyectoView::CProyectoView()
{
	// TODO: add construction code here
	m_pMemDC = 0;
	m_pBitmap = 0;
}

CProyectoView::~CProyectoView()
{
	delete m_pMemDC;
	delete m_pBitmap;
}

BOOL CProyectoView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CProyectoView drawing

void CProyectoView::OnDraw(CDC* pDC)
{
	CProyectoDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	// Ver si hay un mapa de bits presente
	if (m_pMemDC == NULL) return; // no hay mapa de bits
	
	// Visualizar el mapa de bits
	pDC->StretchBlt(0, 0,
					m_nAnchoD,
					m_nAltoD,
					m_pMemDC,
					0, 0,
					m_nAnchoF,
					m_nAltoF,
					SRCCOPY );
}

/////////////////////////////////////////////////////////////////////////////
// CProyectoView diagnostics

#ifdef _DEBUG
void CProyectoView::AssertValid() const
{
	CView::AssertValid();
}

void CProyectoView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CProyectoDoc* CProyectoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CProyectoDoc)));
	return (CProyectoDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CProyectoView message handlers

void CProyectoView::OnBuscarim() 
{
	// TODO: Add your command handler code here
	CBusqueda BusqDlg(this);

	BusqDlg.DoModal();
}

void CProyectoView::OnModificarbd() 
{
	// TODO: Add your command handler code here
	CModificar ModifDlg(this);

	ModifDlg.DoModal();		
}

void CProyectoView::OnOpciones() 
{
	// TODO: Add your command handler code here
	CConfiguracion ConfDlg(this);
	
	ConfDlg.DoModal();
}

void CProyectoView::OnBuscardat() 
{
	// TODO: Add your command handler code here
	CBusqDatos BDatDlg(this);
	
	BDatDlg.DoModal();
}

void CProyectoView::OnContenido() 
{
	// TODO: Add your command handler code here
	HtmlHelp(NULL, GetDocument()->opt->workdir + "\\Ayuda\\Ayuda.chm::/inicio.htm", HH_DISPLAY_TOPIC, 0);
}

void CProyectoView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	// Crear un DC en memoria compatible con el DC del area de trabajo
	CClientDC dc(this);
	OnPrepareDC( &dc ); // ajustar los atributos del DC
	m_pMemDC = new CDC;

	m_pMemDC->CreateCompatibleDC( &dc );

	// Cargar el mapa de bits proporcionado por el recurso IDB_FONDO
	m_pBitmap = new CBitmap;
	m_pBitmap->LoadBitmap( IDB_FONDO );

	//Seleccionar el mapa de bits para el DC de memoria
	m_pMemDC->SelectObject(m_pBitmap);

	// Dimensiones del mapa de Bits fuente
	BITMAP bm; // estructura de datos BITMAP
	m_pBitmap->GetObject( sizeof(bm), &bm ); // dimensiones
	m_nAnchoF = bm.bmWidth; // Ancho en unidades fisicas
	m_nAltoF = bm.bmHeight; // Alto en unidades fisicas
	CRect rect(0, 0, m_nAnchoF, m_nAltoF);
	dc.DPtoLP( &rect ); // dimensiones en unidades logicas

	// Dimensiones del rectangulo para el mapa de bits destino
	m_nAnchoD = rect.Width();
	m_nAltoD = rect.Height();
	
	// Actualizar la vista
	InvalidateRect( NULL );
}

void CProyectoView::OnButModif() 
{
	// TODO: Add your command handler code here
	CModificar ModifDlg(this);

	ModifDlg.DoModal();			
}

void CProyectoView::OnButBusq() 
{
	// TODO: Add your command handler code here
	CBusqueda BusqDlg(this);

	BusqDlg.DoModal();		
}

void CProyectoView::OnButBusqd() 
{
	// TODO: Add your command handler code here
	CBusqDatos BDatDlg(this);
	
	BDatDlg.DoModal();	
}

void CProyectoView::OnButConf() 
{
	// TODO: Add your command handler code here
	CConfiguracion ConfDlg(this);
	
	ConfDlg.DoModal();	
}

void CProyectoView::OnButAyuda() 
{
	// TODO: Add your command handler code here
	HtmlHelp(NULL, GetDocument()->opt->workdir + "\\Ayuda\\Ayuda.chm::/inicio.htm", HH_DISPLAY_TOPIC, 0);
}

void CProyectoView::OnConexion() 
{
	// TODO: Add your command handler code here
	CConexion ConexDlg(this);

	ConexDlg.DoModal();
}

void CProyectoView::OnButConexion() 
{
	// TODO: Add your command handler code here	
	CConexion ConexDlg(this);

	ConexDlg.DoModal();
}
