//{{AFX_INCLUDES()
#include "msflexgrid.h"
//}}AFX_INCLUDES
#if !defined(AFX_BUSQUEDA_H__A8437EBC_920E_47D8_8522_B9D0B12C848C__INCLUDED_)
#define AFX_BUSQUEDA_H__A8437EBC_920E_47D8_8522_B9D0B12C848C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Busqueda.h : header file
//

#include "CImagen.h"
#include "CContorno.h"
#include "CForma.h"
#include "BusqDatos.h"

/////////////////////////////////////////////////////////////////////////////
// CBusqueda dialog

class CBusqueda : public CDialog
{
// Construction
public:
	CBusqueda(CWnd* pParent = NULL);   // standard constructor

	CForma datos;			// Tiene todos los datos de la forma a buscar
	StParecido *stpar;		// Contiene los parecidos con las imgenes buscadas	
	ODatabase *m_pBd;		// Puntero a la conexin con la base de datos Oracle
	CWinThread *pThread;	// Hebra que realiza la ejecucin de la bsqueda
	COpciones *m_Opt;		// Opciones seleccionadas en el formulario "Configuracin"
	int total_filas;		// N total de imgenes que se van a analizar en la bsqueda
	int total_analiz;		// N total de imgenes ya analizadas en la bsqueda
	bool ejecucion;			// Si ejecucion vale false debe detenerse la ejecucin de la hebra

// Dialog Data
	//{{AFX_DATA(CBusqueda)
	enum { IDD = IDD_BUSQUEDA };
	CProgressCtrl	m_Barra;
	CComboBox	m_BD;
	CButton	m_ButBuscar;
	CButton	m_BotCerrar;
	CStatic	m_Image2;
	CStatic	m_Image1;
	CEdit	m_Sigma;
	CButton	m_BotOpenFile;
	CString	m_TxtDimensionX;
	CString	m_TxtDimensionY;
	CString	m_TxtImage;
	CString	m_TxtSigma;
	CMSFlexGrid	m_Grid;
	BOOL	m_ChkTodas;
	CString	m_TxtBD;
	int		m_Desc;
	int		m_Parec;
	CString	m_TxtMejores;
	CString	m_TxtParecido;
	BOOL	m_ChkImagen;
	BOOL	m_ChkMejora;
	BOOL	m_ChkRotacion;
	CString	m_Label;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBusqueda)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	// Bsqueda como imagen
	void BuscarComoImagen();
	// Bsqueda como patrn
	void BuscarComoPatron();
	// Realizamos la bsqueda (como imagen). La vble 'usarbarra' nos dice si debemos mostrar la barra de progreso
	int BuscarImagen(int npuntos, int usarbarra);
	// Realizamos la bsqueda sobre la tabla temporal PuntoM (para las imgenes con < de 'npuntos' ptos)
	int BuscarImagenM(int npuntos);
	// Realizamos la bsqueda (como patrn).
	void BuscarPatron(int npuntos, int ini, int total_filas);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos >= que valor y <= que valor_fin
	void InsertarMayores(int valor, int valor_fin, int punto);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos = que valor
	void InsertarIguales(int valor);
	// Inserta las imgenes en la tabla tmp "PuntoCons" con un n de ptos < que valor
	int InsertarMenores(int valor);
	// Elimina 'nptosref' puntos de la imagen 'nombre' hasta tener 'nptos' puntos, que
	// es el nmero de puntos de la imagen a buscar
	void SuprimirPuntos(CString nombre, int nptos, int nptosref);
	// Elimina el punto 'i' de la imagen 'nombre', que tiene 'nptos' puntos
	void SuprimirPuntoMej(CString nombre, int nptos, int i);
	// Guardo en la tabla temporal 'PuntoM' la imagen a buscar con un punto menos (el menor)
	void CargarMenor(int nummenor, int numref);
	// Guardo en la tabla temporal 'PuntoM' la imagen a buscar con un punto menos (el mejor)
	void CargarMenor1Mej(int npuntos, int numi);
	// Convertimos la consulta FSQL en una SQL vlida equivalente
	bool PreConsulta(CString *sSQL, CString *sSQLNueva);
	// Pone los ttulos al grid con los resultados obtenidos
	void IniciaGrid();
	// Almacena en la tabla temporal 'Resultado' los resultados de la bsqueda
	void GuardarResultados();
	// Mostramos los resultados obtenidos en la pantalla
	void MostrarResultados(int modo);
	// Pone a 0 el campo 'penalizacin' de la tabla 'Imagen' de todas las imgenes implicadas en la bsqueda anterior
	void ActualizarPenalizaciones(int valor);
	// Calculamos la penalizacin que supone en la bsqueda eliminar el punto de curvatura 'curvat'
	int ObtenerPenalizacion(int curvat, int numptos);
	// Borramos la tabla temporal PuntoCons de la base de datos
	void BorrarPuntoCons();
	// Borramos la tabla temporal PuntoM de la base de datos
	void BorrarPuntoM();
	// Borramos la tabla temporal Resultado de la base de datos
	void BorrarResultados();
	// Dibuja la imagen seleccionada en el grid
	void DibujarImagen();
	// Borra el contenido de las cajas de texto del formulario
	void BorrarCajas();
	// Borra la vista de la imagen y el grid de resultados
	void BorrarGrid();
	// Carga el sigma del grupo de imgenes (o el por defecto) en su caja de texto correspondiente
	void CargarSigma();
	// Permite comprobar que no se seleccionan a la vez "Rotacin" y "1-Mejora" cuando se pulsa "1-Mejora"
	void CompruebaOpciones();
	// Permite comprobar que no se seleccionan a la vez "Rotacin" y "1-Mejora" cuando se pulsa "Rotacin"
	void CompruebaOpciones2();
	// Cargo todos los grupos de imgenes en el combo correspondiente
	void CargarComboGrupoImagenes();
	// Llama a OnSelChangeGrid
	void SelectGrid();
	// Devuelve el mximo n de puntos que hay en una imagen de la base de datos
	int MaximoNumPuntos(int todas);
	// Devuelve el n de imgenes que van a utilizarse en la bsqueda
	int TotalImagenes(int valor, int todas);
	// Devuelve la posicin en la que se halla la imagen 'str' en la estructura 'parec'
	int Posicion(StParecido *parec, CString str, int total_filas);
	// Devuelve true si existe alguna imagen con 'npuntos' puntos. false en caso contrario
	bool ExistenPuntos(int npuntos);
	// Muestra un mensaje descriptivo del error sucedido en alguna fase de la bsqueda
	void MostrarError(int error);

// Generated message map functions
	//{{AFX_MSG(CBusqueda)
	virtual BOOL OnInitDialog();
	afx_msg void OnButExamin();
	afx_msg void OnButBusqueda();
	virtual void OnCancel();
	afx_msg void OnSelChangeGrid();
	afx_msg void OnTodas();
	afx_msg void OnSelchangeCombobd();
	afx_msg void OnAsc();
	afx_msg void OnDesc();
	afx_msg void OnNombre();
	afx_msg void OnNpuntos();
	afx_msg void OnParec();
	afx_msg void OnChangeEditMejores();
	afx_msg void OnChangeEditParecido();
	afx_msg void OnChkMejora();
	afx_msg void OnChkRotacion();
	afx_msg void OnAyuda();
	DECLARE_EVENTSINK_MAP()
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BUSQUEDA_H__A8437EBC_920E_47D8_8522_B9D0B12C848C__INCLUDED_)
