// Modificar.cpp : implementation file
//

#include "stdafx.h"
#include "Proyecto.h"
#include "ProyectoDoc.h"
#include "ProyectoView.h"
#include "Modificar.h"
#include "AnadirBd.h"
#include <math.h>
#include <process.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ANCHO_CUADRICULA 200
#define ALTO_CUADRICULA 152

/////////////////////////////////////////////////////////////////////////////
// CModificar dialog

// Columnas del grid que contiene las imgenes de la Base de Datos
enum En
{
	imagen = 0,
	directorio = 1,
	numpuntos = 2,
	longitud = 3
};
// Columnas del grid que contiene los puntos caractersticos de cada imagen
enum En2
{
	orden = 0,
	curvatura = 1,
	signo = 2,
	distancia = 3,
	distanciareal = 4
};

CModificar::CModificar(CWnd* pParent /*=NULL*/)
	: CDialog(CModificar::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModificar)
	m_TxtBD = _T("");
	m_Eleccion = -1;
	m_TxtSigma = _T("");
	m_ValHor = 0;
	m_ValVer = 0;
	//}}AFX_DATA_INIT

	// Realizamos un enlace a la BD
	m_pBd = ((CProyectoView *) pParent)->GetDocument()->m_db;
	// Realizamos un enlace a la configuracin actual
	m_Opt = ((CProyectoView *) pParent)->GetDocument()->opt;
}


void CModificar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModificar)
	DDX_Control(pDX, IDC_SCR_VER, m_ScrVer);
	DDX_Control(pDX, IDC_SCR_HOR, m_ScrHor);
	DDX_Control(pDX, IDC_BUT_ANADIR, m_ButAnadir);
	DDX_Control(pDX, IDC_ELIMINARBD, m_ButEliminarBD);
	DDX_Control(pDX, IDC_RAD_NORMAL, m_RadVista);
	DDX_Control(pDX, IDC_COMBOBD, m_BD);
	DDX_Control(pDX, IDCANCEL, m_ButCancelar);
	DDX_Control(pDX, ID_BUT_ELIMINAR, m_ButEliminar);
	DDX_Control(pDX, IDC_GRID, m_Grid);
	DDX_Control(pDX, IDC_GRID2, m_Grid2);
	DDX_CBString(pDX, IDC_COMBOBD, m_TxtBD);
	DDX_Radio(pDX, IDC_RAD_NORMAL, m_Eleccion);
	DDX_Text(pDX, IDC_EDIT_SIGMA, m_TxtSigma);
	DDX_Scroll(pDX, IDC_SCR_HOR, m_ValHor);
	DDX_Scroll(pDX, IDC_SCR_VER, m_ValVer);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModificar, CDialog)
	//{{AFX_MSG_MAP(CModificar)
	ON_BN_CLICKED(ID_BUT_ELIMINAR, OnButEliminar)
	ON_BN_CLICKED(IDC_BUT_ANADIR, OnButAnadir)
	ON_CBN_SELCHANGE(IDC_COMBOBD, OnSelchangeCombobd)
	ON_BN_CLICKED(IDC_ANADIRBD, OnAnadirbd)
	ON_BN_CLICKED(IDC_ELIMINARBD, OnEliminarbd)
	ON_BN_CLICKED(IDC_RAD_CONTORNO, OnRadContorno)
	ON_BN_CLICKED(IDC_RAD_CONTRASTE, OnRadContraste)
	ON_BN_CLICKED(IDC_RAD_GRAFICA, OnRadGrafica)
	ON_BN_CLICKED(IDC_RAD_NORMAL, OnRadNormal)
	ON_BN_CLICKED(IDC_RAD_UMBRAL, OnRadUmbral)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_AYUDA, OnAyuda)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModificar message handlers

BEGIN_EVENTSINK_MAP(CModificar, CDialog)
    //{{AFX_EVENTSINK_MAP(CModificar)
	ON_EVENT(CModificar, IDC_GRID, 69 /* SelChange */, OnSelChangeGrid, VTS_NONE)
	ON_EVENT(CModificar, IDC_GRID2, 69 /* SelChange */, OnSelChangeGrid2, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

// ************* //
// ** EVENTOS ** //
// ************* //

// ** Inicio ejecucin ventana ** //

// Se dispara al iniciar la ejecucin de la ventana
BOOL CModificar::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CenterWindow();

	m_Eleccion = 0;

	// Inicializar las scrollbars
	m_ScrHor.SetScrollRange(0,20,true);
	m_ScrHor.SetScrollPos(0,true);
	m_ScrHor.EnableScrollBar(ESB_ENABLE_BOTH);	
	m_ScrVer.SetScrollRange(0,20,true);
	m_ScrVer.SetScrollPos(0,true);
	m_ScrVer.EnableScrollBar(ESB_ENABLE_BOTH);

	pDC = GetWindowDC();

	UpdateData(false);

	CargaBDs();
	m_BD.SetCurSel(0);

	if (m_BD.GetCount() != 0)
	{
		CargaSigma();
		CargaGrid();
	}

	ComprobarBotones();

	m_Grid.SetRowSel(1);
	OnSelChangeGrid();
	DibujarImagen(false);
	
	CargarGrid2();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ** Fin ejecucin ventana ** //

// Se dispara cuando pulsamos el botn "Cerrar"
void CModificar::OnCancel() 
{
	CDialog::OnCancel();
}

// ** Botones ** //

// Se dispara cuando pulsamos el botn "Aadir BD"
void CModificar::OnAnadirbd() 
{
	CAnadirBD dlg;
	ODynaset dynaBD;
	CString sSQL;

	dlg.workdir = m_Opt->workdir;

	// Si se cancela no hago nada
	if (dlg.DoModal() == 1)
	{
		sSQL = "INSERT INTO Grupo VALUES ('" + dlg.m_TxtNombreBD + "',"; 
		sSQL = sSQL + dlg.m_TxtSigma + ")";
		m_pBd->ExecuteSQL(sSQL);		
		
		if (m_pBd->ErrorNumber() != 0)
		{
			AfxMessageBox("Imposible aadir ese valor de 'Nombre' o 'Sigma' en la Base de Datos", MB_OK);
			return;
		}

		CargaBDs();
		
		// Selecciono la que acabo de aadir
		m_TxtBD = dlg.m_TxtNombreBD;
		UpdateData(false);

		CargaSigma();

		CargaGrid();

		ComprobarBotones();

		DibujarImagen(false);

		CargarGrid2();
	}
}

// Se dispara cuando pulsamos el botn "Eliminar BD"
void CModificar::OnEliminarbd() 
{
	ODynaset dyna;
	CString sSQL, msg, sname;
	char snombre[100];
	int res;

	msg = "Est seguro de que desea eliminar la base de datos? ADVERTENCIA: Se borrarn ";
	msg = msg + "todas las imgenes y toda la informacin relativa a dicha base de datos.";
	res = AfxMessageBox(msg,MB_YESNO|MB_ICONINFORMATION);
	if (res == IDNO)
		return;
	
	UpdateData(true);

	sSQL = "SELECT Nombre FROM Imagen WHERE GrNombre = '" + m_TxtBD + "'";
	
	dyna.Open(*m_pBd,sSQL);

	// Por cada imagen perteneciente a la BD seleccionada,
	// borro todos sus puntos
	while (!dyna.IsEOF())
	{
		dyna.GetFieldValue("Nombre",snombre, 100);
		sname = CString(snombre);
		sname.Replace("'","''");
		sSQL = "DELETE FROM Punto WHERE INombre = '" + sname + "'";
		m_pBd->ExecuteSQL(sSQL);
		sname.Replace("''","'");

		dyna.MoveNext();
	}
	
	dyna.Close();

	// Borro todas las imgenes de la base de datos seleccionada
	sSQL = "DELETE FROM Imagen WHERE GrNombre = '" + m_TxtBD + "'";
	m_pBd->ExecuteSQL(sSQL);

	// Borro la base de datos seleccionada
	sSQL = "DELETE FROM Grupo WHERE Nombre = '" + m_TxtBD + "'";
	m_pBd->ExecuteSQL(sSQL);
		
	CargaBDs();
	m_BD.SetCurSel(0);
	
	if (m_BD.GetCount() != 0)
	{
		CargaSigma();
		CargaGrid();
	}
	else
	{
		IniciaGrid();
		m_TxtSigma = "";
		UpdateData(false);
	}
	
	ComprobarBotones();

	DibujarImagen(false);

	CargarGrid2();
	
}

// Se dispara cuando pulsamos el botn "Aadir imagen"
void CModificar::OnButAnadir() 
{
	CForma datos;
	ODynaset dyna;
	HCURSOR hOldCursor;
	CString imagen, imagen2, dimx, dimy, str, sSQL, nombref;
	int error, cont, pos;

	CFileDialog Dlg(true,"bmp","*.bmp");
	if (Dlg.DoModal() != IDOK) return;

	// Recupero el nombre del archivo seleccionado
	imagen = Dlg.GetPathName();
	
	if (imagen.GetLength() == 0) return;
	
	// Comprobamos si existe la imagen antes de insertarla
	UpdateData(true);
	
	imagen.Replace("'","''");
	sSQL = "SELECT COUNT(Nombre) AS Cont FROM Imagen WHERE Nombre = '" + imagen + "'";
	imagen.Replace("''","'");

	dyna.Open(*m_pBd,sSQL);
	dyna.GetFieldValue("Cont",&cont);
	dyna.Close();

	if (cont != 0)
	{
		AfxMessageBox("Ya existe esa imagen en algn grupo de imgenes.", MB_OK);
		return;
	}
	
	hOldCursor = SetCursor(LoadCursor((HINSTANCE)NULL, IDC_WAIT)); 
	
	error = datos.AbrirImagen(imagen,&dimx,&dimy);
	if (error != 0)
	{
		MostrarError(error);
		SetCursor(hOldCursor);
		return;
	}
	
	pos = imagen.ReverseFind('\\');
	imagen2 = imagen.Right(imagen.GetLength() - pos - 1);

	error = datos.ObtenerDatos(atoi(dimx),atoi(dimy),(float) atof(m_TxtSigma),imagen2,
			m_Opt->margenumbral, m_Opt->numvecinos, m_Opt->maxptos, m_Opt->umbral_inf,
			m_Opt->umbral_sup, m_Opt->contraste, m_Opt->umbralizada, m_Opt->contorno,
			m_Opt->grafica, m_Opt->dir);
	if (error != 0)
	{
		nombref = imagen2.Left(imagen2.GetLength() - 4); // menos el ".bmp"
		EliminarFicheros(nombref);
		MostrarError(error);
		SetCursor(hOldCursor);
		return;
	}
	
	InsertarImagen(&datos, imagen);

	SetCursor(hOldCursor);
}

// Se dispara cuando pulsamos el botn "Eliminar imagen"
void CModificar::OnButEliminar() 
{
	HCURSOR hOldCursor;
	CString sSQL, nombre, nombref, imag;
	int res;
	
	res = AfxMessageBox("Est seguro de que desea eliminar esta imagen?",MB_YESNO|MB_ICONINFORMATION);
	if (res == IDNO)
		return;
	
	hOldCursor = SetCursor(LoadCursor((HINSTANCE)NULL, IDC_WAIT)); 

	nombre = m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) directorio) + "\\" +
			 m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) imagen);
	imag = m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) imagen);

	nombre.Replace("'","''");
	sSQL = "DELETE FROM Punto WHERE INombre = '" + nombre + "'";
	m_pBd->ExecuteSQL(sSQL);
	nombre.Replace("''","'");

	nombre.Replace("'","''");
	sSQL = "DELETE FROM Imagen WHERE Nombre = '" + nombre + "'";
	m_pBd->ExecuteSQL(sSQL);
	nombre.Replace("''","'");

	CargaSigma();
	CargaGrid();

	ComprobarBotones();

	DibujarImagen(false);

	CargarGrid2();
	
	nombref = m_Opt->dir + "\\" + imag.Left(imag.GetLength() - 4); // menos el ".bmp"
	EliminarFicheros(nombref);
	
	SetCursor(hOldCursor);
}

// Se dispara cuando pulsamos el botn "Ayuda"
void CModificar::OnAyuda() 
{
	HtmlHelp(NULL, m_Opt->workdir + "\\Ayuda\\Ayuda.chm::/modificar_bd.htm", HH_DISPLAY_TOPIC, 0);
}

// ** Option buttons ** //

// Se dispara cuando seleccionamos el option button Normal
void CModificar::OnRadNormal() 
{
	PulsaRad();
}

// Se dispara cuando seleccionamos el option button Contraste
void CModificar::OnRadContraste() 
{
	PulsaRad();
}

// Se dispara cuando seleccionamos el option button Umbraliz.
void CModificar::OnRadUmbral() 
{
	PulsaRad();
}

// Se dispara cuando seleccionamos el option button Contorno
void CModificar::OnRadContorno()
{
	PulsaRad();	
}

// Se dispara cuando seleccionamos el option button Grfica
void CModificar::OnRadGrafica() 
{
	PulsaRad();
}

// ** Combos ** //

// Se dispara cuando modificamos el combo de los grupos de imgenes
void CModificar::OnSelchangeCombobd() 
{
	CargaSigma();
	
	CargaGrid();

	ComprobarBotones();

	DibujarImagen(false);

	CargarGrid2();		
}

// ** Grids ** //

// Se dispara cuando se selecciona una fila en el grid
void CModificar::OnSelChangeGrid() 
{
	ComprobarBotones();

	CargarGrid2();

	DibujarImagen(false);
}

// Se dispara cuando se selecciona una fila en el grid2
void CModificar::OnSelChangeGrid2() 
{
	DibujarImagen(false);
}

// ** Scrolling ** //

// Se dispara cuando se produce un scrolling en el formulario (con la barra horizontal)
void CModificar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	switch(nSBCode)
	{
	case  SB_LINELEFT:
		m_ScrHor.SetScrollPos(m_ScrHor.GetScrollPos() - 1);
		break;
	case  SB_LINERIGHT:
		m_ScrHor.SetScrollPos(m_ScrHor.GetScrollPos() + 1);
		break;
	case SB_THUMBPOSITION:
		m_ScrHor.SetScrollPos(nPos);
		break;
	}

	DibujarImagen(true);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

// Se dispara cuando se produce un scrolling en el formulario (con la barra vertical)
void CModificar::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	switch(nSBCode)
	{
	case  SB_LINEDOWN:
		m_ScrVer.SetScrollPos(m_ScrVer.GetScrollPos() + 1);
		break;
	case  SB_LINEUP:
		m_ScrVer.SetScrollPos(m_ScrVer.GetScrollPos() - 1);
		break;
	case SB_THUMBPOSITION:
		m_ScrVer.SetScrollPos(nPos);
		break;
	}

	DibujarImagen(true);
	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

// ** OnPaint ** //
void CModificar::OnPaint() 
{
	CPaintDC dc(this); // contexto de dispositivo para dibujar
	
	MostrarImagen();

	// Do not call CDialog::OnPaint() for painting messages
}

// ******************** //
// ** PROCEDIMIENTOS ** //
// ******************** //

void CModificar::InsertarImagen(CForma *datos, CString img)
{
	CString sSQL, str;
	char snpuntos[10], slongitud[10], sidpunto[10], sdistr[10], sdist[10];
	char ssigno[10], svalcurv[10], sorden[10], spixelx[10], spixely[10];
	int i, idistr, idist, icurva, maxpunto, ipixelx, ipixely;

	// Insertamos una instancia en la clase Imagen
	itoa(datos->num_puntos,snpuntos,10);
	itoa(datos->longitud,slongitud,10);
	
	UpdateData(true);
	
	img.Replace("'","''");
	sSQL = "INSERT INTO Imagen VALUES ('" + img + "'," + CString(snpuntos);
	sSQL = sSQL + "," + CString(slongitud) + ",0,'" + m_TxtBD + "')";
	m_pBd->ExecuteSQL(sSQL);
	img.Replace("''","'");
	
	sSQL = "SELECT MAX(IdPunto) as Maxi FROM Punto";
	ODynaset dyna;
	dyna.Open(*m_pBd,sSQL);
	dyna.GetFieldValue("Maxi",&maxpunto);
	
	// Insertamos una instancia de la clase Punto por cada punto de la imagen
	for (i=0;i<datos->num_puntos;i++)
	{
		itoa(maxpunto + i + 1,sidpunto,10);
		itoa(datos->curva.intervalos[i].signo,ssigno,10);
		
		idistr = datos->curva.intervalos[i].dist_sigr;
		itoa(idistr,sdistr,10);
		idist = datos->curva.intervalos[i].dist_sig;
		itoa(idist,sdist,10);
		icurva = datos->curva.intervalos[i].val_curv;
		itoa(icurva,svalcurv,10);
		itoa(i + 1,sorden,10);
		ipixelx = datos->curva.intervalos[i].pixel.x;
		itoa(ipixelx,spixelx,10);
		ipixely = datos->curva.intervalos[i].pixel.y;
		itoa(ipixely,spixely,10);

		img.Replace("'","''");
		sSQL = "INSERT INTO Punto VALUES (" + CString(sidpunto) + "," + CString(ssigno) + ",";
		sSQL = sSQL + CString(sdistr) + "," + CString(sdist) + ",";
		sSQL = sSQL + CString(svalcurv) + "," + CString(sorden) + ",";
		sSQL = sSQL + CString(spixelx) + "," + CString(spixely) + ",'" + img + "')";
		m_pBd->ExecuteSQL(sSQL);
		img.Replace("''","'");
	}

	CargaGrid();

	ComprobarBotones();

	DibujarImagen(false);

	CargarGrid2();

	AfxMessageBox("La imagen ha sido aadida a la base de datos correctamente", MB_ICONINFORMATION);
}

void CModificar::EliminarFicheros(CString nombre)
{
	TRY
	{
		CFile::Remove(nombre + "v2.bmp");
	}
	CATCH(CFileException,e )
	{
	}
	END_CATCH

	TRY
	{
		CFile::Remove(nombre + "v3.bmp");
	}
	CATCH(CFileException,e )
	{
	}
	END_CATCH

	TRY
	{
		CFile::Remove(nombre + "v4.bmp");
	}
	CATCH(CFileException,e )
	{
	}
	END_CATCH

	TRY
	{
		CFile::Remove(nombre + "v5.bmp");
	}
	CATCH(CFileException,e )
	{
	}
	END_CATCH
}

void CModificar::IniciaGrid()
{	
	m_Grid.SetRedraw(false);
	m_Grid.Clear();
	m_Grid.SetRows(2);
	
	m_Grid.SetColAlignment((En) imagen, 1);
	m_Grid.SetColWidth((En) imagen, 1500);
	m_Grid.SetTextMatrix(0,(En) imagen, "Imagen");

	m_Grid.SetColWidth((En) directorio, 2600);
	m_Grid.SetTextMatrix(0,(En) directorio, "En la carpeta...");

	m_Grid.SetColWidth((En) numpuntos, 850);
	m_Grid.SetTextMatrix(0,(En) numpuntos, "N Puntos");
	
	m_Grid.SetColWidth((En) longitud, 700);
	m_Grid.SetTextMatrix(0,(En) longitud, "Longitud");

	m_Grid.SetRedraw(true);
}

void CModificar::IniciaGrid2()
{
	m_Grid2.SetRedraw(false);
	
	m_Grid2.Clear();
	m_Grid2.SetRows(2);
	
	m_Grid2.SetColWidth((En2) orden, 600);
	m_Grid2.SetTextMatrix(0,(En2) orden, "Orden");

	m_Grid2.SetColWidth((En2) curvatura, 900);
	m_Grid2.SetTextMatrix(0,(En2) curvatura, "Curvatura");

	m_Grid2.SetColWidth((En2) signo, 600);
	m_Grid2.SetTextMatrix(0,(En2) signo, "Signo");

	m_Grid2.SetColWidth((En2) longitud, 890);
	m_Grid2.SetTextMatrix(0,(En2) longitud, "Dist. sigte.");	

	m_Grid2.SetColWidth((En2) distanciareal, 890);
	m_Grid2.SetTextMatrix(0,(En2) distanciareal, "Dist. real");	

	m_Grid2.SetRedraw(true);
}

void CModificar::CargaGrid()
{
	ODynaset dynaIm;
	CString sSQL, str;
	int i = 1, pos, npuntos, longi;
	char cad[100] = "", strtmp[4], *pdest;
	
	IniciaGrid();
	
	UpdateData(true);
	
	sSQL = "SELECT * FROM Grupo,Imagen WHERE GrNombre = '" + m_TxtBD + "'";
	sSQL = sSQL + " AND Imagen.GrNombre = Grupo.Nombre ORDER BY Imagen.Nombre";

	dynaIm.Open(*m_pBd, sSQL);

	if (!dynaIm.IsEOF())
	{
		while (!dynaIm.IsEOF())
		{			
			m_Grid.SetRows(m_Grid.GetRows() + 1);

			dynaIm.GetFieldValue("NOMBRE",cad,100);

			CString str(cad);	
			pdest = strrchr(cad, '\\');
			pos = pdest - cad + 1;

			m_Grid.SetTextMatrix(i,(En) imagen,str.Right(str.GetLength() - pos));
			
			m_Grid.SetTextMatrix(i,(En) directorio, str.Left(pos - 1));

			dynaIm.GetFieldValue("NUMPUNTOS",&npuntos);
			itoa(npuntos,strtmp,10);
			m_Grid.SetTextMatrix(i,(En) numpuntos, strtmp);

			dynaIm.GetFieldValue("LONGITUD",&longi);
			itoa(longi,strtmp,10);
			m_Grid.SetTextMatrix(i,(En) longitud, strtmp);

			dynaIm.MoveNext();
			i++;
		}
	}
}

void CModificar::CargarGrid2()
{
	ODynaset dynaPto;
	CString sSQL, img;
	char strtmp[4];
	int i = 1, iorden, icurvat, isigno, idist;

	IniciaGrid2();

	img = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) directorio) + "\\";
	img = img + m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) imagen);

	img.Replace("'","''");
	sSQL = "SELECT * FROM Punto WHERE INombre = '" + img + "' ORDER BY Orden";
	dynaPto.Open(*m_pBd, sSQL);
	img.Replace("''","'");

	if (!dynaPto.IsEOF())
	{
		while (!dynaPto.IsEOF())
		{			
			m_Grid2.SetRows(m_Grid2.GetRows() + 1);

			dynaPto.GetFieldValue("Orden",&iorden);
			itoa(iorden,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) orden, strtmp);

			dynaPto.GetFieldValue("Curvatura",&icurvat);
			itoa(icurvat,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) curvatura, strtmp);

			dynaPto.GetFieldValue("Signo",&isigno);
			if (isigno == 0)
				m_Grid2.SetTextMatrix(i, (En2) signo, "+");
			else
				m_Grid2.SetTextMatrix(i, (En2) signo, "-");

			dynaPto.GetFieldValue("Distancia",&idist);
			itoa(idist,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) distancia, strtmp);

			dynaPto.GetFieldValue("Distancia_Real",&idist);
			itoa(idist,strtmp,10);
			m_Grid2.SetTextMatrix(i, (En2) distanciareal, strtmp);
			
			dynaPto.MoveNext();
			i++;
		}
	}
}

void CModificar::CargaBDs()
{
	ODynaset dynaBD;
	char cad[100];
	int i = 0;
	
	// Borro el posible contenido anterior del combo
	m_BD.ResetContent();

	// Abro un recordset para cargar el combo con las bases de datos
	dynaBD.Open(*m_pBd,"SELECT Nombre FROM Grupo ORDER BY Nombre");
		
	if (!dynaBD.IsEOF())
	{
		while (!dynaBD.IsEOF())
		{			
			dynaBD.GetFieldValue("nombre", cad,100);
			CString str(cad);
			m_BD.InsertString(i, str);

			dynaBD.MoveNext();
			i++;
		}
	}
	
	dynaBD.Close();	
}

void CModificar::CargaSigma()
{
	ODynaset dyna;
	CString sSQL;
	double dsigma;

	UpdateData(true);

	sSQL = "SELECT Sigma FROM Grupo WHERE Nombre = '" + m_TxtBD + "'";
	dyna.Open(*m_pBd,sSQL);

	dyna.GetFieldValue("Sigma",&dsigma);
	m_TxtSigma.Format("%.2f",dsigma);

	UpdateData(false);

	dyna.Close();
}

void CModificar::PulsaRad()
{
	DibujarImagen(false);
}

void CModificar::ComprobarBotones()
{
	CString im;

	if (m_BD.GetCount() == 0)
	{
		m_ButEliminarBD.EnableWindow(false);
		m_ButAnadir.EnableWindow(false);
	}
	else
	{
		m_ButEliminarBD.EnableWindow(true);
		m_ButAnadir.EnableWindow(true);
	}

	im = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) imagen);
	if (im.GetLength() == 0)
	{
		m_ButEliminar.EnableWindow(false);
	}
	else
	{
		m_ButEliminar.EnableWindow(true);
	}

}

void CModificar::DibujarImagen(int scrolling)
{
	CFile pFich;
	CRect rect(434,32,638,190);
	CString im, dir, res, res2, resul, resul2, tmp, strorden;
	int ok;
	bool xok, yok;

	im = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) imagen);
	if (im.GetLength() != 0)
	{
		dir = m_Grid.GetTextMatrix(m_Grid.GetRow(),(En) directorio);
		res = dir + "\\" + im;
		res2 = m_Opt->dir + "\\" + im;
	}

	resul = res.Left(res.GetLength() - 4);
	resul2 = res2.Left(res2.GetLength() - 4);
	
	UpdateData(true);

	switch(m_Eleccion)
	{
	case 0:
		resul = resul + ".bmp";
		break;
	case 1:
		resul = resul2 + "v2.bmp";
		break;
	case 2:
		resul = resul2 + "v3.bmp";
		break;
	case 3:
		resul = resul2 + "v4.bmp";
		break;
	case 4:
		resul = resul2 + "v5.bmp";
		break;
	}
	
	ok = pFich.Open(resul,CFile::modeRead);
	
	if (ok == 0)
	{
		// Si no existe la imagen, ponemos la imagen por defecto
		resul = m_Opt->workdir + "\\Novista.bmp";
		pFich.Open(resul,CFile::modeRead);
		dib.CImagen::~CImagen();
		dib.CImagen::CImagen();
		dib.LeerBmp(&pFich);
	}
	else
	{
		dib.CImagen::~CImagen();
		dib.CImagen::CImagen();
		dib.LeerBmp(&pFich);
	}

	xok = false;
	yok = false;
	// Calculamos el scroll en el eje x
	if (dib.m_lpBmIH->biWidth > 200)
	{
		scrx = m_ValHor * (dib.m_lpBmIH->biWidth - 200) / 20;
		m_ScrHor.EnableScrollBar(ESB_ENABLE_BOTH);
	}
	else
	{
		scrx = 0;
		m_ScrHor.EnableScrollBar(ESB_DISABLE_BOTH);
		xok = true;
	}
	if (dib.m_lpBmIH->biHeight > 152)
	{
		scry = (20 - m_ValVer) * (dib.m_lpBmIH->biHeight - 152) / 20;
		m_ScrVer.EnableScrollBar(ESB_ENABLE_BOTH);
	}
	else
	{
		scry = 0;
		m_ScrVer.EnableScrollBar(ESB_DISABLE_BOTH);
		yok = true;
	}
	
	if (m_Eleccion == 3) // Vamos a pintar la grafica
	{
		tmp = m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) directorio) + "\\"; 
		tmp = tmp + m_Grid.GetTextMatrix(m_Grid.GetRow(), (En) imagen);
		strorden = m_Grid2.GetTextMatrix(m_Grid2.GetRow(), (En2) orden);
		if (strorden.GetLength() != 0)
			SeleccionarPunto(tmp, atoi(strorden));
	}
	
	if (xok && yok)
	{
		modo = 0;
		if (!scrolling) 
			// Si no vamos a hacer scroll ejecutamos OnPaint, para que borre
			// lo pintado anteriormente
			InvalidateRect(rect,true);
		else
			// Si vamos a hacer scroll no necesitamos ejecutar OnPaint, puesto
			// que no necesitamos borrar lo anterior (lo sobreescribimos).
			MostrarImagen();
	}
	else
	{
		modo = 1;
		if (!scrolling)
			// Si no vamos a hacer scroll ejecutamos OnPaint, para que borre
			// lo pintado anteriormente
			InvalidateRect(rect,true);
		else
			// Si vamos a hacer scroll no necesitamos ejecutar OnPaint, puesto
			// que no necesitamos borrar lo anterior (lo sobreescribimos).
			MostrarImagen();
	}
}

void CModificar::SeleccionarPunto(CString imagen, int orden)
{
	CString sSQL;
	ODynaset dyna;
	RGBQUAD colorb, colorn;
	char sorden[10];
	int ipixelx, ipixely, ancho, alto;

	colorb.rgbBlue = 255;
	colorb.rgbGreen = 255;
	colorb.rgbRed = 255;
	colorn.rgbBlue = 0;
	colorn.rgbGreen = 0;
	colorn.rgbRed = 0;

	itoa(orden,sorden,10);
	sSQL = "SELECT pixelx,pixely FROM Punto WHERE INombre = '" + imagen;
	sSQL = sSQL + "' AND Orden = " + CString(sorden);
	dyna.Open(*m_pBd, sSQL);

	dyna.GetFieldValue("pixelx",&ipixelx);
	dyna.GetFieldValue("pixely",&ipixely);

	
	// Dibuja un circulito alrededor del punto caracterstico correspondiente
	ancho = dib.m_lpBmIH->biWidth;
	alto = dib.m_lpBmIH->biHeight;

	if (ipixelx + 2 < ancho)
		dib.SetBmpPixel(ipixelx + 2, ipixely, colorb);
	if ((ipixelx + 2 < ancho) && (ipixely + 1 < alto))
		dib.SetBmpPixel(ipixelx + 2, ipixely + 1, colorb);
	if ((ipixelx + 2 < ancho) && (ipixely - 1 >= 0))
		dib.SetBmpPixel(ipixelx + 2, ipixely - 1, colorb);
	if (ipixely - 2 >= 0)
		dib.SetBmpPixel(ipixelx, ipixely - 2, colorb);
	if ((ipixelx + 1 < ancho) && (ipixely - 2 >= 0))
		dib.SetBmpPixel(ipixelx + 1, ipixely - 2, colorb);
	if ((ipixelx - 1 >= 0) && (ipixely - 2 >= 0))
		dib.SetBmpPixel(ipixelx - 1, ipixely - 2, colorb);
	if (ipixelx - 2 >= 0)
		dib.SetBmpPixel(ipixelx - 2, ipixely, colorb);
	if ((ipixelx - 2 >= 0) && (ipixely + 1 < ancho))
		dib.SetBmpPixel(ipixelx - 2, ipixely + 1, colorb);
	if ((ipixelx - 2 >= 0) && (ipixely - 1 >= 0))
		dib.SetBmpPixel(ipixelx - 2, ipixely - 1, colorb);
	if (ipixely + 2 < ancho)
		dib.SetBmpPixel(ipixelx, ipixely + 2, colorb);
	if ((ipixelx + 1 < ancho) && (ipixely + 2 < ancho))
		dib.SetBmpPixel(ipixelx + 1, ipixely + 2, colorb);
	if ((ipixelx - 1 >= 0) && (ipixely + 2 < ancho))
		dib.SetBmpPixel(ipixelx - 1, ipixely + 2, colorb);
}

void CModificar::MostrarImagen()
{
	if (modo == 0)
		dib.AjustarDib(pDC,CPoint(438,62),CSize(200,152));
	else
		dib.VisualizarDib(pDC, CPoint(438,62), scrx, scry, ANCHO_CUADRICULA, ALTO_CUADRICULA);
}

void CModificar::MostrarError(int error)
{
	switch(error)
	{
	case 1:
		MessageBox("Error I/O: no se puede abrir el archivo. Utilice solo ficheros bmp.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 2:
		MessageBox("Error I/O: no se puede leer el archivo. Fichero bmp corrupto.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 3:
		MessageBox("Error I/O: no se puede escribir en el directorio de vistas seleccionado (ver Configuracin).", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 4:
		MessageBox("Imagen no vlida: No es de 256 colores o no es una gama de grises.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 5:
		MessageBox("Imagen no vlida: no posee un fondo homogneo.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 6:
		MessageBox("Contorno no vlido: contorno vaco.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 7:
		MessageBox("Contorno no vlido: nmero de puntos caractersticos demasiado grande.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 8:
		MessageBox("Contorno no vlido: no hay puntos caractersticos.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 9:
		MessageBox("Contorno no vlido: slo posee un punto caracterstico.", "Fuzzy Finder", MB_ICONERROR);
		break;
	case 10:
		MessageBox("Error general: insuficiente memoria.", "Fuzzy Finder", MB_ICONERROR);
		break;
	}
}

