#include <stdio.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <signal.h>
#include <time.h>
#include <ctype.h>

/*
    PROTOTIPO DE LAS FUNCIONES UTILIZADAS
*/
void inicializar_modo_grafico();
int color(char*);
void centroDePantalla(int*,int*);
void activar_alarma();
void funcionamiento_normal();
void presentacion_inicial(int,int);
void dibujar_barras_fijas();
void presentacion_cabina();
void actualizar_estado_barras(float,float,float);
void dibujar_dados(int,int);
int lanzarDados(char*,int,int);
void quien_gana_partida(int,int,int*,int*);
void quien_gana_juego(int,int,int,int*,int*,int*);
char jugar_partida_dados();
void cita_con_el_destino();
void comprobar_estado_sistema(float,float,float,float,float,float,float,float,float);
void modificar_variable(char,float*,int);
void controlar_cabina(float,float,float);
void calcular_parametros_turbulencia(int*,int*,int*);


/* Declaramos como constante el tiempo que permaneceran identicos
   los parametros de una turbulencia (direccion de crecimiento/decrecimiento
   y el valor de la misma)
*/
#define TIEMPO_MISMA_TURBULENCIA 5



/*
   Variables Globales:
   -)  mitadX y mitadY: Las variables que controlan las coordenadas de nuestro
			centro de pantalla, puesto que los grficos que realicemos
			toman valores relativos con respecto a estos, para siempre
			estar "centrados" al espectador.
*/
int mitadX,mitadY;

/*
  Variables Globales:
  -) estrellado: La variable que controla el bucle principal.Mientras
		 est a FALSE, seguimos con la ejecucin del programa.
  -) sistema_en_peligro: Cuando alguna de las dos variables a controlar
		 ,Presion o Altitud, presentan valores "peligrosos" se
		 activa esta variable, para indicar que el avion esta
		 en peligro de entrar en barrena.
  -) modo_turbulencias: Nos indica si el estado actual del sistema es el de
			turbulencias (las barras de presion,altitud y temperatura
			se modifican solas y el usuario debera controlar tales
			parametros).
  -) t1 y t2: Son dos variables que controlan el tiempo que el avion
	      permanece en "barrena", si el tiempo supera la cantidad
	      prefijada, debemos enfrentarnos a la "muerte" mediante
	      un juego de azar: los dados.
  -) tiempo_barrena: Es la variable encargada de controlar cuando tiempo
		     como maximo puede estar nuestro sistema en alerta.
  -) num_partidas_por_juego: Es la variable encargada de almacenar
			     cuantas partidas constituyen un juego de dados.
*/
int estrellado=0;         // Valor False.
int sistema_en_peligro=0; //Valor False.
int modo_turbulencias=0;
time_t t1,t2,t_t1,t_t2;
int tiempo_barrena,num_partidas_por_juego;

/*
   Procedimiento: inicializar_modo_grafico()
   Entradas: Ninguna
   Retorna : Nada
   Acciones:
	     Inicializa el modo grfico de nuestro equipo,
			 utilizando los drivers BGI correspondientes.
			 Si se produce cualquier anomala termina la ejecucin
			 informando del error producido.
*/
void inicializar_modo_grafico(){
     int driver_grafico_monitor,modo_grafico_monitor,codigo_error;

     driver_grafico_monitor=DETECT;
     initgraph(&driver_grafico_monitor,&modo_grafico_monitor,"");
     codigo_error=graphresult();
     if(codigo_error!=grOk){
	printf("Error de Inicializacion Del Modo Grafico: %s\n",grapherrormsg(codigo_error));
	getch();
	exit(-1);
     }
}

/*
     Funcin: color(char* cadena)
     Entradas: cadena => Tipo: String (char*) por Valor
	 Retorna: valor entero (int)
	 Acciones:
		   A partir de la cadena pasada como parametro
		   indicando el color, devuelve el valor entero
		   que lo representa.
		   Su uso es mas bien por comodidad, y facilitar
		   la lectura del codigo.
*/
int color(char* cadena){
    int color_a_devolver;

    if(!strcmp(cadena,"negro")){color_a_devolver=0;}
    else if(!strcmp(cadena,"azul")){color_a_devolver=1;}
    else if(!strcmp(cadena,"verde")){color_a_devolver=2;}
    else if(!strcmp(cadena,"cyan")){color_a_devolver=3;}
    else if(!strcmp(cadena,"rojo")){color_a_devolver=4;}
    else if(!strcmp(cadena,"magenta")){color_a_devolver=5;}
    else if(!strcmp(cadena,"marron")){color_a_devolver=6;}
    else if(!strcmp(cadena,"grisclaro")){color_a_devolver=7;}
    else if(!strcmp(cadena,"grisoscuro")){color_a_devolver=8;}
    else if(!strcmp(cadena,"azulclaro")){color_a_devolver=9;}
    else if(!strcmp(cadena,"verdeclaro")){color_a_devolver=10;}
    else if(!strcmp(cadena,"cyanclaro")){color_a_devolver=11;}
    else if(!strcmp(cadena,"rojoclaro")){color_a_devolver=12;}
    else if(!strcmp(cadena,"magentaclaro")){color_a_devolver=13;}
    else if(!strcmp(cadena,"amarillo")){color_a_devolver=14;}
    else if(!strcmp(cadena,"blanco")){color_a_devolver=15;}
    else {
	  printf("Error:Color NO VALIDO\n");
	  exit(-1);
    }
    return color_a_devolver;
}

/*
    Procedimiento: centroDePantalla(int* x,int* y)
	Entradas: x => Tipo: Entero por Referencia (int*)
	      y => Tipo: Entero por Referencia (int*)
    Retorna:  Nada
	Acciones:
		  Este simple procedimiento recibe dos variables
		  de tipo entero por referencia (puesto que las
		  vamos a modificar) y las devuelve divididas por
		  2.Su uso fundamental es para inicializar las
		  variables globales mencionadas arriba: mitadX y
		  mitadY, apartir del maximo valor de abcisas(getmaxx())
		  y del maximo valor de ordenadas(getmaxy()).
*/
void centroDePantalla(int* x,int* y){
     (*x)=getmaxx()/2;
     (*y)=getmaxy()/2;
}

/*
    Procedimiento: activar_alarma()
	Entradas: Ninguna
	Retorna:  Nada
	Acciones:
		  Procedimiento destinado a notificar al usuario que nos
		  encontramos en un estado de posible cada en barrena.
		  Basicamente se genera un sonido, y mostramos por pantalla
		  los mensajes de notificacin de peligro mediante simples
		  llamadas a funciones de la librera "Graphics.h".
*/
void activar_alarma(){
     sound(1000);
     delay(50);
     sound(300);
     delay(50);
     sound(2000);
     delay(50);
     nosound();
     setcolor(color("amarillo"));
     setfillstyle(SOLID_FILL,RED);
     rectangle(0,372,639,getmaxy());
     floodfill(3,400,YELLOW);
     setcolor(color("azulclaro"));
     settextstyle(8,VERT_DIR,3);
     outtextxy(45,375,"!!ALERTA!!");
     outtextxy(595,375,"!!ALERTA!!");
     settextstyle(8,HORIZ_DIR,3);
     outtextxy(245,400,"!!ALERTA!!");
}

/*
    Procedimiento: funcionamiento_normal()
	Entradas: Ninguna
	Retorna:  Nada
	Acciones:
		  Procedimiento destinado a notificar al usuario que los
		  valores controlados (Presin y Altitud) se encuentran
		  dentro de lo establecido como "normal".Al igual que el
		  procedimiento anterior, los mensajes en pantalla son
		  llamadas a funciones primitivas de la librera Graphics.h
*/

void funcionamiento_normal(){
     setcolor(color("amarillo"));
     setfillstyle(SOLID_FILL,BLACK);
     rectangle(0,372,639,getmaxy());
     floodfill(3,400,YELLOW);
     setcolor(color("verdeclaro"));
     settextstyle(6,HORIZ_DIR,3);
     outtextxy(245,400,"PARAMETROS OK");
     settextstyle(6,VERT_DIR,2);
     outtextxy(40,410,"OK");
     outtextxy(595,410,"OK");
}

/*
    Procedimiento: presentacion_inicial(int x,int y)
	Entradas: x => Tipo: Entero por Valor (int)
		  y => Tipo: Entero por Valor (int)
	Retorna:  Nada
	Acciones:
		  Mediante el uso de primitivas de la librera
		  Graphics.h visualizamos por pantalla los datos
		  del autor y algunos aspectos de inters sobre
		  la aplicacion.Podemos fijarnos que tal y como
		  dijimos, a la hora de visualizar grficos por
		  pantalla, utilizamos posiciones al centro del
		  monitor del equipo (es por ello por lo que
		  recibe tales parmetros de entrada). Cuando
		  invoquemos a tal procedimiento, recibir como es
		  de esperar a mitadX (int x) y mitadY (intY).
*/

void presentacion_inicial(int x,int y){
     setcolor(color("verdeclaro"));
     rectangle(0,0,x*2,y*2);
     setbkcolor(color("azul"));
     setcolor(color("blanco"));
     rectangle(x-150,y-150,x+150,y-40);
     setcolor(color("verde"));
     outtextxy(210,110,"SIMULACION CABINA DE VUELO");
     outtextxy(210,130,"  MEDIANTE  USO    DE     ");
     outtextxy(210,150,"        LIBRERIA          ");
     setcolor(color("rojo"));
     outtextxy(210,170,"       GRAPHICS.H         ");

     circle(x-110,y-70,5);
     circle(x-110,y-70,10);
     circle(x-110,y-70,15);
     setcolor(color("amarillo"));
     circle(x-110,y-70,20);
     line(x-135,y-70,x-85,y-70);
     line(x-110,y-95,x-110,y-45);

     setcolor(color("rojo"));
     circle(x+100,y-70,5);
     circle(x+100,y-70,10);
     circle(x+100,y-70,15);
     setcolor(color("amarillo"));
     circle(x+100,y-70,20);
     line(x+75,y-70,x+125,y-70);
     line(x+100,y-95,x+100,y-45);

     setcolor(color("verdeclaro"));
     rectangle(x-200,y+40,x+200,y+110);
     setcolor(color("blanco"));
     outtextxy(130,290,"PROGRAMA REALIZADO POR:");
     outtextxy(180,310,"-) ANTONIO JOSE     ABAD SANCHEZ");

     setcolor(color("rojo"));
     outtextxy(2,465,"Pulse Cualquier Teclar para Continuar...");

     setcolor(color("blanco"));
     outtextxy(10,400,"A --> + Presion");
     outtextxy(10,410,"Z --> - Presion");
     outtextxy(250,400,"S --> + Altitud");
     outtextxy(250,410,"X --> - Altitud");
     outtextxy(480,400,"D --> + Temperatura");
     outtextxy(480,410,"C --> - Temperatura");
     outtextxy(200,430,"T --> Activar Turbulencias");
     outtextxy(270,450,"P --> Salir");
     getch();

}

void dibujar_barras_fijas(){
     setfillstyle(SOLID_FILL,color("azul"));
     bar(80,50,130,300);
     setcolor(color("blanco"));
     rectangle(79,49,131,301);
     setfillstyle(SOLID_FILL,color("marron"));
     bar(60,302,150,331);
     setcolor(color("blanco"));
     rectangle(59,301,151,332);
     setcolor(color("amarillo"));
     outtextxy(77,312,"PRESION");
     setcolor(color("blanco"));
     outtextxy(10,49,"1 ATM ->");
     outtextxy(10,99,"2 ATM ->");
     setcolor(color("verdeclaro"));
     line(80,102,130,102);
     setcolor(color("blanco"));
     outtextxy(10,149,"3 ATM ->");
     outtextxy(10,199,"4 ATM ->");
     outtextxy(10,249,"5 ATM ->");
     setcolor(color("verdeclaro"));
     line(80,252,130,252);
     setcolor(color("blanco"));
     outtextxy(10,294,"6 ATM ->");

     setfillstyle(SOLID_FILL,color("azul"));
     bar(295,50,345,300);
     setcolor(color("blanco"));
     rectangle(294,49,346,301);
     setfillstyle(SOLID_FILL,color("marron"));
     bar(275,302,365,331);
     setcolor(color("blanco"));
     rectangle(275,301,366,332);
     setcolor(color("amarillo"));
     outtextxy(295,312,"ALTITUD");
     setcolor(color("blanco"));
     outtextxy(220,49,"1000 P ->");
     outtextxy(220,99,"5000 P ->");
     setcolor(color("verdeclaro"));
     line(295,102,345,102);
     setcolor(color("blanco"));
     outtextxy(217,149,"10000 P ->");
     outtextxy(217,199,"15000 P ->");
     outtextxy(217,249,"20000 P ->");
     setcolor(color("verdeclaro"));
     line(295,252,345,252);
     setcolor(color("blanco"));
     outtextxy(217,294,"25000 P ->");

     setfillstyle(SOLID_FILL,color("azul"));
     bar(510,50,560,300);
     setcolor(color("blanco"));
     rectangle(509,49,561,301);
     setfillstyle(SOLID_FILL,color("marron"));
     bar(490,302,580,331);
     setcolor(color("blanco"));
     rectangle(490,301,581,332);
     setcolor(color("amarillo"));
     outtextxy(495,312,"TEMPERATURA");
     setcolor(color("blanco"));
     outtextxy(437,49,"-20 C ->");
     outtextxy(445,99,"0 C ->");
     setcolor(color("verdeclaro"));
     line(510,102,560,102);
     setcolor(color("blanco"));
     outtextxy(445,149,"10 C ->");
     outtextxy(445,199,"30 C ->");
     outtextxy(445,249,"50 C ->");
     setcolor(color("verdeclaro"));
     line(510,252,560,252);
     setcolor(color("blanco"));
     outtextxy(445,294,"70 C ->");







}

void presentacion_cabina(){
     setcolor(color("amarillo"));
     rectangle(0,0,212,20);
     rectangle(213,0,424,20);
     rectangle(425,0,639,20);
     rectangle(0,372,639,getmaxy());
     outtextxy(39,7,"PRESION EN CABINA");
     outtextxy(250,7,"ALTITUD EN CABINA");
     outtextxy(450,7,"TEMPERATURA EN CABINA");
     line(0,0,0,350);
     line(213,21,213,350);
     line(425,21,425,350);
     line(639,21,639,350);
     rectangle(0,351,639,371);

     setcolor(color("verdeclaro"));
     outtextxy(170,358,"ESTADO    GLOBAL      DEL     SISTEMA");
     dibujar_barras_fijas();
}

void actualizar_estado_barras(float valor_presion,float valor_altitud,float valor_temperatura){
     setfillstyle(SOLID_FILL,color("rojo"));
     bar(80,valor_presion-2,130,300);
     setfillstyle(SOLID_FILL,color("azul"));
     bar(80,50,130,valor_presion-2);
     setcolor(color("verdeclaro"));
     line(80,102,130,102);
     line(80,252,130,252);


     setfillstyle(SOLID_FILL,color("rojo"));
     bar(295,valor_altitud-2,345,300);
     setfillstyle(SOLID_FILL,color("azul"));
     bar(295,50,345,valor_altitud-2);
     setcolor(color("verdeclaro"));
     line(295,102,345,102);
     line(295,252,345,252);

     setfillstyle(SOLID_FILL,color("rojo"));
     bar(510,valor_temperatura-2,560,300);
     setfillstyle(SOLID_FILL,color("azul"));
     bar(510,50,560,valor_temperatura-2);
     setcolor(color("verdeclaro"));
     line(510,102,560,102);
     line(510,252,560,252);


}

void dibujar_dados(int dado1,int dado2){

    setcolor(color("blanco"));
    setfillstyle(SOLID_FILL,WHITE);
    bar3d(220,220,290,290,20,30);
    bar3d(330,220,400,290,20,30);
    /*****************************/
    /*      Primer Dado # 1      */
    /*****************************/

    if(dado1==1 && dado2==1){    //1 y 1
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado 1
       fillellipse(366,255,7,7);
       //Dado 2
       fillellipse(256,255,7,7);
    }

    if(dado1==1 && dado2==2){    //1 y 2
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(256,255,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==1 && dado2==3){     //1 y 3
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(256,255,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==1 && dado2==4){      //1 y 4
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(256,255,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==1 && dado2==5){      //1 y 5
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(256,255,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==1 && dado2==6){      //1 y 6
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(256,255,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/  //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}

    /*****************************/
    /*      Primer Dado # 2      */
    /*****************************/

    if(dado1==2 && dado2==1){      //2 y 1
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(366,255,7,7);
	}

    if(dado1==2 && dado2==2){      //2 y 2
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
    }

    if(dado1==2 && dado2==3){      //2 y 3
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

	if(dado1==2 && dado2==4){      //2 y 4
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);

	   //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==2 && dado2==5){       //2 y 5
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==2 && dado2==6){        //2 y 6
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(277,273,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/   //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}

	/*****************************/
    /*      Primer Dado # 2      */
    /*****************************/

    if(dado1==3 && dado2==1){        //3 y 1
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(366,255,7,7);
	}

    if(dado1==3 && dado2==2){        //3 y 2
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
    }

    if(dado1==3 && dado2==3){        //3 y 3
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==3 && dado2==4){        //3 y 4
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==3 && dado2==5){        //3 y 5
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==3 && dado2==6){         //3 y 6
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/  //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}

    /*****************************/
    /*      Primer Dado # 4      */
    /*****************************/

    if(dado1==4 && dado2==1){         //4 y 1
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       //fillellipse(258,255,7,7); //Sirve para 5 //DEBUG
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(366,255,7,7);
	}

    if(dado1==4 && dado2==2){         //4 y 2
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==4 && dado2==3){         //4 y 3
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
	   //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==4 && dado2==4){         //4 y 4
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==4 && dado2==5){        //4 y 5
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
	   //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==4 && dado2==6){        //4 y 6
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/  //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}

    /*****************************/
    /*      Primer Dado # 5      */
    /*****************************/

    if(dado1==5 && dado2==1){        //5 y 1
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(366,255,7,7);
	}

    if(dado1==5 && dado2==2){        //5 y 2
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==5 && dado2==3){        //5 y 3
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==5 && dado2==4){        //5 y 4
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==5 && dado2==5){        //5 y 5
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==5 && dado2==6){        //5 y 6
       setcolor(color("negro"));
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,275,7,7);
       fillellipse(258,255,7,7);
       fillellipse(278,275,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/  //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}

    /*****************************/
    /*      Primer Dado # 6      */
    /*****************************/

    if(dado1==6 && dado2==1){    //6 y 1
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(366,255,7,7);
	}

    if(dado1==6 && dado2==2){    //6 y 2
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==6 && dado2==3){    //6 y 3
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(366,255,7,7);
       fillellipse(386,276,7,7);
	}

    if(dado1==6 && dado2==4){    //6 y 4
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==6 && dado2==5){    //6 y 5
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,276,7,7);
       fillellipse(366,255,7,7); //Central
       fillellipse(386,276,7,7);
       fillellipse(386,234,7,7);
	}

    if(dado1==6 && dado2==6){     //6 y 6
       setcolor(BLACK);
       setfillstyle(SOLID_FILL,BLACK);
       //Dado1
       fillellipse(235,235,7,7);
       fillellipse(235,255,7,7);
       fillellipse(235,275,7,7);
       /*****************************/  //Centrado
       fillellipse(278,275,7,7);
       fillellipse(278,255,7,7);
       fillellipse(278,235,7,7);
       //Dado2
       fillellipse(344,234,7,7);
       fillellipse(344,255,7,7);
       fillellipse(344,276,7,7);
       /**********************/  //Centrado
       fillellipse(386,276,7,7);
       fillellipse(386,255,7,7);
       fillellipse(386,234,7,7);
	}
}
/*
   Procedimiento: lanzarDados
   Entradas:
	     tirador: cadena de caracteres
	     puntuacionJugador: entero por valor
	     puntuacionComputadora: entero por valor
   Retorna:  Nada
   Acciones:
	     Basicamente se encarga de la logica del lanzamiento
	     (utilizando de nuevo el modo aleatorio para obtener
	     las puntuaciones de cada dado) y la representacion
	     del mismo por pantalla.

*/

int lanzarDados(char * tirador,int puntuacionJugador,int puntuacionComputadora){

	 char* quienLanza;
	 int   dado1,dado2,sumaTirada;

	 cleardevice();
	 if(!strcmp(tirador,"C")){
	    quienLanza="Computadora:";
	 }else if(!strcmp(tirador,"J")){
	    quienLanza="Jugador:";
	 }else{
	    printf("Error: Jugador Desconocido\n");
	    exit(-1);
	 }

	 //Ttulo
	 setcolor(color("blanco"));
	 settextstyle(SMALL_FONT,HORIZ_DIR,7);
	 outtextxy(20,24,quienLanza);
	 gotoxy(22,3);
	 printf("Ranking [Computadora=%d]|[Jugador=%d] Partidas por Juego:%d\n",puntuacionComputadora,puntuacionJugador,num_partidas_por_juego);
	 line(0,60,700,60);

	 //Funcion Aleatoria para simular el lanzamiento de los dados.
	 srand(time(NULL)); //Se inicializa la semilla aleatoria.
	 dado1=(rand()%(6))+1;
	 dado2=(rand()%(6))+1;

	 //Mostramos la putuacion de la tirada por pantalla
	 sumaTirada=dado1+dado2;
	 switch(sumaTirada){

	    case 2:
		       outtextxy(228,350,"Tienes: 2 Puntos");
		       break;
	    case 3:
		       outtextxy(228,350,"Tienes: 3 Puntos");
		       break;
	    case 4:
		       outtextxy(228,350,"Tienes: 4 Puntos");
		       break;
	    case 5:
		       outtextxy(228,350,"Tienes: 5 Puntos");
		       break;
	    case 6:
		       outtextxy(228,350,"Tienes: 6 Puntos");
		       break;
	    case 7:
		       outtextxy(228,350,"Tienes: 7 Puntos");
		       break;
	    case 8:
		       outtextxy(228,350,"Tienes: 8 Puntos");
		       break;
	    case 9:
		       outtextxy(228,350,"Tienes: 9 Puntos");
		       break;
	    case 10:
			outtextxy(228,350,"Tienes: 10 Puntos");
			break;
	    case 11:
			outtextxy(228,350,"Tienes: 11 Puntos");
			break;
	    case 12:
			outtextxy(228,350, "Tienes: 12 Puntos");
			break;
	 }

	 dibujar_dados(dado1,dado2);



	 //Finalmente retornamos el valor de la tirada de dados
	 return sumaTirada;

}

void quien_gana_partida(int tj,int tc,int* pgj,int* pgc){

	if(tj>tc){
	   (*pgj)=(*pgj)+1;
	}else if(tc>tj){
	   (*pgc)=(*pgc)+1;
	}
}

void quien_gana_juego(int tp,int pgj,int pgc,int* gj,int* gc,int* ms){
     int mitad;

     mitad=tp/2;
     printf("Mitad:%d\n",mitad);
     if(pgj>mitad){
	printf("Entra por pgj>mitad --> Gana el Jugador\n");
	(*gj)=1;
     }else if(pgc>mitad){
	printf("Entra por pgc>mitad --> Gana la Computadora\n");
	(*gc)=1;
     }else if((pgj==pgc) && (pgj==mitad)){
	printf("Entra por pgj==pgc==mitad --> Muerte Sbita\n");
	(*ms)=1;
     }else{
	printf("Nadie ha ganado aun el juego\n");
     }
}


char jugar_partida_dados(){

     int total_partidas;   //Variable que almacena el total de partidas que constituye un enfrentamiento.
     int pgj;              //Variable que almacena el nmero actual de partidas ganadas por el jugador.
     int pgc;              //Variable que almacena el nmero actual de partidas ganadas por la computadora.
     int hay_ganador;      //Variable que controla el bucle principal del procedimiento; nos indicar si
			   //alguien ya gana el juego.
     int muerte_subita;    //Variable para controlar cuando es necesario un enfrentamiento a muerte sbita.
     int gano_jugador;     //Variable que indica que el jugador fue quien gan el enfrentamiento.
     int gano_computadora; //Variable que indica que la computadora fue quien gan el enfrentamiento.

     int   tirada_jugador,tirada_computadora;
     char* mensaje_quien_gano_juego;

     /*
	     Inicializamos las variables.
     */
     total_partidas=num_partidas_por_juego;
     pgj=0;
     pgc=0;
     hay_ganador=0;
     muerte_subita=0;
     gano_jugador=0;
     gano_computadora=0;

     /*
	     Bucle Principal del procedimiento.
     */
     do{
	if(!muerte_subita){
	   tirada_jugador=lanzarDados("J",pgj,pgc);    getch();
	   tirada_computadora=lanzarDados("C",pgj,pgc);getch();
	   quien_gana_partida(tirada_jugador,tirada_computadora,&pgj,&pgc);
	   quien_gana_juego(total_partidas,pgj,pgc,&gano_jugador,&gano_computadora,&muerte_subita);
	}
	if(muerte_subita){
	   do{
	      tirada_jugador=lanzarDados("J",pgj,pgc);    getch();
	      tirada_computadora=lanzarDados("C",pgj,pgc);getch();
	      if(tirada_jugador>tirada_computadora){
		 muerte_subita=0;
		 gano_jugador=1;
	      }else if(tirada_computadora>tirada_jugador){
		 muerte_subita=0;
		 gano_computadora=1;
	      }
	   }while(muerte_subita);
	}
	hay_ganador=gano_jugador+gano_computadora;
     }while(!hay_ganador);

     if(gano_jugador){
	return 'J';
     }else{
	return 'C';
     }
}

void cita_con_el_destino(){
    char vencedor='N';
    char tecla;

    inicializar_modo_grafico();
    settextstyle(TRIPLEX_FONT,HORIZ_DIR,10);
    setcolor(color("azul"));
    outtextxy(30,40,"The Die...");

	//Dibujo de Dados
    setcolor(color("blanco"));
    setfillstyle(SOLID_FILL,WHITE);
    bar3d(220,220,290,290,20,30);
    bar3d(330,220,400,290,20,30);

	//Puntos del Primer Dado
    setcolor(color("blanco"));
    setfillstyle(SOLID_FILL,BLACK);
    fillellipse(235,235,7,7);
    fillellipse(258,255,7,7);
    fillellipse(280,275,7,7);

	//Puntos del Segundo Dado
    fillellipse(366,255,7,7);

	//Opciones
    setcolor(color("blanco"));
    settextstyle(SMALL_FONT,HORIZ_DIR,7);
    outtextxy(240,310,"'j' ==> Probar Suerte");
    outtextxy(240,335,"'q' ==> Morir sin Intentarlo...");
    outtextxy(70,440,"... una partida a dados contra tu destino...");
    do{
	if(kbhit()){
	   tecla=getch();
	   switch(tecla){
		      case 'j':
				   cleardevice();
				   vencedor=jugar_partida_dados();
				   break;
		      case 'q':
				   closegraph();
				   exit(1);
	   }
	}
    }while((vencedor!='J') && (vencedor!='C'));

    if(vencedor=='J'){
       cleardevice();
	   gotoxy(50,50);
	   printf("... has sobrevivido a la caida en barrena ... no te vuelvas a quedar dormido...");
	   getch();
	   controlar_cabina(150,150,150);
    }else if(vencedor=='C'){
	   cleardevice();
	   gotoxy(50,50);
	   printf("... estas MUERTO ....");
	   getch();
	   closegraph();
	   exit(1);
    }
}

/*
   Procedimiento: comprobar_estado_sistema
   Entradas: 9 parametros por valor tipo flotante:
	     Los 3 parametros del sistema y sus respectivas cotas superiores
	     en inferiores ==> csx = Cota Superior Parametro X (Presion,Altitud,Temperatura)
			   ==> cix = Cota Inferior Parametro X (Presion,Altitud,Temperatura)
   Retorna: Nada
   Acciones:
	    Comprueba que los parametros esten dentro del rango establecido como
	    correcto, en caso contrario activa el mode de alarma e inicia la temporizacion del
	    mismo.
*/

void comprobar_estado_sistema(float presion,float altitud,float temperatura,float cip,float csp,float cia,float csa,float cit,float cst){

     if((presion<cip)||(presion>csp)||(altitud<cia)||(altitud>csa)||(temperatura<cit)||(temperatura>cst)){
       activar_alarma();
       if(!sistema_en_peligro){
	  t1=time(NULL);
       }
       if(sistema_en_peligro){
	  t2=time(NULL);
	  if(difftime(t2,t1)>=tiempo_barrena){
	     sistema_en_peligro=0;
	     cita_con_el_destino();
	  }
       }
       sistema_en_peligro=1;
     }else{
       funcionamiento_normal();
       sistema_en_peligro=0;
     }
}

/*
   Procedimiento: modificar_variable
   Entradas: 2 argumentos por valor => accion tipo caracter.
				    => valor_modificacion tipo entero.
	     1 argumento por referencia => variable tipo flotante.
   Retorna: Las modificaciones pertinentes en la variable pasada por referencia.
   Acciones:
	     En funcion del valor de la accion, suma o resta el valor_modificacion
	     a la variable pasada por referencia. Tiene en cuenta la cota superior de la misma
	     asi como la cota inferior (solo suma si el valor no es mayor que el establecido como
	     maximo, y solo resta si el valor no es menor que el establecido como minimo)
*/
void modificar_variable(char accion,float* variable,int valor_modificacion){
     switch(accion){
	case '+':
		 if((*variable)<=298){
		    (*variable)=(*variable)+valor_modificacion;
		 }
		 break;
	case '-':
		 if((*variable)>=54){
		    (*variable)=(*variable)-valor_modificacion;
		 }
		 break;
     }
}

/* Procedimiento: calcular_parametros_turbulencia
   Entradas: 3 variables enteras pasadas por referencia (int*):
	       - valor_presion
	       - valor_altitud
	       - valor_temperatura
   Retorna: Las modificaciones producidas en las variables por referencia.
   Acciones: Inicializar el modo aleatorio para obtener las direcciones
	     de crecimiento/decrecimiento de los parametros del sistema
	     (presion,altitud,temperatura).
	     El criterio de crecimiento es que el valor aleatorio de la
	     direccion obtenida sea impar(y viceversa).
	     El incremento/decremento de los parametros se encuentra en
	     el rango [1..3] ("lo rapido o lento que el parametro varia").
*/

void calcular_parametros_turbulencia(int* valor_presion,int* valor_altitud,int* valor_temperatura){

     int dir_presion,dir_altitud,dir_temperatura;

     srand(time(NULL));
     dir_presion=rand()%2;
     dir_altitud=rand()%2;
     dir_temperatura=rand()%2;

     (*valor_presion)=rand()%3+1;
     (*valor_altitud)=rand()%3+1;
     (*valor_temperatura)=rand()%3+1;

     if(!dir_presion){
       (*valor_presion)=-(*valor_presion);
     }
     if(!dir_altitud){
	(*valor_altitud)=-(*valor_altitud);
     }
     if(!dir_temperatura){
	(*valor_temperatura)=-(*valor_temperatura);
     }
}

/*
   Procedimiento: controlar_cabina
   Entradas: Los valores actuales de los parametros del sistema.
   Retorna: Nada
   Acciones: La funcion basica de este procedimiento es actualizar los
	     parametros del sistema, para posteriormente representarlos
	     en las barras graficas.
	     La tecla pulsada determinara que parametro se modifica, y en que
	     sentido (se incrementa o bien se decrementa).
	     Por otro lado tenemos un hilo de ejecucion paralela, es el modo
	     de modificacion automatica o modo de simulacion de turbulencias.
	     La tecla t sera la que determina la activacion/desactivacion del
	     mismo, y como aspecto importante a destacar, esta el cambio de
	     la naturaleza de esta turbulencia cada TIEMPO_MISMA_TURBULENCIA
	     segundos.Cuando transcurre este tiempo, se recalculan los parametros
	     de la nueva turbulencia (en esencia se calculan las direcciones
	     de crecimiento/decrecimiento y los valores de los mismos).
*/
void controlar_cabina(float presion_inicial,float altitud_inicial,float temperatura_inicial){
     char tecla;
     int valor_modificacion_presion,valor_modificacion_altitud,valor_modificacion_temperatura;

     inicializar_modo_grafico();
     presentacion_cabina();


     actualizar_estado_barras(presion_inicial,altitud_inicial,temperatura_inicial);

     while(!estrellado){
	if(kbhit()){
	    tecla=getch();
	    tecla=toupper(tecla);
	    switch(tecla){
	       case 'A':
		      modificar_variable('+',&presion_inicial,2);
		      break;
	       case 'Z':
		      modificar_variable('-',&presion_inicial,2);
		      break;
	       case 'S':
		      modificar_variable('+',&altitud_inicial,2);
		      break;
	       case 'X':
		      modificar_variable('-',&altitud_inicial,2);
		      break;
	       case 'D':
		      modificar_variable('+',&temperatura_inicial,2);
		      break;
	       case 'C':
		      modificar_variable('-',&temperatura_inicial,2);
		      break;
	       case 'T':
		      if(modo_turbulencias){
			 modo_turbulencias=0;
		      }else{
			 modo_turbulencias=1;
			 t_t1=time(NULL);
			 calcular_parametros_turbulencia(&valor_modificacion_presion,&valor_modificacion_altitud,&valor_modificacion_temperatura);
		      }
		      break;
	       case 'P':
		      estrellado=1;
		      break;
	       }
	   }else{
	      if(modo_turbulencias){
		 t_t2=time(NULL);
		 if(difftime(t_t2,t_t1)<=TIEMPO_MISMA_TURBULENCIA){
		    presion_inicial=presion_inicial+valor_modificacion_presion;
		    altitud_inicial=altitud_inicial+valor_modificacion_altitud;
		    temperatura_inicial=temperatura_inicial+valor_modificacion_temperatura;
		 }else{
		    calcular_parametros_turbulencia(&valor_modificacion_presion,&valor_modificacion_altitud,&valor_modificacion_temperatura);
		    t_t1=t_t2=time(NULL);
		 }
	      }
	   }
       actualizar_estado_barras(presion_inicial,altitud_inicial,temperatura_inicial);
       delay(100);
       comprobar_estado_sistema(presion_inicial,altitud_inicial,temperatura_inicial,102,252,102,252,102,252);
    }

}

/*
   Procedimiento: main
   Entrada: Numero de Argumentos del Programa (int argc) --> numero entero
	    Los propios argumentos (char** argv) --> matriz de cadenas
   Retorna: Por convenio 0 en caso de ejecucion correcta.
   Acciones:
	    Controla el tipo asi como los valores de los argumentos introducidos;
	    que seran 2:
	       - El Tiempo de Barrena: Por definicion es el maximo tiempo que
		 el sistema puede estar en modo de peligro.
	       - El Numero de Enfrentamientos de una partida de dados: Por definicion
		 es el maximo numero de enfrentamientos jugador/computadora
		 que constituye una partida.
	    Descarga todo el trabajo, previa inicializacion correcta del modo
	    grafico, en el procedimiento Controlar_Cabina.
*/

int main(int argc,char** argv){


    if(argc != 3){
	   printf("Error: Numero de Parametros Incorrecto => Sintaxis: proyecto tiempo_barrena num_partidas_por_juego\n");
	   exit(-1);
    }

    tiempo_barrena=strtol(argv[1],(char**)NULL,10);
    num_partidas_por_juego=strtol(argv[2],(char**)NULL,10);


	if((tiempo_barrena<=0) || (tiempo_barrena>10)){
	   printf("Error: Tiempo_Barrena debe estar comprendido entre 1 y 10\n");
	   exit(-1);
	}
	if((num_partidas_por_juego<=0) || (num_partidas_por_juego>10)){
	   printf("Error: Num_Partidas_Por_Juego debe estar comprendido entre 1 y 10\n");
	   exit(-1);
	}


	inicializar_modo_grafico();
	centroDePantalla(&mitadX,&mitadY);
	presentacion_inicial(mitadX,mitadY);

	controlar_cabina(150,150,150);

	closegraph();



    return 0;
}