/****************************************************************************
*		      JUEGO DE LA SERPIENTE (SNAKE BOOM)                    *
*            Creado por : Fco Javier Jorge Trujillo 74918076-S              *
*****************************************************************************/

/*Se cargan las librerias necesarias*/

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<graphics.h>
#include<dos.h>
#include<string.h>


/*Declaracion de funciones creadas*/

void comprobar_fich_max(char *nom, int i,int k, int numsecr);
void crea_fichero_nuevo (int i);

void inicia_graf ();
void menu_1();
void iniciar_arrays(int *ser,int N,int *sera,int N2,int *bomba,int nb,int *pedazo,int i);
void pinta_tablero();

void menu_ayuda(int *ser,int N);
void menu_ayuda2(int *ser,int N,int *sera,int N2);

int  mueve_serpiente(int *ser,int *ser2,int N,int dir,int i);
void pinta_ser(int *ser,int N, int nc);
void actualizo_ser(int *ser,int *ser2, int i, int N);
int  choque_ser(int i,int N,int *ser,int k);

int  comprueba_item(int *item,int *ser,int N,int k,int i);
void crea_item (int *item,int *ser,int N, int *sera, int N2,int sigue, int i);
int  num_aleatorio (int p);

void crea_bombas(int i,int nb,int sigue,int *bomba,int k,int N,int *ser);
void pinta_bombas(int *bomba,int nb,int i);
void refresca_cuenta_bom(int i,int nb,int *bomba,int *pedazo,int choque);

void pinta_pedazos (int *pedazo,int co,int i);
int choque_trozo(int *pedazo,int *ser,int N,int choquer,int i,int k);

void pinta_ser_entera(int *ser,int N, int nc);
void agrandar_serpiente(int *ser,int N,int dir);


void comprueba_max(int puntos,int temp);
void introduce_max(int temp,int puntos);

void menu_2();
void ver_max();

void final(int puntos, char *spuntos,int tiemp);
void final2(int choque, int choque2);


/*Programa principal*/

void main ()
  {

  /*Declaracion variables*/

  char c;                     /*Guarda el caracter leido por teclado*/
  char spuntos[4];            /*Variable puntos convertida en cadena*/
  char nom[7];                /*Nombre introducido-leido de archivo*/


  int *ser,*ser2;             /*Punteros que sealan a los arrays que
				contienen los puntos de la serpiente 1,
				estado actual(ser)-estado futuro(ser2)*/

  int *sera,*sera2;           /*Punteros que sealan a los arrays que
				contienen los puntos de la serpiente 2,
				estado actual(sera)-estado futuro(sera2)*/

  int *bomba;                 /*Puntero que seala al array que contiene
				la posicion y el estado de las bombas*/

  int N,N2;                   /*Tamao de la serp.1 y de la serp.2*/
  int nb;                     /*Numero de bombas*/
  int choque,choque2;         /*Indica si ha chocado la serp.1 y la serp.2*/
  int cuenta,cuenta2;         /*Cuenta para que la serp1 y la serp.2 crezca*/
  int dir,dir2,dira,dira2;    /*Variables que guardan la direccion actual y
				siguiente de las dos serpientes: 0 derecha,
				1 izquierda, 2 abajo y 3 arriba*/

  int puntos;		      /*Puntos conseguidos*/
  int numsecr;                /*Numero secreto para el archivo de max_score*/
  int tiempo;		      /*Tiempo de espera entre proceso y proceso*/
  int salir;		      /*Variable para indicar la salida del juego*/
  int ini;		      /*Variable para indicar la primera ejecucion*/
  int jug2;		      /*Indica si hay juego para 2 jugadores*/
  int k,i,sigue,sal,choquer;  /*Variables para bucles y condiciones*/

  int item[2];		      /*Array que guarda la posicion del item*/
  int pedazo[40];             /*Array que guarda las posiciones de los pedazos*/

  int error_mem=0;            /*Error en la asignacion de memoria*/
  choque=choque2=puntos=0;

  ini=1;                /*Para que la primera vez que se ejecute carge el menu*/

  comprobar_fich_max(nom,i,k,numsecr);/*Se comprueba si es correcto el fichero
					de maximas puntuaciones*/
  inicia_graf();                      /*Se inicia el modo grafico*/
  menu_1(); 			      /*Carga pantalla presentacion*/

  do
    {
    if(ini==0)   /*Para que la primera vez que se ejecute no empiece a jugar*/
      {
      /*Inicializacion variables*/

      choque=choque2=0,cuenta=75,cuenta2=1,puntos=0;
      dir=0,dira=1,i=0,N=8,N2=8,salir=0;

      /*Asignacion de memoria dinamica para los arrays*/

      if((ser=(int *)malloc(N*sizeof(int)))==NULL)
	error_mem=1;
      if((ser2=(int *)malloc(N*sizeof(int)))==NULL)
	error_mem=1;
      if((sera=(int *)malloc(N2*sizeof(int)))==NULL)
	error_mem=1;
      if((sera2=(int *)malloc(N2*sizeof(int)))==NULL)
	error_mem=1;
      if((bomba=(int *)malloc((4*nb)*sizeof(int)))==NULL)
	error_mem=1;

      if(error_mem==1)
	printf("\nERROR EN LA ASIGNACION DE MEMORIA");

      /*Inicializa los arrays*/

      iniciar_arrays(ser,N,sera,N2,bomba,nb,pedazo,i);
      item[0]=0;
      item[1]=0;

      srand(time(NULL));   /*Para generar un patron con rand*/
      pinta_tablero();     /*Pintar el tablero*/

      /*Comienza el juego*/

      do
	{
	if(kbhit()!=0)                     /*Si se pulsa tecla*/
	  {
	  c=getch();                       /*Se guarda el caracter pulsado*/

	  if(c=='\x1B')                    /*Se pulsa tecla ESC*/
	    salir=1;                       /*Se sale del juego*/

	  if (c=='\x48'&dir2!=2)           /*Se pulsa tecla cursor arriba*/
	    dir=3;                         /*Direccion serpiente1 = arriba*/

	  if (c=='\x50'&dir2!=3)           /*Se pulsa tecla cursor abajo*/
	    dir=2;                         /*Direccion serpiente1 = abajo*/

	  if (c=='\x4D'&dir2!=1)           /*Se pulsa tecla cursor derecha*/
	    dir=0;                         /*Direccion serpiente1 = derecha*/

	  if (c=='\x4B'&dir2!=0)           /*Se pulsa tecla cursor izquierda*/
	    dir=1;                         /*Direccion serpiente1 = izquierda*/

	  if(c=='\x3B'&jug2==0)            /*Se pulsa tecla F1*/
	    menu_ayuda(ser,N);             /*Se carga la ayuda con 1 jugador*/

	  if(c=='\x3B'&jug2==1)            /*Se pulsa tecla F1*/
	    menu_ayuda2(ser,N,sera,N2);    /*Se carga la ayuda con 2 jugadores*/

	  if(jug2==1)                      /*Si hay 2 serpientes*/
	    {
	    if ((c=='w'||c=='W')&dira2!=2) /*Se pulsa tecla w */
	      dira=3;                      /*Direccion serpiente2 = arriba*/

	    if ((c=='s'||c=='S')&dira2!=3) /*Se pulsa tecla s */
	      dira=2;                      /*Direccion serpiente2 = abajo*/

	    if ((c=='d'||c=='D')&dira2!=1) /*Se pulsa tecla d */
	      dira=0;                      /*Direccion serpiente2 = derecha*/

	    if ((c=='a'||c=='A')&dira2!=0) /*Se pulsa tecla a */
	      dira=1;                      /*Direccion serpiente2 = izquierda*/
	     }
	  }/*del if(kbhit()!=0)*/

      else                                 /*Si no se ha pulsado tecla*/
	{

	/*Se mueve la serpiente1 segun dir, se calculan los puntos
	  y se guardan en ser2 (estado proximo)*/

	dir2=mueve_serpiente(ser,ser2,N,dir,i);

	pinta_ser(ser,N,0);      /*Se borra el ultimo punto de la serpiente1*/

	actualizo_ser(ser,ser2,i,N); /*Se actualiza el estado proximo (ser2)
				       al actual (ser)*/

	if(choque_ser(i,N,ser,k)==1) /*Si la serpiente choca consigo mismo*/
	  choque=1;                  /*o con el tablero*/
	else
	  pinta_ser(ser,N,1);        /*Pinta la cabeza de la serpiente*/

	if(jug2==1)                  /*Juegan 2 jugadores*/
	  {

	  /*Se mueve la serpiente2 segun dira, se calculan los puntos
	    y se guardan en sera2 (estado proximo)*/

	  dira2=mueve_serpiente(sera,sera2,N2,dira,i);

	  /*Se comprueba si la serpiente 2 choca con el cuerpo de
	    la serpiente 1*/

	  for(i=0;i<N;i=i+2)
	   {
	   if(sera[0]==ser[i] && sera[1]==ser[i+1])
	     choque2=1;
	   }

	  /*Se comprueba si la serpiente 1 choca con el cuerpo de
	    la serpiente 2*/

	  for(i=0;i<N2;i=i+2)
	   {
	   if(ser[0]==sera[i] && ser[1]==sera[i+1])
	     choque=1;
	   }

	  if(comprueba_item(item,ser,N,sigue,k)==1) /*Si ser1 coje el item*/
	    {
	    cuenta=0;                           /*Cuenta para crecer*/
	    setcolor(0);
	    outtextxy(item[0],item[1],"o");     /*Borra el item*/
	    setcolor(1);
	    outtextxy(item[0],item[1],"*");
	    item[0]=0;                          /*Inicializa la posicion*/
	    item[1]=0;                          /*del item*/
	    }

	  if(comprueba_item(item,sera,N2,sigue,k)==1) /*Si ser2 coje el item*/
	    {
	    cuenta2=0;                           /*Cuenta para crecer*/
	    setcolor(0);
	    outtextxy(item[0],item[1],"o");      /*Borra el item*/
	    setcolor(4);
	    outtextxy(item[0],item[1],"*");
	    item[0]=0;                           /*Inicializa la posicion*/
	    item[1]=0;                           /*del item*/
	    }

	  pinta_ser(sera,N2,0);            /*Borra el ultimo punto de serp.2*/

	  if(choque==0 & choque2==0)
	    actualizo_ser(sera,sera2,i,N2); /*Actualizo el estado si no hay
					      choque*/

	  if(choque_ser(i,N2,sera,k)==1)    /*Comprueba si hay choque de la*/
	      choque2=1;                    /*serp.2 consigo mismo o con el*/
	  else                              /*tablero*/
	    {
	    pinta_ser(sera,N2,4);           /*Pinta la cabeza de serp.2*/
	    }

	  if(item[0]==0 & item[1]==0)      /*Si no hay item en pantalla*/
	    crea_item (item,ser,N,sera,N2,sigue,i);/*lo crea*/
	  else
	   {
	    setcolor(7);
	    outtextxy(item[0],item[1],"o");       /*Pinta Item*/
	   }
	  } /* del if(jug2==1) */

	else                                      /*Juego para un jugador*/
	  {
	  crea_bombas(i,nb,sigue,bomba,k,N,ser);  /*Se crean las bombas*/
	  pinta_bombas(bomba,nb,i);               /*Se pintan las bombas*/

	  for(i=0;i<(4*nb);i=i+4)
	    {
	    if(bomba[i]==ser[0] & bomba[i+1]==ser[1]) /*Se activa la bomba*/
	      {                                       /*si la serpiente pasa*/
	      bomba[i+3]=1;                           /*por encima de ella*/
	      puntos=puntos+50;                       /*puntos+50*/
	      }
	    }

	  /*Comprueba la cuenta de las bombas activadas y pinta las explosiones*/

	  refresca_cuenta_bom(i,nb,bomba,pedazo,choque);

	  /*Comprueba si algun trozo de bomba choca con la serpiente*/

	  if(choque_trozo(pedazo,ser,N,choquer,i,k)==1)
	    {
	    choque=1;
	    }
	  } /*del else*/

	if(choque==1)                    /*La serpiente 1 choca*/
	  {
	  salir=1;                       /*Acaba el juego*/
	  for(i=0;i<=10;i++)
	    {
	    pinta_ser_entera(ser,N,0);   /*Parpadea la serpiente 1*/
	    delay(75);
	    pinta_ser_entera(ser,N,1);
	    delay(75);
	    }
	  }

	if(choque2==1)                   /*La serpiente 2 choca*/
	  {
	  salir=1;                       /*Acaba el juego*/
	  for(i=0;i<=10;i++)
	    {
	    pinta_ser_entera(sera,N2,0); /*Parpadea la serpiente 2*/
	    delay(75);
	    pinta_ser_entera(sera,N2,4);
	    delay(75);
	    }
	  }

	if(jug2==1)                     /*En el juego de 2 jugadores*/
	  {                             /*Si se ha cojido un item*/
	  if(cuenta==0 || cuenta2==0)   /*aumenta la velocidad*/
	    tiempo=tiempo-3;
	  }

	if(cuenta==0)                   /*La serpiente 1 crece*/
	  {
	  N=N+2;
	  ser = (int *) realloc ((int *)ser,N*sizeof(int));
	  ser2 = (int *) realloc ((int *)ser2,N*sizeof(int));
	  agrandar_serpiente(ser,N,dir);
	  cuenta=75;
	  }

	if(cuenta2==0)                  /*La serpiente 2 crece*/
	  {
	  N2=N2+2;
	  sera = (int *) realloc ((int *)sera,N2*sizeof(int));
	  sera2 = (int *) realloc ((int *)sera2,N2*sizeof(int));
	  agrandar_serpiente(sera,N2,dira);
	  cuenta2=1;
	  }
	delay(tiempo);                  /*Tiempo de espera*/
	puntos++;                       /*Incremento de puntos*/

	if(jug2!=1)
	  cuenta--;                     /*En el juego de un jugador*/
	}                               /*cuenta se decrementa con el tiempo*/

      }while (salir != 1);              /*Fin de juego*/


      if(c!='\x1B'& jug2==0)            /*Si no se ha pulsado ESC y se juega*/
	{                               /*con una sola serpiente*/
	final(puntos,spuntos,tiempo);   /*Muestra puntuacion y si comprueba*/
	do                              /*si es max_puntuacion*/
	  {
	  }while(getch()!=' ');         /*Sale al pulsar espacio*/
	}

      if(c!='\x1B'& jug2==1)            /*Si no se ha pulsado ESC y se juega*/
	{                               /*con 2 serpientes*/
	final2(choque,choque2);         /*Muestra quien ha ganado*/
	do
	  {
	  }while(getch()!=' ');         /*Sale al pulsar espacio*/
	}
      }/* del if(ini==0)*/

  menu_2();                             /*Se carga el menu*/
  ini=0;                                /*El programa se ha ejecutado una vez*/
  do
   {
   jug2=0;
   switch (getch())                               /*Segun la tecla pulsada*/
     {
     case '1':nb=5;tiempo=150;sal=1;break;        /*Parametros Nivel facil*/
     case '2':nb=7;tiempo=75;sal=1;break;         /*Parametros Nivel medio*/
     case '3':nb=10;tiempo=50;sal=1;break;        /*Parametros Nivel dificil*/
     case '4':jug2=1;nb=0;tiempo=150;sal=1;break; /*Dos jugadores*/
     case '5':ver_max();sal=0;menu_2();break;     /*Ver maximas puntuaciones*/
     case '6':c='6';sal=1; break;                 /*Salir*/
     default: sal=0; break;
     }
   }while(sal!=1);                   /*Se pulsa tecla valida*/

  }while(c!='6');                    /*Se sale del programa*/

 closegraph();                       /*Se cierra el modo grafico*/

 free(bomba);                        /*Se libera la memoria de los arrays*/
 free(ser);
 free(ser2);
 free(sera);
 free(sera2);
 }


/************************************************************************
     Funcion que comprueba si existe el fichero de maximas puntuaciones,
    si no existe o ha sido manipulado (se establece un numero secreto
 mediante la combinacion de las puntuaciones grabado al final del fichero),
			 se crea un nuevo fichero
*************************************************************************/

void comprobar_fich_max(char *nom,int i, int k, int numsecr)
  {
  numsecr=0;

  FILE *fich;
  fich=fopen ("max_score.txt","r");/*Se abre el fichero modo lectura*/

  if(fich==NULL)                 /*No existe el fichero*/
    crea_fichero_nuevo(i);       /*Se crea nuevo fichero*/

  else
    {
    for(i=0;i<3;i++)             /*Se realiza un barrido al fichero*/
      {
      fscanf(fich,"%i",&k);      /*Se lee la puntuacion*/
      numsecr=numsecr+k;         /*Se le suma al numero secreto la puntuacion*/
      fgets(nom,2,fich);         /*Se lee el espacio*/
      fgets(nom,8,fich);         /*Se lee el nombre*/
      }

    numsecr=(numsecr/4)*3;       /*Se calcula el numero secreto*/
    fscanf(fich,"%i",&k);        /*Se lee el ultimo numero del fichero*/
    if(k!=numsecr)               /*Si el archivo ha sido manipulado !=numsecr*/
      crea_fichero_nuevo(i);     /*Se crea un fichero nuevo*/
    }
  fclose(fich);                  /*Se cierra el fichero*/
  }

/***************************************************************************
      Funcion que crea un fichero llamado max_score.txt cuyo contenido es:
		     "0 jugador0 jugador0 jugador0"
****************************************************************************/

void crea_fichero_nuevo (int i)
  {
  FILE *fich;
  fich=fopen ("max_score.txt","wt"); /*Crea un fichero modo escritura*/

  for(i=0;i<3;i++)
    {
    fputs("0 jugador",fich);        /*Copia al fichero 3 veces la cadena*/
    }
  fputs("0",fich);                  /*Copia al fichero el 0 (numser)*/
  fclose(fich);
  }

/***************************************************************************
		      Funcion que inicia el modo grafico
****************************************************************************/
void inicia_graf ()
  {
  int gdriver = DETECT, gmode, errorcode;
  initgraph(&gdriver, &gmode, "");
  errorcode = graphresult();
  if (errorcode != grOk)            /*Ocurre un error en la inicializacion*/
    {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    }
  }

/****************************************************************************
     Funcion que carga el menu de presentacion y espera un pulso de tecla
*****************************************************************************/
void menu_1()
  {
  setcolor(3);
  bar(170,170,460,320);
  setcolor(5);
  outtextxy(190,190,"---------	 SNAKE BOOM 	---------");
  setcolor(0);
  outtextxy(190,210,"Programa creado por:");
  outtextxy(225,230,"Fco Javier Jorge Trujillo");
  outtextxy(225,250,"74918076-S Electronica");
  outtextxy(225,270,"         @2006");

  do
    {
    setcolor(1);
    outtextxy(185,295,"Pulsa cualquier tecla para seguir");
    delay(1000);
    setcolor(3);
    bar(180,295,450,320);
    delay(500);
    }while (!kbhit());
  }

/****************************************************************************
		      Funcion que inicializa los arrays
*****************************************************************************/

void iniciar_arrays(int *ser,int N,int *sera,int N2,int *bomba,int nb,int *pedazo,int i)
  {
  i=0;
  do
    {
    sera[i]=300+(10*(i/2));    /*Establece las posiciones de las serpiente2*/
    sera[i+1]=250;
    i=i+2;
    }while (i != N2);

  i=0;
  do
    {
    ser[i]=200-(10*(i/2));     /*Establece las posiciones de las serpiente1*/
    ser[i+1]=150;
    i=i+2;
    }while (i != N);

  for (i=0;i<40;i++)
    {
    pedazo[i]=0;                 /*Inicializa a cero los elementos de pedazo[]*/
    }

  for (i=0;i<(4*nb);i++)
    {
    bomba[i]=0;                 /*Inicializa a cero los elementos de bomba[]*/
    }
  }

/****************************************************************************
			   Funcion que pinta el tablero
*****************************************************************************/
void pinta_tablero()
  {
  cleardevice();
  setcolor(7);
  rectangle(105,85,530,400);
  outtextxy(125,420,"PULSA LA TECLA 'ESC' PARA SALIR O 'F1' PARA AYUDA");
  }

/****************************************************************************
      Funcion que muestra la ayuda en pantalla para el juego con una sola
      serpiente.Tras pulsar una tecla, se vuelve a pintar el tablero y la
				serpiente
****************************************************************************/

void menu_ayuda(int *ser,int N)
  {
  cleardevice();
  setcolor(7);
  rectangle(105,85,530,400);
  setcolor(9);
  outtextxy(130,100,"*******************	 AYUDA 	********************");
  setcolor(2);
  outtextxy(130,130,"   La serpiente se maneja con los cursores del");
  outtextxy(130,150,"    teclado:arriba,abajo,izquierda,derecha");
  outtextxy(130,180,"   Las bombas se activan cuando la serpiente");
  outtextxy(130,200,"   pase por encima de ellas, pasado un tiempo");
  outtextxy(130,220,"   estas explotarn y se dividirn en 6 trozos");
  outtextxy(130,250,"   El juego acabar si la serpiente choca con");
  outtextxy(130,270,"     algun trozo,con los limites del tablero");
  outtextxy(130,290,"               o consigo mismo              ");
  outtextxy(130,320,"La serpiente crecer a medida que pase el tiempo");
  outtextxy(130,340,"Con cada bomba activada la puntuacion+50 puntos");
  setcolor(7);
  outtextxy(130,390,"     PULSA CUALQUIER TECLA PARA CONTINUAR");
  getch();
  pinta_tablero();
  pinta_ser_entera(ser,N,1);
  }

/****************************************************************************
      Funcion que muestra la ayuda en pantalla para el juego con dos
      serpientes.Tras pulsar una tecla, se vuelve a pintar el tablero y las
			      dos serpientes
****************************************************************************/

void menu_ayuda2(int *ser,int N,int *sera,int N2)
  {
  cleardevice();
  setcolor(7);
  rectangle(105,85,530,400);
  setcolor(9);
  outtextxy(130,100,"*******************	 AYUDA 	********************");
  setcolor(2);
  outtextxy(130,130,"La serpiente del JUGADOR 1 (AZUL) se maneja con  ");
  outtextxy(130,150," los cursores arriba,abajo,izquierda,derecha");
  outtextxy(130,180,"La serpiente del JUGADOR 2 (ROJO) se maneja con ");
  outtextxy(130,200,"las teclas: W (arriba), S (abajo), A (izquierda) ");
  outtextxy(130,220,"              y D (derecha)");
  outtextxy(130,250,"         Pierde quien choque con la otra ");
  outtextxy(130,270,"     serpiente, con los limites del tablero");
  outtextxy(130,290,"                o consigo mismo");
  outtextxy(130,320,"     La serpiente crecer al cojer el ITEM o");
  outtextxy(130,340,"   La velocidad aumentar con cada ITEM cojido");
  setcolor(15);
  outtextxy(130,390,"     PULSA CUALQUIER TECLA PARA CONTINUAR");
  getch();
  pinta_tablero();
  pinta_ser_entera(ser,N,1);
  pinta_ser_entera(sera,N2,4);
  }

/****************************************************************************
    Funcion que segun la direccion de la serpiente, calcula el estado proximo
    a partir del array del estado actual (ser) y lo guarda en el array
    ser2(estado proximo), devuelve el valor de la nueva direccion que lleva
			       la serpiente
*****************************************************************************/

int mueve_serpiente(int *ser,int *ser2,int N,int dir,int i)
  {
   for (i=2;i<N;i=i+2)       /*El n_punto del array ser2 sera (n-1)_punto del
			       array ser*/
    {
    ser2[i]=ser[i-2];
    ser2[i+1]=ser[i-1];
    }

   switch(dir)               /*Se cambiara el primer punto (cabeza) segun
			       la direccion*/
     {
     case 0:ser2[0]=ser[0]+10;ser2[1]=ser[1];i=0;break;
     case 1:ser2[0]=ser[0]-10;ser2[1]=ser[1];i=1;break;
     case 2:ser2[0]=ser[0];ser2[1]=ser[1]+10;i=2;break;
     case 3:ser2[0]=ser[0];ser2[1]=ser[1]-10;i=3;break;
     }
  return(i);                  /*Se devuelve el valor de la direccion actual*/
  }

/****************************************************************************
Funcion que segun el valor de nc, pinta la cabeza de la serpiente del color
	    (nc) si nc!=0 o borra el ultimo punto si nc==0
*****************************************************************************/

void pinta_ser(int *ser,int N, int nc)
  {
  if (nc==0)
    {
    setcolor(0);
    outtextxy(ser[N-2],ser[N-1],"*");/*Borra el ultimo punto de la serpiente*/
    }
  else
    {
    setcolor(nc);
    outtextxy(ser[0],ser[1],"*");    /*Pinta la cabeza de la serpiente*/
    }
  }

/****************************************************************************
Funcion que copia los puntos del estado proximo (ser2) al estado actual (ser)
*****************************************************************************/

void actualizo_ser(int *ser,int *ser2, int i, int N)
  {
  for (i=0;i<N;i++)
    {
    ser[i]=ser2[i];
    }
  }

/*****************************************************************************
Funcion que comprueba si la cabeza de la serpiente choca con alguna parte de
  su cuerpo o se sale del tablero, si es asi la funcion devuelve un 1 y en
			    caso contrario un 0
******************************************************************************/

int choque_ser(int i,int N,int *ser,int k)
  {
  k=0;
  for (i=2;i<N;i=i+2)
    {
    if((ser[0] == ser[i]) & (ser[1] ==ser[i+1]))  /*Choca con su cuerpo*/
      k=1;
    }

   if (ser[0] <= 105 || ser[0]>520 || ser[1]<90 || ser[1] >390)
     k=1;                                         /*Se sale del tablero*/

  return(k);
  }
/*****************************************************************************
Funcion que comprueba si la serpiente coje el item, si es asi la funcion
		   devuelve un 1 en caso contrario un 0
******************************************************************************/

int comprueba_item(int *item,int *ser,int N,int k,int i)
  {
  k=0;
  for(i=0;i<N;i=i+2)
    {
    if(item[0]==ser[i] & item[1]==ser[i+1]) /*La cabeza coincide con el item*/
      k=1;
    }
return (k);
  }

/*****************************************************************************
 Funcion que genera de forma aleatoria la posicion del item, esta posicion no
     es ninguna de las que ocupe las serpientes ni fuera del tablero
******************************************************************************/

void crea_item (int *item,int *ser,int N, int *sera, int N2,int sigue, int i)
  {
  do
    {
    sigue=1;
    item[0]=num_aleatorio(0);    /*Coordenada x aleatoria dentro del tablero*/
    item[1]=num_aleatorio(1);    /*Coordenada y aleatoria dentro del tablero*/

    for(i=0;i<N;i=i+2)           /*Comprueba si el punto coincide con alguna*/
      {                          /*posicion de la serpiente 1*/
      if(item[0]==ser[i] & item[1] ==ser[i+1])
	sigue=0;
      }

    for(i=0;i<N2;i=i+2)          /*Comprueba si el punto coincide con alguna*/
      {                          /*posicion de la serpiente 2*/
      if(item[0]==sera[i] & item[1] ==sera[i+1])
	sigue=0;
      }
    }while(sigue != 1);          /*Hasta conseguir un punto valido*/
  }

/*****************************************************************************
    Funcion que calcula una coordenada aleatoria pero dentro del tablero y
     multiplo de 10, si p==0 devuelve una coordenada x valida y si p==1
		   devuelve una coordenada y valida
******************************************************************************/

int num_aleatorio (int p)
  {
  int div,num_10=0;
  if(p==0)
    {
    do
     {
     p=rand()%520;
     div=p/10;
     if((div*10)==p & p>110)
       num_10=1;
     }while (num_10 !=1);
    }
  else
    {
    do
      {
      p=rand()%390;
      div=p/10;
      if((div*10)==p & p>90)
	num_10=1;
      }while (num_10 !=1);
    }
  return(p);
 }

/*****************************************************************************
  Funcion que crea las posiciones de las bombas,el estado de las bombas y la
 cuenta de explosion, las posiciones no coinciden con ningun punto del cuerpo
			       de la serpiente
******************************************************************************/

void crea_bombas(int i,int nb,int sigue,int *bomba,int k,int N,int *ser)
  {
  for (i=0;i<(4*nb);i=i+4)
    {
    if(bomba[i+2]==0 & bomba[i+3]==0)  /*Si alguna bomba ha explotado*/
      {
      do                            /*Se crea una nueva bomba*/
	{
	sigue=1;
	bomba[i]=num_aleatorio(0);  /*Coordenada x valida*/
	bomba[i+1]=num_aleatorio(1);/*Coordenada y valida*/

	for(k=0;k<N;k=k+2)          /*Se comprueba si el punto*/
	  {                         /*coincide con la serpiente*/
	  if(bomba[i]==ser[k] & bomba[i+1] ==ser[k+1])
	    sigue=0;
	  }
	}while(sigue != 1);       /*Punto valido*/

      bomba[i+2]=50;              /*Se carga cuenta*/
      bomba[i+3]=0;               /*Se establece estado (desactivada)*/
      }
    }
  }

/*****************************************************************************
	     Funcion que pinta las bombas en pantalla segun su estado
******************************************************************************/

void pinta_bombas(int *bomba,int nb,int i)
  {
  for (i=0;i<(4*nb);i=i+4)
    {
    if(bomba [i+3] ==0 & bomba[i+2] !=0)   /*Si la bomba no ha sido activada*/
      setcolor(7);
    if(bomba [i+3] ==1 & bomba[i+2] !=0)   /*Si la bomba ha sido activada*/
      setcolor(4);
    if(bomba[i+3]==1 & bomba[i+2]==0)      /*Si la bomba ha explotado*/
      setcolor(0);
    outtextxy(bomba[i],bomba[i+1],"0");
    }
   }

/*****************************************************************************
Funcion que comprueba la cuenta de las bombas, si esta no es cero la disminuye
			y si es cero pinta los pedazos
******************************************************************************/

void refresca_cuenta_bom(int i,int nb,int *bomba,int *pedazo,int choque)
  {
  for(i=0;i<(4*nb);i=i+4)
    {
    if(bomba[i+3]==1 & bomba[i+2] !=0)  /*Si la bomba esta activada y la*/
      bomba[i+2]=bomba[i+2]-1;          /*cuenta no es 0 se decrementa*/
    }

  for(i=0;i<(4*nb);i=i+4)
    {
    if(bomba[i+2]==0 & bomba[i+3]==1)  /*La bomba explota*/
      {
      pinta_pedazos(pedazo,0,i);         /*Borra los pedazos anteriores*/

      if(pedazo[i+2]==100)              /*Si los pedazos ya desaparecen*/
	{
	bomba[i+3]=0;                  /*Bomba ha acabado de explotar*/
	pedazo[i+2]=0;
	pedazo[i]=0;
	pedazo[i+1]=0;
	pedazo[i+3]=0;
	}
      else
	{
	if(choque==0)
	  {
	  pedazo[i+2]=pedazo[i+2]+10;    /*Aumenta la distancia de los pedazos*/
	  pedazo[i]=bomba[i];           /*Origen x del pedazo*/
	  pedazo[i+1]=bomba[i+1];       /*Origen y del pedazo*/
	  pedazo[i+3]=1;
	  }
	pinta_pedazos(pedazo,6,i);       /*Pinta los pedazos*/
	}
      }
    }
  }

/*****************************************************************************
Funcion que pinta 6 pedazos a partir de la posicion donde a explotado la bomba
    mas/menos el incremento.Si algun trozo se sale del tablero no lo pinta
******************************************************************************/

void pinta_pedazos (int *pedazo,int col,int i)
  {
  setcolor(col);
  for(i=0;i<40;i=i+4)
    {
    if(pedazo[i+3]==1)
      {
      if (pedazo[i]>105 & pedazo[i]<530 & pedazo[i+1]-pedazo[i+2]>85 & pedazo[i+1]-pedazo[i+2]<400)
	{
	outtextxy(pedazo[i],pedazo[i+1]-pedazo[i+2],"%");
	}

      if (pedazo[i]+pedazo[i+2]>105 & pedazo[i]+pedazo[i+2]<530 & pedazo[i+1]>85 & pedazo[i+1]<400)
	{
	outtextxy(pedazo[i]+pedazo[i+2],pedazo[i+1],"%");
	}

      if (pedazo[i]>105 & pedazo[i]<530 & pedazo[i+1]+pedazo[i+2]>85 & pedazo[i+1]+pedazo[i+2]<400)
	{
	outtextxy(pedazo[i],pedazo[i+1]+pedazo[i+2],"%");
	}

      if (pedazo[i]-pedazo[i+2]>105 & pedazo[i]-pedazo[i+2]<530 & pedazo[i+1]>85 & pedazo[i+1]<400)
	{
	outtextxy(pedazo[i]-pedazo[i+2],pedazo[i+1],"%");
	}

      if (pedazo[i]+pedazo[i+2]>105 & pedazo[i]+pedazo[i+2]<530 & pedazo[i+1]-pedazo[i+2]>85 & pedazo[i+1]-pedazo[i+2]<400)
	{
	outtextxy(pedazo[i]+pedazo[i+2],pedazo[i+1]-pedazo[i+2],"%");
	}

      if (pedazo[i]-pedazo[i+2]>105 & pedazo[i]-pedazo[i+2]<530 & pedazo[i+1]+pedazo[i+2]>85 & pedazo[i+1]+pedazo[i+2]<400)
	{
	outtextxy(pedazo[i]-pedazo[i+2],pedazo[i+1]+pedazo[i+2],"%");
	}

      if (pedazo[i]-pedazo[i+2]>105 & pedazo[i]-pedazo[i+2]<530 & pedazo[i+1]-pedazo[i+2]>85 & pedazo[i+1]-pedazo[i+2]<400)
	{
	outtextxy(pedazo[i]-pedazo[i+2],pedazo[i+1]-pedazo[i+2],"%");
	}

      if (pedazo[i]+pedazo[i+2]>105 & pedazo[i]+pedazo[i+2]<530 & pedazo[i+1]+pedazo[i+2]>85 & pedazo[i+1]+pedazo[i+2]<400)
	{
	outtextxy(pedazo[i]+pedazo[i+2],pedazo[i+1]+pedazo[i+2],"%");
	}
      }
    }
  }

/*****************************************************************************
Funcion que comprueba si algun trozo choca con el cuerpo de la serpiente, en
	       este caso devuelve un 1 en caso contrario un 0
******************************************************************************/

int choque_trozo(int *pedazo,int *ser,int N,int choquer,int i,int k)
{
  choquer=0;

  for(i=0;i<40;i=i+4)
    {
    for (k=0;k<N;k=k+2)
      {
      if(pedazo[i]==ser[k] & pedazo[i+1]+pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]==ser[k] & pedazo[i+1]-pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]+pedazo[i+2]==ser[k] & pedazo[i+1]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]-pedazo[i+2]==ser[k] & pedazo[i+1]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]+pedazo[i+2]==ser[k] & pedazo[i+1]-pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]-pedazo[i+2]==ser[k] & pedazo[i+1]+pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]-pedazo[i+2]==ser[k] & pedazo[i+1]-pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}

      if(pedazo[i]+pedazo[i+2]==ser[k] & pedazo[i+1]+pedazo[i+2]==ser[k+1])
	{
	choquer=1;
	}
      }
    }
  return (choquer);
  }

/*****************************************************************************
	      Funcion que pinta la serpiente entera del color nc
******************************************************************************/

void pinta_ser_entera(int *ser,int N, int nc)
  {
  int i;
  setcolor(nc);
  for(i=0;i<N;i=i+2)
    {
    if (ser[i] >= 105 & ser[i]<=520 & ser[i+1]>=90 & ser[i+1] <=390)
      outtextxy(ser[i],ser[i+1],"*");      /*Solo se pinta si esta dentro
					     del tablero*/
    }
}

/*****************************************************************************
    Funcion que aade un punto al final de la serpiente segun la direccion
******************************************************************************/

void agrandar_serpiente(int *ser,int N,int dir)
  {
  switch(dir)
    {
    case 0:ser[N-2]=ser[N-4]-10;ser[N-1]=ser[N-3];break; /*Derecha*/
    case 1:ser[N-2]=ser[N-4]+10;ser[N-1]=ser[N-3];break; /*Izquierda*/
    case 2:ser[N-2]=ser[N-4];ser[N-1]=ser[N-3]-10;break; /*Abajo*/
    case 3:ser[N-2]=ser[N-4];ser[N-1]=ser[N-3]+10;break; /*Arriba*/
    }
  }
/*****************************************************************************
Funcion que imprime la pantalla de fin de juego mostrando los puntos obtenidos
		  y comprobando si es maxima puntuacion
******************************************************************************/

void final(int puntos, char *spuntos,int tiemp)
  {
  sprintf(spuntos,"%i",puntos);        /*Convierte puntos en una cadena*/
  bar(150,200,500,250);
  setcolor(0);
  outtextxy(410,210,spuntos);
  setcolor(5);
  outtextxy(170,210,"GAME OVER --- HAS CONSEGUIDO:     puntos");
  comprueba_max(puntos,tiemp);         /*Comprueba si es maxima puntuacion*/
  setcolor(1);
  bar(190,220,500,250);
  outtextxy(190,230,"PULSA TECLA ESPACIO PARA IR A MENU");
   }

/*****************************************************************************
    Funcion que comprueba si los puntos obtenidos son maxima puntuacion para
			  el correspondiente nivel
******************************************************************************/

void comprueba_max(int puntos,int temp)
  {
  char nom[7];
  int i,k;
  FILE *fich;
  fich=fopen ("max_score.txt","r");  /*Abre el fichero modo lectura*/

  switch(temp)                       /*Comprueba nivel actual*/
    {
    case 150: k=1;break;             /*Nivel facil*/
    case 75:  k=2;break;             /*Nivel medio*/
    case 50:  k=3;break;             /*Nivel dificil*/
    }

  do                                 /*Lee n veces hasta obtener la puntuacion*/
    {				     /*para ese nivel*/
    fscanf(fich,"%i",&i);
    fgets(nom,2,fich);
    fgets(nom,8,fich);
    k--;
    }while(k!=0);

  if(puntos>i)                       /*La puntuacion es max_puntuacion*/
    introduce_max(temp,puntos);      /*Se introduce nuevo record*/
  }

/*****************************************************************************
     Funcion que pide el nombre y tras introducirlo, lo guarda junto a la
	       puntuacion en el archivo max_score.txt
******************************************************************************/

void introduce_max(int temp,int puntos)
  {
  setcolor(12);
  outtextxy(200,230,"MAXIMA PUNTUACION (Pulsa espacio)");
  do
    {
    }while(getch()!=' ');       /*Espera que se pulse espacio*/

  FILE *fich;
  setcolor(7);
  bar(150,250,500,300);
  setcolor(0);
  outtextxy(160,260,"Introduce nombre: *espacio para acabar*");
  char nombre[]="       ";
  int i=0,k,sal=0;

  do
    {
    nombre[i]=getch();          /*Se va aadiendo los caracteres leidos*/
    setcolor(1);
    outtextxy(290,280,nombre);  /*Se imprime la cadena*/
    if(i==6)                    /*Si se llega al maximo tamao se sale*/
      sal=1;
    if (nombre[i]==' ')         /*Si se pulsa espacio*/
      {                         /*Se sale*/
      sal=1;
      for(k=i;k<=6;k++)         /*Rellena el resto con espacios*/
	nombre[k]=' ';
      }
    i++;
    }while(sal!=1);             /*Hasta que se acabe de introducir el nombre*/

  fclose(fich);

  fich=fopen ("max_score.txt","r"); /*Se abre el fichero modo lectura*/

  char nom1[7],nom2[7],nom3[7],nom[1];
  int k1,k2,k3,numser;

  /*Se guardan las puntuaciones y los nombres del archivo*/

  fscanf(fich,"%i",&k1);
  fgets(nom,2,fich);
  fgets(nom1,8,fich);

  fscanf(fich,"%i",&k2);
  fgets(nom,2,fich);
  fgets(nom2,8,fich);

  fscanf(fich,"%i",&k3);
  fgets(nom,2,fich);
  fgets(nom3,8,fich);

  /*Segun el nivel actual, se sustituye por el nombre introducido y la
    puntuacion obtenida*/

  if(temp==150)
    {
    k1=puntos;
    strcpy(nom1,nombre);
    }
  if(temp== 75)
    {
    k2=puntos;
    strcpy(nom2,nombre);
    }
  if(temp==50)
    {
    k3=puntos;
    strcpy(nom3,nombre);
    }

  fclose(fich);

  fich=fopen ("max_score.txt","w");  /*Se abre el fichero modo escritura*/

  /*Se graban las puntuaciones y los nombres de cada nivel*/

  fprintf(fich,"%i",k1);
  fputs(" ",fich);
  fputs(nom1,fich);

  fprintf(fich,"%i",k2);
  fputs(" ",fich);
  fputs(nom2,fich);

  fprintf(fich,"%i",k3);
  fputs(" ",fich);
  fputs(nom3,fich);

  numser=(k1+k2+k3)/4*3;     /*Se calcula el numero secreto*/

  fprintf(fich,"%i",numser); /*Se guarda dicho numero en el fichero*/

  fclose(fich);              /*Se cierra el fichero*/
  setcolor(7);
  bar(150,250,500,300);
  }

/*****************************************************************************
		     Funcion que carga el menu de opciones
******************************************************************************/

void menu_2()
  {
  cleardevice();
  setcolor(3);
  bar(170,170,460,320);
  setcolor(5);
  outtextxy(190,180,"********ELIGE UNA OPCION*********");
  setcolor(1);
  outtextxy(190,200,"  1.Jugar en nivel facil");
  outtextxy(190,220,"  2.Jugar en nivel medio");
  outtextxy(190,240,"  3.Jugar en nivel avanzado");
  outtextxy(190,260,"  4.Jugar 2 jugadores (combate)");
  outtextxy(190,280,"  5.Ver Maximas puntuaciones");
  outtextxy(190,300,"  6.Salir");
  }

/*****************************************************************************
	    Funcion que imprime en pantalla las puntuaciones maximas
			  y espera pulso de tecla
******************************************************************************/

void ver_max()
  {
  char nom[7],k2[4];
  int i,k,y1=215;
  FILE *fich;
  fich=fopen ("max_score.txt","r");
  setcolor(3);
  bar(170,170,460,320);
  setcolor(5);
  outtextxy(180,180,"*******MAXIMAS PUNTACIONES*******");
  outtextxy(190,200,"NIVEL FACIL");
  outtextxy(190,230,"NIVEL MEDIO");
  outtextxy(190,260,"NIVEL EXPERTO");
  setcolor(8);
  outtextxy(190,215,"PUNTUACION:");
  outtextxy(330,215,"NOMBRE:");
  outtextxy(190,245,"PUNTUACION:");
  outtextxy(330,245,"NOMBRE:");
  outtextxy(190,275,"PUNTUACION:");
  outtextxy(330,275,"NOMBRE:");
  for(i=0;i<3;i++)
    {
    setcolor(4);
    fscanf(fich,"%i",&k);
    sprintf(k2,"%i",k);
    outtextxy(290,y1,k2);
    fgets(nom,2,fich);
    fgets(nom,8,fich);
    outtextxy(390,y1,nom);
    y1=y1+30;
    }
  getch();
  fclose(fich);
  }

/*****************************************************************************
	   Funcion que imprime la pantalla final para 2 jugadores
******************************************************************************/

void final2(int choque, int choque2)
  {
  bar(150,200,500,250);
  setcolor(5);
  if(choque==0 & choque2==1)
    outtextxy(190,210,"  GAME OVER --- Jugador 1 GANA");
  if(choque==1 & choque2==1)
	outtextxy(190,210,"  GAME OVER --- EMPATE");
  if(choque==1 & choque2==0)
	outtextxy(190,210,"  GAME OVER --- Jugador 2 GANA");
  setcolor(1);
  bar(190,220,500,250);
  outtextxy(190,230,"PULSA TECLA ESPACIO PARA IR A MENU");
  }









