/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.editors;

import es.uma.gisum.tjtplugin.editors.ConfigurationFormPage;
import es.uma.gisum.tjtplugin.util.ConfigurationContainer;
import es.uma.gisum.tjtplugin.util.ConfigurationListenerAdapter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationEditor
extends FormEditor {
    ConfigurationFormPage configurationFormPage;
    private TextEditor textEditor;
    private boolean formDirty = false;
    private ConfigurationListener listener = new ConfigurationListener();

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() == 0 && this.formDirty) {
            this.updateTextFromConfiguration();
        }
        this.formDirty = false;
        this.textEditor.doSave(monitor);
        this.updateConfigurationFromText();
    }

    public void doSaveAs() {
        if (this.getActivePage() == 0 && this.formDirty) {
            this.updateTextFromConfiguration();
        }
        this.formDirty = false;
        this.textEditor.doSaveAs();
        this.setInput(this.textEditor.getEditorInput());
        this.updateTitle();
        this.updateConfigurationFromText();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void addPages() {
        this.addConfigurationPage();
        this.addTextEditorPage();
        this.updateTitle();
        this.configurationFormPage.getInput().addConfigurationListener(this.listener);
        this.getContainer().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfigurationEditor.this.updateConfigurationFromText();
            }
        });
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(display);
    }

    private void addConfigurationPage() {
        try {
            this.configurationFormPage = new ConfigurationFormPage(this, "es.uma.gisum.tjtplugin.editors.ConfigurationFormPage", "Configuration");
            int index = this.addPage((IFormPage)this.configurationFormPage);
            this.setPageText(index, this.configurationFormPage.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating variables form page", null, (IStatus)e.getStatus());
        }
    }

    private void addTextEditorPage() {
        try {
            this.textEditor = new TextEditor();
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void updateTitle() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    public boolean isDirty() {
        return this.formDirty || super.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 0: {
                if (!this.textEditor.isDirty()) break;
                this.updateConfigurationFromText();
                break;
            }
            case 1: {
                if (!this.formDirty) break;
                this.updateTextFromConfiguration();
            }
        }
        this.formDirty = false;
        super.pageChange(newPageIndex);
    }

    private void updateConfigurationFromText() {
        ConfigurationContainer configuration = this.configurationFormPage.getInput();
        configuration.removeConfigurationListener(this.listener);
        configuration = new ConfigurationContainer();
        StringReader reader = new StringReader(this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).get());
        try {
            configuration.fromXML(reader);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.configurationFormPage.setInput(configuration);
        configuration.addConfigurationListener(this.listener);
    }

    private void updateTextFromConfiguration() {
        ConfigurationContainer configuration = this.configurationFormPage.getInput();
        StringWriter writer = new StringWriter();
        try {
            configuration.toXML(writer);
            this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()).set(writer.toString());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private void configurationModified() {
        boolean wasDirty = this.isDirty();
        this.formDirty = true;
        if (!wasDirty) {
            this.firePropertyChange(257);
        }
    }

    protected void handlePropertyChange(int propertyId) {
        if (propertyId == 257) {
            this.formDirty = this.isDirty();
        }
        super.handlePropertyChange(propertyId);
    }

    private class ConfigurationListener
    extends ConfigurationListenerAdapter {
        private ConfigurationListener() {
        }

        @Override
        public void anyEvent(ConfigurationContainer source) {
            ConfigurationEditor.this.configurationModified();
        }
    }
}

