/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.editors;

import es.uma.gisum.tjtplugin.editors.TjtInstanceJob;
import es.uma.gisum.tjtplugin.traces.TracesProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class TjtAnalysisJob
extends Job {
    private static final String WINDOWS_SHELL = "bash";
    private static final String LINUX_SHELL = "sh";
    private static final String CONSOLE_NAME = "TJT";
    private static final Pattern EXECUTION_LINE = Pattern.compile("^-------EXECUTION (\\d+)-------$");
    private IJavaProject project;
    private String ltl;
    private int numExecutions = 0;
    private IProject currentProject;
    private String fileName;
    private Process process;
    private IProgressMonitor monitor;

    public TjtAnalysisJob(IJavaProject project, String ltl) {
        this(project, ltl, null, ltl);
    }

    public TjtAnalysisJob(IJavaProject project, String ltl, IProject ip, String fileName) {
        super("TJT Analysis");
        this.project = project;
        this.ltl = ltl.trim();
        this.numExecutions = TjtInstanceJob.getNumberOfExecutions();
        this.currentProject = ip;
        this.fileName = fileName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        try {
            TjtInstanceJob instanceJob = new TjtInstanceJob(this.currentProject, this.fileName, false);
            instanceJob.setUser(true);
            instanceJob.schedule();
            instanceJob.join();
            if (instanceJob.getResult().isOK()) {
                this.numExecutions = TjtInstanceJob.getNumberOfExecutions();
                this.startShell();
                this.startPan();
                this.readPanOutput();
                if (TjtInstanceJob.getSecondCall()) {
                    TjtInstanceJob instanceJob2 = new TjtInstanceJob(this.currentProject, this.fileName, true);
                    instanceJob2.setUser(true);
                    instanceJob2.schedule();
                    instanceJob2.join();
                    this.startShell();
                    this.startPan();
                    this.readPanOutput();
                    TjtInstanceJob.setSecondCall(false);
                }
                TjtInstanceJob.numberOfExecutions = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error during analysis", (Throwable)e);
        }
        monitor.done();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TracesProvider.getInstance().findAndSetTraceFiles(TjtAnalysisJob.this.project);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return Status.OK_STATUS;
    }

    private void startShell() throws IOException {
        String shell = this.isWindows() ? WINDOWS_SHELL : LINUX_SHELL;
        ProcessBuilder pb = new ProcessBuilder(shell);
        pb.redirectErrorStream(true);
        File directory = new File(System.getProperty("user.dir").toString());
        pb.directory(directory);
        this.process = pb.start();
    }

    private void startPan() throws IOException {
        OutputStream os = this.process.getOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        if (!(!this.isEmptyFormula() && this.ltl.contains("[]") || TjtInstanceJob.ltl.contains("[]"))) {
            bw.write("./pan -c");
        } else {
            bw.write("./pan -a -c");
        }
        bw.flush();
        this.process.getOutputStream().close();
    }

    private void readPanOutput() throws IOException, InterruptedException {
        MessageConsole console = this.findConsole(CONSOLE_NAME);
        MessageConsoleStream out = console.newMessageStream();
        InputStream is = this.process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.beginAnalysisTask();
        String line = br.readLine();
        while (line != null) {
            this.checkNewExecutionSubTask(line);
            out.println(line);
            line = br.readLine();
        }
        this.doneAnalysisTask();
        this.process.waitFor();
    }

    private void beginAnalysisTask() {
        if (this.numExecutions > 0) {
            this.monitor.beginTask("Analyzing executions", this.numExecutions);
        } else {
            this.monitor.beginTask("Analyzing executions", -1);
        }
    }

    private void checkNewExecutionSubTask(String line) {
        Matcher matcher = EXECUTION_LINE.matcher(line);
        if (matcher.matches()) {
            if (this.numExecutions > 0) {
                this.monitor.worked(1);
            }
            this.monitor.subTask("Execution " + matcher.group(1));
        }
    }

    private void doneAnalysisTask() {
        this.monitor.done();
    }

    private boolean isEmptyFormula() {
        return this.ltl == null || this.ltl.isEmpty();
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("Win");
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                IConsole ic = existing[i];
                return (MessageConsole)ic;
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

